LavaPack.loadBundle([["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/build/openrpc.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){t.exports={openrpc:"1.2.4",info:{title:"JSON-RPC API",version:"1.0.0",description:"This section provides an interactive reference for MetaMask's Wallet JSON-RPC API. The API builds on a set of standard Ethereum methods with MetaMask-specific enhancements, and is designed for seamless integration into dapps."},methods:[{name:"wallet_addEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Adds an Ethereum chain to the wallet.",description:"Creates a confirmation asking the user to add the specified chain to the wallet application. The caller must specify a chain ID and some chain metadata. Specified by [EIP-3085](https://eips.ethereum.org/EIPS/eip-3085).",params:[{name:"Chain",schema:{$ref:"#/components/schemas/AddEthereumChainParameter"}}],errors:[{code:-32602,message:"Expected null or array with at least one valid string HTTPS URL 'blockExplorerUrl'. Received: ${blockExplorerUrls}"},{code:-32602,message:"Expected 0x-prefixed, unpadded, non-zero hexadecimal string 'chainId'. Received:\n${chainId}"},{code:-32602,message:'Invalid chain ID "${_chainId}": numerical value greater than max safe value. Received:\n${chainId}'},{code:-32602,message:"May not specify default MetaMask chain."},{code:-32602,message:"Expected 2-6 character string 'nativeCurrency.symbol'. Received:\n${ticker}"},{code:-32602,message:"nativeCurrency.symbol does not match currency symbol for a network the user already has added with the same chainId. Received:\n${ticker}"}],result:{name:"Null response",description:"This method returns `null` if the chain is added.",schema:{type:"null"}},examples:[{name:"wallet_addEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64",chainName:"Gnosis",rpcUrls:["https://rpc.gnosischain.com"],iconUrls:["https://xdaichain.com/fake/example/url/xdai.svg","https://xdaichain.com/fake/example/url/xdai.png"],nativeCurrency:{name:"XDAI",symbol:"XDAI",decimals:18},blockExplorerUrls:["https://blockscout.com/poa/xdai/"]}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_switchEthereumChain",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Switches the wallet's active Ethereum chain.",description:"Requests that the wallet switches its active Ethereum chain. Specified by [EIP-3326](https://eips.ethereum.org/EIPS/eip-3326).",params:[{name:"Chain",schema:{title:"Chain",description:"Object containing the chain ID to switch to.",type:"object",required:["chainId"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, as returned by the `eth_chainId` method.",type:"string"}}}}],result:{name:"Null response",description:"This method returns `null` if the active chain is switched.",schema:{type:"null"}},errors:[{code:4902,message:"Unrecognized chain ID. Try adding the chain using wallet_addEthereumChain first."}],examples:[{name:"wallet_switchEthereumChain example",params:[{name:"Chain",value:{chainId:"0x64"}}],result:{name:"Null response",value:"null"}}]},{name:"wallet_getPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the user's permissions.",description:"Gets the user's permissions. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_getPermissions example",params:[],result:{name:"Permission list",value:{eth_accounts:{}}}}]},{name:"wallet_requestPermissions",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Requests additional permissions.",description:"Requests additional permissions from the user. This method accepts a single permission per call. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to request.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being requested.",additionalProperties:!0}}}}],result:{name:"Permissions list",schema:{$ref:"#/components/schemas/PermissionsList"}},examples:[{name:"wallet_requestPermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Permission list",value:{eth_accounts:{}}}}],errors:[{$ref:"#/components/errors/UserRejected"}]},{name:"wallet_revokePermissions",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"}],summary:"Revokes the current dapp permissions.",description:"Revokes previously granted permissions for the current dapp identified by its origin. This method accepts a single permission per call. Specified by [MIP-2](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-2.md) and only available for the MetaMask browser extension.",params:[{name:"Permission",required:!0,schema:{title:"Permission",description:"Object containing the permission to revoke.",type:"object",properties:{permission_name:{type:"object",description:"The permission object. `permission_name` is the name of the permission being revoked.",additionalProperties:!0}}}}],result:{name:"Null response",description:"This method returns `null` if the permission is revoked.",schema:{type:"null"}},errors:[],examples:[{name:"wallet_revokePermissions example",params:[{name:"Permission",value:{eth_accounts:{}}}],result:{name:"Null response",value:"null"}}]},{name:"personal_sign",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a plain text signature challenge to the user.",description:"Presents a plain text signature challenge to the user and returns the signed response. Prepends a safe prefix to the signed message to prevent the challenge tricking users into signing a financial transaction. <br><br> MetaMask implements `personal_sign` similarly to the Go Ethereum client's `eth_sign` implementation. MetaMask's `personal_sign` doesn't accept a password. <br><br> This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",deprecated:!1,params:[{name:"Challenge",required:!0,description:"A hex-encoded UTF-8 string to present to the user. See how to encode a string like this in the [`browser-string-hexer`](https://github.com/danfinlay/browser-string-hexer) module.",schema:{type:"string",pattern:"^0x[a-fA-F\\d]+$"}},{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"personal_sign example",params:[{name:"Challenge",value:"0x506c65617365207369676e2074686973206d65737361676520746f20636f6e6669726d20796f7572206964656e746974792e"},{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"Signature",value:"0x43d7215ebe96c09a5adac69fc76dea5647286b501954ea273e417cf65e6c80e1db4891826375a7de02467a3e01caf125f64c851a8e9ee9467fd6f7e83523b2115bed8e79d527a85e28a36807d79b85fc551b5c15c1ead2e43456c31f565219203db2aed86cb3601b33ec3b410836d4be7718c6148dc9ac82ecc0a04c5edecd8914"}}]},{name:"eth_signTypedData_v4",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],summary:"Presents a structured data message for the user to sign.",description:"Presents a data message for the user to sign in a structured and readable format and returns the signed response. Introduced by [EIP-712](https://eips.ethereum.org/EIPS/eip-712). This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",params:[{name:"Address",required:!0,description:"The address of the requested signing account.",schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Typed data",required:!0,schema:{$ref:"#/components/schemas/TypedData"}}],result:{name:"Signature",description:"A hex-encoded signature.",schema:{type:"string",pattern:"^0x[0-9a-f]*$"}},examples:[{name:"eth_SignTypedData_v4 example",params:[{name:"Address",value:"0x0000000000000000000000000000000000000000"},{name:"Typed data",value:{types:{EIP712Domain:[{name:"name",type:"string"},{name:"version",type:"string"},{name:"chainId",type:"uint256"},{name:"verifyingContract",type:"address"}],Person:[{name:"name",type:"string"},{name:"wallet",type:"address"}],Mail:[{name:"from",type:"Person"},{name:"to",type:"Person"},{name:"contents",type:"string"}]},primaryType:"Mail",domain:{name:"Ether Mail",version:"1",chainId:1,verifyingContract:"0xCcCCccccCCCCcCCCCCCcCcCccCcCCCcCcccccccC"},message:{from:{name:"Cow",wallet:"0xCD2a3d9F938E13CD947Ec05AbC7FE734Df8DD826"},to:{name:"Bob",wallet:"0xbBbBBBBbbBBBbbbBbbBbbbbBBbBbbbbBbBbbBBbB"},contents:"Hello, Bob!"}}}],result:{name:"Signature",value:"0x4355c47d63924e8a72e509b65029052eb6c299d53a04e167c5775fd466751c9d07299936d304c153f6443dfa05f40ff007d72911b6f72307f996231605b915621c"}}]},{name:"wallet_registerOnboarding",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Multichain"}],summary:"Redirects the user back to the site after onboarding.",description:"Registers the requesting site with MetaMask as the initiator of onboarding, enabling MetaMask to redirect the user back to the site after onboarding. Returns a promise that resolves to `true`, or rejects the request if there's an error. Instead of calling this method directly, you should use the [`@metamask/onboarding`](https://github.com/MetaMask/metamask-onboarding) library.",params:[],result:{name:"Registered",description:"`true` if the request was successful, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_registerOnboarding example",params:[],result:{name:"Registered",value:!0}}]},{name:"wallet_watchAsset",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Experimental"},{$ref:"#/components/tags/Multichain"}],summary:"Tracks a token in MetaMask.",description:"Requests that the user track the specified token in MetaMask. Returns a boolean indicating if the token was successfully added. Once added, the token is indistinguishable from those added using legacy methods, such as a centralized registry. Introduced by [EIP-747](https://eips.ethereum.org/EIPS/eip-747).",paramStructure:"by-name",params:[{name:"type",schema:{type:"string",description:"The token type (`ERC20`, `ERC721`, or `ERC1155`). Support for ERC-721 and ERC-1155 tokens is experimental and currently only available on the extension (not on mobile). See [MIP-1](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-1.md) and the [MIP proposal lifecycle](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/PROCESS-GUIDE.md#proposal-lifecycle) for more information.",enum:["ERC20","ERC721","ERC1155"]},required:!0},{name:"options",schema:{description:"An object containing information about the token.",type:"object",required:["address"],properties:{address:{description:"The address of the token contract.",type:"string"},symbol:{description:"A ticker symbol or shorthand, up to 11 characters (optional for ERC-20 tokens).",minLength:2,maxLength:11,type:"string"},decimals:{description:"The number of token decimals (optional for ERC-20 tokens).",type:"number"},image:{description:"A string URL of the token logo (optional for ERC-20 tokens).",type:"string"},tokenId:{description:"The unique identifier of the NFT (required for ERC-721 and ERC-1155 tokens).",type:"string"}}}}],errors:[{code:-32602,message:"Must specify address, symbol, and decimals."},{code:-32602,message:"Invalid symbol: not a string."},{code:-32602,message:"Invalid symbol '${symbol}': longer than 11 characters."},{code:-32602,message:"Invalid decimals '${decimals}': must be 0 <= 36."},{code:-32602,message:"Invalid address '${address}'."},{code:-32602,message:"Asset type is required."},{code:-32602,message:"Both address and tokenId are required."},{code:-32602,message:"Invalid address."},{code:-32e3,message:"Suggested NFT is not owned by the selected account."},{code:-32e3,message:"Suggested NFT of type ${standard} does not match received type ${type}."},{code:-32002,message:"Unable to verify ownership. Possibly because the standard is not supported or the user's currently selected network does not match the chain of the asset in question."}],result:{name:"Added",description:"`true` if the token was added, `false` otherwise.",schema:{type:"boolean"}},examples:[{name:"wallet_watchAsset ERC-20 example",params:[{name:"type",value:"ERC20"},{name:"options",value:{address:"0xb60e8dd61c5d32be8058bb8eb970870f07233155",symbol:"FOO",decimals:18,image:"https://foo.io/token-image.svg"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-721 example",params:[{name:"type",value:"ERC721"},{name:"options",value:{address:"0x123456789abcdef0123456789abcdef01234567",tokenId:"42"}}],result:{name:"Added",value:!0}},{name:"wallet_watchAsset ERC-1155 example",params:[{name:"type",value:"ERC1155"},{name:"options",value:{address:"0xabcdef0123456789abcdef0123456789abcdef01",tokenId:"1337"}}],result:{name:"Added",value:!0}}]},{name:"wallet_scanQRCode",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Mobile"},{$ref:"#/components/tags/Multichain"}],summary:"Requests that the user scan a QR code.",description:"Requests that the user scan a QR code using their device camera. Introduced by [EIP-945](https://github.com/ethereum/EIPs/issues/945).",params:[{name:"Regex",required:!1,description:"A regular expression (regex) string for matching arbitrary QR code strings.",schema:{type:"string",title:"regex"}}],result:{name:"QR code string",description:"A string corresponding to the scanned QR code. If a regex string is provided, the resulting string matches it. If no regex string is provided, the resulting string matches an Ethereum address. If neither condition is met, the method returns an error.",schema:{type:"string",title:"QR code string"}}},{name:"wallet_sendCalls",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Sends a batch of calls.",description:"Requests that the wallet submits a batch of calls. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Calls",required:!0,schema:{$ref:"#/components/schemas/SendCallsParameter"}}],result:{name:"Batch result",schema:{description:"An object containing information about the sent batch.",type:"object",properties:{id:{description:"The ID of the batch of calls.",type:"string"},capabilities:{description:"Wallets can use this object to attach capability-specific metadata.",type:"object"}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{code:-32e3,message:"Version not supported."},{$ref:"#/components/errors/UserRejected"},{$ref:"#/components/errors/Unauthorized"},{code:5700,message:"The wallet does not support a capability that was not marked as optional."},{code:5710,message:"EIP-7702 not supported on the specified chain ID."},{code:5720,message:"There is already a batch submitted with the specified batch ID."},{code:5740,message:"The batch is too large for the wallet to process."},{code:5750,message:"EIP-7702 upgrade rejected for this chain and account."}],examples:[{name:"wallet_sendCalls example",params:[{name:"Calls",value:{version:"2.0.0",from:"0xd46e8dd67c5d32be8058bb8eb970870f07244567",chainId:"0xaa36a7",atomicRequired:!0,calls:[{to:"0x54f1C1965B355e1AB9ec3465616136be35bb5Ff7",value:"0x0"},{to:"0x2D48e6f5Ae053e4E918d2be53570961D880905F2",value:"0x0"}]}}],result:{name:"Batch result",value:{id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}}]},{name:"wallet_getCallsStatus",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the status of a call batch.",description:"Gets the status of a batch of calls that was previously sent using `wallet_sendCalls`. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Batch ID",required:!0,description:"The ID of a batch of calls (the `id` value returned by `wallet_sendCalls`).",schema:{type:"string"}}],result:{name:"Batch status",schema:{description:"An object containing status information of the batch of calls.",type:"object",properties:{version:{description:"The version of the API format.",type:"string"},id:{description:"The ID of the batch of calls.",$ref:"#/components/schemas/uint"},chainId:{description:"The chain ID of the calls.",$ref:"#/components/schemas/uint"},status:{description:"The status code of the batch of calls. Possible values are: <br> <ul>\n  <li>`100` - Pending</li>\n  <li>`200` - Confirmed</li>\n  <li>`400` - Failed offchain</li>\n  <li>`500` - Reverted</li>\n  <li>`600` - Partially reverted</li>\n</ul>",type:"number"},atomic:{description:"`true` if the wallet executed the calls atomically. `false` if the wallet executed the calls non-atomically.",type:"boolean"},receipts:{description:"An array of transaction receipts. If the wallet executed the calls atomically, a single receipt or an array of receipts may be returned, corresponding to how the batch of calls were included onchain.",type:"array",items:{title:"Receipt",description:"A transaction receipt object.",type:"object",properties:{logs:{description:"An array of log objects.",type:"array",items:{title:"Log",description:"An object containing information about the log.",type:"object",properties:{address:{description:"The address that generated the log.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data of the log.",type:"string",pattern:"^0x[0-9a-f]*$"},topics:{description:"An array of log topics.",type:"array",items:{title:"Topic",description:"A log topic.",type:"string",pattern:"^0x[0-9a-f]*$"}}}}},status:{description:"The status of the transaction. `0x1` indicates success, and `0x0` indicates failure.",type:"string",pattern:"^0x[0-1]$"},blockHash:{description:"The hash of the block containing the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"},blockNumber:{description:"The number of the block containing the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},gasUsed:{description:"The amount of gas used by the transaction.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},transactionHash:{description:"The hash of the transaction.",type:"string",pattern:"^0x[0-9a-f]{64}$"}},additionalProperties:!0}},capabilities:{description:"Capabilities associated with the batch of calls.",type:"object",additionalProperties:!0}}}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"},{code:5730,message:"No matching bundle found."}],examples:[{name:"wallet_getCallsStatus example",params:[{name:"Batch ID",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}],result:{name:"Batch status",value:{version:"2.0.0",chainId:"0xaa36a7",id:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331",status:200,atomic:!0,receipts:[{logs:[{address:"0xa922b54716264130634d6ff183747a8ead91a40b",topics:["0x5a2a90727cc9d000dd060b1132a5c977c9702bb3a52afe360c9c22f0e9451a68"],data:"0xabcd"}],status:"0x1",blockHash:"0xf19bbafd9fd0124ec110b848e8de4ab4f62bf60c189524e54213285e7f540d4a",blockNumber:"0xabcd",gasUsed:"0xdef",transactionHash:"0x9b7bb827c2e5e3c1a0a44dc53e573aa0b3af3bd1f9f5ed03071b100bb039eaff"}]}}}]},{name:"wallet_getCapabilities",tags:[{$ref:"#/components/tags/MetaMask"}],summary:"Gets the capabilities of the wallet.",description:"Returns information about the wallet's support for the `atomic` capability. The `atomic` capability specifies how the wallet will execute batches of transactions sent using `wallet_sendCalls`. `wallet_getCapabilities` is specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",params:[{name:"Address",description:"A wallet address.",required:!0,schema:{type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}},{name:"Chain IDs",description:"An array of chain IDs to get capabilities for.",schema:{type:"array",items:{title:"Chain ID",description:"An [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID in hexadecimal format.",$ref:"#/components/schemas/uint"}}}],result:{name:"Capabilities",schema:{description:"An object specifying the status of the `atomic` capability for specific [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain IDs. For each chain, the `atomic` capability can have a `status` of: <br> <ul>\n  <li>`supported` - The wallet will execute calls sent using\n        `wallet_sendCalls` atomically.</li>\n  <li>`ready` - The wallet can upgrade to `supported` pending user\n          approval to upgrade their account via EIP-7702.</li>\n</ul> If the `atomic` capability is not `supported` or `ready` for a specified chain ID, the wallet will not return anything for that chain ID.",type:"object"}},errors:[{$ref:"#/components/errors/InvalidParams"},{$ref:"#/components/errors/Unauthorized"}],examples:[{name:"wallet_getCapabilities example",params:[{name:"Address",value:"0xd46e8dd67c5d32be8058bb8eb970870f07244567"},{name:"Chain IDs",value:["0xaa36a7"]}],result:{name:"Capabilities",value:{"0xaa36a7":{atomic:{status:"ready"}}}}}]},{name:"eth_requestAccounts",tags:[{$ref:"#/components/tags/MetaMask"}],description:"Requests that the user provide access to one or more Ethereum addresses. This method is specified by [EIP-1102](https://eips.ethereum.org/EIPS/eip-1102). Internally, this method calls `wallet_requestPermissions` for permission to call `eth_accounts`.",summary:"Requests that the user provide access to addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},errors:[{$ref:"#/components/errors/UserRejected"}],examples:[{name:"eth_requestAccounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_accounts",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"}],description:"Returns a list of addresses that the user has authorized the dapp to access. This method requires calling `wallet_requestPermissions` for permission. We recommend using `eth_requestAccounts`, which internally calls `wallet_requestPermission`.",summary:"Gets a list of authorized addresses.",params:[],result:{name:"Address list",schema:{type:"array",description:"An array of Ethereum addresses that the user has authorized the dapp to access.",items:{title:"Address",description:"A hex-encoded address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"}}},examples:[{name:"eth_accounts example",params:[],result:{name:"Address list",value:["0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"]}}]},{name:"eth_sendTransaction",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Multichain"}],description:"Creates a new wallet confirmation to make an Ethereum transaction from the user's account. This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",summary:"Initiates a new transaction.",params:[{name:"Transaction",required:!0,description:"The transaction object to sign and send.",schema:{type:"object",title:"Transaction",description:"The parameters to customize a transaction. If a `to` address is not provided, the transaction is assumed to be a contract creation transaction, and the `data` field is used as the contract initialization code. `gasPrice` cannot be used together with `maxPriorityFeePerGas` and `maxFeePerGas`.",required:["from"],if:{properties:{to:{not:{type:"string"}}}},then:{required:["data"]},properties:{to:{description:"The recipient's address.",$ref:"#/components/schemas/address"},from:{description:"The sender's address.",$ref:"#/components/schemas/address"},gas:{description:"The maximum amount of gas the transaction is allowed to use.",$ref:"#/components/schemas/uint"},value:{description:"The amount to transfer in wei.",$ref:"#/components/schemas/uint"},data:{description:"The data to include in the transaction. Used for contract creation transactions.",$ref:"#/components/schemas/bytes"},gasPrice:{description:"The gas price the sender is willing to pay to miners in wei. Used in pre-1559 transactions.",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{description:"Maximum fee per gas the sender is willing to pay to miners in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"},maxFeePerGas:{description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei. Used in 1559 transactions.",$ref:"#/components/schemas/uint"}}}}],result:{name:"Transaction hash",description:"The transaction hash of the sent transaction.",schema:{type:"string",pattern:"^0x[0-9a-f]{64}$"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"sendTransaction",params:[{name:"Transaction",value:{to:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7",from:"0xDeaDbeefdEAdbeefdEadbEEFdeadbeefDEADbEEF",gas:"0x76c0",value:"0x8ac7230489e80000",data:"0x",gasPrice:"0x4a817c800"}}],result:{name:"eth_sendTransactionExampleResult",value:"0x4e306b5a5a37532e1734503f7d2427a86f2c992fbe471f5be403b9f734e667c8"}}]},{name:"eth_decrypt",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Decrypts an encrypted message.",description:"This method is deprecated and may be removed in the future.\n\n Requests that MetaMask decrypt the specified encrypted message.\n The message must have been encrypted using the public encryption key of the specified Ethereum address.\n Returns a promise that resolves to the decrypted message, or rejects if the decryption attempt fails.",params:[{name:"EncryptedMessage",required:!0,description:"The encrypted message to decrypt.",schema:{type:"string"}},{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"PermissionsList",schema:{$ref:"#/components/schemas/PermissionsList"}},errors:[{code:4100,message:"The requested account and/or method has not been authorized by the user."}],examples:[{name:"decryptExample",params:[{name:"EncryptedMessage",value:"0x7b2276657273696f6e223a227832353531392d7873616c736132302d706f6c7931333035222c226e6f6e6365223a2243533967507076467071765358704655416679726a7179774e35302b7a747766222c22657068656d5075626c69634b6579223a224372774b61456d2f4b356d6d714239764c376f5872636d6441417757764479324f784c3333527135576e553d222c2263697068657274657874223a2248347a65336e7177572b753174663956343945506167454e343872774f766b6952676244566e47587a38493d227d"},{name:"Address",value:"0xD1F5279BE4B4dD94133A23deE1B23F5bfC0Db1d0"}],result:{name:"eth_decryptExampleResult",value:"Hello, Ethereum!"}}]},{name:"eth_getEncryptionPublicKey",tags:[{$ref:"#/components/tags/MetaMask"},{$ref:"#/components/tags/Restricted"},{$ref:"#/components/tags/Deprecated"}],summary:"Gets a public key used for encryption.",description:"This method is deprecated and may be removed in the future.\n\n Requests that the user share their public encryption key.\n Returns a public encryption key, or rejects if the user denies the request.\n The public key is computed from entropy associated with the specified user account, using the NaCl implementation of the `X25519_XSalsa20_Poly1305` algorithm.",params:[{name:"Address",required:!0,description:"The address of the Ethereum account that can decrypt the message.",schema:{$ref:"#/components/schemas/address"}}],result:{name:"EncryptionKey",schema:{type:"string"}},examples:[{name:"eth_getEncryptionPublicKey",params:[{name:"Address",value:"0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"}],result:{name:"eth_getEncryptionPublicKeyExampleResult",value:"0x04bfcab3b7ca7e8b3f3b62b2f7f77e9e4b68080bbf8f0f4a1c8f890864d2c7c1d3c45d8b2e3f5f1c27dfeea4c2f5733e90bfc7484e2a690aa9b8ac4559d2e6a8d7"}}]},{name:"web3_clientVersion",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],description:"Returns the current MetaMask client version. This differs slightly per client. For example, the browser extension returns a string like `MetaMask/v10.33.1`, while the mobile app returns a string like `MetaMask/8.1.2/Mobile`.",summary:"Current client version.",params:[],examples:[{name:"MetaMaskClientVersionExample",description:"Example version response from MetaMask.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/v10.33.1"}},{name:"MetaMaskMobileClientVersionExample",description:"Example version response from MetaMask Mobile.",params:[],result:{name:"MetaMaskClientVersion",description:"The current client version.",value:"MetaMask/8.1.2/Mobile"}}],result:{name:"CurrentVersion",description:"The current client version.",schema:{title:"CurrentClientVersion",type:"string"}}},{name:"eth_subscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Subscribes to specific Ethereum events, returning a subscription ID used to receive notifications.",description:"Subscribes to specific events on the Ethereum network, such as new blocks, or logs. When an event occurs, a notification is sent to the client with the corresponding data. To stop receiving notifications, the client can unsubscribe using `eth_unsubscribe`.",params:[{name:"subscriptionType",required:!0,schema:{title:"subscriptionType",type:"string",enum:["newHeads","logs"],description:"The type of subscription to create. Must be one of the following:\n1. `newHeads` - New block headers.\n2. `logs` - Logs matching a filter object."}},{name:"filterOptions",required:!1,schema:{title:"filterOptions",type:"object",description:"(Optional) An object containing filter options specific to the subscription type. Only applicable for the `logs` subscription type.",required:["topics"],properties:{address:{type:"string",description:"(Optional) A single address or an array of addresses to filter the logs by."},topics:{type:"array",description:"An array of topics to filter the logs by.",items:{type:"string"}}}}}],result:{name:"subscriptionId",schema:{type:"string"},description:"A unique subscription ID that can be used to unsubscribe or identify incoming notifications."},examples:[{name:"eth_subscribe example",params:[{name:"subscriptionType",value:"newHeads"}],result:{name:"eth_subscribeExampleResult",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}}]},{name:"eth_unsubscribe",tags:[{$ref:"#/components/tags/Ethereum"},{$ref:"#/components/tags/Multichain"}],summary:"Unsubscribes from a specific Ethereum event, using the subscription ID provided by `eth_subscribe`.",description:"Unsubscribes from specific events on the Ethereum network, to which the client has been previously subscribed using `eth_subscribe`. The client must provide the subscription ID obtained from `eth_subscribe` to stop receiving notifications for the corresponding event.",params:[{name:"subscriptionId",required:!0,schema:{type:"string",description:"The unique subscription ID obtained from `eth_subscribe`, used to identify the subscription to be unsubscribed."}}],result:{name:"unsubscribed",schema:{type:"boolean"},description:"A boolean value indicating whether the unsubscription was successful."},examples:[{name:"eth_unsubscribe example",params:[{name:"subscriptionId",value:"0x1b84f2cdf29a204b79e450c1939b30c1"}],result:{name:"eth_unsubscribeExampleResult",value:!0}}]},{name:"eth_blockNumber",summary:"Returns the number of most recent block.",params:[],result:{name:"Block number",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_blockNumber example",params:[],result:{name:"Block number",value:"0x2377"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_call",summary:"Executes a new message call immediately without creating a transaction on the block chain.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Return data",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_call example",params:[{name:"Transaction",value:{to:"0x69498dd54bd25aa0c886cf1f8b8ae0856d55ff13",value:"0x1"}},{name:"Block",value:"latest"}],result:{name:"Return data",value:"0x"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_chainId",summary:"Returns the chain ID of the current network.",params:[],result:{name:"Chain ID",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_chainId example",params:[],result:{name:"Chain ID",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_coinbase",summary:"Returns the client coinbase address.",params:[],result:{name:"Coinbase address",schema:{$ref:"#/components/schemas/address"}},examples:[{name:"eth_coinbase example",params:[],result:{name:"Coinbase address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_estimateGas",summary:"Generates and returns an estimate of how much gas is necessary to allow the transaction to complete.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/GenericTransaction"}},{name:"Block",required:!1,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Gas used",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_estimateGas example",params:[{name:"Transaction",value:{from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",to:"0x44aa93095d6749a706051658b970b941c72c1d53",value:"0x1"}}],result:{name:"Gas used",value:"0x5208"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_feeHistory",summary:"Transaction fee history",description:"Returns transaction base fee per gas and effective priority fee per gas for the requested/supported block range.",params:[{name:"blockCount",description:"Requested range of blocks. Clients will return less than the requested range if not all blocks are available.",required:!0,schema:{$ref:"#/components/schemas/uint"}},{name:"newestBlock",description:"Highest block of the requested range.",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"rewardPercentiles",description:"A monotonically increasing list of percentile values. For each block in the requested range, the transactions will be sorted in ascending order by effective tip per gas and the coresponding effective tip for the percentile will be determined, accounting for gas consumed.",required:!0,schema:{title:"rewardPercentiles",type:"array",items:{title:"rewardPercentile",description:"Floating point value between 0 and 100.",type:"number"}}}],result:{name:"Fee history result",description:"Fee history for the returned block range. This can be a subsection of the requested range if not all blocks are available.",schema:{title:"feeHistoryResults",description:"Fee history results.",type:"object",required:["oldestBlock","baseFeePerGas","gasUsedRatio"],additionalProperties:!1,properties:{oldestBlock:{title:"oldestBlock",description:"Lowest number block of returned range.",$ref:"#/components/schemas/uint"},baseFeePerGas:{title:"baseFeePerGasArray",description:"An array of block base fees per gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-1559 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},baseFeePerBlobGas:{title:"baseFeePerBlobGasArray",description:"An array of block base fees per blob gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-4844 blocks.",type:"array",items:{$ref:"#/components/schemas/uint"}},gasUsedRatio:{title:"gasUsedRatio",description:"An array of block gas used ratios. These are calculated as the ratio of gasUsed and gasLimit.",type:"array",items:{$ref:"#/components/schemas/ratio"}},blobGasUsedRatio:{title:"blobGasUsedRatio",description:"An array of block blob gas used ratios. These are calculated as the ratio of blobGasUsed and the max blob gas per block.",type:"array",items:{$ref:"#/components/schemas/ratio"}},reward:{title:"rewardArray",description:"A two-dimensional array of effective priority fees per gas at the requested block percentiles.",type:"array",items:{title:"rewardPercentile",description:"An array of effective priority fee per gas data points from a single block. All zeroes are returned if the block is empty.",type:"array",items:{title:"rewardPercentile",description:"A given percentile sample of effective priority fees per gas from a single block in ascending order, weighted by gas used. Zeroes are returned if the block is empty.",$ref:"#/components/schemas/uint"}}}}}},examples:[{name:"eth_feeHistory example",params:[{name:"blockCount",value:"0x5"},{name:"newestblock",value:"latest"},{name:"rewardPercentiles",value:[20,30]}],result:{name:"Fee history result",value:{oldestblock:"0x10b52f",baseFeePerGas:["0x3fa63a3f","0x37f999ee","0x3e36f20a","0x4099f79a","0x430d532d","0x46fcd4a4"],baseFeePerBlobGas:["0x7b7609c19","0x6dbe41789","0x7223341d4","0x6574a002c","0x7223341d4","0x6574a002c"],gasUsedRatio:[.017712333333333333,.9458865666666667,.6534561,.6517375666666667,.7347769666666667],blobGasUsedRatio:[0,.6666666666666666,0,1,0],reward:[["0x3b9aca00","0x59682f00"],["0x3a13012","0x3a13012"],["0x3a13012","0x3a13012"],["0xf4240","0xf4240"],["0xf4240","0xf4240"]]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_gasPrice",summary:"Returns the current price per gas in wei.",params:[],result:{name:"Gas price",schema:{title:"Gas price",$ref:"#/components/schemas/uint"}},examples:[{name:"eth_gasPrice example",params:[],result:{name:"Gas price",value:"0x3e8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBalance",summary:"Returns the balance of the account of given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Balance",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getBalance example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Block",value:"latest"}],result:{name:"Balance",value:"0x1cfe56f3795885980000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByHash",summary:"Returns information about a block by hash.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByHash example",params:[{name:"Block hash",value:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockByNumber",summary:"Returns information about a block by number.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Hydrated transactions",required:!0,schema:{title:"hydrated",type:"boolean"}}],result:{name:"Block information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/Block"}]}},examples:[{name:"eth_getBlockByNumber example",params:[{name:"block",value:"0x68b3"},{name:"Hydrated transactions",value:!1}],result:{name:"Block information",value:{number:"0x68b3",hash:"0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",mixHash:"0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",parentHash:"0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",nonce:"0x378da40ff335b070",sha3Uncles:"0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",logsBloom:"0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",transactionsRoot:"0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",stateRoot:"0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",receiptsRoot:"0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",miner:"0xb42b6c4a95406c78ff892d270ad20b22642e102d",difficulty:"0x66e619a",totalDifficulty:"0x1e875d746ae",extraData:"0xd583010502846765746885676f312e37856c696e7578",size:"0x334",gasLimit:"0x47e7c4",gasUsed:"0x37993",timestamp:"0x5835c54d",uncles:[],transactions:["0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc","0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"],baseFeePerGas:"0x7",withdrawalsRoot:"0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",withdrawals:[{index:"0x0",validatorIndex:"0x9d8c0",address:"0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",amount:"0x11a33e3760"}],blobGasUsed:"0x0",excessBlobGas:"0x0",parentBeaconBlockRoot:"0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByHash",summary:"Returns the number of transactions in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByHash example",params:[{name:"Block hash",value:"0xb903239f8543d04b5dc1ba6579132b143087c68db1b2168786408fcbce568238"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getBlockTransactionCountByNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Transaction count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Transaction count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getBlockTransactionCountByNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Transaction count",value:"0x8"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getCode",summary:"Returns code at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Bytecode",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getCode example",params:[{name:"Address",value:"0xa50a51c09a5c451c52bb714527e1974b686d8e77"},{name:"Block",value:"latest"}],result:{name:"Bytecode",value:"0x60806040526004361060485763ffffffff7c01000000000000000000000000000000000000000000000000000000006000350416633fa4f2458114604d57806355241077146071575b600080fd5b348015605857600080fd5b50605f6088565b60408051918252519081900360200190f35b348015607c57600080fd5b506086600435608e565b005b60005481565b60008190556040805182815290517f199cd93e851e4c78c437891155e2112093f8f15394aa89dab09e38d6ca0727879181900360200190a1505600a165627a7a723058209d8929142720a69bde2ab3bfa2da6217674b984899b62753979743c0470a2ea70029"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterChanges",summary:"Polling method for the filter with the given ID (created using `eth_newFilter`). Returns an array of logs which occurred since last poll.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterChanges example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getFilterLogs",summary:"Returns an array of all logs matching the filter with the given ID (created using `eth_newFilter`).",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getFilterLogs example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getLogs",summary:"Returns an array of all logs matching the specified filter.",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Log objects",schema:{$ref:"#/components/schemas/FilterResults"}},examples:[{name:"eth_getLogs example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Log objects",value:[{logIndex:"0x0",removed:!1,blockNumber:"0x233",blockHash:"0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",transactionHash:"0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000004",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]},{logIndex:"0x0",removed:!1,blockNumber:"0x238",blockHash:"0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",transactionHash:"0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",transactionIndex:"0x0",address:"0x42699a7612a82f1d9c36148af9c77354759b210b",data:"0x0000000000000000000000000000000000000000000000000000000000000007",topics:["0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"]}]}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getProof",summary:"Returns the merkle proof for a given account and optionally some storage keys.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"StorageKeys",required:!0,schema:{title:"Storage keys",type:"array",items:{$ref:"#/components/schemas/bytesMax32"}}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Account",schema:{$ref:"#/components/schemas/AccountProof"}},examples:[{name:"eth_getProof example",params:[{name:"Address",value:"0xe5cB067E90D5Cd1F8052B83562Ae670bA4A211a8"},{name:"StorageKeys",value:["0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421","0x283s34c8e2b1456f09832c71e5d6a0b4f8c9e1d3a2b5c7f0e6d4a8b2c1f3e5d7"]},{name:"Block",value:"latest"}],result:{name:"Account",value:{accountProof:["0xf90211a06a718c2c9da77c253b12d7b2569657901e37bb691718f5dda1b86157ab1dd5eda0e7f19ed5e21bccc8d3260236b24f80ad88b3634f5d005f37b838881f0e12f1bda0abb301291704e4d92686c0f5f8ebb1734185321559b8d717ffdca95c99591976a0d0c2026bfab65c3b95276bfa82af9dec860b485f8857f293c148d63a2182128fa0c98044ec9a1273a218bed58b478277dd39173ad7b8edb95c200423a6bc8fc25fa056e5a55d9ddccdbf49362857200bbb1f042d61187c9f5f9ddcff5d2f1fc984a2a02a5b7200af424114f99a4b5f0a21c19aac82209e431ed80bfde177adb1004bdfa0026e4374f0518ff44a80fa374838ecb86cc64ac93bb710fea6dff4198f947b27a03fea341d87984673ad523177ed52f278bf4d8f97e6531c8ece932aeede4802f4a0bfe2f4a7fcb78f7e9f080dea7b6977fb1d88c441696e4456dad92b9d34ff0f43a02a3eb5c0edb14626c9c629601027bd60178bb2b688a67cea4d179fc432436615a0747355b8e02f3b884b4ffe5cea1619e32515fea064cca98208591af8c744e894a0874253737bae37f020ad3bb7e3292c7c4a63cdc158af6b33aaa4deaef016dccba03d8192bc1fc6aa1548912e763a0b5013a94399cefad7b47cf388873b2b794068a09b67f9737c6028d796bfd1c5da57a6f45824dc891f848ea0e1f8019d1fb5fba8a0aa871f9de8da85960fcd8a22cdf21c27f11e3966c14a6737ffd414b98dda00b280","0xf90211a0d360be1e1da1a0c32bc4c105833bd531e59d110684007b7c50fb2709002973eca0cf6dd1e350a7031b4e2ab49c899fd8bd47551c8565d8fd8d1d7796c83820c3b1a0eb0a88c29bb33989a589156f7bf07d9efc74034dd9d3f5b73385c3b45c3249bea02783c25f97a6ddb8dc07adf4b176991836d39184b1f678adeda832fff15e3664a00a4e288060045e587774d8a64993a7add73068b16863145e1e8eeb4602e18e19a0340851f4046ad1298962d6e47d05c66329549c839c158748aaad7ae00b943aefa085b127bc2a3bd17604283de21b2b3c9aa8f1d4b7b85c94d8105a46fe32c77688a00f531d62b3c5435324c01009c284fe31277e8d38302b75ea01be89f09e205969a00011c8351c0e3d639ac54b9d3a59de630b16a67de8270d7d6064d0a67e93f9cca048780d32b7f2db88650b51c46f46fd0a68795edee1fd5ecee6eb3595741d9669a0c91afd74eaf8e08a997061a62b354e2516fdc494e8e26cc50ceeb8f4a175608ba0e2c07f1b48fab80eecb340f5882e8c7b32ee416e4045c61f1df646a133487303a01a1eff78435a7a29a29463bdc3486ae81364b00bea82ba0fdf67a110770f2261a04f2eb440ba71c72da5fd7f0e439018d6671dc809f747213a1ea755848124e994a074ff9f37fce99daa3ed01dd763076450022996fc729be2cc43c61ec5182c2366a0b80b36b7b621112592f52390b89748d422e9b1517c4b0203b8176a53f89d4a6680","0xf90211a0b25f283bd01a8c8b2418049f9585bc37ff2c1e2e12eab4b7f64ae1f26647389aa02ad96c150d7c3c9c194d30315456852cf6a0a940e0191ae5d04007454823d4e9a0b220cf7a855e2dbcc0b973134e2e119b982d7d40dbb1b27d99816c41f40e829aa049224431da84cbf1b7ae813abcc9ef4c1dfc1760f6ddc5d57f7354bf3cbf6cc4a015191f879ac115b362f0257fd3eedb789537e836574a5b1abf1c9982ebe3bdfea07913c1b6e7282569d2d421e9fa2257f5d1698e93303bc49b941704287d7aaefea0a526576981ce6fd9f2bd48dd2ca6d5272f2fbdc85f0ee35a295f6ccd97ae8765a0313fad407f0c737c29024c02a890c4ecc12d7771c05ab7b435e5087a7cdef4d9a0d2044603cba9d4afdaf6fd2470e729ef3a65242de71276f20d59accfa6b53a7ca0457caacb9370c09b15f7d904adefd2308be94e23669ba5f43241ffff5f438a0aa09fb2dd45a383a0cc088a72b14117e1e9b7d6889218f3ac7631e8de644c5cb76da0c675dcd4d3fb692b514851c6106e2b09e6f5661d56a0a32ae02e2efc1515c235a074949a59ff1bdba87548510d6e404ec4532f4456dfdec8e753d92fda11a3088ba0a328c6ab1ab8f70db4d23e95bb163c13ba0c508f063a5b1393a4efd7ff375f05a0c722fe3ce796998269373cbb2fc229b2bdf2c43c6c2df003309422e043ce6c03a024e69343286eec44fa4744f6907209116e5383cff3fa98fe81ba06e7e8d4366680","0xf90211a00e99ba2198124b8241ea304551fe973215829e2fbc0438d67922707a2a847432a0bb9ce24fd527879c5fe6dbbec1ef5a05ed9d1ca88e921d140bafbec1112f6a6aa099787fd6c7a1989229c4291ef5267335e66152ce417daea46e66d19cb6f81d1ca0e430ff4b8d5621baa5978673344e78b4d8b4df51431b6e63785267c98a24ce18a0bb3e91a825fe3d42ed270a93e9ad1aabd566c40cb28e622f7f1d7ee967c8afd6a0aa364b0056870c6507bc3262a5f851ecb13684088bdb13996d3cb2db401ce3ffa0a3732eba4c7a6e062665ab5be08acb986c3db87556fb138548cc900ff1e56995a026b088e90c9738b8ce16e853107a937a50d52726a24f9f6ce60f587762eb45a2a006c9d5bc3c064b5c1fb565bff91cace9161c64ae653a329610c1dcf34d434429a06c16df2edc70656d322d0c2403bad7d45bc790ffc3e7adeef856d98ea6afc91ba0ae05ed5d6c34b5da29c2e94d7880aeba0906f95f4ec10b132a1d4766a0701c98a01470a86aa350d1ada0c082eac75de828a851f9c8c7c4aa49b1556fe3a5574966a0334eef025100a6da1033710dd98e0475f29d3d7e397caf618ca71c336c5f4f49a0ef0b3abbebcff34d6a8a8f5cdbfbd154ab3452b58dcb09de58ec983644963675a041857e865ec38e200a13bc1a3cb71c7d69aeef7ffdee8be515c9a5b691ce091fa059edd0eb3bbec36bbf38a19802d4646c00ba821ab55fdeea12e15bab62c4e1e580","0xf90211a0af0c7fa65ffcb84c31e68c1cf00e1a20bf8bb497c39883e19b66a99975b03431a0c492cab3623eb7926069794c3c718733e16c5fd0d4a13fb7c752ee9809aac7ada05003cea7132aa70d6f36731d60640a90bcd8f4fd493e4540d5ab1b4943679c0ca0fd700683405b1d2306b586dd3b5b2f92f1692fae20d17cd8b8e59d09b9c6670da01db8683910e46e56e8afeb9fe2b7c35382e5a0914d7b0dd8f0e8cb9981ba7435a0fa7f75d73aa73c35824387bec81388315caa4aee3f4f5562f971beb256c62d49a0ee478e420d83f413e8568dacfd5d83f83a5dd7c45f494b504828e5dc962f0e3ea094b95444a917ac94a675681f6bf851172ad0969801a783a63a71edafed45e7a7a0a0c46586e109abe80fe50361dd582e3f143cb416828239faa43bb2b890869501a0ae051d5d43634c68bf9c97823256cc68580f194dfdbd0c301140c7ca5853430ca0660b9365bb77ec9cdc6eb95516c162dca20727c6f828dbbeb1ae110dde4d3134a09feb1b75e84ff6722e4d837bfb6d207b6ee3b21b86844a01140ce293813b49a1a0ed58a70b04efa3bdc0babe2abfa20824a75d61d52291bfdb5cf08597800764d6a020a2d5d3a83f9e35ad9fd1c448626d90af0eb3efefaa4f2f93207b4096ef5507a0fc8efc4484dcf0a54f0574de9aaade0dcff6ec3599edb9f82efb26b6566dcaeaa032f7e79856db3fd984f72bb2c93d4dab328198d355a61c975fab1f08bdb2046580"],balance:"0x0",codeHash:"0xc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",nonce:"0x0",storageHash:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",storageProof:[{key:"0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",proof:["0xf90211a0c87222cccea2bf32759fcee9dbaacbe3ea4165dd6184af6773651c5e00e34a8ba0be90e6e5d1a67ab5587779c60ac136d6a96db62b84c04998a5f03a367346abd6a05344aa1c9ca2e3e56bf98fd718ec43728578d148e1967fbaf8bf17a2a073a0bda011a2f9312c3308640a0d6ceeae218747290f23806067456da1d444c65abae437a0b3097a108bfce79af6699da4ae3003cd4929f0b4576aad655c31cb725bde84c7a0c133d3c637e174f36a73c22b1039eb003da6374bc0929321241badb3efa3c4a9a0f13059f2301ad9862ce02e3f7f3f2c9ab78eb30583764d73654f7f1f8b1e86fda06544e3915748b18204e09df75ff20d2fa6bd8121e2e669699012d54590383d6fa070e3a8e093691581d58fadb560b510262a758037632cd8670d3a36df828976b7a062a88a2900544dc76a32255a6b2b2a2eef8fa68279700c00adc7508286702552a0a474aeebd5603dfce46a6ecd1ecd519068dc034a544fde03ac42d4018e60a334a0b7d528fc41c8fdc8ea18c6e7d0099270c777ec1403cf879d1f5134bdc12a6c6ca04440f1242e42c5bfa7c536591ab89c8e84bea417435871c32eef1e25295b20daa06a5dcfe3cc84cff9d3e3c3ae868cfba8f0dd111a90c3f85869dab5b893f96643a026b2fb9dd7d08b0ed2f1c44fbf875011412a384f86f751c92e1013248d4aa371a0c75597b2b789fc4e939b71937390ce9d7d53159431328ac52180eef08ef200f280","0xf90191a0f0c5b800b542001597f2b7a8e106ac0e2849d2cc1df1727ac35c4ea3965f1c9180a08537f2e248702a6ae2a57e9110a5740f5772c876389739ac90debd6a0692713ea00b3a26a05b5494fb3ff6f0b3897688a5581066b20b07ebab9252d169d928717fa0a9a54d84976d134d6dba06a65064c7f3a964a75947d452db6f6bb4b6c47b43aaa01e2a1ed3d1572b872bbf09ee44d2ed737da31f01de3c0f4b4e1f046740066461a076f251d160b9a02eb0b5c1d83b61c9cdd4f37361705e79a45529bf49801fb824a0774a01a624cb14a50d17f2fe4b7ae6af8a67bbb029177ccc3dd729a734484d3ea05921b8a19aebe4fff5a36071e311778f9b93459183fdf7f6d870b401fa25dcbba0c8d71dd13d2806e2865a5c2cfa447f626471bf0b66182a8fd07230434e1cad2680a0e9864fdfaf3693b2602f56cd938ccd494b8634b1f91800ef02203a3609ca4c21a0c69d174ad6b6e58b0bd05914352839ec60915cd066dd2bee2a48016139687f21a0513dd5514fd6bad56871711441d38de2821cc6913cb192416b0385f025650731808080"],value:"0x1"}]}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getStorageAt",summary:"Returns the value from a storage position at a given address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Storage slot",required:!0,schema:{$ref:"#/components/schemas/uint256"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Value",schema:{$ref:"#/components/schemas/bytes"}},examples:[{name:"eth_getStorageAt example",params:[{name:"Address",value:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"},{name:"Storage slot",value:"0x0"},{name:"Block",value:"latest"}],result:{name:"Value",value:"0x0000000000000000000000000000000000000000000000000000000000000000"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockHashAndIndex",summary:"Returns information about a transaction by block hash and transaction index position.",params:[{name:"Block hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockHashAndIndex example",params:[{name:"Block hash",value:"0xbf137c3a7a1ebdfac21252765e5d7f40d115c2757e4a4abee929be88c624fdb7"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByBlockNumberAndIndex",summary:"Returns information about a transaction by block number and transaction index position.",params:[{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTag"}},{name:"Transaction index",required:!0,schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByBlockNumberAndIndex example",params:[{name:"Block",value:"0x1442e"},{name:"Transaction index",value:"0x2"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionByHash",summary:"Returns the information about a transaction requested by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Transaction information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/TransactionInfo"}]}},examples:[{name:"eth_getTransactionByHash example",params:[{name:"Transaction hash",value:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44"}],result:{name:"Transaction information",value:{blockHash:"0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",blockNumber:"0x422",chainId:2018,from:"0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",gas:"0x5208",gasPrice:"0x3b9aca00",hash:"0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",input:"0x",nonce:"0x1",to:"0x627306090abab3a6e1400e9345bc60c78a8bef57",transactionIndex:"0x0",value:"0x4e1003b28d9280000",v:"0xfe7",r:"0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",s:"0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionCount",summary:"Returns the number of transactions sent from an address.",params:[{name:"Address",required:!0,schema:{$ref:"#/components/schemas/address"}},{name:"Block",required:!0,schema:{$ref:"#/components/schemas/BlockNumberOrTagOrHash"}}],result:{name:"Transaction count",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_getTransactionCount example",params:[{name:"Address",value:"0xc94770007dda54cF92009BFF0dE90c06F603a09f"},{name:"Block",value:"latest"}],result:{name:"Transaction count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getTransactionReceipt",summary:"Returns the receipt of a transaction by transaction hash.",params:[{name:"Transaction hash",required:!0,schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Receipt information",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{$ref:"#/components/schemas/ReceiptInfo"}]}},examples:[{name:"eth_getTransactionReceipt example",params:[{name:"Transaction hash",value:"0x504ce587a65bdbdb6414a0c6c16d86a04dd79bfcc4f2950eec9634b30ce5370f"}],result:{name:"Receipt information",value:{blockHash:"0xe7212a92cfb9b06addc80dec2a0dfae9ea94fd344efeb157c41e12994fcad60a",blockNumber:"0x50",contractAddress:null,cumulativeGasUsed:"0x5208",from:"0x627306090abab3a6e1400e9345bc60c78a8bef57",gasUsed:"0x5208",blobGasUsed:"0x20000",effectiveGasPrice:"0x1",blobGasPrice:"0x3",logs:[],logsBloom:"0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",status:"0x1",to:"0xf17f52151ebef6c7334fad080c5704d77216b732",transactionHash:"0xc00e97af59c6f88de163306935f7682af1a34c67245e414537d02e422815efc3",transactionIndex:"0x0"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockHash",summary:"Returns the number of uncles in a block from a block matching the given block hash.",params:[{name:"Block hash",schema:{$ref:"#/components/schemas/hash32"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockHash example",params:[{name:"Block hash",value:"0xb3b20624f8f0f86eb50dd04688409e5cea4bd02d700bf6e79e9384d47d6a5a35"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_getUncleCountByBlockNumber",summary:"Returns the number of transactions in a block matching the given block number.",params:[{name:"Block",schema:{$ref:"#/components/schemas/BlockNumberOrTag"}}],result:{name:"Uncle count",schema:{oneOf:[{$ref:"#/components/schemas/notFound"},{title:"Uncle count",$ref:"#/components/schemas/uint"}]}},examples:[{name:"eth_getUncleCountByBlockNumber example",params:[{name:"Block",value:"0xe8"}],result:{name:"Uncle count",value:"0x1"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newBlockFilter",summary:"Creates a filter in the node, to notify when a new block arrives.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newBlockFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newFilter",summary:"Creates a filter object, based on filter options, to notify when the state changes (logs).",params:[{name:"Filter",schema:{$ref:"#/components/schemas/Filter"}}],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newFilter example",params:[{name:"Filter",value:{fromBlock:"0x137d3c2",toBlock:"0x137d3c3",address:"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",topics:[]}}],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_newPendingTransactionFilter",summary:"Creates a filter in the node, to notify when new pending transactions arrive.",params:[],result:{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}},examples:[{name:"eth_newPendingTransactionFilter example",params:[],result:{name:"Filter identifier",value:"0x01"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_sendRawTransaction",summary:"Submits a raw transaction. You can create and sign a transaction externally using a library such as [web3.js](https://web3js.readthedocs.io/) or [ethers.js](https://docs.ethers.org/). For [EIP-4844](https://eips.ethereum.org/EIPS/eip-4844) transactions, the raw form must be the network form. This means it includes the blobs, KZG commitments, and KZG proofs.",params:[{name:"Transaction",required:!0,schema:{$ref:"#/components/schemas/bytes"}}],result:{name:"Transaction hash",schema:{$ref:"#/components/schemas/hash32"}},examples:[{name:"eth_sendRawTransaction example",params:[{name:"Transaction",value:"0xf869018203e882520894f17f52151ebef6c7334fad080c5704d77216b732881bc16d674ec80000801ba02da1c48b670996dcb1f447ef9ef00b33033c48a4fe938f420bec3e56bfd24071a062e0aa78a81bf0290afbc3a9d8e9a068e6d74caa66c5e0fa8a46deaae96b0833"}],result:{name:"Transaction hash",value:"0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_syncing",summary:"Returns an object with data about the sync status or false.",params:[],result:{name:"Syncing status",schema:{$ref:"#/components/schemas/SyncingStatus"}},examples:[{name:"eth_syncing example",params:[],result:{name:"Syncing status",value:{startingBlock:"0x0",currentBlock:"0x1518",highestBlock:"0x9567a3"}}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]},{name:"eth_uninstallFilter",summary:"Uninstalls a filter with given id.",params:[{name:"Filter identifier",schema:{$ref:"#/components/schemas/uint"}}],result:{name:"Success",schema:{type:"boolean"}},examples:[{name:"eth_uninstallFilter example",params:[{name:"Filter identifier",value:"0x01"}],result:{name:"Success",value:!0}}],tags:[{name:"Ethereum API",description:"Ethereum Node JSON-RPC method"},{name:"Multichain API",description:"Multichain JSON-RPC method"}]}],components:{errors:{UserRejected:{code:4001,message:"User rejected the request."},InvalidParams:{code:-32602,message:"The wallet cannot parse the request."},Unauthorized:{code:4100,message:"The requested account and/or method has not been authorized by the user."}},schemas:{TypedData:{title:"Typed data",description:"Object containing information about the typed data to sign.",type:"object",required:["types","primaryType","domain","message"],properties:{types:{type:"object",description:"Object containing type information.",required:["EIP712Domain"],properties:{EIP712Domain:{type:"array",items:{type:"object",title:"Domain separator value",description:"Object containing information about the domain separator value.",properties:{name:{type:"string",description:"Name of the domain separator value."},type:{type:"string",description:"Data type of the domain separator value."}}},description:"An array specifying one or more of the following domain separator values: <br><br> <ul>\n  <li>`name` - The user-readable name of the signing domain, that is, the name of the dapp or the protocol.</li>\n  <li>`version` - The current major version of the signing domain.</li>\n  <li>`chainId` - The chain ID of the network.</li>\n  <li>`verifyingContract` - The address of the contract that will verify the signature.</li>\n  <li>`salt` - A disambiguating salt for the protocol.</li>\n</ul>"}},additionalProperties:{type:"array",required:["name","type"],items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}}}}},domain:{type:"object",description:"Object containing the domain separator values specified in the `EIP712Domain` type."},primaryType:{type:"string",description:"The primary type of the message."},message:{type:"object",description:"The message you're proposing the user to sign."}}},SendCallsParameter:{title:"Calls",description:"An object containing information about a batch of calls.",type:"object",required:["version","from","chainId","atomicRequired","calls"],properties:{version:{description:"The version of the API format. This must be `2.0.0`.",type:"string"},id:{description:"The ID of the batch of calls.",type:"string"},from:{description:"The sender's address.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},chainId:{description:"The [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID of the calls. This must match the currently selected network in the wallet.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},atomicRequired:{description:"`true` if the wallet must execute all calls atomically. If `false`, the wallet may execute the calls sequentially without atomicity. If `false` and the wallet is capable of executing the calls atomically, it may do so.",type:"boolean"},calls:{type:"array",description:"An array of call objects.",items:{title:"Call",description:"An object containing information about the call.",type:"object",properties:{to:{description:"The address of the call's recipient.",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},data:{description:"The data to send with the call.",type:"string",pattern:"^0x[0-9a-f]*$"},value:{description:"The value to send with the call.",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}}},capabilities:{description:"Dapps can use this object to communicate with the wallet about supported capabilities.",type:"object"}}},AddEthereumChainParameter:{title:"Chain",description:"Object containing information about the chain to add.",type:"object",required:["chainId","chainName","nativeCurrency","rpcUrls"],properties:{chainId:{description:"The chain ID as a `0x`-prefixed hexadecimal string, per the `eth_chainId` method. MetaMask compares this chain ID value with the `eth_chainId` return value. If these values aren't identical, MetaMask rejects the request.",type:"string"},blockExplorerUrls:{description:"(Optional) An array of one or more URLs pointing to block explorer sites for the chain.",type:"array",items:{type:"string",description:"Block explorer URL."}},chainName:{description:"A human-readable name for the chain.",type:"string"},iconUrls:{description:"(Optional) An array of one or more URLs pointing to icons that can be used to visually identify the chain. Note: MetaMask will not currently display these icons. You can still include icon URLs so they are used if MetaMask incorporates them into the display of custom networks in the future.",type:"array",items:{format:"uri",type:"string",description:"Icon URL."}},nativeCurrency:{$ref:"#/components/schemas/NativeCurrency"},rpcUrls:{description:"An array of one or more URLs pointing to RPC endpoints that can be used to communicate with the chain. At least one item is required, and only the first item is used.",type:"array",minItems:1,items:{format:"uri",type:"string",description:"RPC URL."}}}},NativeCurrency:{title:"NativeCurrency",type:"object",description:"An object containing information about the native currency of the chain.",required:["decimals","symbol"],properties:{decimals:{description:"A non-negative integer representing the number of decimals the native currency uses.",minimum:0,type:"integer"},name:{description:"A human-readable name of the native currency.",type:"string"},symbol:{description:"A human-readable symbol of the native currency.",type:"string"}}},Caveats:{title:"Caveats",description:"An array of caveats that specify restrictions on the permission.",type:"array",items:{title:"Caveat",description:"Object containing information about the caveat.",type:"object",properties:{type:{title:"Type",type:"string",description:"Type of caveat."},value:{title:"CaveatValue",description:"Value of the caveat."},name:{title:"Name",type:"string",description:"Name of the caveat."}}}},Permission:{title:"Permission",description:"Object containing information about the permission.",type:"object",properties:{id:{description:"The permission ID.",type:"string"},parentCapability:{description:"The name of the permission being granted. For example, `eth_accounts` or `endowment:permitted-chains`.",type:"string"},invoker:{description:"The URI of the dapp being granted this permission.",type:"string"},caveats:{$ref:"#/components/schemas/Caveats"},date:{description:"The timestamp of the permission request.",type:"number"}}},PermissionsList:{title:"Permissions list",description:"An array of the user's permissions.",type:"array",items:{$ref:"#/components/schemas/Permission"}},address:{title:"hex encoded address",type:"string",pattern:"^0x[0-9a-fA-F]{40}$"},addresses:{title:"hex encoded address",type:"array",items:{$ref:"#/components/schemas/address"}},byte:{title:"hex encoded byte",type:"string",pattern:"^0x([0-9a-fA-F]?){1,2}$"},bytes:{title:"hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]*$"},bytesMax32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{0,64}$"},bytes8:{title:"8 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{16}$"},bytes32:{title:"32 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{64}$"},bytes48:{title:"48 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{96}$"},bytes96:{title:"96 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{192}$"},bytes256:{title:"256 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{512}$"},bytes65:{title:"65 hex encoded bytes",type:"string",pattern:"^0x[0-9a-f]{130}$"},ratio:{title:"normalized ratio",type:"number",minimum:0,maximum:1},uint:{title:"hex encoded unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]*|0)$"},uint64:{title:"hex encoded 64 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,15})|0$"},uint256:{title:"hex encoded 256 bit unsigned integer",type:"string",pattern:"^0x([1-9a-f]+[0-9a-f]{0,31})|0$"},hash32:{title:"32 byte hex value",type:"string",pattern:"^0x[0-9a-f]{64}$"},notFound:{title:"Not Found (null)",type:"null"},Block:{title:"Block object",type:"object",required:["hash","parentHash","sha3Uncles","miner","stateRoot","transactionsRoot","receiptsRoot","logsBloom","number","gasLimit","gasUsed","timestamp","extraData","mixHash","nonce","size","transactions","uncles"],additionalProperties:!1,properties:{hash:{title:"Hash",$ref:"#/components/schemas/hash32"},parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},sha3Uncles:{title:"Ommers hash",$ref:"#/components/schemas/hash32"},miner:{title:"Coinbase",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},transactionsRoot:{title:"Transactions root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},difficulty:{title:"Difficulty",$ref:"#/components/schemas/uint"},number:{title:"Number",$ref:"#/components/schemas/uint"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytes"},mixHash:{title:"Mix hash",$ref:"#/components/schemas/hash32"},nonce:{title:"Nonce",$ref:"#/components/schemas/bytes8"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint"},withdrawalsRoot:{title:"Withdrawals root",$ref:"#/components/schemas/hash32"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint"},parentBeaconBlockRoot:{title:"Parent Beacon Block Root",$ref:"#/components/schemas/hash32"},size:{title:"Block size",$ref:"#/components/schemas/uint"},transactions:{anyOf:[{title:"Transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"Full transactions",type:"array",items:{$ref:"#/components/schemas/TransactionInfo"}}]},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/Withdrawal"}},uncles:{title:"Uncles",type:"array",items:{$ref:"#/components/schemas/hash32"}}}},BlockTag:{title:"Block tag",type:"string",enum:["earliest","finalized","safe","latest","pending"],description:"`earliest`: The lowest numbered block the client has available; `finalized`: The most recent crypto-economically secure block, cannot be re-orged outside of manual intervention driven by community coordination; `safe`: The most recent block that is safe from re-orgs under honest majority and certain synchronicity assumptions; `latest`: The most recent block in the canonical chain observed by the client, this block may be re-orged out of the canonical chain even under healthy/normal conditions; `pending`: A sample next block built by the client on top of `latest` and containing the set of transactions usually taken from local mempool. Before the merge transition is finalized, any call querying for `finalized` or `safe` block MUST be responded to with `-39001: Unknown block` error"},BlockNumberOrTag:{title:"Block number or tag",oneOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"}]},BlockNumberOrTagOrHash:{title:"Block number, tag, or block hash",anyOf:[{title:"Block number",$ref:"#/components/schemas/uint"},{title:"Block tag",$ref:"#/components/schemas/BlockTag"},{title:"Block hash",$ref:"#/components/schemas/hash32"}]},BadBlock:{title:"Bad block",type:"object",required:["block","hash","rlp"],additionalProperties:!1,properties:{block:{title:"Block",$ref:"#/components/schemas/Block"},hash:{title:"Hash",$ref:"#/components/schemas/hash32"},rlp:{title:"RLP",$ref:"#/components/schemas/bytes"}}},SyncingStatus:{title:"Syncing status",oneOf:[{title:"Syncing progress",type:"object",additionalProperties:!1,properties:{startingBlock:{title:"Starting block",$ref:"#/components/schemas/uint"},currentBlock:{title:"Current block",$ref:"#/components/schemas/uint"},highestBlock:{title:"Highest block",$ref:"#/components/schemas/uint"}}},{title:"Not syncing",description:"Should always return false if not syncing.",type:"boolean"}]},FilterResults:{title:"Filter results",oneOf:[{title:"new block or transaction hashes",type:"array",items:{$ref:"#/components/schemas/hash32"}},{title:"new logs",type:"array",items:{$ref:"#/components/schemas/Log"}}]},Filter:{title:"filter",type:"object",additionalProperties:!1,properties:{fromBlock:{title:"from block",$ref:"#/components/schemas/uint"},toBlock:{title:"to block",$ref:"#/components/schemas/uint"},address:{title:"Address(es)",oneOf:[{title:"Any Address",type:"null"},{title:"Address",$ref:"#/components/schemas/address"},{title:"Addresses",$ref:"#/components/schemas/addresses"}]},topics:{title:"Topics",$ref:"#/components/schemas/FilterTopics"}}},FilterTopics:{title:"Filter Topics",oneOf:[{title:"Any Topic Match",type:"null"},{title:"Specified Filter Topics",type:"array",items:{$ref:"#/components/schemas/FilterTopic"}}]},FilterTopic:{title:"Filter Topic List Entry",oneOf:[{title:"Single Topic Match",$ref:"#/components/schemas/bytes32"},{title:"Multiple Topic Match",type:"array",items:{$ref:"#/components/schemas/bytes32"}}]},Log:{title:"log",type:"object",required:["transactionHash"],additionalProperties:!1,properties:{removed:{title:"removed",type:"boolean"},logIndex:{title:"log index",$ref:"#/components/schemas/uint"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},address:{title:"address",$ref:"#/components/schemas/address"},data:{title:"data",$ref:"#/components/schemas/bytes"},topics:{title:"topics",type:"array",items:{$ref:"#/components/schemas/bytes32"}}}},ReceiptInfo:{type:"object",title:"Receipt information",required:["blockHash","blockNumber","from","cumulativeGasUsed","gasUsed","logs","logsBloom","transactionHash","transactionIndex","effectiveGasPrice"],additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},transactionHash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"},blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from",$ref:"#/components/schemas/address"},to:{title:"to",description:"Address of the receiver or null in a contract creation transaction.",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Recipient Address",$ref:"#/components/schemas/address"}]},cumulativeGasUsed:{title:"cumulative gas used",description:"The sum of gas used by this transaction and all preceding transactions in the same block.",$ref:"#/components/schemas/uint"},gasUsed:{title:"gas used",description:"The amount of gas used for this specific transaction alone.",$ref:"#/components/schemas/uint"},blobGasUsed:{title:"blob gas used",description:"The amount of blob gas used for this specific transaction. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"},contractAddress:{title:"contract address",description:"The contract address created, if the transaction was a contract creation, otherwise null.",oneOf:[{$ref:"#/components/schemas/address"},{title:"Null",type:"null"}]},logs:{title:"logs",type:"array",items:{$ref:"#/components/schemas/Log"}},logsBloom:{title:"logs bloom",$ref:"#/components/schemas/bytes256"},root:{title:"state root",description:"The post-transaction state root. Only specified for transactions included before the Byzantium upgrade.",$ref:"#/components/schemas/hash32"},status:{title:"status",description:"Either 1 (success) or 0 (failure). Only specified for transactions included after the Byzantium upgrade.",$ref:"#/components/schemas/uint"},effectiveGasPrice:{title:"effective gas price",description:"The actual value per gas deducted from the sender's account. Before EIP-1559, this is equal to the transaction's gas price. After, it is equal to baseFeePerGas + min(maxFeePerGas - baseFeePerGas, maxPriorityFeePerGas).",$ref:"#/components/schemas/uint"},blobGasPrice:{title:"blob gas price",description:"The actual value per gas deducted from the sender's account for blob gas. Only specified for blob transactions as defined by EIP-4844.",$ref:"#/components/schemas/uint"}}},AccountProof:{title:"Account proof",type:"object",required:["address","accountProof","balance","codeHash","nonce","storageHash","storageProof"],additionalProperties:!1,properties:{address:{title:"address",$ref:"#/components/schemas/address"},accountProof:{title:"accountProof",type:"array",items:{$ref:"#/components/schemas/bytes"}},balance:{title:"balance",$ref:"#/components/schemas/uint256"},codeHash:{title:"codeHash",$ref:"#/components/schemas/hash32"},nonce:{title:"nonce",$ref:"#/components/schemas/uint64"},storageHash:{title:"storageHash",$ref:"#/components/schemas/hash32"},storageProof:{title:"Storage proofs",type:"array",items:{$ref:"#/components/schemas/StorageProof"}}}},StorageProof:{title:"Storage proof",type:"object",required:["key","value","proof"],additionalProperties:!1,properties:{key:{title:"key",$ref:"#/components/schemas/bytesMax32"},value:{title:"value",$ref:"#/components/schemas/uint256"},proof:{title:"proof",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},Transaction4844Unsigned:{type:"object",title:"EIP-4844 transaction.",required:["type","nonce","to","gas","value","input","maxPriorityFeePerGas","maxFeePerGas","maxFeePerBlobGas","accessList","blobVersionedHashes","chainId"],properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},AccessListEntry:{title:"Access list entry",type:"object",additionalProperties:!1,properties:{address:{$ref:"#/components/schemas/address"},storageKeys:{type:"array",items:{$ref:"#/components/schemas/hash32"}}}},AccessList:{title:"Access list",type:"array",items:{$ref:"#/components/schemas/AccessListEntry"}},Transaction1559Unsigned:{type:"object",title:"EIP-1559 transaction.",required:["type","nonce","gas","value","input","maxFeePerGas","maxPriorityFeePerGas","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x2$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},gasPrice:{title:"gas price",description:"The effective gas price paid by the sender in wei. For transactions not yet included in a block, this value should be set equal to the max fee per gas. This field is DEPRECATED, please transition to using effectiveGasPrice in the receipt object going forward.",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Transaction2930Unsigned:{type:"object",title:"EIP-2930 transaction.",required:["type","nonce","gas","value","input","gasPrice","chainId","accessList"],properties:{type:{title:"type",type:"string",pattern:"^0x1$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionLegacyUnsigned:{type:"object",title:"Legacy transaction.",required:["type","nonce","gas","value","input","gasPrice"],properties:{type:{title:"type",type:"string",pattern:"^0x0$"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},TransactionUnsigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{$ref:"#/components/schemas/Transaction1559Unsigned"},{$ref:"#/components/schemas/Transaction2930Unsigned"},{$ref:"#/components/schemas/TransactionLegacyUnsigned"}]},Transaction4844Signed:{title:"Signed 4844 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction4844Unsigned"},{title:"EIP-4844 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction1559Signed:{title:"Signed 1559 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction1559Unsigned"},{title:"EIP-1559 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},Transaction2930Signed:{title:"Signed 2930 Transaction",type:"object",allOf:[{$ref:"#/components/schemas/Transaction2930Unsigned"},{title:"EIP-2930 transaction signature properties.",required:["yParity","r","s"],properties:{yParity:{title:"yParity",description:"The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",$ref:"#/components/schemas/uint"},v:{title:"v",description:"For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionLegacySigned:{title:"Signed Legacy Transaction",type:"object",allOf:[{$ref:"#/components/schemas/TransactionLegacyUnsigned"},{title:"Legacy transaction signature properties.",required:["v","r","s"],properties:{v:{title:"v",$ref:"#/components/schemas/uint"},r:{title:"r",$ref:"#/components/schemas/uint"},s:{title:"s",$ref:"#/components/schemas/uint"}}}]},TransactionSigned:{oneOf:[{$ref:"#/components/schemas/Transaction4844Signed"},{$ref:"#/components/schemas/Transaction1559Signed"},{$ref:"#/components/schemas/Transaction2930Signed"},{$ref:"#/components/schemas/TransactionLegacySigned"}]},TransactionInfo:{type:"object",title:"Transaction information",allOf:[{title:"Contextual information",required:["blockHash","blockNumber","from","hash","transactionIndex"],unevaluatedProperties:!1,properties:{blockHash:{title:"block hash",$ref:"#/components/schemas/hash32"},blockNumber:{title:"block number",$ref:"#/components/schemas/uint"},from:{title:"from address",$ref:"#/components/schemas/address"},hash:{title:"transaction hash",$ref:"#/components/schemas/hash32"},transactionIndex:{title:"transaction index",$ref:"#/components/schemas/uint"}}},{$ref:"#/components/schemas/TransactionSigned"}]},GenericTransaction:{type:"object",title:"Transaction object generic to all types",additionalProperties:!1,properties:{type:{title:"type",$ref:"#/components/schemas/byte"},nonce:{title:"nonce",$ref:"#/components/schemas/uint"},to:{title:"to address",oneOf:[{title:"Contract Creation (null)",type:"null"},{title:"Address",$ref:"#/components/schemas/address"}]},from:{title:"from address",$ref:"#/components/schemas/address"},gas:{title:"gas limit",$ref:"#/components/schemas/uint"},value:{title:"value",$ref:"#/components/schemas/uint"},input:{title:"input data",$ref:"#/components/schemas/bytes"},gasPrice:{title:"gas price",description:"The gas price willing to be paid by the sender in wei",$ref:"#/components/schemas/uint"},maxPriorityFeePerGas:{title:"max priority fee per gas",description:"Maximum fee per gas the sender is willing to pay to miners in wei",$ref:"#/components/schemas/uint"},maxFeePerGas:{title:"max fee per gas",description:"The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",$ref:"#/components/schemas/uint"},maxFeePerBlobGas:{title:"max fee per blob gas",description:"The maximum total fee per gas the sender is willing to pay for blob gas in wei",$ref:"#/components/schemas/uint"},accessList:{title:"accessList",description:"EIP-2930 access list",$ref:"#/components/schemas/AccessList"},blobVersionedHashes:{title:"blobVersionedHashes",description:"List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",type:"array",items:{$ref:"#/components/schemas/hash32"}},blobs:{title:"blobs",description:"Raw blob data.",type:"array",items:{$ref:"#/components/schemas/bytes"}},chainId:{title:"chainId",description:"Chain ID that this transaction is valid on.",$ref:"#/components/schemas/uint"}}},Withdrawal:{type:"object",title:"Validator withdrawal",required:["index","validatorIndex","address","amount"],additionalProperties:!1,properties:{index:{title:"index of withdrawal",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"index of validator that generated withdrawal",$ref:"#/components/schemas/uint64"},address:{title:"recipient address for withdrawal value",$ref:"#/components/schemas/address"},amount:{title:"value contained in withdrawal",$ref:"#/components/schemas/uint256"}}},ForkchoiceStateV1:{title:"Forkchoice state object V1",type:"object",required:["headBlockHash","safeBlockHash","finalizedBlockHash"],properties:{headBlockHash:{title:"Head block hash",$ref:"#/components/schemas/hash32"},safeBlockHash:{title:"Safe block hash",$ref:"#/components/schemas/hash32"},finalizedBlockHash:{title:"Finalized block hash",$ref:"#/components/schemas/hash32"}}},ForkchoiceUpdatedResponseV1:{title:"Forkchoice updated response",type:"object",required:["payloadStatus"],properties:{payloadStatus:{title:"Payload status",$ref:"#/components/schemas/RestrictedPayloadStatusV1"},payloadId:{title:"Payload id",$ref:"#/components/schemas/bytes8"}}},PayloadAttributesV1:{title:"Payload attributes object V1",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient"],properties:{timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},suggestedFeeRecipient:{title:"Suggested fee recipient",$ref:"#/components/schemas/address"}}},PayloadAttributesV2:{title:"Payload attributes object V2",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV1/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV1/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV1/properties/suggestedFeeRecipient"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},PayloadAttributesV3:{title:"Payload attributes object V3",type:"object",required:["timestamp","prevRandao","suggestedFeeRecipient","withdrawals","parentBeaconBlockRoot"],properties:{timestamp:{$ref:"#/components/schemas/PayloadAttributesV2/properties/timestamp"},prevRandao:{$ref:"#/components/schemas/PayloadAttributesV2/properties/prevRandao"},suggestedFeeRecipient:{$ref:"#/components/schemas/PayloadAttributesV2/properties/suggestedFeeRecipient"},withdrawals:{$ref:"#/components/schemas/PayloadAttributesV2/properties/withdrawals"},parentBeaconBlockRoot:{title:"Parent beacon block root",$ref:"#/components/schemas/hash32"}}},PayloadStatusV1:{title:"Payload status object V1",type:"object",required:["status"],properties:{status:{title:"Payload validation status",type:"string",enum:["VALID","INVALID","SYNCING","ACCEPTED","INVALID_BLOCK_HASH"]},latestValidHash:{title:"The hash of the most recent valid block",$ref:"#/components/schemas/hash32"},validationError:{title:"Validation error message",type:"string"}}},RestrictedPayloadStatusV1:{$ref:"#/components/schemas/PayloadStatusV1",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",description:"Set of possible values is restricted to VALID, INVALID, SYNCING",enum:["VALID","INVALID","SYNCING"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},PayloadStatusNoInvalidBlockHash:{$ref:"#/components/schemas/PayloadStatusV1",title:"Payload status object deprecating INVALID_BLOCK_HASH status",properties:{status:{$ref:"#/components/schemas/PayloadStatusV1/properties/status",enum:["VALID","INVALID","SYNCING","ACCEPTED"]},latestValidHash:{$ref:"#/components/schemas/PayloadStatusV1/properties/latestValidHash"},validationError:{$ref:"#/components/schemas/PayloadStatusV1/properties/validationError"}}},ExecutionPayloadV1:{title:"Execution payload object V1",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions"],properties:{parentHash:{title:"Parent block hash",$ref:"#/components/schemas/hash32"},feeRecipient:{title:"Recipient of transaction priority fees",$ref:"#/components/schemas/address"},stateRoot:{title:"State root",$ref:"#/components/schemas/hash32"},receiptsRoot:{title:"Receipts root",$ref:"#/components/schemas/hash32"},logsBloom:{title:"Bloom filter",$ref:"#/components/schemas/bytes256"},prevRandao:{title:"Previous randao value",$ref:"#/components/schemas/bytes32"},blockNumber:{title:"Block number",$ref:"#/components/schemas/uint64"},gasLimit:{title:"Gas limit",$ref:"#/components/schemas/uint64"},gasUsed:{title:"Gas used",$ref:"#/components/schemas/uint64"},timestamp:{title:"Timestamp",$ref:"#/components/schemas/uint64"},extraData:{title:"Extra data",$ref:"#/components/schemas/bytesMax32"},baseFeePerGas:{title:"Base fee per gas",$ref:"#/components/schemas/uint256"},blockHash:{title:"Block hash",$ref:"#/components/schemas/hash32"},transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},WithdrawalV1:{title:"Withdrawal object V1",type:"object",required:["index","validatorIndex","address","amount"],properties:{index:{title:"Withdrawal index",$ref:"#/components/schemas/uint64"},validatorIndex:{title:"Validator index",$ref:"#/components/schemas/uint64"},address:{title:"Withdrawal address",$ref:"#/components/schemas/address"},amount:{title:"Withdrawal amount",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV2:{title:"Execution payload object V2",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:"array",items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadV3:{title:"Execution payload object V3",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV2/properties/withdrawals"},blobGasUsed:{title:"Blob gas used",$ref:"#/components/schemas/uint64"},excessBlobGas:{title:"Excess blob gas",$ref:"#/components/schemas/uint64"}}},ExecutionPayloadV4:{title:"Execution payload object V4",type:"object",required:["parentHash","feeRecipient","stateRoot","receiptsRoot","logsBloom","prevRandao","blockNumber","gasLimit","gasUsed","timestamp","extraData","baseFeePerGas","blockHash","transactions","withdrawals","blobGasUsed","excessBlobGas","depositRequests","withdrawalRequests","consolidationRequests"],properties:{parentHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/parentHash"},feeRecipient:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/feeRecipient"},stateRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/stateRoot"},receiptsRoot:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/receiptsRoot"},logsBloom:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/logsBloom"},prevRandao:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/prevRandao"},blockNumber:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockNumber"},gasLimit:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasLimit"},gasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/gasUsed"},timestamp:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/timestamp"},extraData:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/extraData"},baseFeePerGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/baseFeePerGas"},blockHash:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blockHash"},transactions:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/transactions"},withdrawals:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/withdrawals"},blobGasUsed:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/blobGasUsed"},excessBlobGas:{$ref:"#/components/schemas/ExecutionPayloadV3/properties/excessBlobGas"},depositRequests:{title:"Deposit requests",type:"array",items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:"array",items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests",type:"array",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},ExecutionPayloadBodyV1:{title:"Execution payload body object V1",type:"object",required:["transactions"],properties:{transactions:{$ref:"#/components/schemas/ExecutionPayloadV1/properties/transactions"},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}}}},ExecutionPayloadBodyV2:{title:"Execution payload body object V2",type:"object",required:["transactions"],properties:{transactions:{title:"Transactions",type:"array",items:{$ref:"#/components/schemas/bytes"}},withdrawals:{title:"Withdrawals",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalV1"}},depositRequests:{title:"Deposit requests",type:["array","null"],items:{$ref:"#/components/schemas/DepositRequestV1"}},withdrawalRequests:{title:"Withdrawals requests",type:["array","null"],items:{$ref:"#/components/schemas/WithdrawalRequestV1"}},consolidationRequests:{title:"Consolidation requests - array - 'null'",items:{$ref:"#/components/schemas/ConsolidationRequestV1"}}}},BlobsBundleV1:{title:"Blobs bundle object V1",type:"object",required:["commitments","proofs","blobs"],properties:{commitments:{title:"Commitments",type:"array",items:{$ref:"#/components/schemas/bytes48"}},proofs:{title:"Proofs",type:"array",items:{$ref:"#/components/schemas/bytes48"}},blobs:{title:"Blobs",type:"array",items:{$ref:"#/components/schemas/bytes"}}}},DepositRequestV1:{title:"Deposit request object V1",type:"object",required:["pubkey","withdrawalCredentials","amount","signature","index"],properties:{pubkey:{title:"Public key",$ref:"#/components/schemas/bytes48"},withdrawalCredentials:{title:"Withdrawal credentials",$ref:"#/components/schemas/bytes32"},amount:{title:"Deposit amount",$ref:"#/components/schemas/uint64"},signature:{title:"Deposit signature",$ref:"#/components/schemas/bytes96"},index:{title:"Deposit index",$ref:"#/components/schemas/uint64"}}},WithdrawalRequestV1:{title:"Withdrawal request object V1",type:"object",required:["sourceAddress","validatorPubkey","amount"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},validatorPubkey:{title:"Validator public key",$ref:"#/components/schemas/bytes48"},amount:{title:"Withdraw amount",$ref:"#/components/schemas/uint64"}}},ConsolidationRequestV1:{title:"Consolidation request object V1",type:"object",required:["sourceAddress","sourcePubkey","targetPubkey"],properties:{sourceAddress:{title:"Source address",$ref:"#/components/schemas/address"},sourcePubkey:{title:"Source validator public key",$ref:"#/components/schemas/bytes48"},targetPubkey:{title:"Target validator public key",$ref:"#/components/schemas/bytes48"}}},TransitionConfigurationV1:{title:"Transition configuration object",type:"object",required:["terminalTotalDifficulty","terminalBlockHash","terminalBlockNumber"],properties:{terminalTotalDifficulty:{title:"Terminal total difficulty",$ref:"#/components/schemas/uint256"},terminalBlockHash:{title:"Terminal block hash",$ref:"#/components/schemas/hash32"},terminalBlockNumber:{title:"Terminal block number",$ref:"#/components/schemas/uint64"}}}},tags:{MetaMask:{name:"MetaMask",description:"MetaMask-specific methods."},Restricted:{name:"Restricted",description:"Restricted methods. If a method is restricted, the caller must have the corresponding permission via `wallet_requestPermissions` in order to call it."},Mobile:{name:"Mobile",description:"Mobile-specific methods."},Experimental:{name:"Experimental",description:"Experimental methods."},Deprecated:{name:"Deprecated",description:"Deprecated methods."},Ethereum:{name:"Ethereum API",description:"Ethereum execution API methods."},Multichain:{name:"Multichain API",description:"Multichain API methods."}},contentDescriptors:{},examplePairings:{},links:{},examples:{}}}}}},{package:"@metamask/chain-agnostic-permission>@metamask/api-specs",file:"node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/build/openrpc.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/index.js",{"./build/multichain-openrpc.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/build/multichain-openrpc.json","./build/openrpc.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/build/openrpc.json"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.MultiChainOpenRPCDocument=s.MetaMaskOpenRPCDocument=void 0;const n=r(e("./build/openrpc.json"));s.MetaMaskOpenRPCDocument=n.default;const a=r(e("./build/multichain-openrpc.json"));s.MultiChainOpenRPCDocument=a.default,s.default=n.default}}},{package:"@metamask/chain-agnostic-permission>@metamask/api-specs",file:"node_modules/@metamask/chain-agnostic-permission/node_modules/@metamask/api-specs/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/contract-metadata/contract-map.json",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){t.exports={"0x12652C6d93FDB6F4f37d48A8687783C782BB0d10":{name:"Entangle",logo:"NGL.svg",erc20:!0,symbol:"NGL",decimals:18},"0xB50721BCf8d664c30412Cfbc6cf7a15145234ad1":{name:"Arbitrum",logo:"Arb.svg",erc20:!0,symbol:"ARB",decimals:18},"0x4D0528598F916Fd1D8dc80e5f54a8fEEDcFd4b18":{name:"Atoshi",logo:"ATOS.svg",erc20:!0,symbol:"ATOS",decimals:18},"0x57B946008913B82E4dF85f501cbAeD910e58D26C":{name:"POND",logo:"POND.svg",erc20:!0,symbol:"POND",decimals:18},"0x5eed99d066a8CaF10f3E4327c1b3D8b673485eED":{name:"SEED",logo:"SEED.svg",erc20:!0,symbol:"SEED",decimals:18},"0x487d62468282Bd04ddf976631C23128A425555EE":{name:"UPCX",logo:"UPC.svg",erc20:!0,symbol:"UPC",decimals:5},"0xd3210F246Ae54C5a45A7b4A83315bf718F591bfc":{name:"ArkiTech",logo:"ARKI.svg",erc20:!0,symbol:"ARKI",decimals:9},"0x7d51888C5ABb7CDfa9cdd6A50673c7F8afAccD7F":{name:"DuckDAO Token",logo:"duckdao.svg",erc20:!0,symbol:"DD",decimals:18},"0x49642110B712C1FD7261Bc074105E9E44676c68F":{name:"DinoLFG",logo:"DINO.svg",erc20:!0,symbol:"DINO",decimals:18},"0xB8BAa0e4287890a5F79863aB62b7F175ceCbD433":{name:"Swerve DAO Token",logo:"swrv.svg",erc20:!0,symbol:"SWRV",decimals:18},"0x8b79656FC38a04044E495e22fAD747126ca305C4":{name:"AgaveCoin",logo:"agvc.svg",erc20:!0,symbol:"AGVC",decimals:18},"0x967da4048cD07aB37855c090aAF366e4ce1b9F48":{name:"Ocean Token",logo:"ocean.svg",erc20:!0,symbol:"OCEAN",decimals:18},"0x83e6f1E41cdd28eAcEB20Cb649155049Fac3D5Aa":{name:"PolkastarterToken",logo:"pols.svg",erc20:!0,symbol:"POLS",decimals:18},"0x08d967bb0134F2d07f7cfb6E246680c53927DD30":{name:"MATH Token",logo:"math.svg",erc20:!0,symbol:"MATH",decimals:18},"0xccC8cb5229B0ac8069C51fd58367Fd1e622aFD97":{name:"Gods Unchained",logo:"gods.svg",erc20:!0,symbol:"GODS",decimals:18},"0xF57e7e7C23978C3cAEC3C3548E3D615c346e79fF":{name:"Immutable X",logo:"imx.svg",erc20:!0,symbol:"IMX",decimals:18},"0x40D16FC0246aD3160Ccc09B8D0D3A2cD28aE6C2f":{name:"Gho Token",logo:"GHO.svg",erc20:!0,symbol:"GHO",decimals:18},"0x536381a8628dBcC8C70aC9A30A7258442eAb4c92":{name:"Pantos Token ",logo:"pan.svg",erc20:!0,symbol:"PAN",decimals:8},"0x011E128Ec62840186F4A07E85E3ACe28858c5606":{name:"Valeria",logo:"val.svg",erc20:!0,symbol:"VAL",decimals:18},"0x6c3ea9036406852006290770BEdFcAbA0e23A0e8":{name:"PayPal USD",logo:"pyusd.svg",erc20:!0,symbol:"PYUSD",decimals:6},"0x8b385Ca3592A5EFc34E0C9fE663de56897F1751F":{name:"INFibit",logo:"INFibit.svg",erc20:!0,symbol:"IBIT",decimals:18},"0x9bf1D7D63dD7a4ce167CF4866388226EEefa702E":{name:"Ben Coin",logo:"BEN.svg",erc20:!0,symbol:"BEN",decimals:18},"0xC7a2572fA8FDB0f7E81d6D3c4e3CCF78FB0DC374":{name:"Bens Finale",logo:"BensFinale.svg",erc20:!0,symbol:"FINALE",decimals:18},"0x99cFB8cBA9c821B4a343c6a1Fc630465C9708DF5":{name:"Pepe Inu",logo:"PepeInu.svg",erc20:!0,symbol:"$PEPEINU",decimals:18},"0xCEBA2a8F6Ec221AEB5f3a7bcd15Cbc7e6a387bfb":{name:"Peter Pan",logo:"PeterPan.svg",erc20:!0,symbol:"PAN",decimals:18},"0x467719aD09025FcC6cF6F8311755809d45a5E5f3":{name:"Axelar",logo:"axelar.svg",erc20:!0,symbol:"AXL",decimals:6},"0x665F77fbA5975ab40Ce61c90F28007fb5b09D7B1":{name:"Genieswap",logo:"Genieswap.svg",erc20:!0,symbol:"GENIE",decimals:18},"0x09E6d500D14D13e0528d2c0fff24E5ffF68237B4":{name:"Dohrnii",logo:"dhn.svg",erc20:!0,symbol:"DHN",decimals:18},"0xaE0585a259A3BCAB258D6EE02FB583f7B33C2a12":{name:"TempleCoin",logo:"tem.svg",erc20:!0,symbol:"TEM",decimals:18},"0xaeDf386B755465871fF874E3E37Af5976E247064":{name:"Fasttoken",logo:"ftn.svg",erc20:!0,symbol:"FTN",decimals:18},"0x7BEF710a5759d197EC0Bf621c3Df802C2D60D848":{name:"SHOPX",logo:"SHOPX.svg",erc20:!0,symbol:"SHOPX",decimals:18},"0xBa3335588D9403515223F109EdC4eB7269a9Ab5D":{name:"Gearbox",logo:"gear.svg",erc20:!0,symbol:"GEAR",decimals:18},"0x9B6B9d2468E165a02FEf69E61B6D3D6CBC0Ac409":{name:"OASISLIFE",logo:"OFE.svg",erc20:!0,symbol:"OFE",decimals:18},"0xdf0162A6B3e9fDf0302c1e949739DeeaFafd8F89":{name:"METAOASIS",logo:"MOA.svg",erc20:!0,symbol:"MOA",decimals:18},"0xe4dae00bc1c46ea2F44ae71B1BEb8b171C15d812":{name:"PREMA",logo:"PREMA.svg",erc20:!0,symbol:"PRMX",decimals:18},"0x1416946162B1C2c871A73B07E932D2fB6C932069":{name:"Energi",logo:"energi.svg",erc20:!0,symbol:"NRG",decimals:18},"0x0d88eD6E74bbFD96B831231638b66C05571e824F":{name:"Aventus",logo:"aventus.svg",erc20:!0,symbol:"AVT",decimals:18},"0x4FC15c91a9c4A9efB404174464687E8e128730C2":{name:"STAT",logo:"STAT.svg",erc20:!0,erc721:!1,symbol:"STAT",decimals:18},"0x4ad7a056191F4c9519fAcd6D75FA94CA26003aCE":{name:"GoldPesa Option",logo:"GPO.svg",erc20:!0,symbol:"GPO",decimals:18},"0x767FE9EDC9E0dF98E07454847909b5E959D7ca0E":{name:"Illuvium",logo:"illuvium.svg",erc20:!0,erc721:!1,symbol:"ILV",decimals:18},"0x85F17Cf997934a597031b2E18a9aB6ebD4B9f6a4":{name:"NEAR",logo:"NEAR.svg",erc20:!0,symbol:"NEAR",decimals:24},"0x6B3595068778DD592e39A122f4f5a5cF09C90fE2":{name:"SushiSwap",logo:"sushi.svg",erc20:!0,erc721:!1,symbol:"SUSHI",decimals:18},"0x881Ba05de1E78f549cC63a8f6Cabb1d4AD32250D":{name:"00",logo:"00.svg",erc20:!0,erc721:!1,symbol:"00",decimals:18},"0xC211477cb4098aC22a98432781f5f26a1E07a4d4":{name:"CULTURED",logo:"CULTURED.svg",erc20:!0,erc721:!1,symbol:"CULTURED",decimals:18},"0x86f2A193b116d1f9C53Ed26d97F77cDC8BcF4c2b":{name:"EHTAGA",logo:"EHTAGA.svg",erc20:!0,erc721:!1,symbol:"EHTAGA",decimals:18},"0x54b79A15b2e2c55c736A66bb0A978fb840407aC8":{name:"FEVER",logo:"FEVER.svg",erc20:!0,erc721:!1,symbol:"FEVER",decimals:18},"0x677c9fE4396D3D13A0F9013a8118eAE386C843A5":{name:"IAM",logo:"IAM.svg",erc20:!0,erc721:!1,symbol:"IAM",decimals:18},"0xf63c65E855020E4B74f0Ad842D9537dA0E6162eC":{name:"ISH",logo:"ISH.svg",erc20:!0,erc721:!1,symbol:"ISH",decimals:18},"0xc105fA46510F32c0444CCdB4e51065da95caA1B4":{name:"LITA",logo:"LITA.svg",erc20:!0,erc721:!1,symbol:"LITA",decimals:18},"0x5401F949cDfa3E5aF32538167c0314230769209C":{name:"MAHCOIN",logo:"MAHCOIN.svg",erc20:!0,erc721:!1,symbol:"MAHCOIN",decimals:18},"0x711D2C47aFf84B96AD0F36983b1c41Be2C509e18":{name:"NIKITA",logo:"NIKITA.svg",erc20:!0,erc721:!1,symbol:"NIKITA",decimals:18},"0x3C44aEc33993b6830e5C2a705ea879b9C9ba0f7c":{name:"NYELA",logo:"NYELA.svg",erc20:!0,erc721:!1,symbol:"NYELA",decimals:18},"0xfa9096c99e687ea8E0064C23DAaCFE87cc99E4Ba":{name:"RON",logo:"RON.svg",erc20:!0,erc721:!1,symbol:"RON",decimals:18},"0x287a7C95aD00bBDd48599Ad2919567fD09281f07":{name:"STEELO",logo:"STEELO.svg",erc20:!0,erc721:!1,symbol:"STEELO",decimals:18},"0x2Ec3275f7aCe4044e499823F511cd58250be8E3d":{name:"Privilege",logo:"prvg.svg",erc20:!0,symbol:"PRVG",decimals:8},"0x65BB569FAaDD324a00883FdE4c46346cc96D5c0A":{name:"Provide",logo:"prvd.svg",erc20:!0,symbol:"PRVD",decimals:8},"0xB4272071eCAdd69d933AdcD19cA99fe80664fc08":{name:"CryptoFranc",logo:"XCHF.svg",erc20:!0,symbol:"XCHF",decimals:18},"0x5aFE3855358E112B5647B952709E6165e1c1eEEe":{name:"Safe Token",logo:"safe-green-token.svg",erc20:!0,symbol:"SAFE",decimals:18},"0x9C8fF314C9Bc7F6e59A9d9225Fb22946427eDC03":{name:"Nouns",erc20:!1,erc721:!0,symbol:"NOUN",decimals:0,logo:"nouns.svg"},"0xBC4CA0EdA7647A8aB7C2061c2E118A18a936f13D":{name:"BoredApeYachtClub",erc20:!1,erc721:!0,symbol:"BAYC",decimals:0,logo:"bayc.svg"},"0x08D7C0242953446436F34b4C78Fe9da38c73668d":{name:"PROOF Collective",erc20:!1,erc721:!0,symbol:"PROOF",decimals:0,logo:"proof.svg"},"0x23581767a106ae21c074b2276D25e5C3e136a68b":{name:"Moonbirds",erc20:!1,erc721:!0,symbol:"MOONBIRD",decimals:0,logo:"moonbirds.svg"},"0x60E4d786628Fea6478F785A6d7e704777c86a7c6":{name:"MutantApeYachtClub",erc20:!1,erc721:!0,symbol:"MAYC",decimals:0,logo:"mayc.svg"},"0x49cF6f5d44E70224e2E23fDcdd2C053F30aDA28B":{name:"CloneX",erc20:!1,erc721:!0,symbol:"CloneX",decimals:0,logo:"clonex.svg"},"0x8a90CAb2b38dba80c64b7734e58Ee1dB38B8992e":{name:"Doodles",erc20:!1,erc721:!0,symbol:"DOODLE",decimals:0,logo:"doodles.svg"},"0xED5AF388653567Af2F388E6224dC7C4b3241C544":{name:"Azuki",erc20:!1,erc721:!0,symbol:"AZUKI",decimals:0,logo:"azuki.svg"},"0xa3AEe8BcE55BEeA1951EF834b99f3Ac60d1ABeeB":{name:"VeeFriends",erc20:!1,erc721:!0,symbol:"VFT",decimals:0,logo:"veefriends.svg"},"0x34d85c9CDeB23FA97cb08333b511ac86E1C4E258":{name:"Otherdeed",erc20:!1,erc721:!0,symbol:"OTHR",decimals:0,logo:"otherdeed.svg"},"0xBBc2AE13b23d715c30720F079fcd9B4a74093505":{name:"Ethernity Chain Token",logo:"ERN.svg",erc20:!0,symbol:"ERN",decimals:18},"0x243cACb4D5fF6814AD668C3e225246efA886AD5a":{name:"Shina Inu",logo:"shina.svg",erc20:!0,symbol:"SHI",decimals:18},"0xD057B63f5E69CF1B929b356b579Cba08D7688048":{name:"CoW Protocol Virtual Token",logo:"vCOW.svg",erc20:!0,symbol:"vCOW",decimals:18},"0xDEf1CA1fb7FBcDC777520aa7f396b4E015F497aB":{name:"CoW Protocol Token",logo:"COW.svg",erc20:!0,symbol:"COW",decimals:18},"0xEd04915c23f00A313a544955524EB7DBD823143d":{name:"Alchemy Pay",logo:"ACH.svg",erc20:!0,symbol:"ACH",decimals:8},"0xeDF6568618A00C6F0908Bf7758A16F76B6E04aF9":{name:"Arianee",logo:"aria20.svg",erc20:!0,symbol:"ARIA20",decimals:18},"0x88D8DA2A8D0fA5b1f4E38030AC486aDE0AFA2798":{name:"Terrapass Coin",logo:"tpsc.svg",erc20:!0,symbol:"TPSC",decimals:18},"0x4730fB1463A6F1F44AEB45F6c5c422427f37F4D0":{name:"The 4th Pillar Token",logo:"four.svg",erc20:!0,symbol:"FOUR",decimals:18},"0x875773784Af8135eA0ef43b5a374AaD105c5D39e":{name:"Idle DAO Token",logo:"idle.svg",erc20:!0,symbol:"IDLE",decimals:18},"0x6BeA7CFEF803D1e3d5f7C0103f7ded065644e197":{name:"Gamma",logo:"Gamma.svg",erc20:!0,symbol:"GAMMA",decimals:18},"0x26805021988F1a45dC708B5FB75Fc75F21747D8c":{name:"xGamma",logo:"xGamma.svg",erc20:!0,symbol:"xGAMMA",decimals:18},"0xc7D9c108D4E1dD1484D3e2568d7f74bfD763d356":{name:"SORA Synthetic USD",logo:"sora-xstusd.svg",erc20:!0,symbol:"XSTUSD",decimals:18},"0x519C1001D550C0a1DaE7d1fC220f7d14c2A521BB":{name:"Polkaswap",logo:"sora-pswap.svg",erc20:!0,symbol:"PSWAP",decimals:18},"0x40FD72257597aA14C7231A7B1aaa29Fce868F677":{name:"SORA",logo:"sora-xor.svg",erc20:!0,symbol:"XOR",decimals:18},"0x909E34d3f6124C324ac83DccA84b74398a6fa173":{name:"$ZKP Token",logo:"ZKP.svg",erc20:!0,erc721:!1,symbol:"$ZKP",decimals:18},"0xe88f8313e61A97cEc1871EE37fBbe2a8bf3ed1E4":{name:"SORA Validator",logo:"sora-val.svg",erc20:!0,symbol:"VAL",decimals:18},"0x7A58c0Be72BE218B41C608b7Fe7C5bB630736C71":{name:"ConstitutionDAO",logo:"PEOPLE.svg",erc20:!0,symbol:"PEOPLE",decimals:18},"0x32E6C34Cd57087aBBD59B5A4AECC4cB495924356":{name:"BitBase",logo:"BTBS.svg",erc20:!0,symbol:"BTBS",decimals:18},"0x3fa400483487A489EC9b1dB29C4129063EEC4654":{name:"Cryptokek.com",logo:"cryptokek.svg",erc20:!0,symbol:"KEK",decimals:18},"0xEd3D4e446A96dC3b181B64B75c3c70dA41dC3CBe":{name:"Vodra",logo:"Vodra.svg",erc20:!0,symbol:"VDR",decimals:18},"0xb753428af26E81097e7fD17f40c88aaA3E04902c":{name:"Spice",logo:"sfi.svg",erc20:!0,symbol:"SFI",decimals:18},"0xd084944d3c05CD115C09d072B9F44bA3E0E45921":{name:"Manifold Finance",logo:"Manifold.svg",erc20:!0,symbol:"FOLD",decimals:18},"0x9a0242b7a33DAcbe40eDb927834F96eB39f8fBCB":{name:"BABB",logo:"bax.svg",erc20:!0,symbol:"BAX",decimals:18},"0x4Cf89ca06ad997bC732Dc876ed2A7F26a9E7f361":{name:"Mysterium",logo:"MYST.svg",erc20:!0,symbol:"MYST",decimals:18},"0x697eF32B4a3F5a4C39dE1cB7563f24CA7BfC5947":{name:"Insula Token",logo:"Insula.svg",erc20:!0,symbol:"ISLA",decimals:18},"0x62Dc4817588d53a056cBbD18231d91ffCcd34b2A":{name:"DeHive",logo:"dehive.svg",erc20:!0,erc721:!1,symbol:"DHV",decimals:18},"0x8400D94A5cb0fa0D041a3788e395285d61c9ee5e":{name:"Unibright",logo:"ubt.svg",erc20:!0,symbol:"UBT",decimals:8},"0xfAd45E47083e4607302aa43c65fB3106F1cd7607":{name:"Hoge Finance",logo:"HogeFinanceLogo.svg",erc20:!0,symbol:"HOGE",decimals:9},"0xBB0E17EF65F82Ab018d8EDd776e8DD940327B28b":{name:"Axie Infinity Shard",logo:"AXS.svg",erc20:!0,symbol:"AXS",decimals:18},"0xCC8Fa225D80b9c7D42F96e9570156c65D6cAAa25":{name:"Smooth Love Potion",logo:"SLP.svg",erc20:!0,symbol:"SLP",decimals:0},"0x10633216E7E8281e33c86F02Bf8e565a635D9770":{name:"Dvision Network",logo:"dvision.svg",erc20:!0,symbol:"DVI",decimals:18},"0x898BAD2774EB97cF6b94605677F43b41871410B1":{name:"vEth2",logo:"vEth2.svg",erc20:!0,symbol:"vEth2",decimals:18},"0x321C2fE4446C7c963dc41Dd58879AF648838f98D":{name:"Cryptex Finance",logo:"ctx.svg",erc20:!0,symbol:"CTX",decimals:18},"0x16c52CeeCE2ed57dAd87319D91B5e3637d50aFa4":{name:"TCAP Token",logo:"tcap.svg",erc20:!0,symbol:"TCAP",decimals:18},"0xE94B97b6b43639E238c851A7e693F50033EfD75C":{name:"Rainbow Token",logo:"halodao-rnbw.svg",erc20:!0,symbol:"RNBW",decimals:18},"0x47BE779De87de6580d0548cde80710a93c502405":{name:"Rainbow Pool",logo:"halodao-xrnbw.svg",erc20:!0,symbol:"xRNBW",decimals:18},"0xe7aE6D0C56CACaf007b7e4d312f9af686a9E9a04":{name:"Vabble",logo:"VAB.svg",erc20:!0,symbol:"VAB",decimals:18},"0x853d955aCEf822Db058eb8505911ED77F175b99e":{name:"Frax",logo:"frax.svg",erc20:!0,symbol:"FRAX",decimals:18},"0x3432B6A60D23Ca0dFCa7761B7ab56459D9C964D0":{name:"Frax Share",logo:"fxs.svg",erc20:!0,symbol:"FXS",decimals:18},"0x84810bcF08744d5862B8181f12d17bfd57d3b078":{name:"SharedStake",logo:"sharedstake.svg",erc20:!0,symbol:"SGT",decimals:18},"0x75387e1287Dd85482aB66102DA9f6577E027f609":{name:"MindsyncAI",logo:"MAI.svg",erc20:!0,symbol:"MAI",decimals:18},"0x196f4727526eA7FB1e17b2071B3d8eAA38486988":{name:"Reserve",logo:"rsv.svg",erc20:!0,symbol:"RSV",decimals:18},"0x320623b8E4fF03373931769A31Fc52A4E78B5d70":{name:"Reserve Rights",logo:"rsr.svg",erc20:!0,symbol:"RSR",decimals:18},"0x1cF4592ebfFd730c7dc92c1bdFFDfc3B9EfCf29a":{name:"WAVES",logo:"waves.svg",erc20:!0,symbol:"WAVES",decimals:18},"0x252739487C1fa66eaeaE7CED41d6358aB2a6bCa9":{name:"ArCoin",logo:"ArCoin.svg",erc20:!0,symbol:"RCOIN",decimals:8},"0x18aAA7115705e8be94bfFEBDE57Af9BFc265B998":{name:"Audius",logo:"audius.svg",erc20:!0,symbol:"AUDIO",decimals:18},"0x8E3BCC334657560253B83f08331d85267316e08a":{name:"Rubic",logo:"brbc.svg",erc20:!0,symbol:"BRBC",decimals:18},"0xca1207647Ff814039530D7d35df0e1Dd2e91Fa84":{name:"dHEDGE DAO Token",logo:"DHT.svg",erc20:!0,symbol:"DHT",decimals:18},"0x6243d8CEA23066d098a15582d81a598b4e8391F4":{name:"Reflexer Ungovernance Token",logo:"flx.svg",erc20:!0,symbol:"FLX",decimals:18},"0x03ab458634910AaD20eF5f1C8ee96F1D6ac54919":{name:"Rai Reflex Index",logo:"rai.svg",erc20:!0,symbol:"RAI",decimals:18},"0xF25c91C87e0B1fd9B4064Af0F427157AaB0193A7":{name:"BASIC Token",logo:"basic.svg",erc20:!0,symbol:"BASIC",decimals:18},"0x53C8395465A84955c95159814461466053DedEDE":{name:"DeGate Token",logo:"DG.svg",erc20:!0,symbol:"DG",decimals:18},"0xBCf9dBf8B14eD096B2BA08b7269356197fDd1b5D":{name:"Avaluse",logo:"avaluse.svg",erc20:!0,symbol:"AVAL",decimals:18},"0x6E765D26388A17A6e86c49A8E41DF3F58aBcd337":{name:"Kangal",logo:"kangal.svg",erc20:!0,symbol:"KANGAL",decimals:18},"0x9AF4f26941677C706cfEcf6D3379FF01bB85D5Ab":{name:"DomRaiderToken",logo:"drt.svg",erc20:!0,symbol:"DRT",decimals:8},"0x06B179e292f080871825beD5D722162fD96B4c95":{name:"10x.gg",logo:"xgg.svg",erc20:!0,symbol:"XGG",decimals:18},"0xF29992D7b589A0A6bD2de7Be29a97A6EB73EaF85":{name:"DMScript",logo:"dmst.svg",erc20:!0,symbol:"DMST",decimals:18},"0x64aa3364F17a4D01c6f1751Fd97C2BD3D7e7f1D5":{name:"Olympus",logo:"OHM.svg",erc20:!0,symbol:"OHM",decimals:9},"0x0ab87046fBb341D058F17CBC4c1133F25a20a52f":{name:"Governance OHM",logo:"gOHM.svg",erc20:!0,symbol:"gOHM",decimals:18},"0xDd1Ad9A21Ce722C151A836373baBe42c868cE9a4":{name:"Universal Basic Income",logo:"ubi.svg",erc20:!0,symbol:"UBI",decimals:18},"0xf293d23BF2CDc05411Ca0edDD588eb1977e8dcd4":{name:"Sylo",logo:"SYLO.svg",erc20:!0,symbol:"SYLO",decimals:18},"0xae7ab96520DE3A18E5e111B5EaAb095312D7fE84":{name:"Liquid staked Ether 2.0",logo:"stETH.svg",erc20:!0,symbol:"stETH",decimals:18},"0x7f39C581F595B53c5cb19bD0b3f8dA6c935E2Ca0":{name:"Wrapped liquid staked Ether 2.0",logo:"wstETH.svg",erc20:!0,symbol:"wstETH",decimals:18},"0x5A98FcBEA516Cf06857215779Fd812CA3beF1B32":{name:"Lido DAO Token",logo:"LDO.svg",erc20:!0,symbol:"LDO",decimals:18},"0xbd31EA8212119f94A611FA969881CBa3EA06Fa3d":{name:"LUNA Token",logo:"Luna.svg",erc20:!0,symbol:"LUNA",decimals:6},"0xa693B19d2931d498c5B318dF961919BB4aee87a5":{name:"UST Token",logo:"UST.svg",erc20:!0,symbol:"UST",decimals:6},"0xd2877702675e6cEb975b4A1dFf9fb7BAF4C91ea9":{name:"LUNA Token - Shuttle",logo:"lunc.svg",erc20:!0,symbol:"LUNC",decimals:18},"0xa47c8bf37f92aBed4A126BDA807A7b7498661acD":{name:"UST Token - Shuttle",logo:"ustc.svg",erc20:!0,symbol:"USTC",decimals:18},"0xcAAfF72A8CbBfc5Cf343BA4e26f65a257065bFF1":{name:"KRT Token - Shuttle",logo:"KRT.svg",erc20:!0,symbol:"KRT-S",decimals:18},"0x676Ad1b33ae6423c6618C1AEcf53BAa29cf39EE5":{name:"SDT Token - Shuttle",logo:"SDT.svg",erc20:!0,symbol:"SDT-S",decimals:18},"0x156B36ec68FdBF84a925230BA96cb1Ca4c4bdE45":{name:"MNT Token - Shuttle",logo:"MNT.svg",erc20:!0,symbol:"MNT-S",decimals:18},"0x09a3EcAFa817268f77BE1283176B946C4ff2E608":{name:"MIR Token - Shuttle",logo:"MIR.svg",erc20:!0,symbol:"MIR-S",decimals:18},"0xd36932143F6eBDEDD872D5Fb0651f4B72Fd15a84":{name:"Mirror AAPL Token - Shuttle",logo:"mAAPL.svg",erc20:!0,symbol:"mAAPL-S",decimals:18},"0x59A921Db27Dd6d4d974745B7FfC5c33932653442":{name:"Mirror GOOGL Token - Shuttle",logo:"mGOOGL.svg",erc20:!0,symbol:"mGOGL-S",decimals:18},"0x21cA39943E91d704678F5D00b6616650F066fD63":{name:"Mirror TSLA Token - Shuttle",logo:"mTSLA.svg",erc20:!0,symbol:"mTSLA-S",decimals:18},"0xC8d674114bac90148d11D3C1d33C61835a0F9DCD":{name:"Mirror NFLX Token - Shuttle",logo:"mNFLX.svg",erc20:!0,symbol:"mNFLX-S",decimals:18},"0x13B02c8dE71680e71F0820c996E4bE43c2F57d15":{name:"Mirror QQQ Token - Shuttle",logo:"mQQQ.svg",erc20:!0,symbol:"mQQQ-S",decimals:18},"0xEdb0414627E6f1e3F082DE65cD4F9C693D78CCA9":{name:"Mirror TWTR Token - Shuttle",logo:"mTWTR.svg",erc20:!0,symbol:"mTWTR-S",decimals:18},"0x41BbEDd7286dAab5910a1f15d12CBda839852BD7":{name:"Mirror MSFT Token - Shuttle",logo:"mMSFT.svg",erc20:!0,symbol:"mMSFT-S",decimals:18},"0x0cae9e4d663793c2a2A0b211c1Cf4bBca2B9cAa7":{name:"Mirror AMZN Token - Shuttle",logo:"mAMZN.svg",erc20:!0,symbol:"mAMZN-S",decimals:18},"0x56aA298a19C93c6801FDde870fA63EF75Cc0aF72":{name:"Mirror BABA Token - Shuttle",logo:"mBABA.svg",erc20:!0,symbol:"mBABA-S",decimals:18},"0x1d350417d9787E000cc1b95d70E9536DcD91F373":{name:"Mirror IAU Token - Shuttle",logo:"mIAU.svg",erc20:!0,symbol:"mIAU-S",decimals:18},"0x9d1555d8cB3C846Bb4f7D5B1B1080872c3166676":{name:"Mirror SLV Token - Shuttle",logo:"mSLV.svg",erc20:!0,symbol:"mSLV-S",decimals:18},"0x31c63146a635EB7465e5853020b39713AC356991":{name:"Mirror USO Token - Shuttle",logo:"mUSO.svg",erc20:!0,symbol:"mUSO-S",decimals:18},"0xf72FCd9DCF0190923Fadd44811E240Ef4533fc86":{name:"Mirror VIXY Token - Shuttle",logo:"mVIXY.svg",erc20:!0,symbol:"mVIXY-S",decimals:18},"0x21BfBDa47A0B4B5b1248c767Ee49F7caA9B23697":{name:"OVR",logo:"OVR.svg",erc20:!0,symbol:"OVR",decimals:18},"0x4691937a7508860F876c9c0a2a617E7d9E945D4B":{name:"Wootrade Network",logo:"wootrade.svg",erc20:!0,symbol:"WOO",decimals:18},"0xaf9f549774ecEDbD0966C52f250aCc548D3F36E5":{name:"RFUEL",logo:"RFUEL.svg",erc20:!0,symbol:"RFUEL",decimals:18},"0x7420B4b9a0110cdC71fB720908340C03F9Bc03EC":{name:"JasmyCoin",logo:"JASMY.svg",erc20:!0,symbol:"JASMY",decimals:18},"0x947AEb02304391f8fbE5B25D7D98D649b57b1788":{name:"Mandala Exchange Token",logo:"mandala.svg",erc20:!0,symbol:"MDX",decimals:18},"0xCdeee767beD58c5325f68500115d4B722b3724EE":{name:"Carbon",logo:"CRBN.svg",erc20:!0,symbol:"CRBN",decimals:18},"0xA4EED63db85311E22dF4473f87CcfC3DaDCFA3E3":{name:"Rubic",logo:"Rubic.svg",erc20:!0,symbol:"RBC",decimals:18},"0x3A880652F47bFaa771908C07Dd8673A787dAEd3A":{name:"DerivaDAO",logo:"DDX.svg",erc20:!0,symbol:"DDX",decimals:18},"0xbC396689893D065F41bc2C6EcbeE5e0085233447":{name:"Perpetual",logo:"PERP.svg",erc20:!0,symbol:"PERP",decimals:18},"0xeca82185adCE47f39c684352B0439f030f860318":{name:"Perlin",logo:"PERL.svg",erc20:!0,symbol:"PERL",decimals:18},"0xA1AFFfE3F4D611d252010E3EAf6f4D77088b0cd7":{name:"Reflect Finance",logo:"RFI.svg",erc20:!0,symbol:"RFI",decimals:9},"0xC0bA369c8Db6eB3924965e5c4FD0b4C1B91e305F":{name:"DLP Duck Token",logo:"dlpducktoken.svg",erc20:!0,symbol:"DUCK",decimals:18},"0xFbEEa1C75E4c4465CB2FCCc9c6d6afe984558E20":{name:"DuckDaoDime",logo:"ddim.svg",erc20:!0,symbol:"DDIM",decimals:18},"0x745407c86DF8DB893011912d3aB28e68B62E49B0":{name:"MahaDAO",logo:"MAHA.svg",erc20:!0,symbol:"MAHA",decimals:18},"0x8CC0F052fff7eaD7f2EdCCcaC895502E884a8a71":{name:"ARTH Valuecoin",logo:"ARTH.svg",erc20:!0,symbol:"ARTH",decimals:18},"0x3231Cb76718CDeF2155FC47b5286d82e6eDA273f":{name:"Monerium EUR",logo:"EURe.svg",erc20:!0,symbol:"EURe",decimals:18},"0x7ba92741Bf2A568abC6f1D3413c58c6e0244F8fD":{name:"Monerium GBP",logo:"GBPe.svg",erc20:!0,symbol:"GBPe",decimals:18},"0xBc5142e0CC5eB16b47c63B0f033d4c2480853a52":{name:"Monerium USD",logo:"USDe.svg",erc20:!0,symbol:"USDe",decimals:18},"0xC642549743A93674cf38D6431f75d6443F88E3E2":{name:"Monerium ISK",logo:"ISKe.svg",erc20:!0,symbol:"ISKe",decimals:18},"0x66a0f676479Cee1d7373f3DC2e2952778BfF5bd6":{name:"WISE Token",logo:"wise.svg",erc20:!0,symbol:"WISE",decimals:18},"0x72F020f8f3E8fd9382705723Cd26380f8D0c66Bb":{name:"PlotX",logo:"plotx.svg",erc20:!0,symbol:"PLOT",decimals:18},"0x44197A4c44D6A059297cAf6be4F7e172BD56Caaf":{name:"ELTCOIN",logo:"ELTCOIN.svg",erc20:!0,symbol:"ELT",decimals:8},"0x6781a0F84c7E9e846DCb84A9a5bd49333067b104":{name:"ZAP TOKEN",logo:"zapicon.svg",erc20:!0,symbol:"ZAP",decimals:18},"0x00c83aeCC790e8a4453e5dD3B0B4b3680501a7A7":{name:"SKALE",logo:"skl.svg",erc20:!0,symbol:"SKL",decimals:18},"0x674C6Ad92Fd080e4004b2312b45f796a192D27a0":{name:"Neutrino USD",logo:"usdn.svg",erc20:!0,symbol:"USDN",decimals:18},"0xE5CAeF4Af8780E59Df925470b050Fb23C43CA68C":{name:"Ferrum Network Token",logo:"frm.svg",erc20:!0,symbol:"FRM",decimals:6},"0x998FFE1E43fAcffb941dc337dD0468d52bA5b48A":{name:"Rupiah Token",logo:"idrt.svg",erc20:!0,symbol:"IDRT",decimals:2},"0x4E15361FD6b4BB609Fa63C81A2be19d873717870":{name:"Fantom",logo:"ftm.svg",erc20:!0,symbol:"FTM",decimals:18},"0x557B933a7C2c45672B610F8954A3deB39a51A8Ca":{name:"REVV",logo:"revv.svg",erc20:!0,symbol:"REVV",decimals:18},"0xFFC97d72E13E01096502Cb8Eb52dEe56f74DAD7B":{name:"Aave AAVE",logo:"aAAVE.svg",erc20:!0,symbol:"aAAVE",decimals:18},"0x05Ec93c0365baAeAbF7AefFb0972ea7ECdD39CF1":{name:"Aave BAT",logo:"aBAT.svg",erc20:!0,symbol:"aBAT",decimals:18},"0xA361718326c15715591c299427c62086F69923D9":{name:"Aave BUSD",logo:"aBUSD.svg",erc20:!0,symbol:"aBUSD",decimals:18},"0x028171bCA77440897B824Ca71D1c56caC55b68A3":{name:"Aave DAI",logo:"aDAI.svg",erc20:!0,symbol:"aDAI",decimals:18},"0xaC6Df26a590F08dcC95D5a4705ae8abbc88509Ef":{name:"Aave ENJ",logo:"aENJ.svg",erc20:!0,symbol:"aENJ",decimals:18},"0xD37EE7e4f452C6638c96536e68090De8cBcdb583":{name:"Aave GUSD",logo:"aGUSD.svg",erc20:!0,symbol:"aGUSD",decimals:2},"0x39C6b3e42d6A679d7D776778Fe880BC9487C2EDA":{name:"Aave KNC",logo:"aKNC.svg",erc20:!0,symbol:"aKNC",decimals:18},"0xa06bC25B5805d5F8d82847D191Cb4Af5A3e873E0":{name:"Aave LINK",logo:"aLINK.svg",erc20:!0,symbol:"aLINK",decimals:18},"0xa685a61171bb30d4072B338c80Cb7b2c865c873E":{name:"Aave MANA",logo:"aMANA.svg",erc20:!0,symbol:"aMANA",decimals:18},"0xc713e5E149D5D0715DcD1c156a020976e7E56B88":{name:"Aave MKR",logo:"aMKR.svg",erc20:!0,symbol:"aMKR",decimals:18},"0xCC12AbE4ff81c9378D670De1b57F8e0Dd228D77a":{name:"Aave REN",logo:"aREN.svg",erc20:!0,symbol:"aREN",decimals:18},"0x35f6B052C598d933D69A4EEC4D04c73A191fE6c2":{name:"Aave SNX",logo:"aSNX.svg",erc20:!0,symbol:"aSNX",decimals:18},"0x6C5024Cd4F8A59110119C56f8933403A539555EB":{name:"Aave SUSD",logo:"aSUSD.svg",erc20:!0,symbol:"aSUSD",decimals:18},"0x101cc05f4A51C0319f570d5E146a8C625198e636":{name:"Aave TUSD",logo:"aTUSD.svg",erc20:!0,symbol:"aTUSD",decimals:18},"0xB9D7CB55f463405CDfBe4E90a6D2Df01C2B92BF1":{name:"Aave UNI",logo:"aUNI.svg",erc20:!0,symbol:"aUNI",decimals:18},"0xBcca60bB61934080951369a648Fb03DF4F96263C":{name:"Aave USDC",logo:"aUSDC.svg",erc20:!0,symbol:"aUSDC",decimals:6},"0x3Ed3B47Dd13EC9a98b44e6204A523E766B225811":{name:"Aave USDT",logo:"aUSDT.svg",erc20:!0,symbol:"aUSDT",decimals:6},"0x9ff58f4fFB29fA2266Ab25e75e2A8b3503311656":{name:"Aave WBTC",logo:"aWBTC.svg",erc20:!0,symbol:"aWBTC",decimals:8},"0x030bA81f1c18d280636F32af80b9AAd02Cf0854e":{name:"Aave WETH",logo:"aWETH.svg",erc20:!0,symbol:"aWETH",decimals:18},"0x5165d24277cD063F5ac44Efd447B27025e888f37":{name:"Aave YFI",logo:"aYFI.svg",erc20:!0,symbol:"aYFI",decimals:18},"0xdef1fac7Bf08f173D286BbBDcBeeADe695129840":{name:"Defi Factory Token",logo:"DEFT.svg",erc20:!0,symbol:"DEFT",decimals:18},"0xDf7FF54aAcAcbFf42dfe29DD6144A69b629f8C9e":{name:"Aave ZRX",logo:"aZRX.svg",erc20:!0,symbol:"aZRX",decimals:18},"0x7Fc66500c84A76Ad7e9c93437bFc5Ac33E2DDaE9":{name:"Aave",logo:"AAVE.svg",erc20:!0,symbol:"AAVE",decimals:18},"0x44e2deC86B9F0e0266E9AA66e10323A2bd69CF9A":{name:"Attrace",logo:"attr.svg",erc20:!0,symbol:"ATTR",decimals:18},"0x1Da87b114f35E1DC91F72bF57fc07A768Ad40Bb0":{name:"Equalizer",logo:"EQZ.svg",erc20:!0,symbol:"EQZ",decimals:18},"0x4da27a545c0c5B758a6BA100e3a049001de870f5":{name:"Staked Aave",logo:"stkAAVE.svg",erc20:!0,symbol:"stAAVE",decimals:18},"0xba9d4199faB4f26eFE3551D490E3821486f135Ba":{name:"SwissBorg",logo:"chsb.svg",erc20:!0,symbol:"CHSB",decimals:8},"0x7DD9c5Cba05E151C895FDe1CF355C9A1D5DA6429":{name:"Golem Network Token",logo:"glm.svg",erc20:!0,symbol:"GLM",decimals:18},"0x7240aC91f01233BaAf8b064248E80feaA5912BA3":{name:"OctoFi",logo:"octo.svg",erc20:!0,symbol:"OCTO",decimals:18},"0xff56Cc6b1E6dEd347aA0B7676C85AB0B3D08B0FA":{name:"Orbs",logo:"orbs.svg",erc20:!0,symbol:"ORBS",decimals:18},"0x63f88A2298a5c4AEE3c216Aa6D926B184a4b2437":{name:"GAME Credits",logo:"GAMECreditsLogo.svg",erc20:!0,symbol:"GAME",decimals:18},"0x5150956E082C748Ca837a5dFa0a7C10CA4697f9c":{name:"Zeedex",logo:"zdex.svg",erc20:!0,symbol:"ZDEX",decimals:18},"0x84cA8bc7997272c7CfB4D0Cd3D55cd942B3c9419":{name:"DIAdata",logo:"dia.svg",erc20:!0,symbol:"DIA",decimals:18},"0xb78B3320493a4EFaa1028130C5Ba26f0B6085Ef8":{name:"Dracula",logo:"dracula.svg",erc20:!0,symbol:"DRC",decimals:18},"0xF433089366899D83a9f26A773D59ec7eCF30355e":{name:"Metal",logo:"mtl.svg",erc20:!0,symbol:"MTL",decimals:8},"0x85Eee30c52B0b379b046Fb0F85F4f3Dc3009aFEC":{name:"KEEP",logo:"keep.svg",erc20:!0,symbol:"KEEP",decimals:18},"0x8dAEBADE922dF735c38C80C7eBD708Af50815fAa":{name:"tBTC",logo:"tbtc.svg",erc20:!0,symbol:"TBTC",decimals:18},"0xD7EFB00d12C2c13131FD319336Fdf952525dA2af":{name:"Proton",logo:"proton.svg",erc20:!0,symbol:"XPR",decimals:4},"0x178c820f862B14f316509ec36b13123DA19A6054":{name:"Energy Web Token Bridged",logo:"ewtb.svg",erc20:!0,symbol:"EWTB",decimals:18},"0x2b591e99afE9f32eAA6214f7B7629768c40Eeb39":{name:"HEX",logo:"hex.svg",erc20:!0,symbol:"HEX",decimals:8},"0xFca59Cd816aB1eaD66534D82bc21E7515cE441CF":{name:"Rarible",logo:"rari.svg",erc20:!0,symbol:"RARI",decimals:18},"0x7865af71cf0b288b4E7F654f4F7851EB46a2B7F8":{name:"Sentivate",logo:"sentivate.svg",erc20:!0,symbol:"SNTVT",decimals:18},"0xa3d58c4E56fedCae3a7c43A725aeE9A71F0ece4e":{name:"Metronome",logo:"metronome.svg",erc20:!0,symbol:"MET",decimals:18},"0x49d716DFe60b37379010A75329ae09428f17118d":{name:"PoolTogether Dai",logo:"pldai.svg",erc20:!0,symbol:"PLDAI",decimals:18},"0xfE6892654CBB05eB73d28DCc1Ff938f59666Fe9f":{name:"PoolTogether Sai",logo:"plsai.svg",erc20:!0,symbol:"PLSAI",decimals:18},"0x5732046A883704404F284Ce41FfADd5b007FD668":{name:"Bluzelle Token",logo:"Bluzelle.svg",erc20:!0,symbol:"BLZ",decimals:18},"0xBD87447F48ad729C5c4b8bcb503e1395F62e8B98":{name:"PoolTogether USDC",logo:"plusdc.svg",erc20:!0,symbol:"PLUSDC",decimals:6},"0x69A95185ee2a045CDC4bCd1b1Df10710395e4e23":{name:"$Poolz Finance",logo:"Poolz.svg",erc20:!0,symbol:"POOLZ",decimals:18},"0x0adA190c81b814548ddC2F6AdC4a689ce7C1FE73":{name:"yAxis",logo:"yaxis.svg",erc20:!0,symbol:"YAXIS",decimals:18},"0xb1dC9124c395c1e97773ab855d66E879f053A289":{name:"yAxis",logo:"yaxis.svg",erc20:!0,symbol:"YAX",decimals:18},"0xeF31Cb88048416E301Fee1eA13e7664b887BA7e8":{name:"Staked yAxis",logo:"yaxis.svg",erc20:!0,symbol:"sYAX",decimals:18},"0x28cb7e841ee97947a86B06fA4090C8451f64c0be":{name:"YF Link",logo:"YFL.svg",erc20:!0,symbol:"YFL",decimals:18},"0x75D1aA733920b14fC74c9F6e6faB7ac1EcE8482E":{name:"YFLink Staking Share",logo:"YFL.svg",erc20:!0,symbol:"yYFL",decimals:18},"0x7b760D06E401f85545F3B50c44bf5B05308b7b62":{name:"YFLink USD",logo:"YFLUSD.svg",erc20:!0,symbol:"YFLUSD",decimals:18},"0x8282df223AC402d04B2097d16f758Af4F70e7Db0":{name:"YFLink Synthetic",logo:"sYFL.svg",erc20:!0,symbol:"sYFL",decimals:18},"0x008377EB0C62cE8e0BA3D7Bb4A5638591f21588E":{name:"YFLink Bond",logo:"bYFL.svg",erc20:!0,symbol:"bYFL",decimals:18},"0x0bc529c00C6401aEF6D220BE8C6Ea1667F6Ad93e":{name:"yearn.finance",logo:"yfi.svg",erc20:!0,symbol:"YFI",decimals:18},"0x261b45D85cCFeAbb11F022eBa346ee8D1cd488c0":{name:"rDAI",logo:"rdai.svg",erc20:!0,symbol:"rDAI",decimals:18},"0xea8b224eDD3e342DEb514C4176c2E72Bcce6fFF9":{name:"rSAI",logo:"rsai.svg",erc20:!0,symbol:"rSAI",decimals:18},"0x12B19D3e2ccc14Da04FAe33e63652ce469b3F2FD":{name:"GridPlus",logo:"GridPlus.svg",erc20:!0,symbol:"GRID",decimals:12},"0xDb05EA0877A2622883941b939f0bb11d1ac7c400":{name:"Opacity",logo:"opct.svg",erc20:!0,symbol:"OPCT",decimals:18},"0x4575f41308EC1483f3d399aa9a2826d74Da13Deb":{name:"Orchid",logo:"OXT.svg",erc20:!0,symbol:"OXT",decimals:18},"0x4CC19356f2D37338b9802aa8E8fc58B0373296E7":{name:"Selfkey",logo:"KEY.svg",erc20:!0,symbol:"KEY",decimals:18},"0x92A5B04D0ED5D94D7a193d1d334D3D16996f4E13":{name:"Eristica",logo:"Eristica.svg",erc20:!0,symbol:"ERT",decimals:18},"0xdAC17F958D2ee523a2206206994597C13D831ec7":{name:"Tether USD",logo:"usdt.svg",erc20:!0,symbol:"USDT",decimals:6},"0x06AF07097C9Eeb7fD685c692751D5C66dB49c215":{name:"Chai",logo:"CHAI.svg",erc20:!0,symbol:"CHAI",decimals:18},"0x04Fa0d235C4abf4BcF4787aF4CF447DE572eF828":{name:"UMA",logo:"uma.svg",erc20:!0,symbol:"UMA",decimals:18},"0x5f778ec4B31a506c1Dfd8b06F131E9B451a61D39":{name:"UPX Token",logo:"UPX.svg",erc20:!0,symbol:"UPX",decimals:18},"0xb1CD6e4153B2a390Cf00A6556b0fC1458C4A5533":{name:"ETHBNT Liquidity Pool",logo:"ETHBNT.svg",erc20:!0,symbol:"ETHBNT",decimals:18},"0xf0Ee6b27b759C9893Ce4f094b49ad28fd15A23e4":{name:"Enigma",logo:"enigma.svg",erc20:!0,symbol:"ENG",decimals:8},"0xaaAEBE6Fe48E54f431b0C390CfaF0b017d09D42d":{name:"Celsius",logo:"celsius.svg",erc20:!0,symbol:"CEL",decimals:4},"0xb683D83a532e2Cb7DFa5275eED3698436371cc9f":{name:"BTU",logo:"BTU.svg",erc20:!0,symbol:"BTU",decimals:18},"0x746DdA2ea243400D5a63e0700F190aB79f06489e":{name:"BOSAGORA",logo:"BOA.svg",erc20:!0,symbol:"BOA",decimals:7},"0x5D858bcd53E085920620549214a8b27CE2f04670":{name:"POP Network Token",logo:"POP.svg",erc20:!0,symbol:"POP",decimals:18},"0x048Fe49BE32adfC9ED68C37D32B5ec9Df17b3603":{name:"Skrumble Network V2",logo:"skm.svg",erc20:!0,symbol:"SKM",decimals:18},"0x16EA01aCB4b0Bca2000ee5473348B6937ee6f72F":{name:"Enecuum",logo:"ENQ-logo.svg",erc20:!0,symbol:"ENQ",decimals:10},"0xE5B826Ca2Ca02F09c1725e9bd98d9a8874C30532":{name:"ZEON Network",logo:"ZEON_logo.png",erc20:!0,symbol:"ZEON",decimals:18},"0x13cb85823f78Cff38f0B0E90D3e975b8CB3AAd64":{name:"REMIIT REMI Token",logo:"remi.svg",erc20:!0,symbol:"REMI",decimals:18},"0x93a7174dafd31d13400cD9fa01f4e5B5BAa00D39":{name:"Shaka",logo:"hak.svg",erc20:!0,symbol:"HAK",decimals:18},"0x6fB3e0A217407EFFf7Ca062D46c26E5d60a14d69":{name:"IoTeX",logo:"iotex.svg",erc20:!0,symbol:"IOTX",decimals:18},"0xE5a3229CCb22b6484594973A03a3851dCd948756":{name:"RAE Token",logo:"rae.svg",erc20:!0,symbol:"RAE",decimals:18},"0x4470BB87d77b963A013DB939BE332f927f2b992e":{name:"AdEx Legacy Token",logo:"adex.svg",erc20:!0,symbol:"ADXL",decimals:4},"0xADE00C28244d5CE17D72E40330B1c318cD12B7c3":{name:"AdEx Token",logo:"adex.svg",erc20:!0,symbol:"ADX",decimals:18},"0xDc5864eDe28BD4405aa04d93E05A0531797D9D59":{name:"Falcon",logo:"fnt.svg",erc20:!0,symbol:"FNT",decimals:6},"0x1966d718A565566e8E202792658D7b5Ff4ECe469":{name:"nDEX",logo:"nDEX.png",erc20:!0,symbol:"NDX",decimals:18},"0x2260FAC5E5542a773Aa44fBCfeDf7C193bc2C599":{name:"Wrapped BTC",logo:"wbtc.svg",erc20:!0,symbol:"WBTC",decimals:8},"0x150b0b96933B75Ce27af8b92441F8fB683bF9739":{name:"Dragonereum Gold",logo:"gold.svg",erc20:!0,symbol:"GOLD",decimals:18},"0x82f4dED9Cec9B5750FBFf5C2185AEe35AfC16587":{name:"DreamTeam Token",logo:"dream.svg",erc20:!0,symbol:"DREAM",decimals:6},"0x5d60d8d7eF6d37E16EBABc324de3bE57f135e0BC":{name:"MyBit",logo:"MYB.svg",erc20:!0,symbol:"MYB",decimals:18},"0x01FA555c97D7958Fa6f771f3BbD5CCD508f81e22":{name:"Civil Token",logo:"CVL_token.svg",erc20:!0,symbol:"CVL",decimals:18},"0x5adc961D6AC3f7062D2eA45FEFB8D8167d44b190":{name:"Dether",logo:"dether.svg",erc20:!0,symbol:"DTH",decimals:18},"0x3F17Dd476faF0a4855572F0B6ed5115D9bBA22AD":{name:"Wibson",logo:"wibson-logo.png",erc20:!0,symbol:"WIB",decimals:9},"0xDF347911910b6c9A4286bA8E2EE5ea4a39eB2134":{name:"Bob's Repair",logo:"bobsrepair.png",erc20:!0,symbol:"BOB",decimals:18},"0x3505F494c3f0fed0B594E01Fa41Dd3967645ca39":{name:"SWARM",logo:"swarm.svg",erc20:!0,symbol:"SWM",decimals:18},"0x6863bE0e7CF7ce860A574760e9020D519a8bDC47":{name:"On.Live",logo:"onlive.svg",erc20:!0,symbol:"ONL",decimals:18},"0xea5f88E54d982Cbb0c441cde4E79bC305e5b43Bc":{name:"Pareto",logo:"ParetoLogo.png",erc20:!0,symbol:"PARETO",decimals:18},"0x2e91E3e54C5788e9FdD6A181497FDcEa1De1bcc1":{name:"Hercules",logo:"herc.png",erc20:!0,symbol:"HERC",decimals:18},"0x4946Fcea7C692606e8908002e55A582af44AC121":{name:"FOAM",logo:"FOAM.svg",erc20:!0,symbol:"FOAM",decimals:18},"0x4D807509aECe24C0fa5A102b6a3B059Ec6E14392":{name:"Menlo One",logo:"Menlo_One.png",erc20:!0,symbol:"ONE",decimals:18},"0x27054b13b1B798B345b591a4d22e6562d47eA75a":{name:"AirSwap Token",logo:"AirSwapLogo.svg",erc20:!0,symbol:"AST",decimals:4},"0x8D5682941cE456900b12d47ac06a88b47C764CE1":{name:"RightMesh Token",logo:"Rmesh.png",erc20:!0,symbol:"RMESH",decimals:18},"0xDDe12a12A6f67156e0DA672be05c374e1B0a3e57":{name:"JOYSO",logo:"JOY.png",erc20:!0,symbol:"JOY",decimals:6},"0x0D262e5dC4A06a0F1c90cE79C7a60C09DfC884E4":{name:"JET8 Token",logo:"J8T.svg",erc20:!0,symbol:"J8T",decimals:8},"0x4a220E6096B25EADb88358cb44068A3248254675":{name:"Quant Network",logo:"quant-network.svg",erc20:!0,symbol:"QNT",decimals:18},"0xBC86727E770de68B1060C91f6BB6945c73e10388":{name:"Ink Protocol",logo:"ink_protocol.svg",erc20:!0,symbol:"XNK",decimals:18},"0xa95592DCFfA3C080B4B40E459c5f5692F67DB7F8":{name:"ELY Token",logo:"ely.png",erc20:!0,symbol:"ELY",decimals:18},"0x9E46A38F5DaaBe8683E10793b06749EEF7D733d1":{name:"PolySwarm Nectar",logo:"polyswarm_nectar.svg",erc20:!0,symbol:"NCT",decimals:18},"0xe1A178B681BD05964d3e3Ed33AE731577d9d96dD":{name:"BOX Token",logo:"box_token.png",erc20:!0,symbol:"BOX",decimals:18},"0x543Ff227F64Aa17eA132Bf9886cAb5DB55DCAddf":{name:"DAOstack",logo:"gen.svg",erc20:!0,symbol:"GEN",decimals:18},"0x6aEDbF8dFF31437220dF351950Ba2a3362168d1b":{name:"Dragonglass",logo:"dragonglass.svg",erc20:!0,symbol:"DGS",decimals:8},"0xd26114cd6EE289AccF82350c8d8487fedB8A0C07":{name:"OmiseGO",logo:"omg.svg",erc20:!0,symbol:"OMG",decimals:18},"0x99ea4dB9EE77ACD40B119BD1dC4E33e1C070b80d":{name:"Quantstamp",logo:"qsp.svg",erc20:!0,symbol:"QSP",decimals:18},"0xB64ef51C888972c908CFacf59B47C1AfBC0Ab8aC":{name:"Storj",logo:"storj.svg",erc20:!0,symbol:"STORJ",decimals:8},"0xD8E3FB3b08eBA982F2754988d70D57eDc0055ae6":{name:"Zoracles",logo:"zora.svg",erc20:!0,symbol:"ZORA",decimals:9},"0xF938424F7210f31dF2Aee3011291b658f872e91e":{name:"VISOR",logo:"VISR.svg",erc20:!0,symbol:"VISR",decimals:18},"0x0F5D2fB29fb7d3CFeE444a200298f468908cC942":{name:"Decentraland",logo:"mana.svg",erc20:!0,symbol:"MANA",decimals:18},"0x0F513fFb4926ff82D7F60A05069047AcA295C413":{name:"CrowdstartCoin",logo:"XSC_Logo.svg",erc20:!0,symbol:"XSC",decimals:18},"0x5BC7e5f0Ab8b2E10D2D0a3F21739FCe62459aeF3":{name:"Hut34 Entropy Token",logo:"ENTRP.png",symbol:"ENTRP",erc20:!0,decimals:18},"0x946112efaB61C3636CBD52DE2E1392D7A75A6f01":{name:"HYDRO TOKEN",logo:"hydro.svg",erc20:!0,symbol:"HYDRO",decimals:18},"0x2604FA406Be957E542BEb89E6754fCdE6815e83f":{name:"Playkey Token",logo:"playkey.svg",erc20:!0,symbol:"PKT",decimals:18},"0xE41d2489571d322189246DaFA5ebDe1F4699F498":{name:"0x",logo:"zrx.svg",erc20:!0,symbol:"ZRX",decimals:18},"0x957c30aB0426e0C93CD8241E2c60392d08c6aC8e":{name:"Modum Token",logo:"modum.svg",erc20:!0,symbol:"MOD",decimals:0},"0x1a7a8BD9106F2B8D977E08582DC7d24c723ab0DB":{name:"AppCoins",logo:"appc.svg",erc20:!0,decimals:18,symbol:"APPC"},"0xdB25f211AB05b1c97D595516F45794528a807ad8":{name:"STASIS EURS Token",logo:"stasis-eurs.svg",erc20:!0,decimals:2,symbol:"EURS"},"0xCA0e7269600d353F70b14Ad118A49575455C0f2f":{name:"AMLT",logo:"amlt.png",erc20:!0,decimals:18,symbol:"AMLT"},"0xC011a73ee8576Fb46F5E1c5751cA3B9Fe0af2a6F":{name:"Synthetix Network Token",logo:"synthetix.svg",erc20:!0,decimals:18,symbol:"SNX"},"0x57Ab1ec28D129707052df4dF418D58a2D46d5f51":{name:"Synth sUSD",logo:"synthetix_susd.svg",erc20:!0,decimals:18,symbol:"SUSD"},"0x5e74C9036fb86BD7eCdcb084a0673EFc32eA31cb":{name:"Synth sETH",logo:"synthetix_seth.svg",erc20:!0,decimals:18,symbol:"SETH"},"0xfE18be6b3Bd88A2D2A7f928d00292E7a9963CfC6":{name:"Synth sBTC",logo:"synthetix_sbtc.svg",erc20:!0,decimals:18,symbol:"SBTC"},"0x0DB8D8b76BC361bAcbB72E2C491E06085A97Ab31":{name:"IQeon",logo:"iqeon.svg",erc20:!0,decimals:18,symbol:"IQN"},"0x000C100050E98C91f9114fa5Dd75CE6869Bf4F53":{name:"CRYPTO10 Hedged",logo:"c10.svg",erc20:!0,symbol:"C10",decimals:18},"0x26E75307Fc0C021472fEb8F727839531F112f317":{name:"Crypto20",logo:"c20.svg",erc20:!0,symbol:"C20",decimals:18},"0x06012c8cf97BEaD5deAe237070F9587f8E7A266d":{name:"Crypto Kitties",logo:"ck.svg",erc20:!1,erc721:!0,symbol:"CK",decimals:0},"0xE477292f1B3268687A29376116B0ED27A9c76170":{name:"Herocoin",logo:"herocoin_logo.png",erc20:!0,symbol:"PLAY",decimals:18},"0x4F4f0Db4de903B88f2B1a2847971E231D54F8fd3":{name:"Geens Platform Token",logo:"gee-icon.svg",erc20:!0,symbol:"GEE",decimals:8},"0xec67005c4E498Ec7f55E092bd1d35cbC47C91892":{name:"Enzyme Finance",logo:"mln.svg",erc20:!0,symbol:"MLN",decimals:18},"0xba2184520A1cC49a6159c57e61E1844E085615B6":{name:"HelloGold Token",logo:"hgt.png",erc20:!0,symbol:"HGT",decimals:8},"0xba358B6f5b4c0215650444B8C30D870B55050D2D":{name:"Hub Token",logo:"hub.svg",erc20:!0,symbol:"HUB",decimals:18},"0x8727c112C712c4a03371AC87a74dD6aB104Af768":{name:"Jetcoin Institute Token",logo:"JETCOIN28.png",erc20:!0,symbol:"JET",decimals:18},"0xf8e386EDa857484f5a12e4B5DAa9984E06E73705":{name:"Indorse Token",logo:"indorseLogo.jpg",erc20:!0,symbol:"IND",decimals:18},"0xA54ddC7B3CcE7FC8b1E3Fa0256D0DB80D2c10970":{name:"NEVERDIE Coin",logo:"ndc.png",erc20:!0,symbol:"NDC",decimals:18},"0x1c4481750daa5Ff521A2a7490d9981eD46465Dbd":{name:"BlockMason Credit Protocol Token",logo:"bcpt.svg",erc20:!0,symbol:"BCPT",decimals:18},"0x20F7A3DdF244dc9299975b4Da1C39F8D5D75f05A":{name:"Sapien Network Token",logo:"spn.svg",erc20:!0,symbol:"SPN",decimals:6},"0xA4e8C3Ec456107eA67d3075bF9e3DF3A75823DB0":{name:"Loom Token",logo:"loom.svg",erc20:!0,symbol:"LOOM",decimals:18},"0x42476F744292107e34519F9c357927074Ea3F75D":{name:"Loom",logo:"loom.svg",erc20:!0,symbol:"LOOM",decimals:18},"0x4F9254C83EB525f9FCf346490bbb3ed28a81C667":{name:"Celer Network Token",logo:"CELR.svg",erc20:!0,symbol:"CELR",decimals:18},"0x71D01dB8d6a2fBEa7f8d434599C237980C234e4C":{name:"Gladius",logo:"gladius.svg",erc20:!0,symbol:"GLA",decimals:8},"0xdd974D5C2e2928deA5F71b9825b8b646686BD200":{name:"Kyber Network Crystal",logo:"kyber.svg",erc20:!0,symbol:"KNC",decimals:18},"0x1F573D6Fb3F13d689FF844B4cE37794d79a7FF1C":{name:"Bancor Network Token",logo:"bnt.svg",erc20:!0,symbol:"BNT",decimals:18},"0xfa05A73FfE78ef8f1a739473e462c54bae6567D9":{name:"Lunyr Token",logo:"lun.svg",erc20:!0,symbol:"LUN",decimals:18},"0xC741f06082AA47F93729070aD0dD95E223Bda091":{name:"LEDU Token",logo:"edu.svg",erc20:!0,symbol:"LEDU",decimals:8},"0x5c543e7AE0A1104f78406C340E9C64FD9fCE5170":{name:"vSlice",logo:"vslice.png",erc20:!0,symbol:"VSL",decimals:18},"0x1f41E42D0a9e3c0Dd3BA15B527342783B43200A9":{name:"Blockchain Capital",logo:"bcap.svg",erc20:!0,symbol:"BCAP",decimals:0},"0x6531f133e6DeeBe7F2dcE5A0441aA7ef330B4e53":{name:"Chronobank TIME",logo:"chronobank.png",erc20:!0,symbol:"TIME",decimals:8},"0xaAAf91D9b90dF800Df4F55c205fd6989c977E73a":{name:"Monolith TKN",logo:"tkn.svg",erc20:!0,symbol:"TKN",decimals:8},"0x08711D3B02C8758F2FB3ab4e80228418a7F8e39c":{name:"Edgeless",logo:"edg.svg",erc20:!0,symbol:"EDG",decimals:0},"0xf7B098298f7C69Fc14610bf71d5e02c60792894C":{name:"Guppy",logo:"guppy.png",erc20:!0,symbol:"GUP",decimals:3},"0x4DF812F6064def1e5e029f1ca858777CC98D2D81":{name:"Xaurum",logo:"xaurum_logo.svg",erc20:!0,symbol:"XAUR",decimals:8},"0xB9e7F8568e08d5659f5D29C4997173d84CdF2607":{name:"Swarm City Token",logo:"swt.svg",erc20:!0,symbol:"SWT",decimals:18},"0xCb94be6f13A1182E4A4B6140cb7bf2025d28e41B":{name:"Trustcoin",logo:"trst.svg",erc20:!0,symbol:"TRST",decimals:6},"0xCB56b52316041A62B6b5D0583DcE4A8AE7a3C629":{name:"Cigarettes",logo:"cig.svg",erc20:!0,symbol:"CIG",decimals:18},"0x960b236A07cf122663c4303350609A66A7B288C0":{name:"Aragon Network Token v1",logo:"antv1.svg",erc20:!0,symbol:"ANTv1",decimals:18},"0x667088b212ce3d06a1b553a7221E1fD19000d9aF":{name:"WINGS",logo:"wings_logo.svg",erc20:!0,symbol:"WINGS",decimals:18},"0x16484d73Ac08d2355F466d448D2b79D2039F6EBB":{name:"FortKnoxster",logo:"FortKnoxster.svg",erc20:!0,symbol:"FKX",decimals:18},"0xAf30D2a7E90d7DC361c8C4585e9BB7D2F6f15bc7":{name:"FirstBlood Token",logo:"1st.svg",erc20:!0,symbol:"1ST",decimals:18},"0x607F4C5BB672230e8672085532f7e901544a7375":{name:"iExec RLC Token",logo:"rlc.svg",erc20:!0,symbol:"RLC",decimals:9},"0xaeC2E87E0A235266D9C5ADc9DEb4b2E29b54D009":{name:"SingularDTV",logo:"singulardtv.svg",erc20:!0,symbol:"SNGLS",decimals:0},"0x888666CA69E0f178DED6D75b5726Cee99A87D698":{name:"ICONOMI",logo:"iconomi.png",erc20:!0,symbol:"ICN",decimals:18},"0x9f8F72aA9304c8B593d555F12eF6589cC3A579A2":{name:"Maker",logo:"mkr.svg",erc20:!0,symbol:"MKR",decimals:18},"0x89d24A6b4CcB1B6fAA2625fE562bDD9a23260359":{name:"Sai Stablecoin v1.0",logo:"sai.svg",erc20:!0,symbol:"SAI",decimals:18},"0x6B175474E89094C44Da98b954EedeAC495271d0F":{name:"Dai Stablecoin",logo:"dai.svg",erc20:!0,symbol:"DAI",decimals:18},"0xC477D038d5420C6A9e0b031712f61c5120090de9":{name:"Boson Token",logo:"boson.svg",erc20:!0,symbol:"BOSON",decimals:18},"0xD46bA6D942050d489DBd938a2C909A5d5039A161":{name:"Ampleforth",logo:"ampl.svg",erc20:!0,symbol:"AMPL",decimals:9},"0x4b9278b94a1112cAD404048903b8d343a810B07e":{name:"Hifi Finance",logo:"hifi.svg",erc20:!0,symbol:"HIFI",decimals:18},"0x0D8775F648430679A709E98d2b0Cb6250d2887EF":{name:"Basic Attention Token",logo:"bat.svg",erc20:!0,symbol:"BAT",decimals:18},"0x4D8fc1453a0F359e99c9675954e656D80d996FbF":{name:"BEE Token",logo:"bee_token.svg",erc20:!0,symbol:"BEE",decimals:18},"0x6810e776880C02933D47DB1b9fc05908e5386b96":{name:"Gnosis Token",logo:"gnosis.svg",erc20:!0,symbol:"GNO",decimals:18},"0x514910771AF9Ca656af840dff83E8264EcF986CA":{name:"Chainlink Token",logo:"chainlink.svg",erc20:!0,symbol:"LINK",decimals:18},"0xD8912C10681D8B21Fd3742244f44658dBA12264E":{name:"Pluton",logo:"plutus-god.svg",erc20:!0,symbol:"PLU",decimals:18},"0x1985365e9f78359a9B6AD760e32412f4a445E862":{name:"Reputation Old",logo:"rep.svg",erc20:!0,symbol:"REP",decimals:18},"0x221657776846890989a759BA2973e427DfF5C9bB":{name:"Reputation",logo:"repv2.svg",erc20:!0,symbol:"REPv2",decimals:18},"0xd0929d411954c47438dc1d871dd6081F5C5e149c":{name:"Refereum",logo:"rfr.svg",erc20:!0,symbol:"RFR",decimals:4},"0xb0866289e870D2efc282406cF4123Df6E5BcB652":{name:"NoFakeCoin",logo:"nfticon.png",erc20:!0,symbol:"NFC",decimals:18},"0x2C4e8f2D746113d0696cE89B35F0d8bF88E0AEcA":{name:"Open Simple Token",logo:"OST.svg",erc20:!0,symbol:"OST",decimals:18},"0x408e41876cCCDC0F92210600ef50372656052a38":{name:"Republic Token",logo:"ren.svg",erc20:!0,symbol:"REN",decimals:18},"0xEB4C2781e4ebA804CE9a9803C67d0893436bB27D":{name:"renBTC",logo:"renBTC.svg",erc20:!0,symbol:"renBTC",decimals:8},"0x1C5db575E2Ff833E46a2E9864C22F4B22E0B37C2":{name:"renZEC",logo:"renZEC.svg",erc20:!0,symbol:"renZEC",decimals:8},"0x459086F2376525BdCebA5bDDA135e4E9d3FeF5bf":{name:"renBCH",logo:"renBCH.svg",erc20:!0,symbol:"renBCH",decimals:8},"0xD5147bc8e386d91Cc5DBE72099DAC6C9b99276F5":{name:"renFIL",logo:"renFIL.svg",erc20:!0,symbol:"renFIL",decimals:18},"0xa74476443119A942dE498590Fe1f2454d7D4aC0d":{name:"Golem Network Token",logo:"golem.svg",erc20:!0,symbol:"GNT",decimals:18},"0x6888a16eA9792c15A4DCF2f6C623D055c8eDe792":{name:"Spectiv Signal Token",logo:"spectiv.svg",erc20:!0,symbol:"SIG",decimals:18},"0x9a642d6b3368ddc662CA244bAdf32cDA716005BC":{name:"Qtum",logo:"qtum.svg",erc20:!0,decimals:18,symbol:"QTUM"},"0x1234567461d3f8Db7496581774Bd869C83D51c93":{name:"BitClave",logo:"bitclave.svg",erc20:!0,decimals:18,symbol:"CAT"},"0x7d4b8Cce0591C9044a22ee543533b72E976E36C3":{name:"Change",logo:"change.svg",erc20:!0,decimals:18,symbol:"CAG"},"0x1d462414fe14cf489c7A21CaC78509f4bF8CD7c0":{name:"CanYaCoin",logo:"CanYa.svg",erc20:!0,decimals:6,symbol:"CAN"},"0xC18360217D8F7Ab5e7c516566761Ea12Ce7F9D72":{name:"Ethereum Name Service",logo:"ens.svg",erc20:!0,decimals:18,symbol:"ENS"},"0x3d1BA9be9f66B8ee101911bC36D3fB562eaC2244":{name:"Rivetz",logo:"rivetz.png",erc20:!0,decimals:18,symbol:"RVT"},"0x056017c55aE7AE32d12AeF7C679dF83A85ca75Ff":{name:"Project Wyvern Token",logo:"wyvern-logo.svg",erc20:!0,symbol:"WYV",decimals:18},"0xfec0cF7fE078a500abf15F1284958F22049c2C7e":{name:"Maecenas ART Token",logo:"art.svg",erc20:!0,symbol:"ART",decimals:18},"0x05f4a42e251f2d52b8ed15E9FEdAacFcEF1FAD27":{name:"Zilliqa",logo:"zilliqa.svg",erc20:!0,symbol:"ZIL",decimals:12},"0x986EE2B944c42D017F52Af21c4c69B84DBeA35d8":{name:"BitMartToken",logo:"bitmart.png",erc20:!0,symbol:"BMX",decimals:18},"0xF03f8D65BaFA598611C3495124093c56e8F638f0":{name:"Viewly",logo:"viewly.svg",erc20:!0,symbol:"VIEW",decimals:18},"0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2":{name:"Wrapped Ether",logo:"weth.svg",erc20:!0,symbol:"WETH",decimals:18},"0xba5BDe662c17e2aDFF1075610382B9B691296350":{name:"SuperRare Token",logo:"rare.svg",erc20:!0,symbol:"RARE",decimals:18},"0x6C8c6b02E7b2BE14d4fA6022Dfd6d75921D90E4E":{name:"Compound Basic Attention Token",logo:"ctoken-bat.svg",erc20:!0,symbol:"cBAT",decimals:8},"0x70e36f6BF80a52b3B46b3aF8e106CC0ed743E8e4":{name:"Compound Collateral",logo:"ctoken-comp.svg",erc20:!0,symbol:"cCOMP",decimals:8},"0x5d3a536E4D6DbD6114cc1Ead35777bAB948E3643":{name:"Compound Dai",logo:"ctoken-dai.svg",erc20:!0,symbol:"cDAI",decimals:8},"0xF5DCe57282A584D2746FaF1593d3121Fcac444dC":{name:"Compound Sai (Legacy Dai)",logo:"ctoken-sai.svg",erc20:!0,symbol:"cSAI",decimals:8},"0x4Ddc2D193948926D02f9B1fE9e1daa0718270ED5":{name:"Compound Ether",logo:"ctoken-eth.svg",erc20:!0,symbol:"cETH",decimals:8},"0x158079Ee67Fce2f58472A96584A73C7Ab9AC95c1":{name:"Compound Augur",logo:"ctoken-rep.svg",erc20:!0,symbol:"cREP",decimals:8},"0x39AA39c021dfbaE8faC545936693aC917d5E7563":{name:"Compound USD Coin",logo:"ctoken-usdc.svg",erc20:!0,symbol:"cUSDC",decimals:8},"0xf650C3d88D12dB855b8bf7D11Be6C55A4e07dCC9":{name:"Compound Tether",logo:"ctoken-usdt.svg",erc20:!0,symbol:"cUSDT",decimals:8},"0xC11b1268C1A384e55C48c2391d8d480264A3A7F4":{name:"Compound Wrapped BTC",logo:"ctoken-wbtc.svg",erc20:!0,symbol:"cWBTC",decimals:8},"0xB3319f5D18Bc0D84dD1b4825Dcde5d5f7266d407":{name:"Compound 0x",logo:"ctoken-zrx.svg",erc20:!0,symbol:"cZRX",decimals:8},"0xc00e94Cb662C3520282E6f5717214004A7f26888":{name:"Compound",logo:"comp.svg",erc20:!0,symbol:"COMP",decimals:18},"0xFFE02ee4C69eDf1b340fCaD64fbd6b37a7b9e265":{name:"NANJCOIN",logo:"nanjcoin.svg",erc20:!0,symbol:"NANJ",decimals:8},"0xB6eD7644C69416d67B522e20bC294A9a9B405B31":{name:"0xBitcoin Token",logo:"0xbitcoin.svg",erc20:!0,symbol:"0xBTC",decimals:8},"0x744d70FDBE2Ba4CF95131626614a1763DF805B9E":{name:"Status Network Token",logo:"snt.svg",erc20:!0,symbol:"SNT",decimals:18},"0x42d6622deCe394b54999Fbd73D108123806f6a18":{name:"SPANK",logo:"spank.svg",erc20:!0,symbol:"SPANK",decimals:18},"0x6B01c3170ae1EFEBEe1a3159172CB3F7A5ECf9E5":{name:"BOOTY",logo:"booty.png",erc20:!0,symbol:"BOOTY",decimals:18},"0x4a6058666cf1057eaC3CD3A5a614620547559fc9":{name:"Brickblock",logo:"Brickblock.svg",erc20:!0,symbol:"BBK",decimals:18},"0x80fB784B7eD66730e8b1DBd9820aFD29931aab03":{name:"ETHLend Token",logo:"lend.svg",erc20:!0,symbol:"LEND",decimals:18},"0x48FF53777F747cFB694101222a944dE070c15D36":{name:"Ether Kingdoms Token",logo:"IMP.svg",erc20:!0,symbol:"IMP",decimals:7},"0x02F61Fd266DA6E8B102D4121f5CE7b992640CF98":{name:"LikeCoin",logo:"like.svg",erc20:!0,symbol:"LIKE",decimals:18},"0xB8c77482e45F1F44dE1745F52C74426C631bDD52":{name:"Binance Coin",logo:"bnb.png",erc20:!0,symbol:"BNB",decimals:18},"0xD850942eF8811f2A866692A623011bDE52a462C1":{name:"VeChain",logo:"ven.svg",erc20:!0,symbol:"VEN",decimals:18},"0x91Af0fBB28ABA7E31403Cb457106Ce79397FD4E6":{name:"Aergo",logo:"Aergo.svg",erc20:!0,symbol:"AERGO",decimals:18},"0x5CA9a71B1d01849C0a95490Cc00559717fCF0D1d":{name:"Aeternity",logo:"aeternity.svg",erc20:!0,symbol:"AE",decimals:18},"0xd4fa1460F537bb9085d22C7bcCB5DD450Ef28e3a":{name:"Populous",logo:"ppt.svg",erc20:!0,symbol:"PPT",decimals:8},"0xFA1a856Cfa3409CFa145Fa4e20Eb270dF3EB21ab":{name:"IOST",logo:"iost.png",erc20:!0,symbol:"IOST",decimals:18},"0x039B5649A59967e3e936D7471f9c3700100Ee1ab":{name:"Kucoin Shares",logo:"kucoin.svg",erc20:!0,symbol:"KCS",decimals:6},"0x3893b9422Cd5D70a81eDeFfe3d5A1c6A978310BB":{name:"Mithril",logo:"mith.svg",erc20:!0,symbol:"MITH",decimals:18},"0xb7cB1C96dB6B22b0D3d9536E0108d062BD488F74":{name:"Walton Token",logo:"wtc.svg",erc20:!0,symbol:"WTC",decimals:18},"0x1776e1F26f98b1A5dF9cD347953a26dd3Cb46671":{name:"Numeraire",logo:"nmr.png",erc20:!0,symbol:"NMR",decimals:18},"0x056Fd409E1d7A124BD7017459dFEa2F387b6d5Cd":{name:"Gemini Dollar",logo:"gusd.svg",erc20:!0,symbol:"GUSD",decimals:2},"0xA4Bdb11dc0a2bEC88d24A3aa1E6Bb17201112eBe":{name:"StableUSD",logo:"usds.svg",erc20:!0,symbol:"USDS",decimals:6},"0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48":{name:"USDC",logo:"usdc.svg",erc20:!0,symbol:"USDC",decimals:6},"0x1aBaEA1f7C830bD89Acc67eC4af516284b1bC33c":{name:"EURC",logo:"eurc.svg",erc20:!0,symbol:"EURC",decimals:6},"0x93ED3FBe21207Ec2E8f2d3c3de6e058Cb73Bc04d":{name:"Pinakion Token",logo:"pinakion.svg",erc20:!0,symbol:"PNK",decimals:18},"0x419D0d8BdD9aF5e606Ae2232ed285Aff190E711b":{name:"FunFair",logo:"fun.svg",erc20:!0,symbol:"FUN",decimals:8},"0xcA2796F9F61dc7b238Aab043971e49c6164DF375":{name:"YGGDRASH YEED Token",logo:"yggdrash.svg",erc20:!0,symbol:"YEED",decimals:18},"0x03e3f0c25965f13DbbC58246738C183E27b26a56":{name:"Disciplina Token",logo:"disciplina.svg",erc20:!0,symbol:"DSCP",decimals:18},"0xE814aeE960a85208C3dB542C53E7D4a6C8D5f60F":{name:"Chronologic DAY Token",logo:"DAY.png",erc20:!0,symbol:"DAY",decimals:18},"0x7E43581b19ab509BCF9397a2eFd1ab10233f27dE":{name:"PLATINUM",logo:"plat.png",erc20:!0,symbol:"PLAT",decimals:18},"0x8E870D67F660D95d5be530380D0eC0bd388289E1":{name:"Pax Dollar",logo:"usdp.svg",erc20:!0,symbol:"USDP",decimals:18},"0x45804880De22913dAFE09f4980848ECE6EcbAf78":{name:"PAX Gold",logo:"paxg.svg",erc20:!0,symbol:"PAXG",decimals:18},"0x0000000000085d4780B73119b644AE5ecd22b376":{name:"TrueUSD",logo:"TUSD.svg",erc20:!0,symbol:"TUSD",decimals:18},"0x00000000441378008EA67F4284A57932B1c000a5":{name:"TrueGBP",logo:"TGBP.svg",erc20:!0,symbol:"TGBP",decimals:18},"0x00006100F7090010005F1bd7aE6122c3C2CF0090":{name:"TrueAUD",logo:"TAUD.svg",erc20:!0,symbol:"TAUD",decimals:18},"0x00000100F2A2bd000715001920eB70D229700085":{name:"TrueCAD",logo:"TCAD.svg",erc20:!0,symbol:"TCAD",decimals:18},"0x0000852600CEB001E08e00bC008be620d60031F2":{name:"TrueHKD",logo:"THKD.svg",erc20:!0,symbol:"THKD",decimals:18},"0x4Fabb145d64652a948d72533023f6E7A623C7C53":{name:"Binance USD",logo:"busd.svg",erc20:!0,symbol:"BUSD",decimals:18},"0x23Ccc43365D9dD3882eab88F43d515208f832430":{name:"MidasProtocol",logo:"MAS.png",erc20:!0,symbol:"MAS",decimals:18},"0xC16b542ff490e01fcc0DC58a60e1EFdc3e357cA6":{name:"ICE ROCK MINING",logo:"rock2.png",erc20:!0,symbol:"ROCK2",decimals:0},"0x6758B7d441a9739b98552B373703d8d3d14f9e62":{name:"POA20 Token",logo:"POA20.png",erc20:!0,symbol:"POA20",decimals:18},"0x3DB6Ba6ab6F95efed1a6E794caD492fAAabF294D":{name:"LTO Network Token (old)",logo:"LTO.svg",erc20:!0,symbol:"LTOOLD",decimals:8},"0xd01409314aCb3b245CEa9500eCE3F6Fd4d70ea30":{name:"LTO Network Token",logo:"LTO.svg",erc20:!0,symbol:"LTO",decimals:8},"0xfeF4185594457050cC9c23980d301908FE057Bb1":{name:"VIDT Datalink",logo:"VIDT.svg",erc20:!0,symbol:"VIDT-OLD",decimals:18},"0x3BE7bF1A5F23BD8336787D0289B70602f1940875":{name:"VIDT DAO",logo:"VIDT.svg",erc20:!0,symbol:"VIDT",decimals:18},"0x7064aAb39A0Fcf7221c3396719D0917a65E35515":{name:"Cpollo",logo:"Cpollo.svg",erc20:!0,symbol:"CPLO",decimals:18},"0xd8446236FA95b9b5f9fd0f8E7Df1a944823c683d":{name:"NEEO",logo:"neeo.png",erc20:!0,symbol:"NEEO",decimals:18},"0xA823E6722006afe99E91c30FF5295052fe6b8E32":{name:"Neumark",logo:"neu.svg",erc20:!0,symbol:"NEU",decimals:18},"0x8f693ca8D21b157107184d29D398A8D082b38b76":{name:"Streamr",logo:"streamr.svg",erc20:!0,symbol:"DATA",decimals:18},"0x0Cf0Ee63788A0849fE5297F3407f701E122cC023":{name:"Streamr (old)",logo:"streamr_old.svg",erc20:!0,symbol:"XDATA",decimals:18},"0xA0b73E1Ff0B80914AB6fe0444E65848C4C34450b":{name:"Cronos",logo:"cro.svg",erc20:!0,symbol:"CRO",decimals:8},"0xF70a642bD387F94380fFb90451C2c81d4Eb82CBc":{name:"STAR",logo:"starbase.png",erc20:!0,symbol:"STAR",decimals:18},"0x7C5A0CE9267ED19B22F8cae653F198e3E8daf098":{name:"Santiment",logo:"santiment.svg",erc20:!0,symbol:"SAN",decimals:18},"0x58b6A8A3302369DAEc383334672404Ee733aB239":{name:"Livepeer",logo:"lpt.svg",erc20:!0,symbol:"LPT",decimals:18},"0x6fe56C0bcdD471359019FcBC48863d6c3e9d4F41":{name:"Props",logo:"props.png",erc20:!0,symbol:"PROPS",decimals:18},"0x6c6EE5e31d828De241282B9606C8e98Ea48526E2":{name:"HoloToken",logo:"hot.svg",erc20:!0,symbol:"HOT",decimals:18},"0xF629cBd94d3791C9250152BD8dfBDF380E2a3B9c":{name:"Enjin Coin",logo:"enj.svg",erc20:!0,symbol:"ENJ",decimals:18},"0xbf2179859fc6D5BEE9Bf9158632Dc51678a4100e":{name:"AELF",logo:"elf.svg",erc20:!0,symbol:"ELF",decimals:18},"0x39Bb259F66E1C59d5ABEF88375979b4D20D98022":{name:"WAX Token",logo:"wax.svg",erc20:!0,symbol:"WAX",decimals:8},"0x595832F8FC6BF59c85C527fEC3740A1b7a361269":{name:"PowerLedger",logo:"powr.svg",erc20:!0,symbol:"POWR",decimals:6},"0x28dee01D53FED0Edf5f6E310BF8Ef9311513Ae40":{name:"BlitzPredict",logo:"blitzpredict.svg",erc20:!0,symbol:"XBP",decimals:18},"0x33349B282065b0284d756F0577FB39c158F935e6":{name:"Maple Finance",logo:"maple-finance.svg",erc20:!0,erc721:!1,symbol:"MPL",decimals:18},"0xFBeef911Dc5821886e1dda71586d90eD28174B7d":{name:"KnownOrigin",logo:"knownorigin.svg",erc20:!0,symbol:"KODA",decimals:0},"0x8207c1FfC5B6804F6024322CcF34F29c3541Ae26":{name:"Origin Protocol",logo:"ogn.svg",erc20:!0,symbol:"OGN",decimals:18},"0x2A8e1E676Ec238d8A992307B495b45B3fEAa5e86":{name:"Origin Dollar",logo:"ousd.svg",erc20:!0,symbol:"OUSD",decimals:18},"0x856c4Efb76C1D1AE02e20CEB03A2A6a08b0b8dC3":{name:"Origin Ether",logo:"oeth.svg",erc20:!0,symbol:"OETH",decimals:18},"0x9c354503C38481a7A7a51629142963F98eCC12D0":{name:"Origin DeFi Governance",logo:"ogv.svg",erc20:!0,symbol:"OGV",decimals:18},"0x0C4576Ca1c365868E162554AF8e385dc3e7C66D9":{name:"Vote Escrowed Origin DeFi Governance",logo:"veogv.svg",erc20:!0,symbol:"veOGV",decimals:18},"0x8f8221aFbB33998d8584A2B05749bA73c37a938a":{name:"Request",logo:"request.svg",erc20:!0,symbol:"REQ",decimals:18},"0x2aEa4Add166EBf38b63d09a75dE1a7b94Aa24163":{name:"Kudos",logo:"kudos.svg",erc20:!1,erc721:!0,symbol:"KDO",decimals:0},"0x14C926F2290044B647e1Bf2072e67B495eff1905":{name:"Bethereum",logo:"bether.jpg",erc20:!0,symbol:"BETHER",decimals:18},"0x9AAb071B4129B083B01cB5A0Cb513Ce7ecA26fa5":{name:"Hunt Token",logo:"hunt.png",erc20:!0,symbol:"HUNT",decimals:18},"0xFEF3884b603C33EF8eD4183346E093A173C94da6":{name:"Metamorph",logo:"metamorph.svg",erc20:!0,symbol:"METM",decimals:18},"0x0AbdAce70D3790235af448C88547603b945604ea":{name:"district0x",logo:"district0x.svg",erc20:!0,symbol:"DNT",decimals:18},"0xB26631c6dda06aD89B93C71400D25692de89c068":{name:"Minds",logo:"minds.svg",erc20:!0,symbol:"MINDS",decimals:18},"0xBb1f24C0c1554b9990222f036b0AaD6Ee4CAec29":{name:"CryptoSoul",logo:"SOUL.svg",erc20:!0,symbol:"SOUL",decimals:18},"0xFF0E5e014cf97e0615cb50F6f39Da6388E2FaE6E":{name:"Origo",logo:"origo.svg",erc20:!0,symbol:"OGO",decimals:18},"0x0cB8D0B37C7487b11d57F1f33dEfA2B1d3cFccfE":{name:"DANKToken",logo:"dank-logo.svg",erc20:!0,symbol:"DANK",decimals:18},"0x3a4f40631a4f906c2BaD353Ed06De7A5D3fCb430":{name:"PlayDapp Token",logo:"playdapp.svg",erc20:!0,symbol:"PLA",decimals:18},"0xE9e3F9cfc1A64DFca53614a0182CFAD56c10624F":{name:"Su Squares",logo:"Su-Squares.svg",erc20:!1,erc721:!0,symbol:"SU",decimals:0},"0xfA5047c9c78B8877af97BDcb85Db743fD7313d4a":{name:"ROOK",logo:"Rook.svg",erc20:!0,symbol:"ROOK",decimals:18},"0xa62cc35625B0C8dc1fAEA39d33625Bb4C15bD71C":{name:"StormX",logo:"stormx.svg",erc20:!0,symbol:"STMX",decimals:18},"0x7D1AfA7B718fb893dB30A3aBc0Cfc608AaCfeBB0":{name:"Matic Network Token",logo:"matic.svg",erc20:!0,symbol:"MATIC",decimals:18},"0x9992eC3cF6A55b00978cdDF2b27BC6882d88D1eC":{name:"Polymath",logo:"poly.svg",erc20:!0,symbol:"POLY",decimals:18},"0x0a50C93c762fDD6E56D86215C24AaAD43aB629aa":{name:"LGO Token",logo:"lgo.png",erc20:!0,symbol:"LGO",decimals:8},"0xc8Cac7672f4669685817cF332a33Eb249F085475":{name:"LivenCoin",logo:"LVN.svg",erc20:!0,symbol:"LVN",decimals:18},"0xBBbbCA6A901c926F240b89EacB641d8Aec7AEafD":{name:"Loopring",logo:"LRC.svg",erc20:!0,symbol:"LRC",decimals:18},"0x255Aa6DF07540Cb5d3d297f0D0D4D84cb52bc8e6":{name:"Raiden Network Token",logo:"raiden.svg",erc20:!0,symbol:"RDN",decimals:18},"0x66fD97a78d8854fEc445cd1C80a07896B0b4851f":{name:"Lunch Money",logo:"LMY.svg",erc20:!0,symbol:"LMY",decimals:18},"0x679131F591B4f369acB8cd8c51E68596806c3916":{name:"Trustlines Network Token",logo:"TLN128.png",erc20:!0,symbol:"TLN",decimals:18},"0xdcD85914b8aE28c1E62f1C488E1D968D5aaFfE2b":{name:"TOP Network Token",logo:"TOP.svg",erc20:!0,symbol:"TOP",decimals:18},"0xaea46A60368A7bD060eec7DF8CBa43b7EF41Ad85":{name:"Fetch",logo:"fetch.svg",erc20:!0,symbol:"FET",decimals:18},"0x2e1E15C44Ffe4Df6a0cb7371CD00d5028e571d14":{name:"Mettalex",logo:"mettalex.svg",erc20:!0,symbol:"MTLX",decimals:18},"0xf21661D0D1d76d3ECb8e1B9F1c923DBfffAe4097":{name:"Realio Network",logo:"rio.svg",erc20:!0,symbol:"RIO",decimals:18},"0x1f9840a85d5aF5bf1D1762F925BDADdC4201F984":{name:"Uniswap",logo:"uni.svg",erc20:!0,symbol:"UNI",decimals:18},"0x2e6539edc3b76f1E21B71d214527FAbA875F70F3":{name:"Yearn Finance Dot",logo:"YFDOT.svg",erc20:!0,symbol:"YFDOT",decimals:18},"0x9F284E1337A815fe77D2Ff4aE46544645B20c5ff":{name:"Darwinia Commitment Token",logo:"kton.svg",erc20:!0,symbol:"KTON",decimals:18},"0xE48972fCd82a274411c01834e2f031D4377Fa2c0":{name:"TwoKeyEconomy",logo:"2key.svg",erc20:!0,symbol:"2KEY",decimals:18},"0x970B9bB2C0444F5E81e9d0eFb84C8ccdcdcAf84d":{name:"Fuse Token",logo:"fuse.svg",erc20:!0,symbol:"FUSE",decimals:18},"0x0Ae055097C6d159879521C384F1D2123D1f195e6":{name:"STAKE Token",logo:"stake.svg",erc20:!0,symbol:"STAKE",decimals:18},"0x5dc60C4D5e75D22588FA17fFEB90A63E535efCE0":{name:"dKargo",logo:"DKA.svg",erc20:!0,symbol:"DKA",decimals:18},"0x9469D013805bFfB7D3DEBe5E7839237e535ec483":{name:"Darwinia Network Native Token",logo:"ring.svg",erc20:!0,symbol:"RING",decimals:18},"0xA31B1767e09f842ECFd4bc471Fe44F830E3891AA":{name:"ROOBEE",logo:"ROOBEE.svg",erc20:!0,symbol:"ROOBEE",decimals:18},"0xC7e43A1c8E118aA2965F5EAbe0e718D83DB7A63C":{name:"ZCore Token",logo:"zcrt.svg",erc20:!0,symbol:"ZCRT",decimals:18},"0x08d32b0da63e2C3bcF8019c9c5d849d7a9d791e6":{name:"Dentacoin Token",logo:"dcn.svg",erc20:!0,symbol:"DCN",decimals:0},"0xe2f2a5C287993345a840Db3B0845fbC70f5935a5":{name:"mStable USD",logo:"mUSD.svg",erc20:!0,symbol:"mUSD",decimals:18},"0xa3BeD4E1c75D00fa6f4E5E6922DB7261B5E9AcD2":{name:"Meta",logo:"MTA.svg",erc20:!0,symbol:"MTA",decimals:18},"0xe3818504c1B32bF1557b16C238B2E01Fd3149C17":{name:"Pillar",logo:"plr.svg",erc20:!0,symbol:"PLR",decimals:18},"0xba100000625a3754423978a60c9317c58a424e3D":{name:"Balancer (BAL)",logo:"balancer.svg",erc20:!0,symbol:"BAL",decimals:18},"0x8a854288a5976036A725879164Ca3e91d30c6A1B":{name:"Guaranteed Entrance Token",logo:"get-logo.svg",erc20:!0,symbol:"GET",decimals:18},"0x2781246fe707bB15CeE3e5ea354e2154a2877B16":{name:"Elysia",logo:"el.svg",erc20:!0,symbol:"EL",decimals:18},"0x4dA34f8264CB33A5c9F17081B9EF5Ff6091116f4":{name:"Elyfi",logo:"elyfi.svg",erc20:!0,symbol:"ELFI",decimals:18},"0xc12d099be31567add4e4e4d0D45691C3F58f5663":{name:"Auctus",logo:"auc.svg",erc20:!0,symbol:"AUC",decimals:18},"0xdF574c24545E5FfEcb9a659c229253D4111d87e1":{name:"HUSD",logo:"HUSD.svg",erc20:!0,symbol:"HUSD",decimals:8},"0x2ecB13A8c458c379c4d9a7259e202De03c8F3D19":{name:"Block-Chain.com Token",logo:"block-chain.svg",erc20:!0,symbol:"BC",decimals:18},"0x38e4adB44ef08F22F5B5b76A8f0c2d0dCbE7DcA1":{name:"Concentrated Voting Power",logo:"PowerPool.svg",erc20:!0,symbol:"CVP",decimals:18},"0xa117000000f279D81A1D3cc75430fAA017FA5A2e":{name:"Aragon Network Token",logo:"antv2.svg",erc20:!0,symbol:"ANT",decimals:18},"0xDecade1c6Bf2cD9fb89aFad73e4a519C867adcF5":{name:"Experty Wisdom Token",logo:"wisdom-token.svg",erc20:!0,symbol:"WIS",decimals:18},"0x7D85e23014F84E6E21d5663aCD8751bEF3562352":{name:"Axion Old",logo:"obsolete.svg",erc20:!0,symbol:"AXNv1",decimals:18},"0x358AA737e033F34df7c54306960a38d09AaBd523":{name:"Ares Token",logo:"ares.svg",erc20:!0,symbol:"ARES",decimals:18},"0xB62132e35a6c13ee1EE0f84dC5d40bad8d815206":{name:"NEXO",logo:"NEXO.svg",erc20:!0,symbol:"NEXO",decimals:18},"0x4612021C75809160Be60DB21fBc9D6adD0B32deF":{name:"BCP Coin",logo:"BCP.svg",erc20:!0,symbol:"BCP",decimals:18},"0xE9E73E1aE76D17A16cC53E3e87a9a7dA78834d37":{name:"Camp",logo:"Camp.svg",erc20:!0,symbol:"CAMP",decimals:18},"0xdacD69347dE42baBfAEcD09dC88958378780FB62":{name:"Atari Token",logo:"atrilast.svg",erc20:!0,symbol:"ATRI",decimals:0},"0x71F85B2E46976bD21302B64329868fd15eb0D127":{name:"Axion",logo:"axion.svg",erc20:!0,symbol:"AXN",decimals:18},"0xc944E90C64B2c07662A292be6244BDf05Cda44a7":{name:"Graph Token",logo:"graphToken.svg",erc20:!0,symbol:"GRT",decimals:18},"0xFE3E6a25e6b192A42a44ecDDCd13796471735ACf":{name:"Reef Finance",logo:"reef.svg",erc20:!0,symbol:"REEF",decimals:18},"0x43Dfc4159D86F3A37A5A4B3D4580b888ad7d4DDd":{name:"DODO bird",logo:"DODO.svg",erc20:!0,symbol:"DODO",decimals:18},"0x4a615bB7166210CCe20E6642a6f8Fb5d4D044496":{name:"NAOS Finance",logo:"naos.svg",erc20:!0,symbol:"NAOS",decimals:18},"0x111111111117dC0aa78b770fA6A738034120C302":{name:"1INCH Token",logo:"1inch.svg",erc20:!0,symbol:"1INCH",decimals:18},"0x27702a26126e0B3702af63Ee09aC4d1A084EF628":{name:"Aleph.im Token",logo:"aleph.svg",erc20:!0,symbol:"ALEPH",decimals:18},"0x32a7C02e79c4ea1008dD6564b35F131428673c41":{name:"CRUST",logo:"crust.svg",erc20:!0,symbol:"CRU",decimals:18},"0x3472A5A71965499acd81997a54BBA8D852C6E53d":{name:"BADGER",logo:"badger.svg",erc20:!0,symbol:"BADGER",decimals:18},"0x65Def5029A0e7591e46B38742bFEdd1Fb7b24436":{name:"Kanpeki",logo:"kanpeki-green.svg",erc20:!0,symbol:"KAE",decimals:18},"0xF94b5C5651c888d928439aB6514B93944eEE6F48":{name:"Yield App",logo:"yield-app.svg",erc20:!0,symbol:"YLD",decimals:18},"0xDcB01cc464238396E213a6fDd933E36796eAfF9f":{name:"Yield",logo:"yield-logo.svg",erc20:!0,symbol:"YLD",decimals:18},"0x968F6f898a6Df937fC1859b323aC2F14643e3fED":{name:"Newscrypto",logo:"NWC.svg",erc20:!0,symbol:"NWC",decimals:18},"0xeb269732ab75A6fD61Ea60b06fE994cD32a83549":{name:"dForce USDx",logo:"USDx.svg",erc20:!0,symbol:"USDx",decimals:18},"0x6e0daDE58D2d89eBBe7aFc384e3E4f15b70b14D8":{name:"QuiverX",logo:"quiverx.svg",erc20:!0,symbol:"QRX",decimals:18},"0x0beAD9a1bcc1b84D06E3f2df67E3549Fd55aB054":{name:"EURxb",logo:"eurxb.svg",erc20:!0,symbol:"EURxb",decimals:18},"0x9F9c8ec3534c3cE16F928381372BfbFBFb9F4D24":{name:"GraphLinq",logo:"glq.svg",erc20:!0,symbol:"GLQ",decimals:18},"0xEB58343b36C7528F23CAAe63a150240241310049":{name:"NBU",logo:"NBU.svg",erc20:!0,symbol:"NBU",decimals:18},"0x16ECCfDbb4eE1A85A33f3A9B21175Cd7Ae753dB4":{name:"Route",logo:"route.svg",erc20:!0,symbol:"ROUTE",decimals:18},"0x75739d5944534115d7C54ee8C73F186D793BAE02":{name:"Collective",logo:"CO2.svg",erc20:!0,symbol:"CO2",decimals:18},"0x35bD01FC9d6D5D81CA9E055Db88Dc49aa2c699A8":{name:"FWB Pro",logo:"FWB.svg",erc20:!0,symbol:"FWB",decimals:18},"0x9B99CcA871Be05119B2012fd4474731dd653FEBe":{name:"Antimatter",logo:"antimatter.svg",erc20:!0,symbol:"MATTER",decimals:18},"0x6De037ef9aD2725EB40118Bb1702EBb27e4Aeb24":{name:"Render Token",logo:"RNDR.svg",erc20:!0,symbol:"RNDR",decimals:18},"0xDf49C9f599A0A9049D97CFF34D0C30E468987389":{name:"SaTT",logo:"SaTT.svg",erc20:!0,symbol:"SATT",decimals:18},"0x431ad2ff6a9C365805eBaD47Ee021148d6f7DBe0":{name:"dForce",logo:"DF.svg",erc20:!0,symbol:"DF",decimals:18},"0x6e1A19F235bE7ED8E3369eF73b196C07257494DE":{name:"Wrapped Filecoin",logo:"WFIL.svg",erc20:!0,symbol:"WFIL",decimals:18},"0xE452E6Ea2dDeB012e20dB73bf5d3863A3Ac8d77a":{name:"Wrapped Celo",logo:"WCELO.svg",erc20:!0,symbol:"wCELO",decimals:18},"0x4A64515E5E1d1073e83f30cB97BEd20400b66E10":{name:"Wrapped ZEC",logo:"WZEC.svg",erc20:!0,symbol:"WZEC",decimals:18},"0xA3865E64121537b5b59B5e239Db4aCBe6F36aa74":{name:"Wrapped Tezos",logo:"WXTZ.svg",erc20:!0,symbol:"WXTZ",decimals:18},"0x53c4871322Bb47e7A24136fce291a6dcC832a294":{name:"Wrapped Litecoin",logo:"WLTC.svg",erc20:!0,symbol:"WLTC",decimals:18},"0xad3E3Fc59dff318BecEaAb7D00EB4F68b1EcF195":{name:"Wrapped Celo USD",logo:"WCUSD.svg",erc20:!0,symbol:"wCUSD",decimals:18},"0x85D7bdfc9c3426b33A684241eEEE70385Bc42820":{name:"Wrapped Kadena",logo:"WKDA.svg",erc20:!0,symbol:"WKDA",decimals:18},"0x39fBBABf11738317a448031930706cd3e612e1B9":{name:"Wrapped XRP",logo:"WXRP.svg",erc20:!0,symbol:"WXRP",decimals:18},"0xBBC7f7A6AADAc103769C66CBC69AB720f7F9Eae3":{name:"INX Token",logo:"INX.svg",erc20:!0,symbol:"INX",decimals:18},"0x1b40183EFB4Dd766f11bDa7A7c3AD8982e998421":{name:"Vesper",logo:"vsp.svg",erc20:!0,symbol:"VSP",decimals:18},"0x544c42fBB96B39B21DF61cf322b5EDC285EE7429":{name:"InsurAce",logo:"INSUR.svg",erc20:!0,symbol:"INSUR",decimals:18},"0xcC665390b03c5D324D8fAF81C15eCee29A73bCB4":{name:"ChainSwap.com Governance Token",logo:"chainswap.svg",erc20:!0,symbol:"ASAP",decimals:18},"0x182F4c4C97cd1c24E1Df8FC4c053E5C47bf53Bef":{name:"keyTango Token",logo:"keyTango.svg",erc20:!0,symbol:"TANGO",decimals:18},"0x0275E1001e293C46CFe158B3702AADe0B99f88a5":{name:"Oiler",logo:"oiler.svg",erc20:!0,symbol:"OIL",decimals:18},"0xDe30da39c46104798bB5aA3fe8B9e0e1F348163F":{name:"Gitcoin",logo:"gtc.svg",erc20:!0,symbol:"GTC",decimals:18},"0x1796ae0b0fa4862485106a0de9b654eFE301D0b2":{name:"Polychain Monsters",logo:"PMON.svg",erc20:!0,symbol:"PMON",decimals:18},"0x8eEF5a82E6Aa222a60F009ac18c24EE12dBf4b41":{name:"Tixl",logo:"TXL.svg",erc20:!0,symbol:"TXL",decimals:18},"0x5218E472cFCFE0b64A064F055B43b4cdC9EfD3A6":{name:"unFederalReserve Token",logo:"eRSDL.svg",erc20:!0,symbol:"eRSDL",decimals:18},"0xE4cC5A22B39fFB0A56d67F94f9300db20D786a5F":{name:"unFederal eRSDL",logo:"uneRSDL.svg",erc20:!0,symbol:"uneRSDL",decimals:8},"0x2dbA05B51eF5A7DE3E7c3327201CA2F8a25C2414":{name:"unFederal DAI",logo:"unDAI.svg",erc20:!0,symbol:"unDAI",decimals:8},"0xFaCecE87e14B50eafc85C44C01702F5f485CA460":{name:"unFederal ETH",logo:"unETH.svg",erc20:!0,symbol:"unETH",decimals:8},"0x6b576972de33BebDe3A703BfF52a091e79f8c87A":{name:"unFederal USDC",logo:"unUSDC.svg",erc20:!0,symbol:"unUSDC",decimals:8},"0x6e2aA5bB90ac37D9006685AFc651ef067E1c7b44":{name:"unFederal USDT",logo:"unUSDT.svg",erc20:!0,symbol:"unUSDT",decimals:8},"0x5D446FC8DBd10EBAcfE9A427aB5402586af98cD4":{name:"unFederal WBTC",logo:"unWBTC.svg",erc20:!0,symbol:"unWBTC",decimals:8},"0xD837eCa6C91c67D98461A411BA2f00bdA9960a9D":{name:"unFederal AAVE",logo:"unAAVE.svg",erc20:!0,symbol:"unAAVE",decimals:8},"0x9e29Ce9cD25F4141dF6BB85b27Ef6933a16A5824":{name:"unFederal YFI",logo:"unYFI.svg",erc20:!0,symbol:"unYFI",decimals:8},"0x031002d15B0D0Cd7c9129d6F644446368deaE391":{name:"unFederal LINK",logo:"unLINK.svg",erc20:!0,symbol:"unLINK",decimals:8},"0xB8E2e2101eD11e9138803cd3e06e16dd19910647":{name:"ArdCoin",logo:"ardcoin.svg",erc20:!0,symbol:"ARDX",decimals:2},"0x6D0F5149c502faf215C89ab306ec3E50b15e2892":{name:"Portion Token",logo:"PRT.svg",erc20:!0,symbol:"PRT",decimals:18},"0xcc7ab8d78dBA187dC95bF3bB86e65E0C26d0041f":{name:"3SPACE ART",logo:"3SPACE.svg",erc20:!0,symbol:"PACE",decimals:18},"0x3845badAde8e6dFF049820680d1F14bD3903a5d0":{name:"SAND",logo:"SAND.svg",erc20:!0,symbol:"SAND",decimals:18},"0xcc7ab8d78dBA187dC95bF3bB86e65E0C26d0041f":{name:"Spacelens",logo:"SPACE.svg",erc20:!0,symbol:"SPACE",decimals:18},"0x50f5474724e0Ee42D9a4e711ccFB275809Fd6d4a":{name:"Sandbox's LANDs",logo:"SAND.svg",erc20:!1,erc721:!0,symbol:"LAND",decimals:0},"0x362bc847A3a9637d3af6624EeC853618a43ed7D2":{name:"PARSIQ",logo:"parsiq.svg",erc20:!0,symbol:"PRQ",decimals:18},"0x21381e026Ad6d8266244f2A583b35F9E4413FA2a":{name:"Formation Finance",logo:"form.svg",erc20:!0,symbol:"FORM",decimals:18},"0x2ba592F78dB6436527729929AAf6c908497cB200":{name:"Cream",logo:"cream.svg",erc20:!0,symbol:"CREAM",decimals:18},"0x46576e20EC5F25586A6Fa2E0d6B6058354B72E72":{name:"Cryptomind",logo:"CR.svg",erc20:!0,erc721:!1,symbol:"CR",decimals:8},"0x5ab21Ec0bfa0B29545230395e3Adaca7d552C948":{name:"PUNKS Comic",logo:"punks-comic.svg",erc20:!1,erc721:!0,symbol:"COMIC",decimals:0},"0x9C2dc0c3CC2BADdE84B0025Cf4df1c5aF288D835":{name:"Coreto",logo:"coreto.svg",erc20:!0,symbol:"COR",decimals:18},"0x0De05F6447ab4D22c8827449EE4bA2D5C288379B":{name:"OOKI",logo:"ooki.svg",erc20:!0,symbol:"OOKI",decimals:18},"0x6B4c7A5e3f0B99FCD83e9c089BDDD6c7FCe5c611":{name:"Million",logo:"million.svg",erc20:!0,symbol:"MM",decimals:18},"0x56d811088235F11C8920698a204A5010a788f4b3":{name:"bZx Protocol Token (BZRX)",logo:"ic_token_bzrx.svg",erc20:!0,symbol:"BZRX",decimals:18},"0xB72B31907C1C95F3650b64b2469e08EdACeE5e8F":{name:"bZx Vesting Token (vBZRX)",logo:"ic_token_vbzrx.svg",erc20:!0,symbol:"vBZRX",decimals:18},"0x3085154623F51b00Dedfc6Ceeb5197277A66B17B":{name:"NIFTY",logo:"nfty.svg",erc20:!0,symbol:"NFTY",decimals:18},"0xB983E01458529665007fF7E0CDdeCDB74B967Eb6":{name:"Fulcrum ETH iToken (iETH)",logo:"ic_token_ieth.svg",erc20:!0,symbol:"iETH",decimals:18},"0x32E4c68B3A4a813b710595AebA7f6B7604Ab9c15":{name:"Fulcrum USDC iToken (iUSDC)",logo:"ic_token_iusdc.svg",erc20:!0,symbol:"iUSDC",decimals:6},"0x2ffa85f655752fB2aCB210287c60b9ef335f5b6E":{name:"Fulcrum WBTC iToken (iWBTC)",logo:"ic_token_ibtc.svg",erc20:!0,symbol:"iWBTC",decimals:8},"0x687642347a9282Be8FD809d8309910A3f984Ac5a":{name:"Fulcrum KNC iToken (iKNC)",logo:"ic_token_iknc.svg",erc20:!0,symbol:"iKNC",decimals:18},"0x463538705E7d22aA7f03Ebf8ab09B067e1001B54":{name:"Fulcrum LINK iToken (iLINK)",logo:"ic_token_ilink.svg",erc20:!0,symbol:"iLINK",decimals:18},"0x6b093998D36f2C7F0cc359441FBB24CC629D5FF0":{name:"Fulcrum DAI iToken (iDAI)",logo:"ic_token_idai.svg",erc20:!0,symbol:"iDAI",decimals:18},"0x7e9997a38A439b2be7ed9c9C4628391d3e055D48":{name:"Fulcrum USDT iToken (iUSDT)",logo:"ic_token_iusdt.svg",erc20:!0,symbol:"iUSDT",decimals:6},"0x9189c499727f88F8eCC7dC4EEA22c828E6AaC015":{name:"Fulcrum MKR iToken (iMKR)",logo:"ic_token_imkr.svg",erc20:!0,symbol:"iMKR",decimals:18},"0x18240BD9C07fA6156Ce3F3f61921cC82b2619157":{name:"Fulcrum BZRX iToken (iBZRX)",logo:"ic_token_ibzrx.svg",erc20:!0,symbol:"iBZRX",decimals:18},"0x7F3Fe9D492A9a60aEBb06d82cBa23c6F32CAd10b":{name:"Fulcrum YFI iToken (iYFI)",logo:"ic_token_iyfi.svg",erc20:!0,symbol:"iYFI",decimals:18},"0x0a625FceC657053Fe2D9FFFdeb1DBb4e412Cf8A8":{name:"Fulcrum UNI iToken (iUNI)",logo:"ic_token_iuni.svg",erc20:!0,symbol:"iUNI",decimals:18},"0x0cae8d91E0b1b7Bd00D906E990C3625b2c220db1":{name:"Fulcrum AAVE iToken (iAAVE)",logo:"ic_token_iaave.svg",erc20:!0,symbol:"iAAVE",decimals:18},"0x3dA0e01472Dee3746b4D324a65D7EdFaECa9Aa4f":{name:"Fulcrum LRC iToken (iLRC)",logo:"ic_token_ilrc.svg",erc20:!0,symbol:"iLRC",decimals:18},"0x6d29903BC2c4318b59B35d97Ab98ab9eC08Ed70D":{name:"Fulcrum COMP iToken (iCOMP)",logo:"ic_token_icomp.svg",erc20:!0,symbol:"iCOMP",decimals:18},"0x08c32b0726C5684024ea6e141C50aDe9690bBdcc":{name:"Stratos Token",logo:"stos.svg",erc20:!0,symbol:"STOS",decimals:18},"0xe28b3B32B6c345A34Ff64674606124Dd5Aceca30":{name:"Injective",logo:"inj.svg",erc20:!0,symbol:"INJ",decimals:18},"0xe516D78d784C77D479977BE58905B3f2b1111126":{name:"Bitspawn",logo:"spwn.svg",erc20:!0,symbol:"SPWN",decimals:18},"0xB16e967ff83DE3F1e9FCeAfbc2C28c1c5c56eF91":{name:"Polkadog",logo:"polkadog.svg",erc20:!0,symbol:"PDOG",decimals:18},"0x07c52c2537D84e532a9F15d32E152C8B94D2b232":{name:"ZkTube",logo:"ZKT.svg",erc20:!0,symbol:"ZKT",decimals:18},"0xF4d861575ecC9493420A3f5a14F85B13f0b50EB3":{name:"Fractal Protocol",logo:"fractal.svg",erc20:!0,symbol:"FCL",decimals:18},"0x3af33bEF05C2dCb3C7288b77fe1C8d2AeBA4d789":{name:"Kromatika",logo:"krom.svg",erc20:!0,symbol:"KROM",decimals:18},"0xA130E3a33a4d84b04c3918c4E5762223Ae252F80":{name:"Swash Token",logo:"swash.svg",erc20:!0,symbol:"SWASH",decimals:18},"0xea7Cc765eBC94C4805e3BFf28D7E4aE48D06468A":{name:"NearPad Token",logo:"nearpad.svg",erc20:!0,symbol:"PAD",decimals:18},"0x87C22615435998D69ACA34889D03155B694a94fc":{name:"DiemLibre",logo:"DLB.svg",erc20:!0,symbol:"DLB",decimals:18},"0x4d224452801ACEd8B2F0aebE155379bb5D594381":{name:"ApeCoin",logo:"APE.svg",erc20:!0,symbol:"APE",decimals:18},"0xCd1fAFf6e578Fa5cAC469d2418C95671bA1a62Fe":{name:"Torum Token",logo:"torum.svg",erc20:!0,symbol:"XTM",decimals:18},"0xcf0C122c6b73ff809C693DB761e7BaeBe62b6a2E":{name:"FLOKI",logo:"floki.svg",erc20:!0,symbol:"FLOKI",decimals:9},"0xe831F96A7a1DcE1aa2EB760b1e296c6A74CaA9d5":{name:"Nexum Coin",logo:"nexum.svg",erc20:!0,symbol:"Nexm",decimals:8},"0x6710c63432A2De02954fc0f851db07146a6c0312":{name:"MFG",logo:"mfg.svg",erc20:!0,symbol:"MFG",decimals:18},"0xae78736Cd615f374D3085123A210448E74Fc6393":{name:"Rocket Pool ETH",logo:"rETH.svg",erc20:!0,symbol:"rETH",decimals:18},"0x0C10bF8FcB7Bf5412187A595ab97a3609160b5c6":{name:"Decentralized USD",logo:"USDD.svg",erc20:!0,symbol:"USDD",decimals:18},"0xD33526068D116cE69F19A9ee46F0bd304F21A51f":{name:"Rocket Pool",logo:"rpl.svg",erc20:!0,symbol:"RPL",decimals:18},"0x9d38F670D15C14716BE1F109a4F453E966A2B6D4":{name:"Quid Ika",logo:"QuidIka.svg",erc20:!0,symbol:"QUID",decimals:9},"0xD3c625F54dec647DB8780dBBe0E880eF21BA4329":{name:"HollaEx Token",logo:"xht.svg",erc20:!0,symbol:"XHT",decimals:18},"0x01e0E2e61f554eCAaeC0cC933E739Ad90f24a86d":{name:"GTON",logo:"gton.svg",erc20:!0,symbol:"GTON",decimals:18},"0xeFF66B4A84C8a6b69b99EB1C5e39aF8fc35d13db":{name:"sGTON",logo:"sgton.svg",erc20:!0,symbol:"sGTON",decimals:18},"0x7659CE147D0e714454073a5dd7003544234b6Aa0":{name:"XCAD Token",logo:"xcad.svg",erc20:!0,symbol:"XCAD",decimals:18},"0x88dF592F8eb5D7Bd38bFeF7dEb0fBc02cf3778a0":{name:"Tellor Tributes",logo:"TRB.svg",erc20:!0,symbol:"TRB",decimals:18},"0x8d96B4ab6C741a4C8679AE323a100d74f085BA8F":{name:"Bazaars",logo:"BZR.svg",erc20:!0,symbol:"BZR",decimals:18},"0x9ee91F9f426fA633d227f7a9b000E28b9dfd8599":{name:"Liquid staked MATIC",logo:"stMATIC.svg",erc20:!0,symbol:"stMATIC",decimals:18},"0x0d02755a5700414B26FF040e1dE35D337DF56218":{name:"Bend Token",logo:"BendDAO.svg",erc20:!0,symbol:"BEND",decimals:18},"0x1A4b46696b2bB4794Eb3D4c26f1c55F9170fa4C5":{name:"BitDAO",logo:"BitDAO.svg",erc20:!0,erc721:!1,symbol:"BIT",decimals:18},"0xb8919522331C59f5C16bDfAA6A121a6E03A91F62":{name:"Home",logo:"home.svg",erc20:!0,erc721:!1,symbol:"HOME",decimals:6},"0xa54d2EBfD977ad836203c85F18db2F0a0cF88854":{name:"Bacon",logo:"bacon.svg",erc20:!0,erc721:!1,symbol:"BACON",decimals:18},"0x249cA82617eC3DfB2589c4c17ab7EC9765350a18":{name:"Verse",logo:"VERSE.svg",erc20:!0,erc721:!1,symbol:"VERSE",decimals:18},"0x317eb4ad9cfaC6232f0046831322E895507bcBeb":{name:"Tidex Token",logo:"tidex.svg",erc20:!0,symbol:"TDX",decimals:18},"0x95aD61b0a150d79219dCF64E1E6Cc01f0B64C4cE":{name:"SHIBA INU",logo:"shib.svg",erc20:!0,symbol:"SHIB",decimals:18},"0x3506424F91fD33084466F402d5D97f05F8e3b4AF":{name:"chiliZ",logo:"chz.svg",erc20:!0,symbol:"CHZ",decimals:18},"0x15D4c048F83bd7e37d49eA4C83a07267Ec4203dA":{name:"Gala",logo:"gala.svg",erc20:!0,symbol:"GALA",decimals:8},"0x69af81e73A73B40adF4f3d4223Cd9b1ECE623074":{name:"Mask Network",logo:"mask.svg",erc20:!0,symbol:"MASK",decimals:18},"0xD533a949740bb3306d119CC777fa900bA034cd52":{name:"Curve DAO Token",logo:"crv.svg",erc20:!0,symbol:"CRV",decimals:18},"0x92D6C1e31e14520e676a687F0a93788B716BEff5":{name:"dYdX",logo:"dydx.svg",erc20:!0,symbol:"DYDX",decimals:18},"0x60bE1e1fE41c1370ADaF5d8e66f07Cf1C2Df2268":{name:"Perion Credits",logo:"perc.svg",erc20:!0,symbol:"PERC",decimals:18},"0x8971f9fd7196e5cEE2C1032B50F656855af7Dd26":{name:"Lambda",logo:"LAMB.svg",erc20:!0,symbol:"LAMB",decimals:18},"0x65514b352d1d4a17DE97f95C7faB177C625Bd6ff":{name:"KIBBLE Token",logo:"kibble.svg",erc20:!0,erc721:!1,symbol:"KBLE",decimals:18},"0xd9Fcd98c322942075A5C3860693e9f4f03AAE07b":{name:"Euler",logo:"eul.svg",erc20:!0,erc721:!1,symbol:"EUL",decimals:18},"0x777fD20c983d6658c1D50b3958B3A1733d1cd1E1":{name:"PUBLISH",logo:"publish.svg",erc20:!0,symbol:"NEWS",decimals:9},"0x19062190B1925b5b6689D7073fDfC8c2976EF8Cb":{name:"Swarm",logo:"ethswarm.svg",erc20:!0,symbol:"BZZ",decimals:16},"0x6aA030a9710CAD6E719A4EC0a85260Eb3F4F86c1":{name:"Real World Asset",logo:"rwa.svg",erc20:!0,symbol:"RWA",decimals:18},"0xde16Ce60804a881e9F8c4eBB3824646EDecd478D":{name:"MagicCraft",logo:"magiccraft.svg",erc20:!0,symbol:"MCRT",decimals:9},"0x7163436b8EfFfB469F6BB81cc908b1661d4795e6":{name:"Esco coin",logo:"escocoin.svg",erc20:!0,symbol:"ESCO",decimals:18},"0x9625cE7753ace1fa1865A47aAe2c5C2Ce4418569":{name:"KAP Games",logo:"kap-games.svg",erc20:!0,symbol:"KAP",decimals:18},"0x4FbB350052Bca5417566f188eB2EBCE5b19BC964":{name:"Rigo",logo:"grg.svg",erc20:!0,symbol:"GRG",decimals:18},"0xD8E163967FED76806Df0097B704bA721B9b37656":{name:"Cope",logo:"cope.svg",erc20:!0,symbol:"COPE",decimals:18},"0xdfbc9050F5B01DF53512DCC39B4f2B2BBaCD517A":{name:"Jobchain",logo:"job.svg",erc20:!0,symbol:"JOB",decimals:8},"0x083D41d6DD21EE938f0c055CA4fb12268DF0EfaC":{name:"GogolCoin",logo:"gol.svg",erc20:!0,symbol:"GOL",decimals:4},"0x9B4a69dE6CA0deFDD02c0c4ce6Cb84de5202944E":{name:"PROOF Platform",erc20:!0,symbol:"PROOF",decimals:9,logo:"proof-platform.svg"},"0x4507cEf57C46789eF8d1a19EA45f4216bae2B528":{name:"TokenFi",logo:"tokenfi.svg",erc20:!0,symbol:"TOKEN",decimals:9},"0x8B39B70E39Aa811b69365398e0aACe9bee238AEb":{name:"PolkaFoundry",logo:"pkf.svg",erc20:!0,symbol:"PKF",decimals:18},"0x2c95D751DA37A5C1d9c5a7Fd465c1d50F3d96160":{name:"WASSIE",logo:"wassie.svg",erc20:!0,symbol:"WASSIE",decimals:18},"0x06325440D014e39736583c165C2963BA99fAf14E":{name:"Curve.fi",logo:"steCRV.png",erc20:!0,symbol:"steCRV",decimals:18},"0x4E241A9EC66832a16bceaeB9156E524487f061D7":{name:"ETF Rocks",logo:"etf.svg",erc20:!0,symbol:"ETF",decimals:18},"0xA849EaaE994fb86Afa73382e9Bd88c2B6b18Dc71":{name:"Mass Vehicle Ledger",logo:"mvl.svg",erc20:!0,symbol:"MVL",decimals:18},"0xd5F7838F5C461fefF7FE49ea5ebaF7728bB0ADfa":{name:"Mantle Staked Ether",logo:"mETH.svg",erc20:!0,erc721:!1,symbol:"mETH",decimals:18}}}}},{package:"@metamask/contract-metadata",file:"node_modules/@metamask/contract-metadata/contract-map.json"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/contract-metadata/index.js",{"./contract-map.json":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/contract-metadata/contract-map.json"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){t.exports=e("./contract-map.json")}}},{package:"@metamask/contract-metadata",file:"node_modules/@metamask/contract-metadata/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/constants.cjs",{"./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/types.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP=s.ApprovalType=s.ORIGIN_METAMASK=s.NFT_API_TIMEOUT=s.NFT_API_VERSION=s.NFT_API_BASE_URL=s.OPENSEA_PROXY_URL=s.BUILT_IN_NETWORKS=s.BUILT_IN_CUSTOM_NETWORKS_RPC=s.TESTNET_TICKER_SYMBOLS=s.ASSET_TYPES=s.GWEI=s.ERC1155_TOKEN_RECEIVER_INTERFACE_ID=s.ERC1155_METADATA_URI_INTERFACE_ID=s.ERC1155_INTERFACE_ID=s.ERC721_ENUMERABLE_INTERFACE_ID=s.ERC721_METADATA_INTERFACE_ID=s.ERC721_INTERFACE_ID=s.ERC20=s.ERC1155=s.ERC721=s.MAX_SAFE_CHAIN_ID=s.GANACHE_CHAIN_ID=s.IPFS_DEFAULT_GATEWAY_URL=s.FALL_BACK_VS_CURRENCY=s.RPC=void 0;const r=e("./types.cjs");var n;s.RPC="rpc",s.FALL_BACK_VS_CURRENCY="ETH",s.IPFS_DEFAULT_GATEWAY_URL="https://cloudflare-ipfs.com/ipfs/",s.GANACHE_CHAIN_ID="0x539",s.MAX_SAFE_CHAIN_ID=0xfffffffffffec,s.ERC721="ERC721",s.ERC1155="ERC1155",s.ERC20="ERC20",s.ERC721_INTERFACE_ID="0x80ac58cd",s.ERC721_METADATA_INTERFACE_ID="0x5b5e139f",s.ERC721_ENUMERABLE_INTERFACE_ID="0x780e9d63",s.ERC1155_INTERFACE_ID="0xd9b67a26",s.ERC1155_METADATA_URI_INTERFACE_ID="0x0e89341c",s.ERC1155_TOKEN_RECEIVER_INTERFACE_ID="0x4e2312e0",s.GWEI="gwei",s.ASSET_TYPES={NATIVE:"NATIVE",TOKEN:"TOKEN",NFT:"NFT",UNKNOWN:"UNKNOWN"},s.TESTNET_TICKER_SYMBOLS={GOERLI:"GoerliETH",SEPOLIA:"SepoliaETH",LINEA_GOERLI:"LineaETH",LINEA_SEPOLIA:"LineaETH",MEGAETH_TESTNET:"MegaETH"},s.BUILT_IN_CUSTOM_NETWORKS_RPC={MEGAETH_TESTNET:"https://carrot.megaeth.com/rpc","megaeth-testnet":"https://carrot.megaeth.com/rpc","monad-testnet":"https://testnet-rpc.monad.xyz"},s.BUILT_IN_NETWORKS={[r.NetworkType.goerli]:{chainId:r.ChainId.goerli,ticker:r.NetworksTicker.goerli,rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl.goerli}},[r.NetworkType.sepolia]:{chainId:r.ChainId.sepolia,ticker:r.NetworksTicker.sepolia,rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl.sepolia}},[r.NetworkType.mainnet]:{chainId:r.ChainId.mainnet,ticker:r.NetworksTicker.mainnet,rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl.mainnet}},[r.NetworkType["linea-goerli"]]:{chainId:r.ChainId["linea-goerli"],ticker:r.NetworksTicker["linea-goerli"],rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl["linea-goerli"]}},[r.NetworkType["linea-sepolia"]]:{chainId:r.ChainId["linea-sepolia"],ticker:r.NetworksTicker["linea-sepolia"],rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl["linea-sepolia"]}},[r.NetworkType["linea-mainnet"]]:{chainId:r.ChainId["linea-mainnet"],ticker:r.NetworksTicker["linea-mainnet"],rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl["linea-mainnet"]}},[r.NetworkType["megaeth-testnet"]]:{chainId:r.ChainId["megaeth-testnet"],ticker:r.NetworksTicker["megaeth-testnet"],rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl["megaeth-testnet"]}},[r.NetworkType["monad-testnet"]]:{chainId:r.ChainId["monad-testnet"],ticker:r.NetworksTicker["monad-testnet"],rpcPrefs:{blockExplorerUrl:r.BlockExplorerUrl["monad-testnet"]}},[r.NetworkType.rpc]:{chainId:undefined,blockExplorerUrl:undefined,ticker:undefined,rpcPrefs:undefined}},s.OPENSEA_PROXY_URL="https://proxy.api.cx.metamask.io/opensea/v1/api/v2",s.NFT_API_BASE_URL="https://nft.api.cx.metamask.io",s.NFT_API_VERSION="1",s.NFT_API_TIMEOUT=15e3,s.ORIGIN_METAMASK="metamask",function(e){e.AddEthereumChain="wallet_addEthereumChain",e.ConnectAccounts="connect_accounts",e.EthDecrypt="eth_decrypt",e.EthGetEncryptionPublicKey="eth_getEncryptionPublicKey",e.EthSignTypedData="eth_signTypedData",e.PersonalSign="personal_sign",e.ResultError="result_error",e.ResultSuccess="result_success",e.SnapDialogAlert="snap_dialog:alert",e.SnapDialogConfirmation="snap_dialog:confirmation",e.SnapDialogPrompt="snap_dialog:prompt",e.SnapDialogDefault="snap_dialog",e.SwitchEthereumChain="wallet_switchEthereumChain",e.Transaction="transaction",e.Unlock="unlock",e.WalletConnect="wallet_connect",e.WalletRequestPermissions="wallet_requestPermissions",e.WatchAsset="wallet_watchAsset"}(n||(s.ApprovalType=n={})),s.CHAIN_ID_TO_ETHERS_NETWORK_NAME_MAP={[r.ChainId.goerli]:r.BuiltInNetworkName.Goerli,[r.ChainId.sepolia]:r.BuiltInNetworkName.Sepolia,[r.ChainId.mainnet]:r.BuiltInNetworkName.Mainnet,[r.ChainId["linea-goerli"]]:r.BuiltInNetworkName.LineaGoerli,[r.ChainId["linea-sepolia"]]:r.BuiltInNetworkName.LineaSepolia,[r.ChainId["linea-mainnet"]]:r.BuiltInNetworkName.LineaMainnet,[r.ChainId.aurora]:r.BuiltInNetworkName.Aurora}}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/constants.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/create-service-policy.cjs",{cockatiel:"/home/runner/work/metamask-extension/metamask-extension/node_modules/cockatiel/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createServicePolicy=s.DEFAULT_DEGRADED_THRESHOLD=s.DEFAULT_CIRCUIT_BREAK_DURATION=s.DEFAULT_MAX_CONSECUTIVE_FAILURES=s.DEFAULT_MAX_RETRIES=s.handleWhen=s.handleAll=s.ExponentialBackoff=s.ConstantBackoff=s.CircuitState=s.BrokenCircuitError=void 0;const r=e("cockatiel");Object.defineProperty(s,"BrokenCircuitError",{enumerable:!0,get:function(){return r.BrokenCircuitError}}),Object.defineProperty(s,"CircuitState",{enumerable:!0,get:function(){return r.CircuitState}}),Object.defineProperty(s,"ExponentialBackoff",{enumerable:!0,get:function(){return r.ExponentialBackoff}}),Object.defineProperty(s,"ConstantBackoff",{enumerable:!0,get:function(){return r.ConstantBackoff}}),Object.defineProperty(s,"handleAll",{enumerable:!0,get:function(){return r.handleAll}}),Object.defineProperty(s,"handleWhen",{enumerable:!0,get:function(){return r.handleWhen}}),s.DEFAULT_MAX_RETRIES=3,s.DEFAULT_MAX_CONSECUTIVE_FAILURES=3*(1+s.DEFAULT_MAX_RETRIES),s.DEFAULT_CIRCUIT_BREAK_DURATION=18e5,s.DEFAULT_DEGRADED_THRESHOLD=5e3;const n=e=>"object"!=typeof e||null===e||!("httpStatus"in e)||"number"!=typeof e.httpStatus||e.httpStatus>=500;s.createServicePolicy=function(e={}){const{maxRetries:t=s.DEFAULT_MAX_RETRIES,retryFilterPolicy:a=r.handleAll,maxConsecutiveFailures:o=s.DEFAULT_MAX_CONSECUTIVE_FAILURES,circuitBreakDuration:i=s.DEFAULT_CIRCUIT_BREAK_DURATION,degradedThreshold:m=s.DEFAULT_DEGRADED_THRESHOLD,backoff:c=new r.ExponentialBackoff}=e,d=(0,r.retry)(a,{maxAttempts:t,backoff:c}),u=d.onRetry.bind(d),l=(0,r.circuitBreaker)((0,r.handleWhen)(n),{halfOpenAfter:i,breaker:new r.ConsecutiveBreaker(o)}),f=l.onBreak.bind(l),h=new r.EventEmitter;d.onGiveUp((()=>{l.state===r.CircuitState.Closed&&h.emit()})),d.onSuccess((({duration:e})=>{l.state===r.CircuitState.Closed&&e>m&&h.emit()}));const p=h.addListener;return{...(0,r.wrap)(d,l),circuitBreakerPolicy:l,retryPolicy:d,onBreak:f,onDegraded:p,onRetry:u}}}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/create-service-policy.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/constants.cjs","./create-service-policy.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/create-service-policy.cjs","./siwe.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/siwe.cjs","./types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/types.cjs","./util.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/util.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),s.isEqualCaseInsensitive=s.weiHexToGweiDec=s.toHex=s.toChecksumHexAddress=s.timeoutFetch=s.successfulFetch=s.safelyExecuteWithTimeout=s.safelyExecute=s.query=s.normalizeEnsName=s.isValidHexAddress=s.isValidJson=s.isSmartContractCode=s.isSafeDynamicKey=s.isSafeChainId=s.isPlainObject=s.isNonEmptyArray=s.HttpError=s.hexToText=s.hexToBN=s.handleFetch=s.gweiDecToWEIBN=s.getBuyURL=s.fromHex=s.fractionBN=s.fetchWithErrorHandling=s.convertHexToDecimal=s.BNToHex=s.handleWhen=s.handleAll=s.createServicePolicy=s.ExponentialBackoff=s.DEFAULT_MAX_RETRIES=s.DEFAULT_MAX_CONSECUTIVE_FAILURES=s.DEFAULT_DEGRADED_THRESHOLD=s.DEFAULT_CIRCUIT_BREAK_DURATION=s.ConstantBackoff=s.CircuitState=s.BrokenCircuitError=void 0;var a=e("./create-service-policy.cjs");Object.defineProperty(s,"BrokenCircuitError",{enumerable:!0,get:function(){return a.BrokenCircuitError}}),Object.defineProperty(s,"CircuitState",{enumerable:!0,get:function(){return a.CircuitState}}),Object.defineProperty(s,"ConstantBackoff",{enumerable:!0,get:function(){return a.ConstantBackoff}}),Object.defineProperty(s,"DEFAULT_CIRCUIT_BREAK_DURATION",{enumerable:!0,get:function(){return a.DEFAULT_CIRCUIT_BREAK_DURATION}}),Object.defineProperty(s,"DEFAULT_DEGRADED_THRESHOLD",{enumerable:!0,get:function(){return a.DEFAULT_DEGRADED_THRESHOLD}}),Object.defineProperty(s,"DEFAULT_MAX_CONSECUTIVE_FAILURES",{enumerable:!0,get:function(){return a.DEFAULT_MAX_CONSECUTIVE_FAILURES}}),Object.defineProperty(s,"DEFAULT_MAX_RETRIES",{enumerable:!0,get:function(){return a.DEFAULT_MAX_RETRIES}}),Object.defineProperty(s,"ExponentialBackoff",{enumerable:!0,get:function(){return a.ExponentialBackoff}}),Object.defineProperty(s,"createServicePolicy",{enumerable:!0,get:function(){return a.createServicePolicy}}),Object.defineProperty(s,"handleAll",{enumerable:!0,get:function(){return a.handleAll}}),Object.defineProperty(s,"handleWhen",{enumerable:!0,get:function(){return a.handleWhen}}),n(e("./constants.cjs"),s);var o=e("./util.cjs");Object.defineProperty(s,"BNToHex",{enumerable:!0,get:function(){return o.BNToHex}}),Object.defineProperty(s,"convertHexToDecimal",{enumerable:!0,get:function(){return o.convertHexToDecimal}}),Object.defineProperty(s,"fetchWithErrorHandling",{enumerable:!0,get:function(){return o.fetchWithErrorHandling}}),Object.defineProperty(s,"fractionBN",{enumerable:!0,get:function(){return o.fractionBN}}),Object.defineProperty(s,"fromHex",{enumerable:!0,get:function(){return o.fromHex}}),Object.defineProperty(s,"getBuyURL",{enumerable:!0,get:function(){return o.getBuyURL}}),Object.defineProperty(s,"gweiDecToWEIBN",{enumerable:!0,get:function(){return o.gweiDecToWEIBN}}),Object.defineProperty(s,"handleFetch",{enumerable:!0,get:function(){return o.handleFetch}}),Object.defineProperty(s,"hexToBN",{enumerable:!0,get:function(){return o.hexToBN}}),Object.defineProperty(s,"hexToText",{enumerable:!0,get:function(){return o.hexToText}}),Object.defineProperty(s,"HttpError",{enumerable:!0,get:function(){return o.HttpError}}),Object.defineProperty(s,"isNonEmptyArray",{enumerable:!0,get:function(){return o.isNonEmptyArray}}),Object.defineProperty(s,"isPlainObject",{enumerable:!0,get:function(){return o.isPlainObject}}),Object.defineProperty(s,"isSafeChainId",{enumerable:!0,get:function(){return o.isSafeChainId}}),Object.defineProperty(s,"isSafeDynamicKey",{enumerable:!0,get:function(){return o.isSafeDynamicKey}}),Object.defineProperty(s,"isSmartContractCode",{enumerable:!0,get:function(){return o.isSmartContractCode}}),Object.defineProperty(s,"isValidJson",{enumerable:!0,get:function(){return o.isValidJson}}),Object.defineProperty(s,"isValidHexAddress",{enumerable:!0,get:function(){return o.isValidHexAddress}}),Object.defineProperty(s,"normalizeEnsName",{enumerable:!0,get:function(){return o.normalizeEnsName}}),Object.defineProperty(s,"query",{enumerable:!0,get:function(){return o.query}}),Object.defineProperty(s,"safelyExecute",{enumerable:!0,get:function(){return o.safelyExecute}}),Object.defineProperty(s,"safelyExecuteWithTimeout",{enumerable:!0,get:function(){return o.safelyExecuteWithTimeout}}),Object.defineProperty(s,"successfulFetch",{enumerable:!0,get:function(){return o.successfulFetch}}),Object.defineProperty(s,"timeoutFetch",{enumerable:!0,get:function(){return o.timeoutFetch}}),Object.defineProperty(s,"toChecksumHexAddress",{enumerable:!0,get:function(){return o.toChecksumHexAddress}}),Object.defineProperty(s,"toHex",{enumerable:!0,get:function(){return o.toHex}}),Object.defineProperty(s,"weiHexToGweiDec",{enumerable:!0,get:function(){return o.weiHexToGweiDec}}),Object.defineProperty(s,"isEqualCaseInsensitive",{enumerable:!0,get:function(){return o.isEqualCaseInsensitive}}),n(e("./types.cjs"),s),n(e("./siwe.cjs"),s)}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/logger.cjs",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createModuleLogger=s.projectLogger=void 0;const r=e("@metamask/utils");Object.defineProperty(s,"createModuleLogger",{enumerable:!0,get:function(){return r.createModuleLogger}}),s.projectLogger=(0,r.createProjectLogger)("controller-utils")}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/logger.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/siwe.cjs",{"./logger.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/logger.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","@spruceid/siwe-parser":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@spruceid/siwe-parser/dist/parsers.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.detectSIWE=s.isValidSIWEOrigin=s.parseDomainParts=void 0;const r=e("@metamask/utils"),n=e("@spruceid/siwe-parser"),a=e("./logger.cjs"),o=(0,a.createModuleLogger)(a.projectLogger,"detect-siwe");function i(e){try{const n="string"!=typeof(s=e)?s:(0,r.remove0x)(s),a=t.from(n,"hex");return 32===a.length?e:a.toString("utf8")}catch(t){return o(t),e}var s}const m={"http:":"80","https:":"443"};s.parseDomainParts=(e,t)=>e.match(/^[^/:]*:\/\//u)?new URL(e):new URL(`${t}//${e}`);s.isValidSIWEOrigin=e=>{try{const{origin:t,siwe:r}=e;if(!t||!r?.parsedMessage?.domain)return!1;const n=new URL(t),a=(0,s.parseDomainParts)(r.parsedMessage.domain,n.protocol);return 0===a.hostname.localeCompare(n.hostname,undefined,{sensitivity:"accent"})&&(""!==a.port&&a.port!==n.port?""===n.port&&a.port===m[n.protocol]:""===a.username||a.username===n.username)}catch(e){return o(e),!1}};s.detectSIWE=e=>{try{const{data:t}=e,s=i(t);return{isSIWEMessage:!0,parsedMessage:new n.ParsedMessage(s)}}catch(e){return{isSIWEMessage:!1,parsedMessage:null}}}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/siwe.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/types.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,n;Object.defineProperty(s,"__esModule",{value:!0}),s.NetworkNickname=s.BlockExplorerUrl=s.NetworksTicker=s.ChainId=s.BuiltInNetworkName=s.isInfuraNetworkType=s.isNetworkType=s.NetworkType=s.CustomNetworkType=s.InfuraNetworkType=void 0,s.InfuraNetworkType={mainnet:"mainnet",goerli:"goerli",sepolia:"sepolia","linea-goerli":"linea-goerli","linea-sepolia":"linea-sepolia","linea-mainnet":"linea-mainnet"},s.CustomNetworkType={"megaeth-testnet":"megaeth-testnet","monad-testnet":"monad-testnet"},s.NetworkType={...s.InfuraNetworkType,...s.CustomNetworkType,rpc:"rpc"},s.isNetworkType=function(e){return Object.values(s.NetworkType).includes(e)},s.isInfuraNetworkType=function(e){return Object.keys(s.InfuraNetworkType).includes(e)},function(e){e.Mainnet="mainnet",e.Goerli="goerli",e.Sepolia="sepolia",e.LineaGoerli="linea-goerli",e.LineaSepolia="linea-sepolia",e.LineaMainnet="linea-mainnet",e.Aurora="aurora",e.MegaETHTestnet="megaeth-testnet",e.MonadTestnet="monad-testnet"}(r||(s.BuiltInNetworkName=r={})),s.ChainId={[r.Mainnet]:"0x1",[r.Goerli]:"0x5",[r.Sepolia]:"0xaa36a7",[r.Aurora]:"0x4e454152",[r.LineaGoerli]:"0xe704",[r.LineaSepolia]:"0xe705",[r.LineaMainnet]:"0xe708",[r.MegaETHTestnet]:"0x18c6",[r.MonadTestnet]:"0x279f"},function(e){e.mainnet="ETH",e.goerli="GoerliETH",e.sepolia="SepoliaETH",e["linea-goerli"]="LineaETH",e["linea-sepolia"]="LineaETH",e["linea-mainnet"]="ETH",e["megaeth-testnet"]="MegaETH",e["monad-testnet"]="MON",e.rpc=""}(n||(s.NetworksTicker=n={})),s.BlockExplorerUrl={[r.Mainnet]:"https://etherscan.io",[r.Goerli]:"https://goerli.etherscan.io",[r.Sepolia]:"https://sepolia.etherscan.io",[r.LineaGoerli]:"https://goerli.lineascan.build",[r.LineaSepolia]:"https://sepolia.lineascan.build",[r.LineaMainnet]:"https://lineascan.build",[r.MegaETHTestnet]:"https://megaexplorer.xyz",[r.MonadTestnet]:"https://testnet.monadexplorer.com"},s.NetworkNickname={[r.Mainnet]:"Ethereum Mainnet",[r.Goerli]:"Goerli",[r.Sepolia]:"Sepolia",[r.LineaGoerli]:"Linea Goerli",[r.LineaSepolia]:"Linea Sepolia",[r.LineaMainnet]:"Linea",[r.MegaETHTestnet]:"Mega Testnet",[r.MonadTestnet]:"Monad Testnet"}}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/types.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/util.cjs",{"./constants.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/constants.cjs","@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethereumjs/util/dist/cjs/index.js","@metamask/ethjs-unit":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-unit/lib/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","bn.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/bn.js/lib/bn.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","eth-ens-namehash":"/home/runner/work/metamask-extension/metamask-extension/node_modules/eth-ens-namehash/index.js","fast-deep-equal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/fast-deep-equal/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.isEqualCaseInsensitive=s.isValidJson=s.isNonEmptyArray=s.isPlainObject=s.convertHexToDecimal=s.query=s.normalizeEnsName=s.timeoutFetch=s.fetchWithErrorHandling=s.handleFetch=s.successfulFetch=s.HttpError=s.isSmartContractCode=s.isValidHexAddress=s.toChecksumHexAddress=s.safelyExecuteWithTimeout=s.safelyExecute=s.toHex=s.fromHex=s.hexToText=s.hexToBN=s.getBuyURL=s.weiHexToGweiDec=s.gweiDecToWEIBN=s.fractionBN=s.BNToHex=s.isSafeChainId=s.isSafeDynamicKey=s.PROTOTYPE_POLLUTION_BLOCKLIST=void 0;const n=e("@ethereumjs/util"),a=e("@metamask/ethjs-unit"),o=e("@metamask/utils"),i=r(e("bn.js")),m=r(e("eth-ens-namehash")),c=r(e("fast-deep-equal")),d=e("./constants.cjs"),u=new Error("timeout");function l(e){return e?new i.default((0,o.remove0x)(e),16):new i.default(0)}s.PROTOTYPE_POLLUTION_BLOCKLIST=["__proto__","constructor","prototype"],s.isSafeDynamicKey=function(e){return"string"==typeof e&&!s.PROTOTYPE_POLLUTION_BLOCKLIST.some((t=>e===t))},s.isSafeChainId=function(e){if(!(0,o.isHexString)(e))return!1;const t=Number.parseInt(e,(0,o.isStrictHexString)(e)?16:10);return Number.isSafeInteger(t)&&t>0&&t<=d.MAX_SAFE_CHAIN_ID},s.BNToHex=function(e){return(0,o.add0x)(e.toString(16))},s.fractionBN=function(e,t,s){const r=new i.default(t),n=new i.default(s);return e.mul(r).div(n)},s.gweiDecToWEIBN=function(e){if(Number.isNaN(e))return new i.default(0);const t=e.toString().split("."),s=t[0]||"0";let r=t[1]||"";if(!r)return(0,a.toWei)(s,"gwei");if(r.length<=9)return(0,a.toWei)(`${s}.${r}`,"gwei");const n=r.slice(9)[0];r=r.slice(0,9);let o=(0,a.toWei)(`${s}.${r}`,"gwei");return Number(n)>=5&&(o=o.add(new i.default(1))),o},s.weiHexToGweiDec=function(e){const t=new i.default((0,o.remove0x)(e),16);return(0,a.fromWei)(t,"gwei")},s.getBuyURL=function(e="1",t,s=5){switch(e){case"1":return`https://buy.coinbase.com/?code=9ec56d01-7e81-5017-930c-513daa27bb6a&amount=${s}&address=${t}&crypto_currency=ETH`;case"5":return"https://goerli-faucet.slock.it/";case"11155111":return"https://sepoliafaucet.net/";default:return undefined}},s.hexToBN=l,s.hexToText=function(e){try{const s=(0,o.remove0x)(e);return t.from(s,"hex").toString("utf8")}catch(t){return e}},s.fromHex=function(e){return i.default.isBN(e)?e:new i.default(l(e).toString(10))},s.toHex=function(e){return"string"==typeof e&&(0,o.isStrictHexString)(e)?e:`0x${i.default.isBN(e)||"bigint"==typeof e?e.toString(16):new i.default(e.toString(),10).toString(16)}`},s.safelyExecute=async function(e,t=!1){try{return await e()}catch(e){return t&&console.error(e),undefined}},s.safelyExecuteWithTimeout=async function(e,t=!1,s=500){try{return await Promise.race([e(),new Promise(((e,t)=>setTimeout((()=>{t(u)}),s)))])}catch(e){return t&&console.error(e),undefined}},s.toChecksumHexAddress=function(e){if("string"!=typeof e)return e;const t=(0,o.add0x)(e);return(0,o.isHexString)(t)?(0,n.toChecksumAddress)(t):t},s.isValidHexAddress=function(e,{allowNonPrefixed:t=!0}={}){const s=t?(0,o.add0x)(e):e;return!!(0,o.isStrictHexString)(s)&&(0,n.isValidAddress)(s)},s.isSmartContractCode=function(e){return!!e&&("0x"!==e&&"0x0"!==e)};class f extends Error{constructor(e,t){super(t||`Fetch failed with status '${e}'`),this.httpStatus=e}}async function h(e,t){const s=await fetch(e,t);if(!s.ok)throw new f(s.status,`Fetch failed with status '${s.status}' for request '${String(e)}'`);return s}async function p(e,t){const s=await h(e,t);return await s.json()}s.HttpError=f,s.successfulFetch=h,s.handleFetch=p,s.fetchWithErrorHandling=async function({url:e,options:t,timeout:s,errorCodesToCatch:r}){let n;try{n=s?Promise.race([await p(e,t),new Promise(((e,t)=>setTimeout((()=>{t(u)}),s)))]):await p(e,t)}catch(e){!function(e,t=[]){if(!e)return;if(!(e instanceof Error))throw e;if(!t.some((t=>e.message.includes(`Fetch failed with status '${t}'`)))&&!e.message.includes("Failed to fetch")&&e!==u)throw e;console.error(e)}(e,r)}return n},s.timeoutFetch=async function(e,t,s=500){return Promise.race([h(e,t),new Promise(((e,t)=>setTimeout((()=>{t(u)}),s)))])},s.normalizeEnsName=function(e){if("."===e)return e;if(e&&"string"==typeof e)try{const t=m.default.normalize(e.trim());if(t.match(/^(([\w\d-]+)\.)*[\w\d-]{7,}\.(eth|test)$/u))return t}catch(e){}return null},s.query=function(e,t,s=[]){return new Promise(((r,n)=>{const a=(e,t)=>{e?n(e):r(t)};t in e&&"function"==typeof e[t]?e[t](...s,a):e.sendAsync({method:t,params:s},a)}))};s.convertHexToDecimal=(e="0x0")=>(0,o.isStrictHexString)(e)?parseInt(e,16):Number(e)?Number(e):0,s.isPlainObject=function(e){return Boolean(e)&&"object"==typeof e&&!Array.isArray(e)},s.isNonEmptyArray=function(e){return Array.isArray(e)&&e.length>0},s.isValidJson=function(e){try{return(0,c.default)(e,JSON.parse(JSON.stringify(e)))}catch(e){return!1}},s.isEqualCaseInsensitive=function(e,t){return"string"==typeof e&&"string"==typeof t&&e.toLowerCase()===t.toLowerCase()}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/controller-utils",file:"node_modules/@metamask/controller-utils/dist/util.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/delegation-deployments/dist/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});var r={DelegationManager:"0xdb9B1e94B5b69Df7e401DDbedE43491141047dB3",EntryPoint:"0x0000000071727De22E5E9d8BAf0edAc6f37da032",SimpleFactory:"0x69Aa2f9fe1572F1B640E1bbc512f5c3a734fc77c",MultiSigDeleGatorImpl:"0x56a9EdB16a0105eb5a4C54f4C062e2868844f3A7",HybridDeleGatorImpl:"0x48dBe696A4D990079e039489bA2053B36E8FFEC4",EIP7702StatelessDeleGatorImpl:"0x63c0c19a282a1B52b07dD5a65b58948A07DAE32B",AllowedCalldataEnforcer:"0xc2b0d624c1c4319760C96503BA27C347F3260f55",AllowedMethodsEnforcer:"0x2c21fD0Cb9DC8445CB3fb0DC5E7Bb0Aca01842B5",AllowedTargetsEnforcer:"0x7F20f61b1f09b08D970938F6fa563634d65c4EeB",BlockNumberEnforcer:"0x5d9818dF0AE3f66e9c3D0c5029DAF99d1823ca6c",DeployedEnforcer:"0x24ff2AA430D53a8CD6788018E902E098083dcCd2",ERC20BalanceChangeEnforcer:"0xcdF6aB796408598Cea671d79506d7D48E97a5437",ERC20TransferAmountEnforcer:"0xf100b0819427117EcF76Ed94B358B1A5b5C6D2Fc",ERC20PeriodTransferEnforcer:"0x474e3Ae7E169e940607cC624Da8A15Eb120139aB",ERC20StreamingEnforcer:"0x56c97aE02f233B29fa03502Ecc0457266d9be00e",ERC721BalanceChangeEnforcer:"0x8aFdf96eDBbe7e1eD3f5Cd89C7E084841e12A09e",ERC721TransferEnforcer:"0x3790e6B7233f779b09DA74C72b6e94813925b9aF",ERC1155BalanceChangeEnforcer:"0x63c322732695cAFbbD488Fc6937A0A7B66fC001A",ExactCalldataBatchEnforcer:"0x982FD5C86BBF425d7d1451f974192d4525113DfD",ExactCalldataEnforcer:"0x99F2e9bF15ce5eC84685604836F71aB835DBBdED",ExactExecutionBatchEnforcer:"0x1e141e455d08721Dd5BCDA1BaA6Ea5633Afd5017",ExactExecutionEnforcer:"0x146713078D39eCC1F5338309c28405ccf85Abfbb",IdEnforcer:"0xC8B5D93463c893401094cc70e66A206fb5987997",LimitedCallsEnforcer:"0x04658B29F6b82ed55274221a06Fc97D318E25416",NativeBalanceChangeEnforcer:"0xbD7B277507723490Cd50b12EaaFe87C616be6880",ArgsEqualityCheckEnforcer:"0x44B8C6ae3C304213c3e298495e12497Ed3E56E41",NativeTokenPaymentEnforcer:"0x4803a326ddED6dDBc60e659e5ed12d85c7582811",NativeTokenTransferAmountEnforcer:"0xF71af580b9c3078fbc2BBF16FbB8EEd82b330320",NativeTokenStreamingEnforcer:"0xD10b97905a320b13a0608f7E9cC506b56747df19",NativeTokenPeriodTransferEnforcer:"0x9BC0FAf4Aca5AE429F4c06aEEaC517520CB16BD9",NonceEnforcer:"0xDE4f2FAC4B3D87A1d9953Ca5FC09FCa7F366254f",OwnershipTransferEnforcer:"0x7EEf9734E7092032B5C56310Eb9BbD1f4A524681",RedeemerEnforcer:"0xE144b0b2618071B4E56f746313528a669c7E65c5",SpecificActionERC20TransferBatchEnforcer:"0x00e0251aaA263dfE3B3541B758A82D1CBA1c3B6D",TimestampEnforcer:"0x1046bb45C8d673d4ea75321280DB34899413c069",ValueLteEnforcer:"0x92Bf12322527cAA612fd31a0e810472BBB106A8F",MultiTokenPeriodEnforcer:"0xFB2f1a9BD76d3701B730E5d69C3219D42D80eBb7"},n={DelegationManager:"0x56D56e07e3d6Ee5a24e30203A37a0a460f42D7A3",EntryPoint:"0x0000000071727De22E5E9d8BAf0edAc6f37da032",SimpleFactory:"0x6ff518884f21168c30c58CB21184D6AdBC18Ad90",MultiSigDeleGatorImpl:"0xd1f421EDbA5e3FA9efe3874827114b20C5BEC40C",HybridDeleGatorImpl:"0x941f3a016F8726d5643Ce62452d0D78492D42b42",AllowedCalldataEnforcer:"0xff71d60f3208469cBCE0859717B5198042DCB3F3",AllowedMethodsEnforcer:"0xe32C2561792e8446Abe73B9f557B881C13906186",AllowedTargetsEnforcer:"0x06aaE4c67EEA95277c46Bf79b1583d4a01772D22",BlockNumberEnforcer:"0x8E470D2Ae278457b42d2405E0B8Cd4BE21Ed9045",DeployedEnforcer:"0xf9088f013dBD9ebb7Cebd66fEB48253c6Ac5a820",ERC20BalanceGteEnforcer:"0xB7B6f32ec6343261D814e55Ed8C5925d91Cab861",ERC20TransferAmountEnforcer:"0x9A069b18032B31429A363AeCFb1B6A0564b44471",IdEnforcer:"0x91015c3b9D9523966eD2399885e5Df7A567f916c",LimitedCallsEnforcer:"0xe694bFfffEA3E85923b1210b37e6a0175e910863",NonceEnforcer:"0xE83BCFD8bBE672A96747e831050a91cf44F4F87A",TimestampEnforcer:"0x550FdD13eEBC1f22ea2a2480024BacBF0Ad7e5CE",ValueLteEnforcer:"0xBE32a6DB7471F63BB168C088c57Db01AfAe87967",NativeTokenTransferAmountEnforcer:"0x5eD3833d7B957A8DB8A461c3AF2d668Ec25382E0",NativeBalanceGteEnforcer:"0x376a98860E210DdEda3689fb39565592c563cB0A",ArgsEqualityCheckEnforcer:"0x7378dE585998d3E18Ce147867C335C25B3dB8Ee5",NativeTokenPaymentEnforcer:"0x87Fe18EbF99e42fcE8A03a25F1d20E119407f8e7",RedeemerEnforcer:"0x926672b130D1EF60A9d6b11D2048d121b30f40C1"},a={DelegationManager:"0xbe4138886cb096bdc1b930f2f0ca7892aa234d78",EntryPoint:"0x0000000071727De22E5E9d8BAf0edAc6f37da032",SimpleFactory:"0x6ff518884f21168c30c58CB21184D6AdBC18Ad90",MultiSigDeleGatorImpl:"0x11f555af5844d85bfcf5d61d2a22866527eb585a",HybridDeleGatorImpl:"0xd6edd1256deccb2b06bdecef92dc16bcf26e531b",AllowedCalldataEnforcer:"0x48db3835a873d64a4af2c09f014052407c003bd7",AllowedMethodsEnforcer:"0xfd731951bf1c52afccee3e6f14ab656475b76dd4",AllowedTargetsEnforcer:"0xbc8673c0afa52d86d991c06881e55b2966920564",BlockNumberEnforcer:"0xc15faffa0d879b9263c15a46ce31eacfa2e0e8ae",DeployedEnforcer:"0x5accb9559b56a6c1e3f90e342c85c42d93720d43",ERC20BalanceGteEnforcer:"0xb5d6b1ec6d868a3bae5b7f48178eaa2686a7a087",ERC20TransferAmountEnforcer:"0x92ac423b9c111962179a6242e1adb58d02c103be",IdEnforcer:"0x34152d9f3f8f74338d50703e780389e829b4abac",LimitedCallsEnforcer:"0x4b3adad4a328bee8ba17b86074d92fe7372180cd",NonceEnforcer:"0x2f32ff3fc3086d7f63f16fe8d0065390d460b40d",TimestampEnforcer:"0x78e05f779490c24bf3bfa135b4112e7003b321cd",ValueLteEnforcer:"0xfc20ede0a1132e839fbda9d7ed3904ff3c89540f"},o={mainnet:1,polygon:137,bsc:56,optimism:10,arbitrum:42161,linea:59144,base:8453,gnosis:100,sepolia:11155111,lineaSepolia:59141,baseSepolia:84532,megaEthTestnet:6342,chiado:10200,lineaGoerli:59140},i={"1.0.0":{[o.optimism]:a,[o.polygon]:a,[o.base]:a,[o.arbitrum]:a,[o.linea]:a,[o.sepolia]:{...a,HybridDeleGatorImpl:"0x5989F5D13DF8fc818EdA65e417AED90459fD67F7"},[o.lineaSepolia]:{...a,HybridDeleGatorImpl:"0x5989F5D13DF8fc818EdA65e417AED90459fD67F7"}},"1.1.0":{[o.arbitrum]:n,[o.base]:n,[o.linea]:n,[o.optimism]:n,[o.polygon]:n,[o.sepolia]:n,[o.lineaSepolia]:n,[o.baseSepolia]:{...n,SimpleFactory:"0xE8eA1DE8D6AfE400B7C8C1A81B7C29B7876b4d02"}},"1.3.0":{[o.mainnet]:r,[o.polygon]:r,[o.bsc]:r,[o.optimism]:r,[o.arbitrum]:r,[o.linea]:r,[o.base]:r,[o.gnosis]:r,[o.sepolia]:r,[o.lineaSepolia]:r,[o.baseSepolia]:r,[o.megaEthTestnet]:r,[o.chiado]:r}};s.CHAIN_ID=o,s.DELEGATOR_CONTRACTS=i}}},{package:"@metamask/delegation-deployments",file:"node_modules/@metamask/delegation-deployments/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-block-tracker/dist/BlockTracker.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0})}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/BlockTracker.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-block-tracker/dist/PollingBlockTracker.js",{"./logging-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-block-tracker/dist/logging-utils.js","@metamask/safe-event-emitter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/safe-event-emitter/dist/cjs/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","json-rpc-random-id":"/home/runner/work/metamask-extension/metamask-extension/node_modules/json-rpc-random-id/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,n,a,o,i,m,c,d=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)},u=this&&this.__classPrivateFieldSet||function(e,t,s,r,n){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?n.call(e,s):n?n.value=s:t.set(e,s),s},l=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.PollingBlockTracker=void 0;const f=l(e("@metamask/safe-event-emitter")),h=e("@metamask/utils"),p=l(e("json-rpc-random-id")),g=e("./logging-utils"),k=(0,g.createModuleLogger)(g.projectLogger,"polling-block-tracker"),b=(0,p.default)(),y=["sync","latest"];class x extends f.default{constructor(e={}){if(!e.provider)throw new Error("PollingBlockTracker - no provider specified.");super(),r.add(this),n.set(this,[]),a.set(this,void 0),o.set(this,void 0),this._blockResetDuration=e.blockResetDuration||2e4,this._usePastBlocks=e.usePastBlocks||!1,this._currentBlock=null,this._isRunning=!1,this._onNewListener=this._onNewListener.bind(this),this._onRemoveListener=this._onRemoveListener.bind(this),this._resetCurrentBlock=this._resetCurrentBlock.bind(this),this._setupInternalEvents(),this._provider=e.provider,this._pollingInterval=e.pollingInterval||2e4,this._retryTimeout=e.retryTimeout||this._pollingInterval/10,this._keepEventLoopActive=e.keepEventLoopActive===undefined||e.keepEventLoopActive,this._setSkipCacheFlag=e.setSkipCacheFlag||!1}async destroy(){this._cancelBlockResetTimeout(),super.removeAllListeners(),this._maybeEnd()}isRunning(){return this._isRunning}getCurrentBlock(){return this._currentBlock}async getLatestBlock(){if(this._currentBlock)return this._currentBlock;if(d(this,a,"f"))return await d(this,a,"f").promise;const{promise:e,resolve:t,reject:s}=(0,h.createDeferredPromise)({suppressUnhandledRejection:!0});u(this,a,{reject:s,promise:e},"f");try{if(!this._isRunning){const e=await this._fetchLatestBlock();return this._newPotentialLatest(e),t(e),e}const s=e=>{d(this,r,"m",m).call(this,s),this.removeListener("latest",s),t(e)};return d(this,r,"m",i).call(this,s),this.once("latest",s),await e}catch(e){throw s(e),e}finally{u(this,a,undefined,"f")}}removeAllListeners(e){return e?super.removeAllListeners(e):super.removeAllListeners(),this._setupInternalEvents(),this._onRemoveListener(),this}_setupInternalEvents(){this.removeListener("newListener",this._onNewListener),this.removeListener("removeListener",this._onRemoveListener),this.on("newListener",this._onNewListener),this.on("removeListener",this._onRemoveListener)}_onNewListener(e){y.includes(e)&&this._maybeStart()}_onRemoveListener(){this._getBlockTrackerEventCount()>0||this._maybeEnd()}_maybeStart(){this._isRunning||(this._isRunning=!0,this._cancelBlockResetTimeout(),this._start(),this.emit("_started"))}_maybeEnd(){this._isRunning&&(this._isRunning=!1,this._setupBlockResetTimeout(),this._end(),d(this,r,"m",c).call(this,new Error("Block tracker destroyed")),this.emit("_ended"))}_getBlockTrackerEventCount(){return y.map((e=>this.listeners(e))).flat().filter((e=>d(this,n,"f").every((t=>!Object.is(t,e))))).length}_shouldUseNewBlock(e){const t=this._currentBlock;if(!t)return!0;const s=w(e),r=w(t);return this._usePastBlocks&&s<r||s>r}_newPotentialLatest(e){this._shouldUseNewBlock(e)&&this._setCurrentBlock(e)}_setCurrentBlock(e){const t=this._currentBlock;this._currentBlock=e,this.emit("latest",e),this.emit("sync",{oldBlock:t,newBlock:e})}_setupBlockResetTimeout(){this._cancelBlockResetTimeout(),this._blockResetTimeout=setTimeout(this._resetCurrentBlock,this._blockResetDuration),this._blockResetTimeout.unref&&this._blockResetTimeout.unref()}_cancelBlockResetTimeout(){this._blockResetTimeout&&clearTimeout(this._blockResetTimeout)}_resetCurrentBlock(){this._currentBlock=null}async checkForLatestBlock(){return await this._updateLatestBlock(),await this.getLatestBlock()}_start(){this._updateAndQueue()}_end(){this._clearPollingTimeout()}async _updateLatestBlock(){const e=await this._fetchLatestBlock();this._newPotentialLatest(e)}async _fetchLatestBlock(){if(d(this,o,"f"))return await d(this,o,"f").promise;const{promise:e,resolve:t,reject:s}=(0,h.createDeferredPromise)({suppressUnhandledRejection:!0});u(this,o,{reject:s,promise:e},"f");try{const e={jsonrpc:"2.0",id:b(),method:"eth_blockNumber",params:[]};this._setSkipCacheFlag&&(e.skipCache=!0),k("Making request",e);const s=await this._provider.request(e);return k("Got result",s),t(s),s}catch(e){throw k("Encountered error fetching block",(0,h.getErrorMessage)(e)),s(e),d(this,r,"m",c).call(this,e),e}finally{u(this,o,undefined,"f")}}async _updateAndQueue(){let e=this._pollingInterval;try{await this._updateLatestBlock()}catch(t){try{this.emit("error",t)}catch(e){console.error(`Error updating latest block: ${(0,h.getErrorMessage)(t)}`)}e=this._retryTimeout}if(!this._isRunning)return;this._clearPollingTimeout();const t=setTimeout((()=>{this._updateAndQueue()}),e);t.unref&&!this._keepEventLoopActive&&t.unref(),this._pollingTimeout=t,this.emit("_waitingForNextIteration")}_clearPollingTimeout(){this._pollingTimeout&&(clearTimeout(this._pollingTimeout),this._pollingTimeout=undefined)}}function w(e){return Number.parseInt(e,16)}s.PollingBlockTracker=x,n=new WeakMap,a=new WeakMap,o=new WeakMap,r=new WeakSet,i=function(e){d(this,n,"f").push(e)},m=function(e){d(this,n,"f").splice(d(this,n,"f").indexOf(e),1)},c=function(e){var t;null===(t=d(this,a,"f"))||void 0===t||t.reject(e),u(this,a,undefined,"f")}}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/PollingBlockTracker.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-block-tracker/dist/index.js",{"./BlockTracker":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-block-tracker/dist/BlockTracker.js","./PollingBlockTracker":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-block-tracker/dist/PollingBlockTracker.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./PollingBlockTracker"),s),n(e("./BlockTracker"),s)}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-block-tracker/dist/logging-utils.js",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createModuleLogger=s.projectLogger=void 0;const r=e("@metamask/utils");Object.defineProperty(s,"createModuleLogger",{enumerable:!0,get:function(){return r.createModuleLogger}}),s.projectLogger=(0,r.createProjectLogger)("eth-block-tracker")}}},{package:"@metamask/network-controller>@metamask/eth-block-tracker",file:"node_modules/@metamask/eth-block-tracker/dist/logging-utils.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/dist/hd-keyring.cjs",{"@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethereumjs/util/dist/cjs/index.js","@metamask/eth-sig-util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/index.js","@metamask/key-tree":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/key-tree/dist/index.cjs","@metamask/scure-bip39":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/scure-bip39/dist/index.js","@metamask/scure-bip39/dist/wordlists/english.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/scure-bip39/dist/wordlists/english.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/hdkey":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/hdkey.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){var r,n,a,o,i,m,c,d,u,l,f,h=this&&this.__classPrivateFieldSet||function(e,t,s,r,n){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?n.call(e,s):n?n.value=s:t.set(e,s),s},p=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)};Object.defineProperty(s,"__esModule",{value:!0}),s.HdKeyring=void 0;const g=e("@ethereumjs/util"),k=e("@metamask/eth-sig-util"),b=e("@metamask/key-tree"),y=e("@metamask/scure-bip39"),x=e("@metamask/scure-bip39/dist/wordlists/english.js"),w=e("@metamask/utils"),E=e("ethereum-cryptography/hdkey"),_=e("ethereum-cryptography/keccak"),v="m/44'/60'/0'/0",A="HD Key Tree";class T{constructor(e={}){r.add(this),this.type=A,this.hdPath=v,n.set(this,[]),a.set(this,void 0),h(this,a,e.cryptographicFunctions,"f")}async generateRandomMnemonic(){await p(this,r,"m",u).call(this,(0,y.generateMnemonic)(x.wordlist))}async serialize(){let e=[];if(this.mnemonic){const t=p(this,r,"m",o).call(this,this.mnemonic);e=Array.from((new TextEncoder).encode(t))}return{mnemonic:e,numberOfAccounts:p(this,n,"f").length,hdPath:this.hdPath}}async deserialize(e={}){if(e.numberOfAccounts&&!e.mnemonic)throw new Error("Eth-Hd-Keyring: Deserialize method cannot be called with an opts value for numberOfAccounts and no menmonic");if(this.root)throw new Error("Eth-Hd-Keyring: Secret recovery phrase already provided");return h(this,n,[],"f"),this.mnemonic=null,this.seed=null,this.root=null,this.hdPath=e.hdPath??v,e.mnemonic&&await p(this,r,"m",u).call(this,e.mnemonic),e.numberOfAccounts?this.addAccounts(e.numberOfAccounts):[]}async addAccounts(e=1){if(!this.root)throw new Error("Eth-Hd-Keyring: No secret recovery phrase provided");const t=p(this,n,"f").length,s=[];for(let r=t;r<e+t;r++){const e=this.root.deriveChild(r);s.push(e),p(this,n,"f").push(e)}const a=s.map((e=>((0,w.assert)(e.publicKey,"Expected public key to be set"),p(this,r,"m",l).call(this,e.publicKey))));return Promise.resolve(a)}getAccounts(){return p(this,n,"f").map((e=>((0,w.assert)(e.publicKey,"Expected public key to be set"),p(this,r,"m",l).call(this,e.publicKey))))}async getAppKeyAddress(e,t){if(!t||"string"!=typeof t)throw new Error("'origin' must be a non-empty string");const s=p(this,r,"m",d).call(this,e,{withAppKeyOrigin:t});(0,w.assert)(s.publicKey,"Expected public key to be set");return p(this,r,"m",f).call(this,(0,w.bytesToHex)((0,g.publicToAddress)(s.publicKey)))}async exportAccount(e,t){const s=t?p(this,r,"m",d).call(this,e,t):p(this,r,"m",d).call(this,e),{privateKey:n}=s;return(0,w.assert)(n instanceof Uint8Array,"Expected private key to be of type Uint8Array"),(0,w.remove0x)((0,w.bytesToHex)(n))}async signTransaction(e,s,n={}){const a=p(this,r,"m",c).call(this,e,n);return s.sign(t.from(a))??s}async signMessage(e,s,n={}){(0,w.assertIsHexString)(s);const a=(0,w.remove0x)(s),o=p(this,r,"m",c).call(this,e,n),i=(0,g.ecsign)(t.from(a,"hex"),t.from(o));return(0,k.concatSig)(t.from((0,w.bigIntToBytes)(i.v)),t.from(i.r),t.from(i.s))}async signPersonalMessage(e,s,n={}){const a=p(this,r,"m",c).call(this,e,n),o=t.from(a);return(0,k.personalSign)({privateKey:o,data:s})}async decryptMessage(e,s){const n=p(this,r,"m",d).call(this,e),{privateKey:a}=n;(0,w.assert)(a,"Expected private key to be set");const o=t.from(a).toString("hex");return(0,k.decrypt)({privateKey:o,encryptedData:s})}async signTypedData(e,s,n={version:k.SignTypedDataVersion.V1}){const a=Object.keys(k.SignTypedDataVersion).includes(n.version)?n.version:k.SignTypedDataVersion.V1,o=p(this,r,"m",c).call(this,e,n);return(0,k.signTypedData)({privateKey:t.from(o),data:s,version:a})}async signEip7702Authorization(e,s,n){const a=p(this,r,"m",c).call(this,e,n);return(0,k.signEIP7702Authorization)({privateKey:t.from(a),authorization:s})}removeAccount(e){const t=p(this,r,"m",f).call(this,e);if(!p(this,n,"f").map((({publicKey:e})=>e&&p(this,r,"m",l).call(this,e))).includes(t))throw new Error(`Address ${t} not found in this keyring`);h(this,n,p(this,n,"f").filter((({publicKey:e})=>e&&p(this,r,"m",l).call(this,e)!==t)),"f")}async getEncryptionPublicKey(e,t={}){const s=p(this,r,"m",c).call(this,e,t);return(0,k.getEncryptionPublicKey)((0,w.remove0x)((0,w.bytesToHex)(s)))}}s.HdKeyring=T,n=new WeakMap,a=new WeakMap,r=new WeakSet,o=function(e){return Array.from(new Uint16Array(new Uint8Array(e).buffer)).map((e=>x.wordlist[e])).join(" ")},i=function(e){const t=e.split(" ").map((e=>x.wordlist.indexOf(e)));return new Uint8Array(new Uint16Array(t).buffer)},m=function(e){let s=e;var n;if("object"==typeof(n=e)&&null!==n&&"type"in n&&"Buffer"===n.type&&"data"in n&&Array.isArray(n.data)&&(s=e.data),"string"==typeof s||t.isBuffer(s)||Array.isArray(s)){let e;return e=Array.isArray(s)?t.from(s).toString():t.isBuffer(s)?s.toString():s,p(this,r,"m",i).call(this,e)}return s instanceof Object&&!(s instanceof Uint8Array)?Uint8Array.from(Object.values(s)):((0,w.assert)(s instanceof Uint8Array,"Expected Uint8Array mnemonic"),s)},c=function(e,t){if(!e)throw new Error("Must specify address.");const s=p(this,r,"m",d).call(this,e,t);return(0,w.assert)(s.privateKey,"Missing private key"),s.privateKey},d=function(e,{withAppKeyOrigin:s}={}){const a=p(this,r,"m",f).call(this,e),o=p(this,n,"f").find((({publicKey:e})=>e&&p(this,r,"m",l).call(this,e)===a));if(!o)throw new Error("HD Keyring - Unable to find matching address.");if(s){const{privateKey:e}=o;(0,w.assert)(e,"Expected private key to be set");const r=t.from(s,"utf8"),n=t.concat([e,r]),a=t.from((0,_.keccak256)(n));return{privateKey:a,publicKey:t.from((0,g.privateToPublic)(a))}}return o},u=async function(e){if(this.root)throw new Error("Eth-Hd-Keyring: Secret recovery phrase already provided");this.mnemonic=p(this,r,"m",m).call(this,e),this.seed=await(0,b.mnemonicToSeed)(this.mnemonic,"",p(this,a,"f")),this.hdWallet=E.HDKey.fromMasterSeed(this.seed),this.root=this.hdWallet.derive(this.hdPath)},l=function(e){return(0,w.add0x)((0,w.bytesToHex)((0,g.publicToAddress)(t.from(e),!0)).toLowerCase())},f=function(e){const t=(0,k.normalize)(e);return(0,w.assert)(t,"Expected address to be set"),(0,w.add0x)(t)},T.type=A}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring",file:"node_modules/@metamask/eth-hd-keyring/dist/hd-keyring.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/dist/index.cjs",{"./hd-keyring.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/dist/hd-keyring.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.HdKeyring=void 0;var r=e("./hd-keyring.cjs");Object.defineProperty(s,"HdKeyring",{enumerable:!0,get:function(){return r.HdKeyring}})}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring",file:"node_modules/@metamask/eth-hd-keyring/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/abi.js",{"./errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/errors.js","./packer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/packer.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.decodeSingle=s.decode=s.encodePacked=s.encodeSingle=s.encode=void 0;const r=e("@metamask/utils"),n=e("./errors"),a=e("./packer");s.encode=(e,t,s,r)=>{try{return(0,a.pack)({types:e,values:t,packed:s,tight:r})}catch(e){if(e instanceof n.ParserError)throw new n.ParserError(`Unable to encode value: ${e.message}`,e);throw new n.ParserError(`An unexpected error occurred: ${(0,n.getErrorMessage)(e)}`,e)}};s.encodeSingle=(e,t)=>(0,s.encode)([e],[t]);s.encodePacked=(e,t,r)=>(0,s.encode)(e,t,!0,r);s.decode=(e,t)=>{const s=(0,r.createBytes)(t);try{return(0,a.unpack)(e,s)}catch(e){if(e instanceof n.ParserError)throw new n.ParserError(`Unable to decode value: ${e.message}`,e);throw new n.ParserError(`An unexpected error occurred: ${(0,n.getErrorMessage)(e)}`,e)}};s.decodeSingle=(e,t)=>{const a=(0,s.decode)([e],t);return(0,r.assert)(1===a.length,new n.ParserError("Decoded value array has unexpected length.")),a[0]}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/abi.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/errors.js",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.ParserError=s.getErrorStack=s.getErrorMessage=void 0;const r=e("@metamask/utils");s.getErrorMessage=e=>"string"==typeof e?e:e instanceof Error||(0,r.isObject)(e)&&(0,r.hasProperty)(e,"message")&&"string"==typeof e.message?e.message:"Unknown error.";s.getErrorStack=e=>e instanceof Error?e.stack:undefined;class n extends Error{constructor(e,t){super(e),this.name="ParserError";const r=(0,s.getErrorStack)(t);r&&(this.stack=r)}}s.ParserError=n}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/errors.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/index.js",{"./abi":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/abi.js","./errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/errors.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/types/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./abi"),s),n(e("./errors"),s),n(e("./types"),s)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/iterator.js",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.iterate=void 0;const r=e("@metamask/utils");s.iterate=function*(e,t=32){for(let s=0;s<e.length;s+=t){const n=e=>{(0,r.assert)(e>=0,"Cannot skip a negative number of bytes."),(0,r.assert)(e%t==0,"Length must be a multiple of the size."),s+=e},a=e.subarray(s);yield{skip:n,value:a}}return{skip:()=>undefined,value:new Uint8Array}}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/iterator.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/packer.js",{"./errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/errors.js","./iterator":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/iterator.js","./parsers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/index.js","./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/utils/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.unpack=s.pack=s.isDynamicParser=s.getParser=void 0;const r=e("@metamask/utils"),n=e("./errors"),a=e("./iterator"),o=e("./parsers"),i=e("./utils");s.getParser=e=>{const t={address:o.address,array:o.array,bool:o.bool,bytes:o.bytes,fixedBytes:o.fixedBytes,function:o.fn,number:o.number,string:o.string,tuple:o.tuple},s=t[e];if(s)return s;const r=Object.values(t).find((t=>t.isType(e)));if(r)return r;throw new n.ParserError(`The type "${e}" is not supported.`)};s.isDynamicParser=(e,t)=>{const{isDynamic:s}=e;return"function"==typeof s?s(t):s};s.pack=({types:e,values:t,packed:a=!1,tight:o=!1,arrayPacked:m=!1,byteArray:c=new Uint8Array})=>{(0,r.assert)(e.length===t.length,new n.ParserError(`The number of types (${e.length}) does not match the number of values (${t.length}).`));const{staticBuffer:d,dynamicBuffer:u,pointers:l}=e.reduce((({staticBuffer:e,dynamicBuffer:n,pointers:i},c,d)=>{const u=(0,s.getParser)(c),l=t[d];if(a||m||!(0,s.isDynamicParser)(u,c))return{staticBuffer:u.encode({buffer:e,value:l,type:c,packed:a,tight:o}),dynamicBuffer:n,pointers:i};return{staticBuffer:(0,r.concatBytes)([e,new Uint8Array(32)]),dynamicBuffer:u.encode({buffer:n,value:l,type:c,packed:a,tight:o}),pointers:[...i,{position:e.length,pointer:n.length}]}}),{staticBuffer:new Uint8Array,dynamicBuffer:new Uint8Array,pointers:[]});(0,r.assert)(!a&&!m||0===u.length,new n.ParserError("Invalid pack state."));const f=d.length,h=l.reduce(((e,{pointer:t,position:s})=>{const n=(0,i.padStart)((0,r.numberToBytes)(f+t));return(0,i.set)(e,n,s)}),d);return(0,r.concatBytes)([c,h,u])};s.unpack=(e,t)=>{const o=(0,a.iterate)(t);return e.map((e=>{const{value:{value:a,skip:i},done:m}=o.next();(0,r.assert)(!m,new n.ParserError(`The encoded value is invalid for the provided types. Reached end of buffer while attempting to parse "${e}".`));const c=(0,s.getParser)(e);if((0,s.isDynamicParser)(c,e)){const s=(0,r.bytesToNumber)(a.subarray(0,32)),n=t.subarray(s);return c.decode({type:e,value:n,skip:i})}return c.decode({type:e,value:a,skip:i})}))}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/packer.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/address.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/errors.js","../utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/utils/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.address=s.getAddress=void 0;const r=e("@metamask/utils"),n=e("../errors"),a=e("../utils");s.getAddress=e=>{const t=(0,r.createBytes)(e);return(0,r.assert)(t.length<=20,new n.ParserError(`Invalid address value. Expected address to be 20 bytes long, but received ${t.length} bytes.`)),(0,a.padStart)(t,20)},s.address={isDynamic:!1,isType:e=>"address"===e,getByteLength:()=>32,encode({buffer:e,value:t,packed:n}){const o=(0,s.getAddress)(t);if(n)return(0,r.concatBytes)([e,o]);const i=(0,a.padStart)(o);return(0,r.concatBytes)([e,i])},decode:({value:e})=>(0,r.add0x)((0,r.bytesToHex)(e.slice(12,32)))}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/address.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/array.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/errors.js","../packer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/packer.js","../utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/utils/index.js","./fixed-bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/fixed-bytes.js","./tuple":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/tuple.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.array=s.getTupleType=s.getArrayType=s.isArrayType=void 0;const r=e("@metamask/utils"),n=e("../errors"),a=e("../packer"),o=e("../utils"),i=e("./fixed-bytes"),m=e("./tuple"),c=/^(?<type>.*)\[(?<length>\d*?)\]$/u;s.isArrayType=e=>c.test(e);s.getArrayType=e=>{const t=e.match(c);return(0,r.assert)(t?.groups?.type,new n.ParserError(`Invalid array type. Expected an array type, but received "${e}".`)),[t.groups.type,t.groups.length?parseInt(t.groups.length,10):undefined]};s.getTupleType=(e,t)=>`(${new Array(t).fill(e).join(",")})`,s.array={isDynamic(e){const[t,r]=(0,s.getArrayType)(e);return r===undefined||(0,a.isDynamicParser)((0,a.getParser)(t),t)},isType:e=>(0,s.isArrayType)(e),getByteLength(e){(0,r.assert)((0,s.isArrayType)(e),new n.ParserError(`Expected an array type, but received "${e}".`));const[t,o]=(0,s.getArrayType)(e);return(0,a.isDynamicParser)(this,e)||o===undefined?32:m.tuple.getByteLength((0,s.getTupleType)(t,o))},encode({type:e,buffer:t,value:c,packed:d,tight:u}){const[l,f]=(0,s.getArrayType)(e);if((0,r.assert)(!d||!(0,s.isArrayType)(l),new n.ParserError("Cannot pack nested arrays.")),d&&(0,a.isDynamicParser)((0,a.getParser)(l),l))return(0,a.pack)({types:new Array(c.length).fill(l),values:c,byteArray:t,packed:d,arrayPacked:!0,tight:u});if(f)return(0,r.assert)(f===c.length,new n.ParserError(`Array length does not match type length. Expected a length of ${f}, but received ${c.length}.`)),m.tuple.encode({type:(0,s.getTupleType)(l,f),buffer:t,value:c,packed:i.fixedBytes.isType(l)&&u,tight:u});if(d)return(0,a.pack)({types:new Array(c.length).fill(l),values:c,byteArray:t,packed:i.fixedBytes.isType(l)&&u,arrayPacked:!0,tight:u});const h=(0,o.padStart)((0,r.numberToBytes)(c.length));return(0,a.pack)({types:new Array(c.length).fill(l),values:c,byteArray:(0,r.concatBytes)([t,h]),packed:d,tight:u})},decode({type:e,value:t,...o}){const[i,c]=(0,s.getArrayType)(e);if(c){const e=m.tuple.decode({type:(0,s.getTupleType)(i,c),value:t,...o});return(0,r.assert)(e.length===c,new n.ParserError(`Array length does not match type length. Expected a length of ${c}, but received ${e.length}.`)),e}const d=(0,r.bytesToNumber)(t.subarray(0,32));return(0,a.unpack)(new Array(d).fill(i),t.subarray(32))}}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/array.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/bool.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/errors.js","./number":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/number.js","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.bool=s.getBooleanValue=void 0;const r=e("@metamask/superstruct"),n=e("@metamask/utils"),a=e("../errors"),o=e("./number"),i=(0,r.coerce)((0,r.boolean)(),(0,r.union)([(0,r.literal)("true"),(0,r.literal)("false")]),(e=>"true"===e));s.getBooleanValue=e=>{try{return(0,r.create)(e,i)?BigInt(1):BigInt(0)}catch{throw new a.ParserError(`Invalid boolean value. Expected a boolean literal, or the string "true" or "false", but received "${e}".`)}},s.bool={isDynamic:!1,isType:e=>"bool"===e,getByteLength:()=>32,encode({buffer:e,value:t,packed:r,tight:a}){const i=(0,s.getBooleanValue)(t);return r?(0,n.concatBytes)([e,(0,n.bigIntToBytes)(i)]):o.number.encode({type:"uint256",buffer:e,value:i,packed:r,tight:a})},decode:e=>o.number.decode({...e,type:"uint256"})===BigInt(1)}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/bool.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/bytes.js",{"../utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/utils/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.bytes=void 0;const r=e("@metamask/utils"),n=e("../utils");s.bytes={isDynamic:!0,isType:e=>"bytes"===e,getByteLength:()=>32,encode({buffer:e,value:t,packed:s}){const a=(0,r.createBytes)(t);if(s)return(0,r.concatBytes)([e,a]);const o=32*Math.ceil(a.byteLength/32);return(0,r.concatBytes)([e,(0,n.padStart)((0,r.numberToBytes)(a.byteLength)),(0,n.padEnd)(a,o)])},decode({value:e}){const t=e.subarray(0,32),s=(0,r.bytesToNumber)(t);return e.slice(32,32+s)}}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/bytes.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/fixed-bytes.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/errors.js","../utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/utils/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.fixedBytes=s.getByteLength=void 0;const r=e("@metamask/utils"),n=e("../errors"),a=e("../utils"),o=/^bytes([0-9]{1,2})$/u;s.getByteLength=e=>{const t=e.match(o)?.[1];(0,r.assert)(t,`Invalid byte length. Expected a number between 1 and 32, but received "${e}".`);const s=Number(t);return(0,r.assert)(s>0&&s<=32,new n.ParserError(`Invalid byte length. Expected a number between 1 and 32, but received "${e}".`)),s},s.fixedBytes={isDynamic:!1,isType:e=>o.test(e),getByteLength:()=>32,encode({type:e,buffer:t,value:o,packed:i}){const m=(0,s.getByteLength)(e),c=(0,r.createBytes)(o);return(0,r.assert)(c.length<=m,new n.ParserError(`Expected a value of length ${m}, but received a value of length ${c.length}.`)),i?(0,r.concatBytes)([t,(0,a.padEnd)(c,m)]):(0,r.concatBytes)([t,(0,a.padEnd)(c)])},decode({type:e,value:t}){const r=(0,s.getByteLength)(e);return t.slice(0,r)}}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/fixed-bytes.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/function.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/errors.js","./fixed-bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/fixed-bytes.js","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.fn=s.getFunction=void 0;const r=e("@metamask/superstruct"),n=e("@metamask/utils"),a=e("../errors"),o=e("./fixed-bytes"),i=(0,r.coerce)((0,r.object)({address:n.StrictHexStruct,selector:n.StrictHexStruct}),(0,r.union)([n.StrictHexStruct,(0,r.instance)(Uint8Array)]),(e=>{const t=(0,n.createBytes)(e);return(0,n.assert)(24===t.length,new a.ParserError(`Invalid Solidity function. Expected function to be 24 bytes long, but received ${t.length} bytes.`)),{address:(0,n.bytesToHex)(t.subarray(0,20)),selector:(0,n.bytesToHex)(t.subarray(20,24))}}));s.getFunction=e=>{const t=(0,r.create)(e,i);return(0,n.concatBytes)([(0,n.hexToBytes)(t.address),(0,n.hexToBytes)(t.selector)])},s.fn={isDynamic:!1,isType:e=>"function"===e,getByteLength:()=>32,encode({buffer:e,value:t,packed:r,tight:n}){const a=(0,s.getFunction)(t);return o.fixedBytes.encode({type:"bytes24",buffer:e,value:a,packed:r,tight:n})},decode:({value:e})=>({address:(0,n.bytesToHex)(e.slice(0,20)),selector:(0,n.bytesToHex)(e.slice(20,24))})}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/function.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/index.js",{"./address":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/address.js","./array":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/array.js","./bool":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/bool.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/bytes.js","./fixed-bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/fixed-bytes.js","./function":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/function.js","./number":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/number.js","./parser":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/parser.js","./string":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/string.js","./tuple":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/tuple.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./address"),s),n(e("./array"),s),n(e("./bool"),s),n(e("./bytes"),s),n(e("./fixed-bytes"),s),n(e("./function"),s),n(e("./number"),s),n(e("./parser"),s),n(e("./string"),s),n(e("./tuple"),s)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/number.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/errors.js","../utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/utils/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.number=s.getBigInt=s.assertNumberLength=s.getLength=s.isSigned=void 0;const r=e("@metamask/utils"),n=e("../errors"),a=e("../utils"),o=/^u?int(?<length>[0-9]*)?$/u;s.isSigned=e=>!e.startsWith("u");s.getLength=e=>{if("int"===e||"uint"===e)return 256;const t=e.match(o);(0,r.assert)(t?.groups?.length,new n.ParserError(`Invalid number type. Expected a number type, but received "${e}".`));const s=parseInt(t.groups.length,10);return(0,r.assert)(s>=8&&s<=256,new n.ParserError(`Invalid number length. Expected a number between 8 and 256, but received "${e}".`)),(0,r.assert)(s%8==0,new n.ParserError(`Invalid number length. Expected a multiple of 8, but received "${e}".`)),s};s.assertNumberLength=(e,t)=>{const a=(0,s.getLength)(t),o=BigInt(2)**BigInt(a-((0,s.isSigned)(t)?1:0))-BigInt(1);(0,s.isSigned)(t)?(0,r.assert)(e>=-(o+BigInt(1))&&e<=o,new n.ParserError(`Number "${e}" is out of range for type "${t}".`)):(0,r.assert)(e<=o,new n.ParserError(`Number "${e}" is out of range for type "${t}".`))};s.getBigInt=e=>{try{return(0,r.createBigInt)(e)}catch{throw new n.ParserError(`Invalid number. Expected a valid number value, but received "${e}".`)}},s.number={isDynamic:!1,isType:e=>o.test(e),getByteLength:()=>32,encode({type:e,buffer:t,value:n,packed:o}){const i=(0,s.getBigInt)(n);if((0,s.assertNumberLength)(i,e),(0,s.isSigned)(e)){if(o){const n=(0,s.getLength)(e)/8;return(0,r.concatBytes)([t,(0,r.signedBigIntToBytes)(i,n)])}return(0,r.concatBytes)([t,(0,a.padStart)((0,r.signedBigIntToBytes)(i,32))])}if(o){const n=(0,s.getLength)(e)/8;return(0,r.concatBytes)([t,(0,a.padStart)((0,r.bigIntToBytes)(i),n)])}return(0,r.concatBytes)([t,(0,a.padStart)((0,r.bigIntToBytes)(i))])},decode({type:e,value:t}){const n=t.subarray(0,32);if((0,s.isSigned)(e)){const t=(0,r.bytesToSignedBigInt)(n);return(0,s.assertNumberLength)(t,e),t}const a=(0,r.bytesToBigInt)(n);return(0,s.assertNumberLength)(a,e),a}}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/number.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/parser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0})}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/parser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/string.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/bytes.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.string=void 0;const r=e("@metamask/utils"),n=e("./bytes");s.string={isDynamic:!0,isType:e=>"string"===e,getByteLength:()=>32,encode:({buffer:e,value:t,packed:s,tight:a})=>n.bytes.encode({type:"bytes",buffer:e,value:(0,r.stringToBytes)(t),packed:s,tight:a}),decode:e=>(0,r.bytesToString)(n.bytes.decode(e))}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/string.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/tuple.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/errors.js","../packer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/packer.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.tuple=s.getTupleElements=void 0;const r=e("@metamask/utils"),n=e("../errors"),a=e("../packer"),o=/^\((.+)\)$/u;s.getTupleElements=e=>{(0,r.assert)(e.startsWith("(")&&e.endsWith(")"),new n.ParserError(`Invalid tuple type. Expected tuple type, but received "${e}".`));const t=[];let s="",a=0;for(let r=1;r<e.length-1;r++){const n=e[r];","===n&&0===a?(t.push(s.trim()),s=""):(s+=n,"("===n?a+=1:")"===n&&(a-=1))}return s.trim()&&t.push(s.trim()),t},s.tuple={isDynamic:e=>(0,s.getTupleElements)(e).some((e=>{const t=(0,a.getParser)(e);return(0,a.isDynamicParser)(t,e)})),isType:e=>(e=>o.test(e))(e),getByteLength(e){if((0,a.isDynamicParser)(this,e))return 32;return(0,s.getTupleElements)(e).reduce(((e,t)=>e+(0,a.getParser)(t).getByteLength(t)),0)},encode({type:e,buffer:t,value:r,packed:n,tight:o}){const i=(0,s.getTupleElements)(e);return(0,a.pack)({types:i,values:r,byteArray:t,packed:n,tight:o})},decode({type:e,value:t,skip:r}){const n=(0,s.getTupleElements)(e);return r(this.getByteLength(e)-32),(0,a.unpack)(n,t)}}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/tuple.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/types/abi.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0})}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/types/abi.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/types/index.js",{"./abi":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/types/abi.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./abi"),s)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/types/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/utils/buffer.js",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.padEnd=s.padStart=s.set=void 0;const r=e("@metamask/utils");s.set=(e,t,s)=>(0,r.concatBytes)([e.subarray(0,s),t,e.subarray(s+t.length)]);s.padStart=(e,t=32)=>{const s=new Uint8Array(Math.max(t-e.length,0)).fill(0);return(0,r.concatBytes)([s,e])};s.padEnd=(e,t=32)=>{const s=new Uint8Array(Math.max(t-e.length,0)).fill(0);return(0,r.concatBytes)([e,s])}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/utils/buffer.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/utils/index.js",{"./buffer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/utils/buffer.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./buffer"),s)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/utils/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/encryption.js",{"./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/utils.js","@scure/base":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@scure/base/lib/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js",tweetnacl:"/home/runner/work/metamask-extension/metamask-extension/node_modules/tweetnacl/nacl-fast.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),a=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var s in e)"default"!==s&&Object.prototype.hasOwnProperty.call(e,s)&&r(t,e,s);return n(t,e),t};Object.defineProperty(s,"__esModule",{value:!0}),s.getEncryptionPublicKey=s.decryptSafely=s.decrypt=s.encryptSafely=s.encrypt=void 0;const o=e("@scure/base"),i=a(e("tweetnacl")),m=e("./utils");function c({publicKey:e,data:t,version:s}){if((0,m.isNullish)(e))throw new Error("Missing publicKey parameter");if((0,m.isNullish)(t))throw new Error("Missing data parameter");if((0,m.isNullish)(s))throw new Error("Missing version parameter");if("x25519-xsalsa20-poly1305"===s){if("string"!=typeof t)throw new Error("Message data must be given as a string");const s=i.box.keyPair();let r;try{r=o.base64.decode(e)}catch(e){throw new Error("Bad public key")}const n=o.utf8.decode(t),a=i.randomBytes(i.box.nonceLength),m=i.box(n,a,r,s.secretKey);return{version:"x25519-xsalsa20-poly1305",nonce:o.base64.encode(a),ephemPublicKey:o.base64.encode(s.publicKey),ciphertext:o.base64.encode(m)}}throw new Error("Encryption type/version not supported")}function d({encryptedData:e,privateKey:s}){if((0,m.isNullish)(e))throw new Error("Missing encryptedData parameter");if((0,m.isNullish)(s))throw new Error("Missing privateKey parameter");if("x25519-xsalsa20-poly1305"===e.version){const r=t.from(s,"hex"),n=i.box.keyPair.fromSecretKey(r).secretKey,a=o.base64.decode(e.nonce),m=o.base64.decode(e.ciphertext),c=o.base64.decode(e.ephemPublicKey),d=i.box.open(m,a,c,n);try{if(!d)throw new Error;const e=o.utf8.encode(d);if(!e)throw new Error;return e}catch(e){if(e&&"string"==typeof e.message&&e.message.length)throw new Error(`Decryption failed: ${e.message}`);throw new Error("Decryption failed.")}}throw new Error("Encryption type/version not supported.")}s.encrypt=c,s.encryptSafely=function({publicKey:e,data:s,version:r}){if((0,m.isNullish)(e))throw new Error("Missing publicKey parameter");if((0,m.isNullish)(s))throw new Error("Missing data parameter");if((0,m.isNullish)(r))throw new Error("Missing version parameter");if("object"==typeof s&&s&&"toJSON"in s)throw new Error("Cannot encrypt with toJSON property.  Please remove toJSON property");const n={data:s,padding:""},a=t.byteLength(JSON.stringify(n),"utf-8")%2048;let o=0;return a>0&&(o=2048-a-16),n.padding="0".repeat(o),c({publicKey:e,data:JSON.stringify(n),version:r})},s.decrypt=d,s.decryptSafely=function({encryptedData:e,privateKey:t}){if((0,m.isNullish)(e))throw new Error("Missing encryptedData parameter");if((0,m.isNullish)(t))throw new Error("Missing privateKey parameter");return JSON.parse(d({encryptedData:e,privateKey:t})).data},s.getEncryptionPublicKey=function(e){const s=t.from(e,"hex"),r=i.box.keyPair.fromSecretKey(s).publicKey;return o.base64.encode(r)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/encryption.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/index.js",{"./encryption":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/encryption.js","./personal-sign":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/personal-sign.js","./sign-eip7702-authorization":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/sign-eip7702-authorization.js","./sign-typed-data":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/sign-typed-data.js","./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/utils.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),s.normalize=s.concatSig=void 0,n(e("./personal-sign"),s),n(e("./sign-typed-data"),s),n(e("./encryption"),s),n(e("./sign-eip7702-authorization"),s);var a=e("./utils");Object.defineProperty(s,"concatSig",{enumerable:!0,get:function(){return a.concatSig}}),Object.defineProperty(s,"normalize",{enumerable:!0,get:function(){return a.normalize}})}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/personal-sign.js",{"./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/utils.js","@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.extractPublicKey=s.recoverPersonalSignature=s.personalSign=void 0;const r=e("@ethereumjs/util"),n=e("./utils");function a(e,t){const s=(0,r.hashPersonalMessage)((0,n.legacyToBuffer)(e));return(0,n.recoverPublicKey)(s,t)}s.personalSign=function({privateKey:e,data:t}){if((0,n.isNullish)(t))throw new Error("Missing data parameter");if((0,n.isNullish)(e))throw new Error("Missing privateKey parameter");const s=(0,n.legacyToBuffer)(t),a=(0,r.hashPersonalMessage)(s),o=(0,r.ecsign)(a,e);return(0,n.concatSig)((0,r.toBuffer)(o.v),o.r,o.s)},s.recoverPersonalSignature=function({data:e,signature:t}){if((0,n.isNullish)(e))throw new Error("Missing data parameter");if((0,n.isNullish)(t))throw new Error("Missing signature parameter");const s=a(e,t),o=(0,r.publicToAddress)(s);return(0,r.bufferToHex)(o)},s.extractPublicKey=function({data:e,signature:t}){if((0,n.isNullish)(e))throw new Error("Missing data parameter");if((0,n.isNullish)(t))throw new Error("Missing signature parameter");return`0x${a(e,t).toString("hex")}`}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/personal-sign.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/sign-eip7702-authorization.js",{"./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/utils.js","@ethereumjs/rlp":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethereumjs/rlp/dist/index.js","@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.hashEIP7702Authorization=s.recoverEIP7702Authorization=s.signEIP7702Authorization=void 0;const r=e("@ethereumjs/rlp"),n=e("@ethereumjs/util"),a=e("@metamask/utils"),o=e("ethereum-cryptography/keccak"),i=e("./utils");function m(e){c(e);const s=(0,r.encode)(e),n=t.concat([t.from("05","hex"),s]);return t.from((0,o.keccak256)(n))}function c(e){if((0,i.isNullish)(e))throw new Error("Missing authorization parameter");const[t,s,r]=e;if((0,i.isNullish)(t))throw new Error("Missing chainId parameter");if((0,i.isNullish)(s))throw new Error("Missing contractAddress parameter");if((0,i.isNullish)(r))throw new Error("Missing nonce parameter")}s.signEIP7702Authorization=function({privateKey:e,authorization:t}){if(c(t),(0,i.isNullish)(e))throw new Error("Missing privateKey parameter");const s=m(t),{r:r,s:a,v:o}=(0,n.ecsign)(s,e),d=(0,n.toBuffer)(o);return(0,i.concatSig)(d,r,a)},s.recoverEIP7702Authorization=function({signature:e,authorization:t}){if(c(t),(0,i.isNullish)(e))throw new Error("Missing signature parameter");const s=m(t),r=(0,i.recoverPublicKey)(s,e),o=(0,n.publicToAddress)(r);return(0,a.bytesToHex)(o)},s.hashEIP7702Authorization=m}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/sign-eip7702-authorization.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/sign-typed-data.js",{"./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/utils.js","@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js","@metamask/abi-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/index.js","@metamask/abi-utils/dist/parsers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/parsers/index.js","@metamask/abi-utils/dist/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/abi-utils/dist/utils/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.recoverTypedSignature=s.signTypedData=s.typedSignatureHash=s.TypedDataUtils=s.TYPED_MESSAGE_SCHEMA=s.SignTypedDataVersion=void 0;const r=e("@ethereumjs/util"),n=e("@metamask/abi-utils"),a=e("@metamask/abi-utils/dist/parsers"),o=e("@metamask/abi-utils/dist/utils"),i=e("@metamask/utils"),m=e("ethereum-cryptography/keccak"),c=e("./utils");var d;function u(e,t){if(!Object.keys(d).includes(e))throw new Error(`Invalid version: '${e}'`);if(t&&!t.includes(e))throw new Error(`SignTypedDataVersion not allowed: '${e}'. Allowed versions are: ${t.join(", ")}`)}function l(e,t){(0,i.assert)(null!==t,`Unable to encode value: Invalid number. Expected a valid number value, but received "${t}".`);const s=BigInt(t),r=(0,a.getLength)(e),n=BigInt(2)**BigInt(r)-BigInt(1);return(0,i.assert)(s>=-n&&s<=n,`Unable to encode value: Number "${t}" is out of range for type "${e}".`),s}function f(e){let t=BigInt(0);for(let s=0;s<e.length;s++){const r=BigInt(e.charCodeAt(s)-48);t*=BigInt(10),t+=r>=49?r-BigInt(49)+BigInt(10):r>=17?r-BigInt(17)+BigInt(10):r}return(0,o.padStart)((0,i.bigIntToBytes)(t),20)}function h(e,t,s,a,c){if(u(c,[d.V3,d.V4]),e[s]!==undefined)return["bytes32",c===d.V4&&null==a?"0x0000000000000000000000000000000000000000000000000000000000000000":(0,r.arrToBufArr)((0,m.keccak256)(p(s,a,e,c)))];if("function"===s)throw new Error('Unsupported or invalid type: "function"');if(a===undefined)throw new Error(`missing value for field ${t} of type ${s}`);if("address"===s){if("number"==typeof a)return["address",(0,o.padStart)((0,i.numberToBytes)(a),20)];if((0,i.isStrictHexString)(a))return["address",(0,i.add0x)(a)];if("string"==typeof a)return["address",f(a).subarray(0,20)]}if("bool"===s)return["bool",Boolean(a)];if("bytes"===s)return"number"==typeof a?a=(0,i.numberToBytes)(a):(0,i.isStrictHexString)(a)||"0x"===a?a=(0,i.hexToBytes)(a):"string"==typeof a&&(a=(0,i.stringToBytes)(a)),["bytes32",(0,r.arrToBufArr)((0,m.keccak256)(a))];if(s.startsWith("bytes")&&"bytes"!==s&&!s.includes("["))return"number"==typeof a?a<0?["bytes32",new Uint8Array(32)]:["bytes32",(0,i.bigIntToBytes)(BigInt(a))]:(0,i.isStrictHexString)(a)?["bytes32",(0,i.hexToBytes)(a)]:["bytes32",a];if(s.startsWith("int")&&!s.includes("[")){const e=l(s,a);return e>=BigInt(0)?["uint256",e]:["int256",e]}if("string"===s)return a="number"==typeof a?(0,i.numberToBytes)(a):(0,i.stringToBytes)(null!=a?a:""),["bytes32",(0,r.arrToBufArr)((0,m.keccak256)(a))];if(s.endsWith("]")){if(c===d.V3)throw new Error("Arrays are unimplemented in encodeData; use V4 extension");const o=s.slice(0,s.lastIndexOf("[")),i=a.map((s=>h(e,t,o,s,c)));return["bytes32",(0,r.arrToBufArr)((0,m.keccak256)((0,n.encode)(i.map((([e])=>e)),i.map((([,e])=>e)))))]}return[s,a]}function p(e,t,s,a){u(a,[d.V3,d.V4]);const o=["bytes32"],i=[y(e,s)];for(const r of s[e]){if(a===d.V3&&t[r.name]===undefined)continue;const[e,n]=h(s,r.name,r.type,t[r.name],a);o.push(e),i.push(n)}return(0,r.arrToBufArr)((0,n.encode)(o,i))}function g(e,t){let s="";const r=k(e,t);r.delete(e);const n=[e,...Array.from(r).sort()];for(const e of n){if(!t[e])throw new Error(`No type definition specified: ${e}`);s+=`${e}(${t[e].map((({name:e,type:t})=>`${t} ${e}`)).join(",")})`}return s}function k(e,t,s=new Set){if("string"!=typeof e)throw new Error(`Invalid findTypeDependencies input ${JSON.stringify(e)}`);const r=e.match(/^\w*/u);if([e]=r,s.has(e)||t[e]===undefined)return s;s.add(e);for(const r of t[e])k(r.type,t,s);return s}function b(e,t,s,n){u(n,[d.V3,d.V4]);const a=p(e,t,s,n),o=(0,m.keccak256)(a);return(0,r.arrToBufArr)(o)}function y(e,t){const s=(0,i.stringToBytes)(g(e,t));return(0,r.arrToBufArr)((0,m.keccak256)(s))}function x(e){const t={};for(const r in s.TYPED_MESSAGE_SCHEMA.properties)e[r]&&(t[r]=e[r]);return"types"in t&&(t.types=Object.assign({EIP712Domain:[]},t.types)),t}function w(e,t){u(t,[d.V3,d.V4]);const s=x(e),{domain:r}=s;return b("EIP712Domain",r,{EIP712Domain:s.types.EIP712Domain},t)}function E(e,t){if((0,a.isArrayType)(e)&&Array.isArray(t)){const[s]=(0,a.getArrayType)(e);return t.map((e=>E(s,e)))}if("address"===e){if((0,i.isStrictHexString)(t))return(0,o.padStart)((0,i.hexToBytes)(t).subarray(0,20),20);if(t instanceof Uint8Array)return(0,o.padStart)(t.subarray(0,20),20)}if("bool"===e)return Boolean(t);if(e.startsWith("bytes")&&"bytes"!==e){const s=(0,a.getByteLength)(e);if("number"==typeof t)return t<0?new Uint8Array:(0,i.numberToBytes)(t).subarray(0,s);if((0,i.isStrictHexString)(t))return(0,i.hexToBytes)(t).subarray(0,s);if(t instanceof Uint8Array)return t.subarray(0,s)}if(e.startsWith("uint")&&"number"==typeof t)return Math.abs(t);if(e.startsWith("int")&&"number"==typeof t){const s=(0,a.getLength)(e);return BigInt.asIntN(s,BigInt(t))}return t}function _(e,t){return t.map((t=>{if("string"==typeof t||"number"==typeof t||"bigint"==typeof t){const s=l(e,t);if(s>=BigInt(0))return(0,o.padStart)((0,i.bigIntToBytes)(s),32);const r=(0,a.getLength)(e),n=BigInt.asIntN(r,s);return(0,i.signedBigIntToBytes)(n,32)}return t}))}function v(e){const t=new Error("Expect argument to be non-empty array");if("object"!=typeof e||!("length"in e)||!e.length)throw t;const s=e.map((({name:e,type:t,value:s})=>{if("address[]"===t)return{name:e,type:"bytes32[]",value:(r=s,r.map((e=>"number"==typeof e?(0,o.padStart)((0,i.numberToBytes)(e),32):(0,i.isStrictHexString)(e)?(0,o.padStart)((0,i.hexToBytes)(e).subarray(0,32),32):e instanceof Uint8Array?(0,o.padStart)(e.subarray(0,32),32):e)))};var r;if(t.startsWith("int")&&(0,a.isArrayType)(t)){const[r,n]=(0,a.getArrayType)(t);return{name:e,type:`bytes32[${null!=n?n:""}]`,value:_(r,s)}}return{name:e,type:t,value:E(t,s)}})),d=s.map((e=>"bytes"!==e.type?e.value:(0,c.legacyToBuffer)(e.value))),u=s.map((e=>{if("function"===e.type)throw new Error('Unsupported or invalid type: "function"');return e.type})),l=e.map((e=>{if(!e.name)throw t;return`${e.type} ${e.name}`}));return(0,r.arrToBufArr)((0,m.keccak256)((0,n.encodePacked)(["bytes32","bytes32"],[(0,m.keccak256)((0,n.encodePacked)(["string[]"],[l],!0)),(0,m.keccak256)((0,n.encodePacked)(u,d,!0))])))}!function(e){e.V1="V1",e.V3="V3",e.V4="V4"}(d=s.SignTypedDataVersion||(s.SignTypedDataVersion={})),s.TYPED_MESSAGE_SCHEMA={type:"object",properties:{types:{type:"object",additionalProperties:{type:"array",items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}},required:["name","type"]}}},primaryType:{type:"string"},domain:{type:"object"},message:{type:"object"}},required:["types","primaryType","domain","message"]},s.TypedDataUtils={encodeData:p,encodeType:g,findTypeDependencies:k,hashStruct:b,hashType:y,sanitizeData:x,eip712Hash:function(e,t){u(t,[d.V3,d.V4]);const s=x(e),n=[(0,i.hexToBytes)("1901")];return n.push(w(e,t)),"EIP712Domain"!==s.primaryType&&n.push(b(s.primaryType,s.message,s.types,t)),(0,r.arrToBufArr)((0,m.keccak256)((0,i.concatBytes)(n)))},eip712DomainHash:w},s.typedSignatureHash=function(e){const t=v(e);return(0,i.bytesToHex)(t)},s.signTypedData=function({privateKey:e,data:t,version:n}){if(u(n),(0,c.isNullish)(t))throw new Error("Missing data parameter");if((0,c.isNullish)(e))throw new Error("Missing private key parameter");const a=n===d.V1?v(t):s.TypedDataUtils.eip712Hash(t,n),o=(0,r.ecsign)(a,e);return(0,c.concatSig)((0,r.arrToBufArr)((0,i.bigIntToBytes)(o.v)),o.r,o.s)},s.recoverTypedSignature=function({data:e,signature:t,version:n}){if(u(n),(0,c.isNullish)(e))throw new Error("Missing data parameter");if((0,c.isNullish)(t))throw new Error("Missing signature parameter");const a=n===d.V1?v(e):s.TypedDataUtils.eip712Hash(e,n),o=(0,c.recoverPublicKey)(a,t),m=(0,r.publicToAddress)(o);return(0,i.bytesToHex)(m)}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/sign-typed-data.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/utils.js",{"@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.normalize=s.recoverPublicKey=s.concatSig=s.legacyToBuffer=s.isNullish=s.padWithZeroes=void 0;const r=e("@ethereumjs/util"),n=e("@metamask/utils");function a(e,t){if(""!==e&&!/^[a-f0-9]+$/iu.test(e))throw new Error(`Expected an unprefixed hex string. Received: ${e}`);if(t<0)throw new Error(`Expected a non-negative integer target length. Received: ${t}`);return String.prototype.padStart.call(e,t,"0")}function o(e){return null===e||e===undefined}s.padWithZeroes=a,s.isNullish=o,s.legacyToBuffer=function(e){return"string"!=typeof e||(0,r.isHexString)(e)?(0,r.toBuffer)(e):t.from(e)},s.concatSig=function(e,t,s){const o=(0,r.fromSigned)(t),i=(0,r.fromSigned)(s),m=(0,r.bufferToInt)(e),c=a((0,r.toUnsigned)(o).toString("hex"),64),d=a((0,r.toUnsigned)(i).toString("hex"),64),u=(0,n.remove0x)((0,n.numberToHex)(m));return(0,n.add0x)(c.concat(d,u))},s.recoverPublicKey=function(e,t){const s=(0,r.fromRpcSig)(t);return(0,r.ecrecover)(e,s.v,s.r,s.s)},s.normalize=function(e){if(o(e))return undefined;if("number"==typeof e){if(e<0)return"0x";const t=(0,n.numberToBytes)(e);e=(0,n.bytesToHex)(t)}if("string"!=typeof e){let t="eth-sig-util.normalize() requires hex string or integer input.";throw t+=` received ${typeof e}: ${e}`,new Error(t)}return(0,n.add0x)(e.toLowerCase())}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/dist/utils.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/account.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js","./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js","@ethereumjs/rlp":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethereumjs/rlp/dist/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js","ethereum-cryptography/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/utils.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.accountBodyToRLP=s.accountBodyToSlim=s.accountBodyFromSlim=s.isZeroAddress=s.zeroAddress=s.importPublic=s.privateToAddress=s.privateToPublic=s.publicToAddress=s.pubToAddress=s.isValidPublic=s.isValidPrivate=s.generateAddress2=s.generateAddress=s.isValidChecksumAddress=s.toChecksumAddress=s.isValidAddress=s.Account=void 0;const r=e("@ethereumjs/rlp"),n=e("ethereum-cryptography/keccak"),a=e("ethereum-cryptography/secp256k1"),o=e("ethereum-cryptography/utils"),i=e("./bytes"),m=e("./constants"),c=e("./helpers"),d=e("./internal"),u=BigInt(0);class l{constructor(e=u,t=u,s=m.KECCAK256_RLP,r=m.KECCAK256_NULL){this.nonce=e,this.balance=t,this.storageRoot=s,this.codeHash=r,this._validate()}static fromAccountData(e){const{nonce:t,balance:s,storageRoot:r,codeHash:n}=e;return new l(t!==undefined?(0,i.bufferToBigInt)((0,i.toBuffer)(t)):undefined,s!==undefined?(0,i.bufferToBigInt)((0,i.toBuffer)(s)):undefined,r!==undefined?(0,i.toBuffer)(r):undefined,n!==undefined?(0,i.toBuffer)(n):undefined)}static fromRlpSerializedAccount(e){const t=(0,i.arrToBufArr)(r.RLP.decode(Uint8Array.from(e)));if(!Array.isArray(t))throw new Error("Invalid serialized account input. Must be array");return this.fromValuesArray(t)}static fromValuesArray(e){const[t,s,r,n]=e;return new l((0,i.bufferToBigInt)(t),(0,i.bufferToBigInt)(s),r,n)}_validate(){if(this.nonce<u)throw new Error("nonce must be greater than zero");if(this.balance<u)throw new Error("balance must be greater than zero");if(32!==this.storageRoot.length)throw new Error("storageRoot must have a length of 32");if(32!==this.codeHash.length)throw new Error("codeHash must have a length of 32")}raw(){return[(0,i.bigIntToUnpaddedBuffer)(this.nonce),(0,i.bigIntToUnpaddedBuffer)(this.balance),this.storageRoot,this.codeHash]}serialize(){return t.from(r.RLP.encode((0,i.bufArrToArr)(this.raw())))}isContract(){return!this.codeHash.equals(m.KECCAK256_NULL)}isEmpty(){return this.balance===u&&this.nonce===u&&this.codeHash.equals(m.KECCAK256_NULL)}}s.Account=l;s.isValidAddress=function(e){try{(0,c.assertIsString)(e)}catch(e){return!1}return/^0x[0-9a-fA-F]{40}$/.test(e)};s.toChecksumAddress=function(e,s){(0,c.assertIsHexString)(e);const r=(0,d.stripHexPrefix)(e).toLowerCase();let a="";if(s!==undefined){a=(0,i.bufferToBigInt)((0,i.toBuffer)(s)).toString()+"0x"}const m=t.from(a+r,"utf8"),u=(0,o.bytesToHex)((0,n.keccak256)(m));let l="0x";for(let e=0;e<r.length;e++)parseInt(u[e],16)>=8?l+=r[e].toUpperCase():l+=r[e];return l};s.isValidChecksumAddress=function(e,t){return(0,s.isValidAddress)(e)&&(0,s.toChecksumAddress)(e,t)===e};s.generateAddress=function(e,s){return(0,c.assertIsBuffer)(e),(0,c.assertIsBuffer)(s),(0,i.bufferToBigInt)(s)===BigInt(0)?t.from((0,n.keccak256)(r.RLP.encode((0,i.bufArrToArr)([e,null])))).slice(-20):t.from((0,n.keccak256)(r.RLP.encode((0,i.bufArrToArr)([e,s])))).slice(-20)};s.generateAddress2=function(e,s,r){if((0,c.assertIsBuffer)(e),(0,c.assertIsBuffer)(s),(0,c.assertIsBuffer)(r),20!==e.length)throw new Error("Expected from to be of length 20");if(32!==s.length)throw new Error("Expected salt to be of length 32");const a=(0,n.keccak256)(t.concat([t.from("ff","hex"),e,s,(0,n.keccak256)(r)]));return(0,i.toBuffer)(a).slice(-20)};s.isValidPrivate=function(e){return a.secp256k1.utils.isValidPrivateKey(e)};s.isValidPublic=function(e,s=!1){if((0,c.assertIsBuffer)(e),64===e.length)try{return a.secp256k1.ProjectivePoint.fromHex(t.concat([t.from([4]),e])),!0}catch(e){return!1}if(!s)return!1;try{return a.secp256k1.ProjectivePoint.fromHex(e),!0}catch(e){return!1}};s.pubToAddress=function(e,s=!1){if((0,c.assertIsBuffer)(e),s&&64!==e.length&&(e=t.from(a.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),64!==e.length)throw new Error("Expected pubKey to be of length 64");return t.from((0,n.keccak256)(e)).slice(-20)},s.publicToAddress=s.pubToAddress;s.privateToPublic=function(e){return(0,c.assertIsBuffer)(e),t.from(a.secp256k1.ProjectivePoint.fromPrivateKey(e).toRawBytes(!1).slice(1))};s.privateToAddress=function(e){return(0,s.publicToAddress)((0,s.privateToPublic)(e))};s.importPublic=function(e){return(0,c.assertIsBuffer)(e),64!==e.length&&(e=t.from(a.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),e};s.zeroAddress=function(){const e=(0,i.zeros)(20);return(0,i.bufferToHex)(e)};function f(e){const[t,s,r,n]=e;return[t,s,0===(0,i.arrToBufArr)(r).length?m.KECCAK256_RLP:r,0===(0,i.arrToBufArr)(n).length?m.KECCAK256_NULL:n]}s.isZeroAddress=function(e){try{(0,c.assertIsString)(e)}catch(e){return!1}return(0,s.zeroAddress)()===e},s.accountBodyFromSlim=f;const h=new Uint8Array(0);s.accountBodyToSlim=function(e){const[t,s,r,n]=e;return[t,s,(0,i.arrToBufArr)(r).equals(m.KECCAK256_RLP)?h:r,(0,i.arrToBufArr)(n).equals(m.KECCAK256_NULL)?h:n]},s.accountBodyToRLP=function(e,t=!0){const s=t?f(e):e;return(0,i.arrToBufArr)(r.RLP.encode(s))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/account.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/address.js",{"./account":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/account.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.Address=void 0;const r=e("./account"),n=e("./bytes");class a{constructor(e){if(20!==e.length)throw new Error("Invalid address length");this.buf=e}static zero(){return new a((0,n.zeros)(20))}static fromString(e){if(!(0,r.isValidAddress)(e))throw new Error("Invalid address");return new a((0,n.toBuffer)(e))}static fromPublicKey(e){if(!t.isBuffer(e))throw new Error("Public key should be Buffer");const s=(0,r.pubToAddress)(e);return new a(s)}static fromPrivateKey(e){if(!t.isBuffer(e))throw new Error("Private key should be Buffer");const s=(0,r.privateToAddress)(e);return new a(s)}static generate(e,t){if("bigint"!=typeof t)throw new Error("Expected nonce to be a bigint");return new a((0,r.generateAddress)(e.buf,(0,n.bigIntToBuffer)(t)))}static generate2(e,s,n){if(!t.isBuffer(s))throw new Error("Expected salt to be a Buffer");if(!t.isBuffer(n))throw new Error("Expected initCode to be a Buffer");return new a((0,r.generateAddress2)(e.buf,s,n))}equals(e){return this.buf.equals(e.buf)}isZero(){return this.equals(a.zero())}isPrecompileOrSystemAddress(){const e=(0,n.bufferToBigInt)(this.buf),t=BigInt(0),s=BigInt("0xffff");return e>=t&&e<=s}toString(){return"0x"+this.buf.toString("hex")}toBuffer(){return t.from(this.buf)}}s.Address=a}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/address.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js",{events:"/home/runner/work/metamask-extension/metamask-extension/node_modules/events/events.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.AsyncEventEmitter=void 0;const r=e("events");class n extends r.EventEmitter{emit(e,...t){let[s,r]=t;const n=this;let a=n._events[e]??[];return r===undefined&&"function"==typeof s&&(r=s,s=undefined),"newListener"!==e&&"removeListener"!==e||(s={event:s,fn:r},r=undefined),a=Array.isArray(a)?a:[a],async function(e,t,s){let r;for await(const n of t)try{n.length<2?n.call(e,s):await new Promise(((t,r)=>{n.call(e,s,(e=>{e?r(e):t()}))}))}catch(e){r=e}if(r)throw r}(n,a.slice(),s).then(r).catch(r),n.listenerCount(e)>0}once(e,t){const s=this;let r;if("function"!=typeof t)throw new TypeError("listener must be a function");return r=t.length>=2?function(n,a){s.removeListener(e,r),t(n,a)}:function(n){s.removeListener(e,r),t(n,r)},s.on(e,r),s}first(e,t){let s=this._events[e]??[];if("function"!=typeof t)throw new TypeError("listener must be a function");return Array.isArray(s)||(this._events[e]=s=[s]),s.unshift(t),this}before(e,t,s){return this.beforeOrAfter(e,t,s)}after(e,t,s){return this.beforeOrAfter(e,t,s,"after")}beforeOrAfter(e,t,s,r){let n,a,o=this._events[e]??[];const i="after"===r?1:0;if("function"!=typeof s)throw new TypeError("listener must be a function");if("function"!=typeof t)throw new TypeError("target must be a function");for(Array.isArray(o)||(this._events[e]=o=[o]),a=o.length,n=o.length;n--;)if(o[n]===t){a=n+i;break}return o.splice(a,0,s),this}on(e,t){return super.on(e,t)}addListener(e,t){return super.addListener(e,t)}prependListener(e,t){return super.prependListener(e,t)}prependOnceListener(e,t){return super.prependOnceListener(e,t)}removeAllListeners(e){return super.removeAllListeners(e)}removeListener(e,t){return super.removeListener(e,t)}eventNames(){return super.eventNames()}listeners(e){return super.listeners(e)}listenerCount(e){return super.listenerCount(e)}getMaxListeners(){return super.getMaxListeners()}setMaxListeners(e){return super.setMaxListeners(e)}}s.AsyncEventEmitter=n}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js",{"./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.intToUnpaddedBuffer=s.bigIntToUnpaddedBuffer=s.bigIntToHex=s.bufArrToArr=s.arrToBufArr=s.validateNoLeadingZeroes=s.baToJSON=s.toUtf8=s.short=s.addHexPrefix=s.toUnsigned=s.fromSigned=s.bufferToInt=s.bigIntToBuffer=s.bufferToBigInt=s.bufferToHex=s.toBuffer=s.unpadHexString=s.unpadArray=s.unpadBuffer=s.setLengthRight=s.setLengthLeft=s.zeros=s.intToBuffer=s.intToHex=void 0;const r=e("./helpers"),n=e("./internal");s.intToHex=function(e){if(!Number.isSafeInteger(e)||e<0)throw new Error(`Received an invalid integer type: ${e}`);return`0x${e.toString(16)}`};s.intToBuffer=function(e){const r=(0,s.intToHex)(e);return t.from((0,n.padToEven)(r.slice(2)),"hex")};s.zeros=function(e){return t.allocUnsafe(e).fill(0)};const a=function(e,t,r){const n=(0,s.zeros)(t);return r?e.length<t?(e.copy(n),n):e.slice(0,t):e.length<t?(e.copy(n,t-e.length),n):e.slice(-t)};s.setLengthLeft=function(e,t){return(0,r.assertIsBuffer)(e),a(e,t,!1)};s.setLengthRight=function(e,t){return(0,r.assertIsBuffer)(e),a(e,t,!0)};const o=function(e){let t=e[0];for(;e.length>0&&"0"===t.toString();)t=(e=e.slice(1))[0];return e};s.unpadBuffer=function(e){return(0,r.assertIsBuffer)(e),o(e)};s.unpadArray=function(e){return(0,r.assertIsArray)(e),o(e)};s.unpadHexString=function(e){return(0,r.assertIsHexString)(e),e=(0,n.stripHexPrefix)(e),"0x"+o(e)};s.toBuffer=function(e){if(null===e||e===undefined)return t.allocUnsafe(0);if(t.isBuffer(e))return t.from(e);if(Array.isArray(e)||e instanceof Uint8Array)return t.from(e);if("string"==typeof e){if(!(0,n.isHexString)(e))throw new Error(`Cannot convert string to buffer. toBuffer only supports 0x-prefixed hex strings and this string was given: ${e}`);return t.from((0,n.padToEven)((0,n.stripHexPrefix)(e)),"hex")}if("number"==typeof e)return(0,s.intToBuffer)(e);if("bigint"==typeof e){if(e<BigInt(0))throw new Error(`Cannot convert negative bigint to buffer. Given: ${e}`);let s=e.toString(16);return s.length%2&&(s="0"+s),t.from(s,"hex")}if(e.toArray)return t.from(e.toArray());if(e.toBuffer)return t.from(e.toBuffer());throw new Error("invalid type")};function i(e){const t=(0,s.bufferToHex)(e);return"0x"===t?BigInt(0):BigInt(t)}function m(e){return(0,s.toBuffer)("0x"+e.toString(16))}s.bufferToHex=function(e){return"0x"+(e=(0,s.toBuffer)(e)).toString("hex")},s.bufferToBigInt=i,s.bigIntToBuffer=m;s.bufferToInt=function(e){const t=Number(i(e));if(!Number.isSafeInteger(t))throw new Error("Number exceeds 53 bits");return t};s.fromSigned=function(e){return BigInt.asIntN(256,i(e))};s.toUnsigned=function(e){return m(BigInt.asUintN(256,e))};s.addHexPrefix=function(e){return"string"!=typeof e||(0,n.isHexPrefixed)(e)?e:"0x"+e},s.short=function(e,s=50){const r=t.isBuffer(e)?e.toString("hex"):e;return r.length<=s?r:r.slice(0,s)+"…"};s.toUtf8=function(e){if((e=(0,n.stripHexPrefix)(e)).length%2!=0)throw new Error("Invalid non-even hex string input for toUtf8() provided");return t.from(e.replace(/^(00)+|(00)+$/g,""),"hex").toString("utf8")};s.baToJSON=function(e){if(t.isBuffer(e))return`0x${e.toString("hex")}`;if(e instanceof Array){const t=[];for(let r=0;r<e.length;r++)t.push((0,s.baToJSON)(e[r]));return t}};s.validateNoLeadingZeroes=function(e){for(const[t,s]of Object.entries(e))if(s!==undefined&&s.length>0&&0===s[0])throw new Error(`${t} cannot have leading zeroes, received: ${s.toString("hex")}`)},s.arrToBufArr=function e(s){return Array.isArray(s)?s.map((t=>e(t))):t.from(s)},s.bufArrToArr=function e(t){return Array.isArray(t)?t.map((t=>e(t))):Uint8Array.from(t??[])};s.bigIntToHex=e=>"0x"+e.toString(16),s.bigIntToUnpaddedBuffer=function(e){return(0,s.unpadBuffer)(m(e))},s.intToUnpaddedBuffer=function(e){return(0,s.unpadBuffer)((0,s.intToBuffer)(e))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.MAX_WITHDRAWALS_PER_PAYLOAD=s.RLP_EMPTY_STRING=s.KECCAK256_RLP=s.KECCAK256_RLP_S=s.KECCAK256_RLP_ARRAY=s.KECCAK256_RLP_ARRAY_S=s.KECCAK256_NULL=s.KECCAK256_NULL_S=s.TWO_POW256=s.SECP256K1_ORDER_DIV_2=s.SECP256K1_ORDER=s.MAX_INTEGER_BIGINT=s.MAX_INTEGER=s.MAX_UINT64=void 0;const r=e("buffer"),n=e("ethereum-cryptography/secp256k1");s.MAX_UINT64=BigInt("0xffffffffffffffff"),s.MAX_INTEGER=BigInt("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),s.MAX_INTEGER_BIGINT=BigInt("115792089237316195423570985008687907853269984665640564039457584007913129639935"),s.SECP256K1_ORDER=n.secp256k1.CURVE.n,s.SECP256K1_ORDER_DIV_2=n.secp256k1.CURVE.n/BigInt(2),s.TWO_POW256=BigInt("0x10000000000000000000000000000000000000000000000000000000000000000"),s.KECCAK256_NULL_S="c5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",s.KECCAK256_NULL=r.Buffer.from(s.KECCAK256_NULL_S,"hex"),s.KECCAK256_RLP_ARRAY_S="1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",s.KECCAK256_RLP_ARRAY=r.Buffer.from(s.KECCAK256_RLP_ARRAY_S,"hex"),s.KECCAK256_RLP_S="56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",s.KECCAK256_RLP=r.Buffer.from(s.KECCAK256_RLP_S,"hex"),s.RLP_EMPTY_STRING=r.Buffer.from([128]),s.MAX_WITHDRAWALS_PER_PAYLOAD=16}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/encoding.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.compactBytesToNibbles=s.bytesToNibbles=s.nibblesToCompactBytes=s.nibblesToBytes=s.hasTerminator=void 0;s.hasTerminator=e=>e.length>0&&16===e[e.length-1];s.nibblesToBytes=(e,t)=>{for(let s=0,r=0;r<e.length;s+=1,r+=2)t[s]=e[r]<<4|e[r+1]};s.nibblesToCompactBytes=e=>{let t=0;(0,s.hasTerminator)(e)&&(t=1,e=e.subarray(0,e.length-1));const r=new Uint8Array(e.length/2+1);return r[0]=t<<5,1&~e.length||(r[0]|=16,r[0]|=e[0],e=e.subarray(1)),(0,s.nibblesToBytes)(e,r.subarray(1)),r};s.bytesToNibbles=e=>{const t=2*e.length+1,s=new Uint8Array(t);for(let t=0;t<e.length;t++){const r=e[t];s[2*t]=r/16,s[2*t+1]=r%16}return s[t-1]=16,s};s.compactBytesToNibbles=e=>{if(0===e.length)return e;let t=(0,s.bytesToNibbles)(e);t[0]<2&&(t=t.subarray(0,t.length-1));const r=2-(1&t[0]);return t.subarray(r)}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/encoding.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js",{"../../../../../../../../../is-buffer/index.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/is-buffer/index.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.assertIsString=s.assertIsArray=s.assertIsBuffer=s.assertIsHexString=void 0;const r=e("./internal");s.assertIsHexString=function(e){if(!(0,r.isHexString)(e)){throw new Error(`This method only supports 0x-prefixed hex strings but input was: ${e}`)}};s.assertIsBuffer=function(e){if(!t.isBuffer(e)){throw new Error(`This method only supports Buffer but input was: ${e}`)}};s.assertIsArray=function(e){if(!Array.isArray(e)){throw new Error(`This method only supports number arrays but input was: ${e}`)}};s.assertIsString=function(e){if("string"!=typeof e){throw new Error(`This method only supports strings but input was: ${e}`)}}}).call(this)}).call(this,{isBuffer:e("../../../../../../../../../is-buffer/index.js")})}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js",{"./account":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/account.js","./address":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/address.js","./asyncEventEmitter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js","./encoding":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/encoding.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js","./lock":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/lock.js","./provider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/provider.js","./signature":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/signature.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/types.js","./units":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/units.js","./withdrawal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/withdrawal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),s.toAscii=s.stripHexPrefix=s.padToEven=s.isHexString=s.isHexPrefixed=s.getKeys=s.getBinarySize=s.fromUtf8=s.fromAscii=s.arrayContainsArray=void 0,n(e("./constants"),s),n(e("./units"),s),n(e("./account"),s),n(e("./address"),s),n(e("./withdrawal"),s),n(e("./signature"),s),n(e("./bytes"),s),n(e("./types"),s),n(e("./encoding"),s),n(e("./asyncEventEmitter"),s);var a=e("./internal");Object.defineProperty(s,"arrayContainsArray",{enumerable:!0,get:function(){return a.arrayContainsArray}}),Object.defineProperty(s,"fromAscii",{enumerable:!0,get:function(){return a.fromAscii}}),Object.defineProperty(s,"fromUtf8",{enumerable:!0,get:function(){return a.fromUtf8}}),Object.defineProperty(s,"getBinarySize",{enumerable:!0,get:function(){return a.getBinarySize}}),Object.defineProperty(s,"getKeys",{enumerable:!0,get:function(){return a.getKeys}}),Object.defineProperty(s,"isHexPrefixed",{enumerable:!0,get:function(){return a.isHexPrefixed}}),Object.defineProperty(s,"isHexString",{enumerable:!0,get:function(){return a.isHexString}}),Object.defineProperty(s,"padToEven",{enumerable:!0,get:function(){return a.padToEven}}),Object.defineProperty(s,"stripHexPrefix",{enumerable:!0,get:function(){return a.stripHexPrefix}}),Object.defineProperty(s,"toAscii",{enumerable:!0,get:function(){return a.toAscii}}),n(e("./lock"),s),n(e("./provider"),s)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(e){(function(){function t(e){if("string"!=typeof e)throw new Error("[isHexPrefixed] input must be type 'string', received type "+typeof e);return"0"===e[0]&&"x"===e[1]}Object.defineProperty(s,"__esModule",{value:!0}),s.isHexString=s.getKeys=s.fromAscii=s.fromUtf8=s.toAscii=s.arrayContainsArray=s.getBinarySize=s.padToEven=s.stripHexPrefix=s.isHexPrefixed=void 0,s.isHexPrefixed=t;function r(e){let t=e;if("string"!=typeof t)throw new Error("[padToEven] value must be type 'string', received "+typeof t);return t.length%2&&(t=`0${t}`),t}s.stripHexPrefix=e=>{if("string"!=typeof e)throw new Error("[stripHexPrefix] input must be type 'string', received "+typeof e);return t(e)?e.slice(2):e},s.padToEven=r,s.getBinarySize=function(t){if("string"!=typeof t)throw new Error("[getBinarySize] method requires input type 'string', received "+typeof t);return e.byteLength(t,"utf8")},s.arrayContainsArray=function(e,t,s){if(!0!==Array.isArray(e))throw new Error(`[arrayContainsArray] method requires input 'superset' to be an array, got type '${typeof e}'`);if(!0!==Array.isArray(t))throw new Error(`[arrayContainsArray] method requires input 'subset' to be an array, got type '${typeof t}'`);return t[!0===s?"some":"every"]((t=>e.indexOf(t)>=0))},s.toAscii=function(e){let t="",s=0;const r=e.length;for("0x"===e.substring(0,2)&&(s=2);s<r;s+=2){const r=parseInt(e.substr(s,2),16);t+=String.fromCharCode(r)}return t},s.fromUtf8=function(t){return`0x${r(e.from(t,"utf8").toString("hex")).replace(/^0+|0+$/g,"")}`},s.fromAscii=function(e){let t="";for(let s=0;s<e.length;s++){const r=e.charCodeAt(s).toString(16);t+=r.length<2?`0${r}`:r}return`0x${t}`},s.getKeys=function(e,t,s){if(!Array.isArray(e))throw new Error("[getKeys] method expects input 'params' to be an array, got "+typeof e);if("string"!=typeof t)throw new Error("[getKeys] method expects input 'key' to be type 'string', got "+typeof e);const r=[];for(let n=0;n<e.length;n++){let a=e[n][t];if(!0!==s||a){if("string"!=typeof a)throw new Error("invalid abi - expected type 'string', received "+typeof a)}else a="";r.push(a)}return r},s.isHexString=function(e,t){return!("string"!=typeof e||!e.match(/^0x[0-9A-Fa-f]*$/))&&!(void 0!==t&&t>0&&e.length!==2+2*t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/lock.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.Lock=void 0;s.Lock=class{constructor(){this.permits=1,this.promiseResolverQueue=[]}async acquire(){return this.permits>0?(this.permits-=1,Promise.resolve(!0)):new Promise((e=>this.promiseResolverQueue.push(e)))}release(){if(this.permits+=1,this.permits>1&&this.promiseResolverQueue.length>0)console.warn("Lock.permits should never be > 0 when there is someone waiting.");else if(1===this.permits&&this.promiseResolverQueue.length>0){this.permits-=1;const e=this.promiseResolverQueue.shift();e&&e(!0)}}}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/lock.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/provider.js",{"micro-ftch":"/home/runner/work/metamask-extension/metamask-extension/node_modules/micro-ftch/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.getProvider=s.fetchFromProvider=void 0;const r=e("micro-ftch");s.fetchFromProvider=async(e,t)=>(await(0,r.default)(e,{headers:{"content-type":"application/json"},type:"json",data:{method:t.method,params:t.params,jsonrpc:"2.0",id:1}})).result;s.getProvider=e=>{if("string"==typeof e)return e;if(e?.connection?.url!==undefined)return e.connection.url;throw new Error("Must provide valid provider URL or Web3Provider")}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/provider.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/signature.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js","./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.hashPersonalMessage=s.isValidSignature=s.fromRpcSig=s.toCompactSig=s.toRpcSig=s.ecrecover=s.ecsign=void 0;const r=e("ethereum-cryptography/keccak"),n=e("ethereum-cryptography/secp256k1"),a=e("./bytes"),o=e("./constants"),i=e("./helpers");function m(e,t){return e===BigInt(0)||e===BigInt(1)?e:t===undefined?e-BigInt(27):e-(t*BigInt(2)+BigInt(35))}function c(e){return e===BigInt(0)||e===BigInt(1)}s.ecsign=function(e,s,r){const a=n.secp256k1.sign(e,s),o=a.toCompactRawBytes();return{r:t.from(o.slice(0,32)),s:t.from(o.slice(32,64)),v:r===undefined?BigInt(a.recovery+27):BigInt(a.recovery+35)+BigInt(r)*BigInt(2)}};s.ecrecover=function(e,s,r,o,i){const d=t.concat([(0,a.setLengthLeft)(r,32),(0,a.setLengthLeft)(o,32)],64),u=m(s,i);if(!c(u))throw new Error("Invalid signature v value");const l=n.secp256k1.Signature.fromCompact(d).addRecoveryBit(Number(u)).recoverPublicKey(e);return t.from(l.toRawBytes(!1).slice(1))};s.toRpcSig=function(e,s,r,n){if(!c(m(e,n)))throw new Error("Invalid signature v value");return(0,a.bufferToHex)(t.concat([(0,a.setLengthLeft)(s,32),(0,a.setLengthLeft)(r,32),(0,a.toBuffer)(e)]))};s.toCompactSig=function(e,s,r,n){if(!c(m(e,n)))throw new Error("Invalid signature v value");let o=r;return(e>BigInt(28)&&e%BigInt(2)===BigInt(1)||e===BigInt(1)||e===BigInt(28))&&(o=t.from(r),o[0]|=128),(0,a.bufferToHex)(t.concat([(0,a.setLengthLeft)(s,32),(0,a.setLengthLeft)(o,32)]))};s.fromRpcSig=function(e){const t=(0,a.toBuffer)(e);let s,r,n;if(t.length>=65)s=t.slice(0,32),r=t.slice(32,64),n=(0,a.bufferToBigInt)(t.slice(64));else{if(64!==t.length)throw new Error("Invalid signature length");s=t.slice(0,32),r=t.slice(32,64),n=BigInt((0,a.bufferToInt)(t.slice(32,33))>>7),r[0]&=127}return n<27&&(n+=BigInt(27)),{v:n,r:s,s:r}};s.isValidSignature=function(e,t,s,r=!0,n){if(32!==t.length||32!==s.length)return!1;if(!c(m(e,n)))return!1;const i=(0,a.bufferToBigInt)(t),d=(0,a.bufferToBigInt)(s);return!(i===BigInt(0)||i>=o.SECP256K1_ORDER||d===BigInt(0)||d>=o.SECP256K1_ORDER)&&!(r&&d>=o.SECP256K1_ORDER_DIV_2)};s.hashPersonalMessage=function(e){(0,i.assertIsBuffer)(e);const s=t.from(`Ethereum Signed Message:\n${e.length}`,"utf-8");return t.from((0,r.keccak256)(t.concat([s,e])))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/signature.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/types.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.toType=s.TypeOutput=void 0;const r=e("./bytes"),n=e("./internal");var a;!function(e){e[e.Number=0]="Number",e[e.BigInt=1]="BigInt",e[e.Buffer=2]="Buffer",e[e.PrefixedHexString=3]="PrefixedHexString"}(a=s.TypeOutput||(s.TypeOutput={})),s.toType=function(e,t){if(null===e)return null;if(e===undefined)return undefined;if("string"==typeof e&&!(0,n.isHexString)(e))throw new Error(`A string must be provided with a 0x-prefix, given: ${e}`);if("number"==typeof e&&!Number.isSafeInteger(e))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative input type)");const s=(0,r.toBuffer)(e);switch(t){case a.Buffer:return s;case a.BigInt:return(0,r.bufferToBigInt)(s);case a.Number:{const e=(0,r.bufferToBigInt)(s);if(e>BigInt(Number.MAX_SAFE_INTEGER))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative output type)");return Number(e)}case a.PrefixedHexString:return(0,r.bufferToHex)(s);default:throw new Error("unknown outputType")}}}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/types.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/units.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.GWEI_TO_WEI=void 0,s.GWEI_TO_WEI=BigInt(1e9)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/units.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/withdrawal.js",{"./address":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/address.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/types.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.Withdrawal=void 0;const r=e("./address"),n=e("./bytes"),a=e("./types");class o{constructor(e,t,s,r){this.index=e,this.validatorIndex=t,this.address=s,this.amount=r}static fromWithdrawalData(e){const{index:t,validatorIndex:s,address:n,amount:i}=e,m=(0,a.toType)(t,a.TypeOutput.BigInt),c=(0,a.toType)(s,a.TypeOutput.BigInt),d=new r.Address((0,a.toType)(n,a.TypeOutput.Buffer)),u=(0,a.toType)(i,a.TypeOutput.BigInt);return new o(m,c,d,u)}static fromValuesArray(e){if(4!==e.length)throw Error(`Invalid withdrawalArray length expected=4 actual=${e.length}`);const[t,s,r,n]=e;return o.fromWithdrawalData({index:t,validatorIndex:s,address:r,amount:n})}static toBufferArray(e){const{index:s,validatorIndex:n,address:o,amount:i}=e,m=(0,a.toType)(s,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(s,a.TypeOutput.Buffer),c=(0,a.toType)(n,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(n,a.TypeOutput.Buffer);let d;d=o instanceof r.Address?o.buf:(0,a.toType)(o,a.TypeOutput.Buffer);return[m,c,d,(0,a.toType)(i,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(i,a.TypeOutput.Buffer)]}raw(){return o.toBufferArray(this)}toValue(){return{index:this.index,validatorIndex:this.validatorIndex,address:this.address.buf,amount:this.amount}}toJSON(){return{index:(0,n.bigIntToHex)(this.index),validatorIndex:(0,n.bigIntToHex)(this.validatorIndex),address:"0x"+this.address.buf.toString("hex"),amount:(0,n.bigIntToHex)(this.amount)}}}s.Withdrawal=o}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/withdrawal.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-hd-keyring/node_modules/@scure/base/lib/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function r(e){if(!Number.isSafeInteger(e))throw new Error(`Wrong integer: ${e}`)}function n(e){return e instanceof Uint8Array||null!=e&&"object"==typeof e&&"Uint8Array"===e.constructor.name}function a(...e){const t=e=>e,s=(e,t)=>s=>e(t(s));return{encode:e.map((e=>e.encode)).reduceRight(s,t),decode:e.map((e=>e.decode)).reduce(s,t)}}function o(e){return{encode:t=>{if(!Array.isArray(t)||t.length&&"number"!=typeof t[0])throw new Error("alphabet.encode input should be an array of numbers");return t.map((t=>{if(r(t),t<0||t>=e.length)throw new Error(`Digit index outside alphabet: ${t} (alphabet: ${e.length})`);return e[t]}))},decode:t=>{if(!Array.isArray(t)||t.length&&"string"!=typeof t[0])throw new Error("alphabet.decode input should be array of strings");return t.map((t=>{if("string"!=typeof t)throw new Error(`alphabet.decode: not string element=${t}`);const s=e.indexOf(t);if(-1===s)throw new Error(`Unknown letter: "${t}". Allowed: ${e}`);return s}))}}}function i(e=""){if("string"!=typeof e)throw new Error("join separator should be string");return{encode:t=>{if(!Array.isArray(t)||t.length&&"string"!=typeof t[0])throw new Error("join.encode input should be array of strings");for(let e of t)if("string"!=typeof e)throw new Error(`join.encode: non-string input=${e}`);return t.join(e)},decode:t=>{if("string"!=typeof t)throw new Error("join.decode input should be string");return t.split(e)}}}function m(e,t="="){if(r(e),"string"!=typeof t)throw new Error("padding chr should be string");return{encode(s){if(!Array.isArray(s)||s.length&&"string"!=typeof s[0])throw new Error("padding.encode input should be array of strings");for(let e of s)if("string"!=typeof e)throw new Error(`padding.encode: non-string input=${e}`);for(;s.length*e%8;)s.push(t);return s},decode(s){if(!Array.isArray(s)||s.length&&"string"!=typeof s[0])throw new Error("padding.encode input should be array of strings");for(let e of s)if("string"!=typeof e)throw new Error(`padding.decode: non-string input=${e}`);let r=s.length;if(r*e%8)throw new Error("Invalid padding: string should have whole number of bytes");for(;r>0&&s[r-1]===t;r--)if(!((r-1)*e%8))throw new Error("Invalid padding: string has too much padding");return s.slice(0,r)}}}function c(e){if("function"!=typeof e)throw new Error("normalize fn should be function");return{encode:e=>e,decode:t=>e(t)}}function d(e,t,s){if(t<2)throw new Error(`convertRadix: wrong from=${t}, base cannot be less than 2`);if(s<2)throw new Error(`convertRadix: wrong to=${s}, base cannot be less than 2`);if(!Array.isArray(e))throw new Error("convertRadix: data should be array");if(!e.length)return[];let n=0;const a=[],o=Array.from(e);for(o.forEach((e=>{if(r(e),e<0||e>=t)throw new Error(`Wrong integer: ${e}`)}));;){let e=0,r=!0;for(let a=n;a<o.length;a++){const i=o[a],m=t*e+i;if(!Number.isSafeInteger(m)||t*e/t!==e||m-i!=t*e)throw new Error("convertRadix: carry overflow");e=m%s;const c=Math.floor(m/s);if(o[a]=c,!Number.isSafeInteger(c)||c*s+e!==m)throw new Error("convertRadix: carry overflow");r&&(c?r=!1:n=a)}if(a.push(e),r)break}for(let t=0;t<e.length-1&&0===e[t];t++)a.push(0);return a.reverse()}
/*! scure-base - MIT License (c) 2022 Paul Miller (paulmillr.com) */
Object.defineProperty(s,"__esModule",{value:!0}),s.bytes=s.stringToBytes=s.str=s.bytesToString=s.hex=s.utf8=s.bech32m=s.bech32=s.base58check=s.createBase58check=s.base58xmr=s.base58xrp=s.base58flickr=s.base58=s.base64urlnopad=s.base64url=s.base64nopad=s.base64=s.base32crockford=s.base32hexnopad=s.base32hex=s.base32nopad=s.base32=s.base16=s.utils=void 0,s.assertNumber=r;const u=(e,t)=>t?u(t,e%t):e,l=(e,t)=>e+(t-u(e,t));function f(e,t,s,n){if(!Array.isArray(e))throw new Error("convertRadix2: data should be array");if(t<=0||t>32)throw new Error(`convertRadix2: wrong from=${t}`);if(s<=0||s>32)throw new Error(`convertRadix2: wrong to=${s}`);if(l(t,s)>32)throw new Error(`convertRadix2: carry overflow from=${t} to=${s} carryBits=${l(t,s)}`);let a=0,o=0;const i=2**s-1,m=[];for(const n of e){if(r(n),n>=2**t)throw new Error(`convertRadix2: invalid data word=${n} from=${t}`);if(a=a<<t|n,o+t>32)throw new Error(`convertRadix2: carry overflow pos=${o} from=${t}`);for(o+=t;o>=s;o-=s)m.push((a>>o-s&i)>>>0);a&=2**o-1}if(a=a<<s-o&i,!n&&o>=t)throw new Error("Excess padding");if(!n&&a)throw new Error(`Non-zero padding: ${a}`);return n&&o>0&&m.push(a>>>0),m}function h(e){return r(e),{encode:t=>{if(!n(t))throw new Error("radix.encode input should be Uint8Array");return d(Array.from(t),256,e)},decode:t=>{if(!Array.isArray(t)||t.length&&"number"!=typeof t[0])throw new Error("radix.decode input should be array of numbers");return Uint8Array.from(d(t,e,256))}}}function p(e,t=!1){if(r(e),e<=0||e>32)throw new Error("radix2: bits should be in (0..32]");if(l(8,e)>32||l(e,8)>32)throw new Error("radix2: carry overflow");return{encode:s=>{if(!n(s))throw new Error("radix2.encode input should be Uint8Array");return f(Array.from(s),8,e,!t)},decode:s=>{if(!Array.isArray(s)||s.length&&"number"!=typeof s[0])throw new Error("radix2.decode input should be array of numbers");return Uint8Array.from(f(s,e,8,t))}}}function g(e){if("function"!=typeof e)throw new Error("unsafeWrapper fn should be function");return function(...t){try{return e.apply(null,t)}catch(e){}}}function k(e,t){if(r(e),"function"!=typeof t)throw new Error("checksum fn should be function");return{encode(s){if(!n(s))throw new Error("checksum.encode: input should be Uint8Array");const r=t(s).slice(0,e),a=new Uint8Array(s.length+e);return a.set(s),a.set(r,s.length),a},decode(s){if(!n(s))throw new Error("checksum.decode: input should be Uint8Array");const r=s.slice(0,-e),a=t(r).slice(0,e),o=s.slice(-e);for(let t=0;t<e;t++)if(a[t]!==o[t])throw new Error("Invalid checksum");return r}}}s.utils={alphabet:o,chain:a,checksum:k,convertRadix:d,convertRadix2:f,radix:h,radix2:p,join:i,padding:m},s.base16=a(p(4),o("0123456789ABCDEF"),i("")),s.base32=a(p(5),o("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),m(5),i("")),s.base32nopad=a(p(5),o("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),i("")),s.base32hex=a(p(5),o("0123456789ABCDEFGHIJKLMNOPQRSTUV"),m(5),i("")),s.base32hexnopad=a(p(5),o("0123456789ABCDEFGHIJKLMNOPQRSTUV"),i("")),s.base32crockford=a(p(5),o("0123456789ABCDEFGHJKMNPQRSTVWXYZ"),i(""),c((e=>e.toUpperCase().replace(/O/g,"0").replace(/[IL]/g,"1")))),s.base64=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),m(6),i("")),s.base64nopad=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),i("")),s.base64url=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),m(6),i("")),s.base64urlnopad=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),i(""));const b=e=>a(h(58),o(e),i(""));s.base58=b("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz"),s.base58flickr=b("123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ"),s.base58xrp=b("rpshnaf39wBUDNEGHJKLM4PQRST7VWXYZ2bcdeCg65jkm8oFqi1tuvAxyz");const y=[0,2,3,5,6,7,9,10,11];s.base58xmr={encode(e){let t="";for(let r=0;r<e.length;r+=8){const n=e.subarray(r,r+8);t+=s.base58.encode(n).padStart(y[n.length],"1")}return t},decode(e){let t=[];for(let r=0;r<e.length;r+=11){const n=e.slice(r,r+11),a=y.indexOf(n.length),o=s.base58.decode(n);for(let e=0;e<o.length-a;e++)if(0!==o[e])throw new Error("base58xmr: wrong padding");t=t.concat(Array.from(o.slice(o.length-a)))}return Uint8Array.from(t)}};s.createBase58check=e=>a(k(4,(t=>e(e(t)))),s.base58),s.base58check=s.createBase58check;const x=a(o("qpzry9x8gf2tvdw0s3jn54khce6mua7l"),i("")),w=[996825010,642813549,513874426,1027748829,705979059];function E(e){const t=e>>25;let s=(33554431&e)<<5;for(let e=0;e<w.length;e++)1==(t>>e&1)&&(s^=w[e]);return s}function _(e,t,s=1){const r=e.length;let n=1;for(let t=0;t<r;t++){const s=e.charCodeAt(t);if(s<33||s>126)throw new Error(`Invalid prefix (${e})`);n=E(n)^s>>5}n=E(n);for(let t=0;t<r;t++)n=E(n)^31&e.charCodeAt(t);for(let e of t)n=E(n)^e;for(let e=0;e<6;e++)n=E(n);return n^=s,x.encode(f([n%2**30],30,5,!1))}function v(e){const t="bech32"===e?1:734539939,s=p(5),r=s.decode,n=s.encode,a=g(r);function o(e,s,r=90){if("string"!=typeof e)throw new Error("bech32.encode prefix should be string, not "+typeof e);if(s instanceof Uint8Array&&(s=Array.from(s)),!Array.isArray(s)||s.length&&"number"!=typeof s[0])throw new Error("bech32.encode words should be array of numbers, not "+typeof s);if(0===e.length)throw new TypeError(`Invalid prefix length ${e.length}`);const n=e.length+7+s.length;if(!1!==r&&n>r)throw new TypeError(`Length ${n} exceeds limit ${r}`);const a=e.toLowerCase(),o=_(a,s,t);return`${a}1${x.encode(s)}${o}`}function i(e,s=90){if("string"!=typeof e)throw new Error("bech32.decode input should be string, not "+typeof e);if(e.length<8||!1!==s&&e.length>s)throw new TypeError(`Wrong string length: ${e.length} (${e}). Expected (8..${s})`);const r=e.toLowerCase();if(e!==r&&e!==e.toUpperCase())throw new Error("String must be lowercase or uppercase");const n=r.lastIndexOf("1");if(0===n||-1===n)throw new Error('Letter "1" must be present between prefix and data only');const a=r.slice(0,n),o=r.slice(n+1);if(o.length<6)throw new Error("Data must be at least 6 characters long");const i=x.decode(o).slice(0,-6),m=_(a,i,t);if(!o.endsWith(m))throw new Error(`Invalid checksum in ${e}: expected "${m}"`);return{prefix:a,words:i}}return{encode:o,decode:i,encodeFromBytes:function(e,t){return o(e,n(t))},decodeToBytes:function(e){const{prefix:t,words:s}=i(e,!1);return{prefix:t,words:s,bytes:r(s)}},decodeUnsafe:g(i),fromWords:r,fromWordsUnsafe:a,toWords:n}}s.bech32=v("bech32"),s.bech32m=v("bech32m"),s.utf8={encode:e=>(new TextDecoder).decode(e),decode:e=>(new TextEncoder).encode(e)},s.hex=a(p(4),o("0123456789abcdef"),i(""),c((e=>{if("string"!=typeof e||e.length%2)throw new TypeError(`hex.decode: expected string, got ${typeof e} with length ${e.length}`);return e.toLowerCase()})));const A={utf8:s.utf8,hex:s.hex,base16:s.base16,base32:s.base32,base64:s.base64,base64url:s.base64url,base58:s.base58,base58xmr:s.base58xmr},T="Invalid encoding type. Available types: utf8, hex, base16, base32, base64, base64url, base58, base58xmr";s.bytesToString=(e,t)=>{if("string"!=typeof e||!A.hasOwnProperty(e))throw new TypeError(T);if(!n(t))throw new TypeError("bytesToString() expects Uint8Array");return A[e].encode(t)},s.str=s.bytesToString;s.stringToBytes=(e,t)=>{if(!A.hasOwnProperty(e))throw new TypeError(T);if("string"!=typeof t)throw new TypeError("stringToBytes() expects string");return A[e].decode(t)},s.bytes=s.stringToBytes}}},{package:"@metamask/keyring-controller>@metamask/eth-hd-keyring>@metamask/eth-sig-util>@scure/base",file:"node_modules/@metamask/eth-hd-keyring/node_modules/@scure/base/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/create-infura-middleware.js",{"./fetch-config-from-req":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/fetch-config-from-req.js","./logging-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/logging-utils.js","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createInfuraMiddlewareWithoutRpcService=s.createInfuraMiddleware=void 0;const r=e("@metamask/json-rpc-engine"),n=e("@metamask/rpc-errors"),a=e("./fetch-config-from-req"),o=e("./logging-utils"),i=(0,o.createModuleLogger)(o.projectLogger,"create-infura-middleware"),m=["Gateway timeout","ETIMEDOUT","ECONNRESET","SyntaxError"];function c({network:e="mainnet",maxAttempts:t=5,source:s,projectId:n,headers:a={}}){if(!n||"string"!=typeof n)throw new Error(`Invalid value for 'projectId': "${n}"`);if(!a||"object"!=typeof a)throw new Error(`Invalid value for 'headers': "${a}"`);if(!t)throw new Error(`Invalid value for 'maxAttempts': "${t}" (${typeof t})`);return(0,r.createAsyncMiddleware)((async(r,o)=>{for(let m=1;m<=t;m++)try{i("Attempting request to Infura. network = %o, projectId = %s, headers = %o, req = %o",e,n,a,r),await d(e,n,a,r,o,s);break}catch(e){if(!l(e))throw i("Non-retriable request error encountered. req = %o, res = %o, error = %o",r,o,e),e;if(!(t-m)){i("Retriable request error encountered, but exceeded max attempts. req = %o, res = %o, error = %o",r,o,e);const t=`InfuraProvider - cannot complete request. All retries exhausted.\nOriginal Error:\n${e.toString()}\n\n`;throw new Error(t)}i("Retriable request error encountered. req = %o, res = %o, error = %o",r,o,e),i("Waiting 1 second to try again..."),await f(1e3)}}))}async function d(e,t,s,r,o,i){const{fetchUrl:m,fetchParams:c}=(0,a.fetchConfigFromReq)({network:e,projectId:t,extraHeaders:s,req:r,source:i}),d=await fetch(m,c),l=await d.text();if(!d.ok)switch(d.status){case 405:throw n.rpcErrors.methodNotFound();case 429:throw u("Request is being rate limited.");case 503:case 504:throw function(){let e="Gateway timeout. The request took too long to process. ";return e+="This can happen when querying logs over too wide a block range.",u(e)}();default:throw u(l)}if("eth_getBlockByNumber"===r.method&&"Not Found"===l)return void(o.result=null);const f=JSON.parse(l);o.result=f.result,o.error=f.error}function u(e){return n.rpcErrors.internal(e)}function l(e){const t=e.toString();return m.some((e=>t.includes(e)))}async function f(e){return new Promise((t=>{setTimeout(t,e)}))}s.createInfuraMiddleware=function(e){return"rpcService"in e?function({rpcService:e,options:t={}}){const{source:s,headers:n={}}=t;return(0,r.createAsyncMiddleware)((async(t,r)=>{const a=s!==undefined&&t.origin!==undefined?Object.assign(Object.assign({},n),{"Infura-Source":`${s}/${t.origin}`}):n,o=await e.request({id:t.id,jsonrpc:t.jsonrpc,method:t.method,params:t.params},{headers:a});"error"in o?r.error=o.error:(r.result=o.result,r.error=undefined)}))}(e):c(e)},s.createInfuraMiddlewareWithoutRpcService=c}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/create-infura-middleware.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/create-provider.js",{"./create-infura-middleware":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/create-infura-middleware.js","@metamask/eth-json-rpc-provider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/index.cjs","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createProvider=void 0;const r=e("@metamask/eth-json-rpc-provider"),n=e("@metamask/json-rpc-engine"),a=e("./create-infura-middleware");s.createProvider=function(e){const t=new n.JsonRpcEngine;return t.push((0,a.createInfuraMiddleware)(e)),(0,r.providerFromEngine)(t)}}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/create-provider.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/fetch-config-from-req.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function r(e){return{id:e.id,jsonrpc:e.jsonrpc,method:e.method,params:e.params}}Object.defineProperty(s,"__esModule",{value:!0}),s.fetchConfigFromReq=void 0,s.fetchConfigFromReq=function({network:e,projectId:t,extraHeaders:s={},req:n,source:a}){const o=n.origin||"internal",i=Object.assign({},s,{Accept:"application/json","Content-Type":"application/json"});return a&&(i["Infura-Source"]=`${a}/${o}`),{fetchUrl:`https://${e}.infura.io/v3/${t}`,fetchParams:{method:"POST",headers:i,body:JSON.stringify(r(n))}}}}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/fetch-config-from-req.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/index.js",{"./create-infura-middleware":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/create-infura-middleware.js","./create-provider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/create-provider.js","./fetch-config-from-req":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/fetch-config-from-req.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./create-infura-middleware"),s),n(e("./fetch-config-from-req"),s),n(e("./create-provider"),s)}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-infura/dist/logging-utils.js",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createModuleLogger=s.projectLogger=void 0;const r=e("@metamask/utils");Object.defineProperty(s,"createModuleLogger",{enumerable:!0,get:function(){return r.createModuleLogger}}),s.projectLogger=(0,r.createProjectLogger)("eth-json-rpc-infura")}}},{package:"@metamask/network-controller>@metamask/eth-json-rpc-infura",file:"node_modules/@metamask/eth-json-rpc-infura/dist/logging-utils.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/block-cache.js",{"./logging-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/logging-utils.js","./utils/cache":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/cache.js","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createBlockCacheMiddleware=void 0;const r=e("@metamask/json-rpc-engine"),n=e("./logging-utils"),a=e("./utils/cache"),o=(0,n.createModuleLogger)(n.projectLogger,"block-cache"),i=[undefined,null,"<nil>"];class m{constructor(){this.cache={}}getBlockCache(e){const t=Number.parseInt(e,16);let s=this.cache[t];if(!s){const e={};this.cache[t]=e,s=e}return s}async get(e,t){const s=this.getBlockCache(t),r=(0,a.cacheIdentifierForRequest)(e,!0);return r?s[r]:undefined}async set(e,t,s){if(!this.canCacheResult(e,s))return;const r=(0,a.cacheIdentifierForRequest)(e,!0);if(!r)return;this.getBlockCache(t)[r]=s}canCacheRequest(e){if(!(0,a.canCache)(e.method))return!1;return"pending"!==(0,a.blockTagForRequest)(e)}canCacheResult(e,t){return!i.includes(t)&&!(e.method&&["eth_getTransactionByHash","eth_getTransactionReceipt"].includes(e.method)&&(!t||!t.blockHash||"0x0000000000000000000000000000000000000000000000000000000000000000"===t.blockHash))}clearBefore(e){const t=Number.parseInt(e,16);Object.keys(this.cache).map(Number).filter((e=>e<t)).forEach((e=>delete this.cache[e]))}}s.createBlockCacheMiddleware=function({blockTracker:e}={}){if(!e)throw new Error("createBlockCacheMiddleware - No PollingBlockTracker specified");const t=new m,s={[a.CacheStrategy.Permanent]:t,[a.CacheStrategy.Block]:t,[a.CacheStrategy.Fork]:t,[a.CacheStrategy.Never]:undefined};return(0,r.createAsyncMiddleware)((async(r,n,i)=>{if(r.skipCache)return i();const m=(0,a.cacheTypeForMethod)(r.method),c=s[m];if(!c)return i();if(!c.canCacheRequest(r))return i();const d=(0,a.blockTagForRequest)(r),u=d&&"string"==typeof d?d:"latest";let l;if(o("blockTag = %o, req = %o",u,r),"earliest"===u)l="0x00";else if("latest"===u){o("Fetching latest block number to determine cache key");const s=await e.getLatestBlock();o("Clearing values stored under block numbers before %o",s),t.clearBefore(s),l=s}else l=u;const f=await c.get(r,l);return f===undefined?(o("No cache stored under block number %o, carrying request forward",l),await i(),o("Populating cache with",n),await c.set(r,l,n.result)):(o("Cache hit, reusing cache result stored under block number %o",l),n.result=f),undefined}))}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/block-cache.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/block-ref-rewrite.js",{"./utils/cache":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/cache.js","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createBlockRefRewriteMiddleware=void 0;const r=e("@metamask/json-rpc-engine"),n=e("./utils/cache");s.createBlockRefRewriteMiddleware=function({blockTracker:e}={}){if(!e)throw Error('BlockRefRewriteMiddleware - mandatory "blockTracker" option is missing.');return(0,r.createAsyncMiddleware)((async(t,s,r)=>{const a=(0,n.blockTagParamIndex)(t.method);if(a===undefined)return r();if("latest"!==(Array.isArray(t.params)&&t.params[a]?t.params[a]:"latest"))return r();const o=await e.getLatestBlock();return Array.isArray(t.params)&&(t.params[a]=o),r()}))}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/block-ref-rewrite.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/block-ref.js",{"./logging-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/logging-utils.js","./utils/cache":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/cache.js","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs","klona/full":"/home/runner/work/metamask-extension/metamask-extension/node_modules/klona/full/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createBlockRefMiddleware=void 0;const r=e("@metamask/json-rpc-engine"),n=e("klona/full"),a=e("./logging-utils"),o=e("./utils/cache"),i=(0,a.createModuleLogger)(a.projectLogger,"block-ref");s.createBlockRefMiddleware=function({provider:e,blockTracker:t}={}){if(!e)throw Error('BlockRefMiddleware - mandatory "provider" option is missing.');if(!t)throw Error('BlockRefMiddleware - mandatory "blockTracker" option is missing.');return(0,r.createAsyncMiddleware)((async(s,r,a)=>{var m;const c=(0,o.blockTagParamIndex)(s.method);if(c===undefined)return a();if("latest"!==(Array.isArray(s.params)&&null!==(m=s.params[c])&&void 0!==m?m:"latest"))return i('blockRef is not "latest", carrying request forward'),a();const d=await t.getLatestBlock();i(`blockRef is "latest", setting param ${c} to latest block ${d}`);const u=(0,n.klona)(s);return Array.isArray(u.params)&&(u.params[c]=d),i("Performing another request %o",u),r.result=await e.request(u),undefined}))}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/block-ref.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/block-tracker-inspector.js",{"./logging-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/logging-utils.js","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createBlockTrackerInspectorMiddleware=void 0;const r=e("@metamask/json-rpc-engine"),n=e("./logging-utils"),a=(0,n.createModuleLogger)(n.projectLogger,"block-tracker-inspector"),o=["eth_getTransactionByHash","eth_getTransactionReceipt"];function i(e){const{result:t}=e;return t&&"object"==typeof t&&(s=t,r="blockNumber",Object.hasOwnProperty.call(s,r))&&"string"==typeof t.blockNumber?t.blockNumber:undefined;var s,r}s.createBlockTrackerInspectorMiddleware=function({blockTracker:e}){return(0,r.createAsyncMiddleware)((async(t,s,r)=>{if(!o.includes(t.method))return r();await r();const n=i(s);if(!n)return undefined;a("res.result.blockNumber exists, proceeding. res = %o",s);return Number.parseInt(n,16)>Number.parseInt(e.getCurrentBlock(),16)&&(a("blockNumber from response is greater than current block number, refreshing current block number"),await e.checkForLatestBlock()),undefined}))}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/block-tracker-inspector.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/fetch.js",{"./utils/timeout":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/timeout.js","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createFetchConfigFromReq=s.createFetchMiddleware=void 0;const r=e("@metamask/json-rpc-engine"),n=e("@metamask/rpc-errors"),a=e("./utils/timeout"),o=["Gateway timeout","ETIMEDOUT","failed to parse response body","Failed to fetch"];function i(e){switch(e.status){case 405:throw n.rpcErrors.methodNotFound();case 418:throw n.rpcErrors.internal({message:"Request is being rate limited."});case 503:case 504:throw function(){let e="Gateway timeout. The request took too long to process. ";return e+="This can happen when querying logs over too wide a block range.",n.rpcErrors.internal({message:e})}()}}function m(e,t){if(200!==e.status)throw n.rpcErrors.internal({message:`Non-200 status code: '${e.status}'`,data:t});if(t.error)throw n.rpcErrors.internal({data:t.error});return t.result}function c({btoa:e,req:t,rpcUrl:s,originHttpHeaderKey:r}){const n=new URL(s),a=function(e){let t="";t+=e.protocol,t+=`//${e.hostname}`,e.port&&(t+=`:${e.port}`);return t+=`${e.pathname}`,t+=`${e.search}`,t}(n),o={id:t.id,jsonrpc:t.jsonrpc,method:t.method,params:t.params},i=t.origin,m={method:"POST",headers:{Accept:"application/json","Content-Type":"application/json"},body:JSON.stringify(o)};if(n.username&&n.password){const t=e(`${n.username}:${n.password}`);m.headers.Authorization=`Basic ${t}`}return r&&i&&(m.headers[r]=i),{fetchUrl:a,fetchParams:m}}s.createFetchMiddleware=function(e){return"rpcService"in e?function({rpcService:e,options:t={}}){return(0,r.createAsyncMiddleware)((async(s,r)=>{const a="originHttpHeaderKey"in t&&t.originHttpHeaderKey!==undefined&&s.origin!==undefined?{[t.originHttpHeaderKey]:s.origin}:{},o=await e.request({id:s.id,jsonrpc:s.jsonrpc,method:s.method,params:s.params},{headers:a});if("error"in o)throw n.rpcErrors.internal({data:o.error});r.result=o.result}))}(e):function({btoa:e,fetch:t,rpcUrl:s,originHttpHeaderKey:n}){return(0,r.createAsyncMiddleware)((async(r,d,u)=>{const{fetchUrl:l,fetchParams:f}=c({btoa:e,req:r,rpcUrl:s,originHttpHeaderKey:n}),h=5,p=1e3;for(let e=0;e<h;e++){try{const e=await t(l,f);i(e);const s=await e.text();let r;try{r=JSON.parse(s)}catch(e){throw new Error(`FetchMiddleware - failed to parse response body: "${s}"`)}const n=m(e,r);return void(d.result=n)}catch(e){const t=e.toString();if(!o.some((e=>t.includes(e))))throw e}await(0,a.timeout)(p)}}))}(e)},s.createFetchConfigFromReq=c}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/fetch.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/index.js",{"./block-cache":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/block-cache.js","./block-ref":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/block-ref.js","./block-ref-rewrite":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/block-ref-rewrite.js","./block-tracker-inspector":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/block-tracker-inspector.js","./fetch":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/fetch.js","./inflight-cache":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/inflight-cache.js","./methods/wallet-get-calls-status":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-get-calls-status.js","./providerAsMiddleware":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/providerAsMiddleware.js","./retryOnEmpty":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/retryOnEmpty.js","./wallet":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/wallet.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),s.GetCallsStatusCode=void 0,n(e("./block-cache"),s),n(e("./block-ref-rewrite"),s),n(e("./block-ref"),s),n(e("./block-tracker-inspector"),s),n(e("./fetch"),s),n(e("./inflight-cache"),s);var a=e("./methods/wallet-get-calls-status");Object.defineProperty(s,"GetCallsStatusCode",{enumerable:!0,get:function(){return a.GetCallsStatusCode}}),n(e("./providerAsMiddleware"),s),n(e("./retryOnEmpty"),s),n(e("./wallet"),s)}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/inflight-cache.js",{"./logging-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/logging-utils.js","./utils/cache":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/cache.js","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs","klona/full":"/home/runner/work/metamask-extension/metamask-extension/node_modules/klona/full/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createInflightCacheMiddleware=void 0;const r=e("@metamask/json-rpc-engine"),n=e("klona/full"),a=e("./logging-utils"),o=e("./utils/cache"),i=(0,a.createModuleLogger)(a.projectLogger,"inflight-cache");s.createInflightCacheMiddleware=function(){const e={};return(0,r.createAsyncMiddleware)((async(t,s,r)=>{if(t.skipCache)return r();const a=(0,o.cacheIdentifierForRequest)(t);if(!a)return i("Request is not cacheable, proceeding. req = %o",t),r();let m=e[a];return m?(i("Running %i handler(s) for request %o",m.length,t),await async function(e,t){const{resolve:s,promise:r}=function(){let e;const t=new Promise((t=>{e=t}));return{resolve:e,promise:t}}();return t.push((t=>{e.result=(0,n.klona)(t.result),e.error=(0,n.klona)(t.error),s()})),r}(s,m),undefined):(m=[],e[a]=m,i("Carrying original request forward %o",t),await r(),delete e[a],i("Running %i collected handler(s) for request %o",m.length,t),function(e,t){setTimeout((()=>{t.forEach((t=>{try{t(e)}catch(e){console.error(e)}}))}))}(s,m),undefined)}))}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/inflight-cache.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/logging-utils.js",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createModuleLogger=s.projectLogger=void 0;const r=e("@metamask/utils");Object.defineProperty(s,"createModuleLogger",{enumerable:!0,get:function(){return r.createModuleLogger}}),s.projectLogger=(0,r.createProjectLogger)("eth-json-rpc-middleware")}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/logging-utils.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-get-calls-status.js",{"../utils/validation":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/validation.js","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.walletGetCallsStatus=s.GetCallsStatusCode=void 0;const r=e("@metamask/rpc-errors"),n=e("@metamask/superstruct"),a=e("@metamask/utils"),o=e("../utils/validation"),i=(0,n.tuple)([a.StrictHexStruct]);!function(e){e[e.PENDING=100]="PENDING",e[e.CONFIRMED=200]="CONFIRMED",e[e.FAILED_OFFCHAIN=400]="FAILED_OFFCHAIN",e[e.REVERTED=500]="REVERTED",e[e.REVERTED_PARTIAL=600]="REVERTED_PARTIAL"}(s.GetCallsStatusCode||(s.GetCallsStatusCode={})),s.walletGetCallsStatus=async function(e,t,{getCallsStatus:s}){if(!s)throw r.rpcErrors.methodNotSupported();(0,o.validateParams)(e.params,i);const n=e.params[0];t.result=await s(n,e)}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-get-calls-status.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-get-capabilities.js",{"../utils/validation":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/validation.js","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.walletGetCapabilities=void 0;const r=e("@metamask/rpc-errors"),n=e("@metamask/superstruct"),a=e("@metamask/utils"),o=e("../utils/validation"),i=(0,n.tuple)([a.HexChecksumAddressStruct,(0,n.optional)((0,n.array)(a.StrictHexStruct))]);s.walletGetCapabilities=async function(e,t,{getAccounts:s,getCapabilities:n}){if(!n)throw r.rpcErrors.methodNotSupported();(0,o.validateParams)(e.params,i);const a=e.params[0],m=e.params[1];await(0,o.validateAndNormalizeKeyholder)(a,e,{getAccounts:s});const c=await n(a,m,e);t.result=c}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-get-capabilities.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-send-calls.js",{"../utils/validation":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/validation.js","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.walletSendCalls=void 0;const r=e("@metamask/rpc-errors"),n=e("@metamask/superstruct"),a=e("@metamask/utils"),o=e("../utils/validation"),i=(0,n.record)((0,n.string)(),(0,n.type)({optional:(0,n.optional)((0,n.boolean)())})),m=(0,n.tuple)([(0,n.object)({version:(0,n.nonempty)((0,n.string)()),id:(0,n.optional)(a.StrictHexStruct),from:(0,n.optional)(a.HexChecksumAddressStruct),chainId:a.StrictHexStruct,atomicRequired:(0,n.boolean)(),calls:(0,n.array)((0,n.object)({to:(0,n.optional)(a.HexChecksumAddressStruct),data:(0,n.optional)(a.StrictHexStruct),value:(0,n.optional)(a.StrictHexStruct),capabilities:(0,n.optional)(i)})),capabilities:(0,n.optional)(i)})]);s.walletSendCalls=async function(e,t,{getAccounts:s,processSendCalls:n}){if(!n)throw r.rpcErrors.methodNotSupported();(0,o.validateParams)(e.params,m);const a=e.params[0],i=a.from?await(0,o.validateAndNormalizeKeyholder)(a.from,e,{getAccounts:s}):undefined,c=Object.assign(Object.assign({},a),{from:i});t.result=await n(c,e)}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-send-calls.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/providerAsMiddleware.js",{"@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.ethersProviderAsMiddleware=s.providerAsMiddleware=void 0;const r=e("@metamask/json-rpc-engine");s.providerAsMiddleware=function(e){return(0,r.createAsyncMiddleware)((async(t,s)=>{s.result=await e.request(t)}))},s.ethersProviderAsMiddleware=function(e){return(t,s,r,n)=>{e.send(t,((e,t)=>e?n(e):(Object.assign(s,t),n())))}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/providerAsMiddleware.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/retryOnEmpty.js",{"./logging-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/logging-utils.js","./utils/cache":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/cache.js","./utils/error":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/error.js","./utils/timeout":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/timeout.js","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs","klona/full":"/home/runner/work/metamask-extension/metamask-extension/node_modules/klona/full/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createRetryOnEmptyMiddleware=void 0;const r=e("@metamask/json-rpc-engine"),n=e("klona/full"),a=e("./logging-utils"),o=e("./utils/cache"),i=e("./utils/error"),m=e("./utils/timeout"),c=(0,a.createModuleLogger)(a.projectLogger,"retry-on-empty"),d=[undefined,null,"<nil>"];s.createRetryOnEmptyMiddleware=function({provider:e,blockTracker:t}={}){if(!e)throw Error('RetryOnEmptyMiddleware - mandatory "provider" option is missing.');if(!t)throw Error('RetryOnEmptyMiddleware - mandatory "blockTracker" option is missing.');return(0,r.createAsyncMiddleware)((async(s,r,a)=>{const u=(0,o.blockTagParamIndex)(s.method);if(u===undefined)return a();let l=Array.isArray(s.params)&&s.params[u]?s.params[u]:undefined;if(l===undefined&&(l="latest"),["latest","pending"].includes(l))return a();const f=Number.parseInt(l.slice(2),16);if(Number.isNaN(f))return a();const h=await t.getLatestBlock(),p=Number.parseInt(h.slice(2),16);if(f>p)return c("Requested block number %o is higher than latest block number %o, falling through to original request",f,p),a();c("Requested block number %o is not higher than latest block number %o, trying request until non-empty response is received",f,p);const g=(0,n.klona)(s),k=await async function(e,t){for(let s=0;s<e;s++)try{return await t()}catch(e){if((0,i.isExecutionRevertedError)(e))throw e;c("(call %i) Request failed, waiting 1s to retry again...",s+1),await(0,m.timeout)(1e3)}throw c("Retries exhausted"),new Error("RetryOnEmptyMiddleware - retries exhausted")}(10,(async()=>{c("Performing request %o",g);const t=await e.request(g);c("Result is %o",t);if(d.includes(t))throw new Error(`RetryOnEmptyMiddleware - empty result "${JSON.stringify(t)}" for request "${JSON.stringify(g)}"`);return t}));return c("Copying result %o",k),r.result=k,undefined}))}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/retryOnEmpty.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/cache.js",{"safe-stable-stringify":"/home/runner/work/metamask-extension/metamask-extension/node_modules/safe-stable-stringify/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.cacheTypeForMethod=s.blockTagParamIndex=s.blockTagForRequest=s.canCache=s.cacheIdentifierForRequest=s.CacheStrategy=void 0;const r=(0,e("safe-stable-stringify").configure)({bigint:!1,circularValue:Error});var n;function a(e){return i(e)!==n.Never}function o(e){switch(e){case"eth_getStorageAt":return 2;case"eth_getBalance":case"eth_getCode":case"eth_getTransactionCount":case"eth_call":return 1;case"eth_getBlockByNumber":return 0;default:return undefined}}function i(e){switch(e){case"web3_clientVersion":case"web3_sha3":case"eth_protocolVersion":case"eth_getBlockTransactionCountByHash":case"eth_getUncleCountByBlockHash":case"eth_getCode":case"eth_getBlockByHash":case"eth_getTransactionByHash":case"eth_getTransactionByBlockHashAndIndex":case"eth_getTransactionReceipt":case"eth_getUncleByBlockHashAndIndex":case"eth_getCompilers":case"eth_compileLLL":case"eth_compileSolidity":case"eth_compileSerpent":case"shh_version":case"test_permaCache":return n.Permanent;case"eth_getBlockByNumber":case"eth_getBlockTransactionCountByNumber":case"eth_getUncleCountByBlockNumber":case"eth_getTransactionByBlockNumberAndIndex":case"eth_getUncleByBlockNumberAndIndex":case"test_forkCache":return n.Fork;case"eth_gasPrice":case"eth_blockNumber":case"eth_getBalance":case"eth_getStorageAt":case"eth_getTransactionCount":case"eth_call":case"eth_estimateGas":case"eth_getFilterLogs":case"eth_getLogs":case"test_blockCache":return n.Block;default:return n.Never}}!function(e){e.Block="block",e.Fork="fork",e.Never="never",e.Permanent="perma"}(n=s.CacheStrategy||(s.CacheStrategy={})),s.cacheIdentifierForRequest=function(e,t){var s;const n=t?function(e){if(!e.params)return[];const t=o(e.method);if(t===undefined||!Array.isArray(e.params)||t>=e.params.length)return e.params;if("eth_getBlockByNumber"===e.method)return e.params.slice(1);return e.params.slice(0,t)}(e):null!==(s=e.params)&&void 0!==s?s:[];return a(e.method)?`${e.method}:${r(n)}`:null},s.canCache=a,s.blockTagForRequest=function(e){if(!e.params)return undefined;const t=o(e.method);return t===undefined||!Array.isArray(e.params)||t>=e.params.length?undefined:e.params[t]},s.blockTagParamIndex=o,s.cacheTypeForMethod=i}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/cache.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/common.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.stripArrayTypeIfPresent=void 0;s.stripArrayTypeIfPresent=e=>(null==e?void 0:e.match(/\S\[\d*\]$/u))?e.replace(/\[\d*\]$/gu,"").trim():e}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/common.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/error.js",{"@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.isExecutionRevertedError=void 0;const r=e("@metamask/rpc-errors"),n=e("@metamask/utils");s.isExecutionRevertedError=function(e){return(0,n.isJsonRpcError)(e)&&e.code===r.errorCodes.rpc.invalidInput&&"execution reverted"===e.message}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/error.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/normalize.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function r(e){return"string"!=typeof e?e:JSON.parse(e)}Object.defineProperty(s,"__esModule",{value:!0}),s.parseTypedMessage=s.normalizeTypedMessage=void 0,s.normalizeTypedMessage=function(e){var t;let s;try{s=r(e)}catch(t){return e}const{verifyingContract:n}=null!==(t=s.domain)&&void 0!==t?t:{};return n?(s.domain.verifyingContract=function(e){if(e.startsWith("0X"))return`0x${e.slice(2)}`;return e}(n),JSON.stringify(s)):e},s.parseTypedMessage=r}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/normalize.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/timeout.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.timeout=void 0,s.timeout=async function(e){return new Promise((t=>setTimeout(t,e)))}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/timeout.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/validation.js",{"@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.resemblesAddress=s.validateParams=s.validateAndNormalizeKeyholder=void 0;const r=e("@metamask/rpc-errors"),n=e("@metamask/superstruct");function a(e){return 42===e.length}s.validateAndNormalizeKeyholder=async function(e,t,{getAccounts:s}){if("string"==typeof e&&e.length>0&&a(e)){const n=(await s(t)).map((e=>e.toLowerCase())),a=e.toLowerCase();if(n.includes(a))return a;throw r.providerErrors.unauthorized()}throw r.rpcErrors.invalidParams({message:"Invalid parameters: must provide an Ethereum address."})},s.validateParams=function(e,t){const[s]=(0,n.validate)(e,t);if(s)throw r.rpcErrors.invalidParams(function(e,t){return`${t}\n\n${e.failures().map((e=>`${e.path.join(" > ")}${e.path.length?" - ":""}${e.message}`)).join("\n")}`}(s,"Invalid params"))},s.resemblesAddress=a}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/utils/validation.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/wallet.js",{"./methods/wallet-get-calls-status":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-get-calls-status.js","./methods/wallet-get-capabilities":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-get-capabilities.js","./methods/wallet-send-calls":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/methods/wallet-send-calls.js","./utils/common":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/common.js","./utils/normalize":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/normalize.js","./utils/validation":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/dist/utils/validation.js","@metamask/eth-sig-util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/index.js","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs","@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),a=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var s in e)"default"!==s&&Object.prototype.hasOwnProperty.call(e,s)&&r(t,e,s);return n(t,e),t};Object.defineProperty(s,"__esModule",{value:!0}),s.createWalletMiddleware=void 0;const o=a(e("@metamask/eth-sig-util")),i=e("@metamask/json-rpc-engine"),m=e("@metamask/rpc-errors"),c=e("@metamask/utils"),d=e("./methods/wallet-get-calls-status"),u=e("./methods/wallet-get-capabilities"),l=e("./methods/wallet-send-calls"),f=e("./utils/common"),h=e("./utils/normalize"),p=e("./utils/validation");function g(e){const{primaryType:t,types:s}=(0,h.parseTypedMessage)(e);if(!s)throw m.rpcErrors.invalidInput();if(!s[(0,f.stripArrayTypeIfPresent)(t)])throw m.rpcErrors.invalidInput()}function k(e){const{domain:{verifyingContract:t}={}}=(0,h.parseTypedMessage)(e);if(t&&"cosmos"!==t&&!(0,c.isValidHexAddress)(t))throw m.rpcErrors.invalidInput()}s.createWalletMiddleware=function({getAccounts:e,getCallsStatus:t,getCapabilities:s,processDecryptMessage:r,processEncryptionPublicKey:n,processPersonalMessage:a,processTransaction:c,processSignTransaction:f,processTypedMessage:b,processTypedMessageV3:y,processTypedMessageV4:x,processSendCalls:w}){if(!e)throw new Error("opts.getAccounts is required");return(0,i.createScaffoldMiddleware)({eth_accounts:(0,i.createAsyncMiddleware)((async function(t,s){s.result=await e(t)})),eth_coinbase:(0,i.createAsyncMiddleware)((async function(t,s){const r=await e(t);s.result=r[0]||null})),eth_sendTransaction:(0,i.createAsyncMiddleware)((async function(e,t){if(!c)throw m.rpcErrors.methodNotSupported();if(!(e.params&&Array.isArray(e.params)&&e.params.length>=1))throw m.rpcErrors.invalidInput();const s=e.params[0],r=Object.assign(Object.assign({},s),{from:await E((null==s?void 0:s.from)||"",e)});t.result=await c(r,e)})),eth_signTransaction:(0,i.createAsyncMiddleware)((async function(e,t){if(!f)throw m.rpcErrors.methodNotSupported();if(!(e.params&&Array.isArray(e.params)&&e.params.length>=1))throw m.rpcErrors.invalidInput();const s=e.params[0],r=Object.assign(Object.assign({},s),{from:await E((null==s?void 0:s.from)||"",e)});t.result=await f(r,e)})),eth_signTypedData:(0,i.createAsyncMiddleware)((async function(e,t){if(!b)throw m.rpcErrors.methodNotSupported();if(!((null==e?void 0:e.params)&&Array.isArray(e.params)&&e.params.length>=2))throw m.rpcErrors.invalidInput();const s=e.params,r=s[0],n=await E(s[1],e),a=s[2]||{},o=Object.assign(Object.assign({},a),{from:n,data:r,signatureMethod:"eth_signTypedData",version:"V1"});t.result=await b(o,e,"V1")})),eth_signTypedData_v3:(0,i.createAsyncMiddleware)((async function(e,t){if(!y)throw m.rpcErrors.methodNotSupported();if(!((null==e?void 0:e.params)&&Array.isArray(e.params)&&e.params.length>=2))throw m.rpcErrors.invalidInput();const s=e.params,r=await E(s[0],e),n=(0,h.normalizeTypedMessage)(s[1]);g(n),k(n);const a={data:n,from:r,version:"V3",signatureMethod:"eth_signTypedData_v3"};t.result=await y(a,e,"V3")})),eth_signTypedData_v4:(0,i.createAsyncMiddleware)((async function(e,t){if(!x)throw m.rpcErrors.methodNotSupported();if(!((null==e?void 0:e.params)&&Array.isArray(e.params)&&e.params.length>=2))throw m.rpcErrors.invalidInput();const s=e.params,r=await E(s[0],e),n=(0,h.normalizeTypedMessage)(s[1]);g(n),k(n);const a={data:n,from:r,version:"V4",signatureMethod:"eth_signTypedData_v4"};t.result=await x(a,e,"V4")})),personal_sign:(0,i.createAsyncMiddleware)((async function(e,t){if(!a)throw m.rpcErrors.methodNotSupported();if(!((null==e?void 0:e.params)&&Array.isArray(e.params)&&e.params.length>=2))throw m.rpcErrors.invalidInput();const s=e.params,r=s[0],n=s[1],o=s[2]||{};let i,c;if((0,p.resemblesAddress)(r)&&!(0,p.resemblesAddress)(n)){let e="The eth_personalSign method requires params ordered ";e+="[message, address]. This was previously handled incorrectly, ",e+="and has been corrected automatically. ",e+="Please switch this param order for smooth behavior in the future.",t.warning=e,i=r,c=n}else c=r,i=n;i=await E(i,e);const d=Object.assign(Object.assign({},o),{from:i,data:c,signatureMethod:"personal_sign"});t.result=await a(d,e)})),eth_getEncryptionPublicKey:(0,i.createAsyncMiddleware)((async function(e,t){if(!n)throw m.rpcErrors.methodNotSupported();if(!((null==e?void 0:e.params)&&Array.isArray(e.params)&&e.params.length>=1))throw m.rpcErrors.invalidInput();const s=e.params,r=await E(s[0],e);t.result=await n(r,e)})),eth_decrypt:(0,i.createAsyncMiddleware)((async function(e,t){if(!r)throw m.rpcErrors.methodNotSupported();if(!((null==e?void 0:e.params)&&Array.isArray(e.params)&&e.params.length>=1))throw m.rpcErrors.invalidInput();const s=e.params,n=s[0],a=await E(s[1],e),o=s[2]||{},i=Object.assign(Object.assign({},o),{from:a,data:n});t.result=await r(i,e)})),personal_ecRecover:(0,i.createAsyncMiddleware)((async function(e,t){if(!((null==e?void 0:e.params)&&Array.isArray(e.params)&&e.params.length>=2))throw m.rpcErrors.invalidInput();const s=e.params,r=s[0],n=s[1],a=o.recoverPersonalSignature({data:r,signature:n});t.result=a})),wallet_getCapabilities:(0,i.createAsyncMiddleware)((async(t,r)=>(0,u.walletGetCapabilities)(t,r,{getAccounts:e,getCapabilities:s}))),wallet_sendCalls:(0,i.createAsyncMiddleware)((async(t,s)=>(0,l.walletSendCalls)(t,s,{getAccounts:e,processSendCalls:w}))),wallet_getCallsStatus:(0,i.createAsyncMiddleware)((async(e,s)=>(0,d.walletGetCallsStatus)(e,s,{getCallsStatus:t})))});async function E(t,s){return(0,p.validateAndNormalizeKeyholder)(t,s,{getAccounts:e})}}}}},{package:"@metamask/eth-json-rpc-middleware",file:"node_modules/@metamask/eth-json-rpc-middleware/dist/wallet.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/account.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/constants.js","./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/helpers.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/internal.js","@ethereumjs/rlp":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethereumjs/rlp/dist/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js","ethereum-cryptography/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/utils.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.accountBodyToRLP=s.accountBodyToSlim=s.accountBodyFromSlim=s.isZeroAddress=s.zeroAddress=s.importPublic=s.privateToAddress=s.privateToPublic=s.publicToAddress=s.pubToAddress=s.isValidPublic=s.isValidPrivate=s.generateAddress2=s.generateAddress=s.isValidChecksumAddress=s.toChecksumAddress=s.isValidAddress=s.Account=void 0;const r=e("@ethereumjs/rlp"),n=e("ethereum-cryptography/keccak"),a=e("ethereum-cryptography/secp256k1"),o=e("ethereum-cryptography/utils"),i=e("./bytes"),m=e("./constants"),c=e("./helpers"),d=e("./internal"),u=BigInt(0);class l{constructor(e=u,t=u,s=m.KECCAK256_RLP,r=m.KECCAK256_NULL){this.nonce=e,this.balance=t,this.storageRoot=s,this.codeHash=r,this._validate()}static fromAccountData(e){const{nonce:t,balance:s,storageRoot:r,codeHash:n}=e;return new l(t!==undefined?(0,i.bufferToBigInt)((0,i.toBuffer)(t)):undefined,s!==undefined?(0,i.bufferToBigInt)((0,i.toBuffer)(s)):undefined,r!==undefined?(0,i.toBuffer)(r):undefined,n!==undefined?(0,i.toBuffer)(n):undefined)}static fromRlpSerializedAccount(e){const t=(0,i.arrToBufArr)(r.RLP.decode(Uint8Array.from(e)));if(!Array.isArray(t))throw new Error("Invalid serialized account input. Must be array");return this.fromValuesArray(t)}static fromValuesArray(e){const[t,s,r,n]=e;return new l((0,i.bufferToBigInt)(t),(0,i.bufferToBigInt)(s),r,n)}_validate(){if(this.nonce<u)throw new Error("nonce must be greater than zero");if(this.balance<u)throw new Error("balance must be greater than zero");if(32!==this.storageRoot.length)throw new Error("storageRoot must have a length of 32");if(32!==this.codeHash.length)throw new Error("codeHash must have a length of 32")}raw(){return[(0,i.bigIntToUnpaddedBuffer)(this.nonce),(0,i.bigIntToUnpaddedBuffer)(this.balance),this.storageRoot,this.codeHash]}serialize(){return t.from(r.RLP.encode((0,i.bufArrToArr)(this.raw())))}isContract(){return!this.codeHash.equals(m.KECCAK256_NULL)}isEmpty(){return this.balance===u&&this.nonce===u&&this.codeHash.equals(m.KECCAK256_NULL)}}s.Account=l;s.isValidAddress=function(e){try{(0,c.assertIsString)(e)}catch(e){return!1}return/^0x[0-9a-fA-F]{40}$/.test(e)};s.toChecksumAddress=function(e,s){(0,c.assertIsHexString)(e);const r=(0,d.stripHexPrefix)(e).toLowerCase();let a="";if(s!==undefined){a=(0,i.bufferToBigInt)((0,i.toBuffer)(s)).toString()+"0x"}const m=t.from(a+r,"utf8"),u=(0,o.bytesToHex)((0,n.keccak256)(m));let l="0x";for(let e=0;e<r.length;e++)parseInt(u[e],16)>=8?l+=r[e].toUpperCase():l+=r[e];return l};s.isValidChecksumAddress=function(e,t){return(0,s.isValidAddress)(e)&&(0,s.toChecksumAddress)(e,t)===e};s.generateAddress=function(e,s){return(0,c.assertIsBuffer)(e),(0,c.assertIsBuffer)(s),(0,i.bufferToBigInt)(s)===BigInt(0)?t.from((0,n.keccak256)(r.RLP.encode((0,i.bufArrToArr)([e,null])))).slice(-20):t.from((0,n.keccak256)(r.RLP.encode((0,i.bufArrToArr)([e,s])))).slice(-20)};s.generateAddress2=function(e,s,r){if((0,c.assertIsBuffer)(e),(0,c.assertIsBuffer)(s),(0,c.assertIsBuffer)(r),20!==e.length)throw new Error("Expected from to be of length 20");if(32!==s.length)throw new Error("Expected salt to be of length 32");const a=(0,n.keccak256)(t.concat([t.from("ff","hex"),e,s,(0,n.keccak256)(r)]));return(0,i.toBuffer)(a).slice(-20)};s.isValidPrivate=function(e){return a.secp256k1.utils.isValidPrivateKey(e)};s.isValidPublic=function(e,s=!1){if((0,c.assertIsBuffer)(e),64===e.length)try{return a.secp256k1.ProjectivePoint.fromHex(t.concat([t.from([4]),e])),!0}catch(e){return!1}if(!s)return!1;try{return a.secp256k1.ProjectivePoint.fromHex(e),!0}catch(e){return!1}};s.pubToAddress=function(e,s=!1){if((0,c.assertIsBuffer)(e),s&&64!==e.length&&(e=t.from(a.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),64!==e.length)throw new Error("Expected pubKey to be of length 64");return t.from((0,n.keccak256)(e)).slice(-20)},s.publicToAddress=s.pubToAddress;s.privateToPublic=function(e){return(0,c.assertIsBuffer)(e),t.from(a.secp256k1.ProjectivePoint.fromPrivateKey(e).toRawBytes(!1).slice(1))};s.privateToAddress=function(e){return(0,s.publicToAddress)((0,s.privateToPublic)(e))};s.importPublic=function(e){return(0,c.assertIsBuffer)(e),64!==e.length&&(e=t.from(a.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),e};s.zeroAddress=function(){const e=(0,i.zeros)(20);return(0,i.bufferToHex)(e)};function f(e){const[t,s,r,n]=e;return[t,s,0===(0,i.arrToBufArr)(r).length?m.KECCAK256_RLP:r,0===(0,i.arrToBufArr)(n).length?m.KECCAK256_NULL:n]}s.isZeroAddress=function(e){try{(0,c.assertIsString)(e)}catch(e){return!1}return(0,s.zeroAddress)()===e},s.accountBodyFromSlim=f;const h=new Uint8Array(0);s.accountBodyToSlim=function(e){const[t,s,r,n]=e;return[t,s,(0,i.arrToBufArr)(r).equals(m.KECCAK256_RLP)?h:r,(0,i.arrToBufArr)(n).equals(m.KECCAK256_NULL)?h:n]},s.accountBodyToRLP=function(e,t=!0){const s=t?f(e):e;return(0,i.arrToBufArr)(r.RLP.encode(s))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/account.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/address.js",{"./account":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/account.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/bytes.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.Address=void 0;const r=e("./account"),n=e("./bytes");class a{constructor(e){if(20!==e.length)throw new Error("Invalid address length");this.buf=e}static zero(){return new a((0,n.zeros)(20))}static fromString(e){if(!(0,r.isValidAddress)(e))throw new Error("Invalid address");return new a((0,n.toBuffer)(e))}static fromPublicKey(e){if(!t.isBuffer(e))throw new Error("Public key should be Buffer");const s=(0,r.pubToAddress)(e);return new a(s)}static fromPrivateKey(e){if(!t.isBuffer(e))throw new Error("Private key should be Buffer");const s=(0,r.privateToAddress)(e);return new a(s)}static generate(e,t){if("bigint"!=typeof t)throw new Error("Expected nonce to be a bigint");return new a((0,r.generateAddress)(e.buf,(0,n.bigIntToBuffer)(t)))}static generate2(e,s,n){if(!t.isBuffer(s))throw new Error("Expected salt to be a Buffer");if(!t.isBuffer(n))throw new Error("Expected initCode to be a Buffer");return new a((0,r.generateAddress2)(e.buf,s,n))}equals(e){return this.buf.equals(e.buf)}isZero(){return this.equals(a.zero())}isPrecompileOrSystemAddress(){const e=(0,n.bufferToBigInt)(this.buf),t=BigInt(0),s=BigInt("0xffff");return e>=t&&e<=s}toString(){return"0x"+this.buf.toString("hex")}toBuffer(){return t.from(this.buf)}}s.Address=a}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/address.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js",{events:"/home/runner/work/metamask-extension/metamask-extension/node_modules/events/events.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.AsyncEventEmitter=void 0;const r=e("events");class n extends r.EventEmitter{emit(e,...t){let[s,r]=t;const n=this;let a=n._events[e]??[];return r===undefined&&"function"==typeof s&&(r=s,s=undefined),"newListener"!==e&&"removeListener"!==e||(s={event:s,fn:r},r=undefined),a=Array.isArray(a)?a:[a],async function(e,t,s){let r;for await(const n of t)try{n.length<2?n.call(e,s):await new Promise(((t,r)=>{n.call(e,s,(e=>{e?r(e):t()}))}))}catch(e){r=e}if(r)throw r}(n,a.slice(),s).then(r).catch(r),n.listenerCount(e)>0}once(e,t){const s=this;let r;if("function"!=typeof t)throw new TypeError("listener must be a function");return r=t.length>=2?function(n,a){s.removeListener(e,r),t(n,a)}:function(n){s.removeListener(e,r),t(n,r)},s.on(e,r),s}first(e,t){let s=this._events[e]??[];if("function"!=typeof t)throw new TypeError("listener must be a function");return Array.isArray(s)||(this._events[e]=s=[s]),s.unshift(t),this}before(e,t,s){return this.beforeOrAfter(e,t,s)}after(e,t,s){return this.beforeOrAfter(e,t,s,"after")}beforeOrAfter(e,t,s,r){let n,a,o=this._events[e]??[];const i="after"===r?1:0;if("function"!=typeof s)throw new TypeError("listener must be a function");if("function"!=typeof t)throw new TypeError("target must be a function");for(Array.isArray(o)||(this._events[e]=o=[o]),a=o.length,n=o.length;n--;)if(o[n]===t){a=n+i;break}return o.splice(a,0,s),this}on(e,t){return super.on(e,t)}addListener(e,t){return super.addListener(e,t)}prependListener(e,t){return super.prependListener(e,t)}prependOnceListener(e,t){return super.prependOnceListener(e,t)}removeAllListeners(e){return super.removeAllListeners(e)}removeListener(e,t){return super.removeListener(e,t)}eventNames(){return super.eventNames()}listeners(e){return super.listeners(e)}listenerCount(e){return super.listenerCount(e)}getMaxListeners(){return super.getMaxListeners()}setMaxListeners(e){return super.setMaxListeners(e)}}s.AsyncEventEmitter=n}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/bytes.js",{"./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/helpers.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/internal.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.intToUnpaddedBuffer=s.bigIntToUnpaddedBuffer=s.bigIntToHex=s.bufArrToArr=s.arrToBufArr=s.validateNoLeadingZeroes=s.baToJSON=s.toUtf8=s.short=s.addHexPrefix=s.toUnsigned=s.fromSigned=s.bufferToInt=s.bigIntToBuffer=s.bufferToBigInt=s.bufferToHex=s.toBuffer=s.unpadHexString=s.unpadArray=s.unpadBuffer=s.setLengthRight=s.setLengthLeft=s.zeros=s.intToBuffer=s.intToHex=void 0;const r=e("./helpers"),n=e("./internal");s.intToHex=function(e){if(!Number.isSafeInteger(e)||e<0)throw new Error(`Received an invalid integer type: ${e}`);return`0x${e.toString(16)}`};s.intToBuffer=function(e){const r=(0,s.intToHex)(e);return t.from((0,n.padToEven)(r.slice(2)),"hex")};s.zeros=function(e){return t.allocUnsafe(e).fill(0)};const a=function(e,t,r){const n=(0,s.zeros)(t);return r?e.length<t?(e.copy(n),n):e.slice(0,t):e.length<t?(e.copy(n,t-e.length),n):e.slice(-t)};s.setLengthLeft=function(e,t){return(0,r.assertIsBuffer)(e),a(e,t,!1)};s.setLengthRight=function(e,t){return(0,r.assertIsBuffer)(e),a(e,t,!0)};const o=function(e){let t=e[0];for(;e.length>0&&"0"===t.toString();)t=(e=e.slice(1))[0];return e};s.unpadBuffer=function(e){return(0,r.assertIsBuffer)(e),o(e)};s.unpadArray=function(e){return(0,r.assertIsArray)(e),o(e)};s.unpadHexString=function(e){return(0,r.assertIsHexString)(e),e=(0,n.stripHexPrefix)(e),"0x"+o(e)};s.toBuffer=function(e){if(null===e||e===undefined)return t.allocUnsafe(0);if(t.isBuffer(e))return t.from(e);if(Array.isArray(e)||e instanceof Uint8Array)return t.from(e);if("string"==typeof e){if(!(0,n.isHexString)(e))throw new Error(`Cannot convert string to buffer. toBuffer only supports 0x-prefixed hex strings and this string was given: ${e}`);return t.from((0,n.padToEven)((0,n.stripHexPrefix)(e)),"hex")}if("number"==typeof e)return(0,s.intToBuffer)(e);if("bigint"==typeof e){if(e<BigInt(0))throw new Error(`Cannot convert negative bigint to buffer. Given: ${e}`);let s=e.toString(16);return s.length%2&&(s="0"+s),t.from(s,"hex")}if(e.toArray)return t.from(e.toArray());if(e.toBuffer)return t.from(e.toBuffer());throw new Error("invalid type")};function i(e){const t=(0,s.bufferToHex)(e);return"0x"===t?BigInt(0):BigInt(t)}function m(e){return(0,s.toBuffer)("0x"+e.toString(16))}s.bufferToHex=function(e){return"0x"+(e=(0,s.toBuffer)(e)).toString("hex")},s.bufferToBigInt=i,s.bigIntToBuffer=m;s.bufferToInt=function(e){const t=Number(i(e));if(!Number.isSafeInteger(t))throw new Error("Number exceeds 53 bits");return t};s.fromSigned=function(e){return BigInt.asIntN(256,i(e))};s.toUnsigned=function(e){return m(BigInt.asUintN(256,e))};s.addHexPrefix=function(e){return"string"!=typeof e||(0,n.isHexPrefixed)(e)?e:"0x"+e},s.short=function(e,s=50){const r=t.isBuffer(e)?e.toString("hex"):e;return r.length<=s?r:r.slice(0,s)+"…"};s.toUtf8=function(e){if((e=(0,n.stripHexPrefix)(e)).length%2!=0)throw new Error("Invalid non-even hex string input for toUtf8() provided");return t.from(e.replace(/^(00)+|(00)+$/g,""),"hex").toString("utf8")};s.baToJSON=function(e){if(t.isBuffer(e))return`0x${e.toString("hex")}`;if(e instanceof Array){const t=[];for(let r=0;r<e.length;r++)t.push((0,s.baToJSON)(e[r]));return t}};s.validateNoLeadingZeroes=function(e){for(const[t,s]of Object.entries(e))if(s!==undefined&&s.length>0&&0===s[0])throw new Error(`${t} cannot have leading zeroes, received: ${s.toString("hex")}`)},s.arrToBufArr=function e(s){return Array.isArray(s)?s.map((t=>e(t))):t.from(s)},s.bufArrToArr=function e(t){return Array.isArray(t)?t.map((t=>e(t))):Uint8Array.from(t??[])};s.bigIntToHex=e=>"0x"+e.toString(16),s.bigIntToUnpaddedBuffer=function(e){return(0,s.unpadBuffer)(m(e))},s.intToUnpaddedBuffer=function(e){return(0,s.unpadBuffer)((0,s.intToBuffer)(e))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/bytes.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/constants.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.MAX_WITHDRAWALS_PER_PAYLOAD=s.RLP_EMPTY_STRING=s.KECCAK256_RLP=s.KECCAK256_RLP_S=s.KECCAK256_RLP_ARRAY=s.KECCAK256_RLP_ARRAY_S=s.KECCAK256_NULL=s.KECCAK256_NULL_S=s.TWO_POW256=s.SECP256K1_ORDER_DIV_2=s.SECP256K1_ORDER=s.MAX_INTEGER_BIGINT=s.MAX_INTEGER=s.MAX_UINT64=void 0;const r=e("buffer"),n=e("ethereum-cryptography/secp256k1");s.MAX_UINT64=BigInt("0xffffffffffffffff"),s.MAX_INTEGER=BigInt("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),s.MAX_INTEGER_BIGINT=BigInt("115792089237316195423570985008687907853269984665640564039457584007913129639935"),s.SECP256K1_ORDER=n.secp256k1.CURVE.n,s.SECP256K1_ORDER_DIV_2=n.secp256k1.CURVE.n/BigInt(2),s.TWO_POW256=BigInt("0x10000000000000000000000000000000000000000000000000000000000000000"),s.KECCAK256_NULL_S="c5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",s.KECCAK256_NULL=r.Buffer.from(s.KECCAK256_NULL_S,"hex"),s.KECCAK256_RLP_ARRAY_S="1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",s.KECCAK256_RLP_ARRAY=r.Buffer.from(s.KECCAK256_RLP_ARRAY_S,"hex"),s.KECCAK256_RLP_S="56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",s.KECCAK256_RLP=r.Buffer.from(s.KECCAK256_RLP_S,"hex"),s.RLP_EMPTY_STRING=r.Buffer.from([128]),s.MAX_WITHDRAWALS_PER_PAYLOAD=16}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/constants.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/encoding.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.compactBytesToNibbles=s.bytesToNibbles=s.nibblesToCompactBytes=s.nibblesToBytes=s.hasTerminator=void 0;s.hasTerminator=e=>e.length>0&&16===e[e.length-1];s.nibblesToBytes=(e,t)=>{for(let s=0,r=0;r<e.length;s+=1,r+=2)t[s]=e[r]<<4|e[r+1]};s.nibblesToCompactBytes=e=>{let t=0;(0,s.hasTerminator)(e)&&(t=1,e=e.subarray(0,e.length-1));const r=new Uint8Array(e.length/2+1);return r[0]=t<<5,1&~e.length||(r[0]|=16,r[0]|=e[0],e=e.subarray(1)),(0,s.nibblesToBytes)(e,r.subarray(1)),r};s.bytesToNibbles=e=>{const t=2*e.length+1,s=new Uint8Array(t);for(let t=0;t<e.length;t++){const r=e[t];s[2*t]=r/16,s[2*t+1]=r%16}return s[t-1]=16,s};s.compactBytesToNibbles=e=>{if(0===e.length)return e;let t=(0,s.bytesToNibbles)(e);t[0]<2&&(t=t.subarray(0,t.length-1));const r=2-(1&t[0]);return t.subarray(r)}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/encoding.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/helpers.js",{"../../../../../../is-buffer/index.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/is-buffer/index.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/internal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.assertIsString=s.assertIsArray=s.assertIsBuffer=s.assertIsHexString=void 0;const r=e("./internal");s.assertIsHexString=function(e){if(!(0,r.isHexString)(e)){throw new Error(`This method only supports 0x-prefixed hex strings but input was: ${e}`)}};s.assertIsBuffer=function(e){if(!t.isBuffer(e)){throw new Error(`This method only supports Buffer but input was: ${e}`)}};s.assertIsArray=function(e){if(!Array.isArray(e)){throw new Error(`This method only supports number arrays but input was: ${e}`)}};s.assertIsString=function(e){if("string"!=typeof e){throw new Error(`This method only supports strings but input was: ${e}`)}}}).call(this)}).call(this,{isBuffer:e("../../../../../../is-buffer/index.js")})}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/helpers.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/index.js",{"./account":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/account.js","./address":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/address.js","./asyncEventEmitter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/constants.js","./encoding":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/encoding.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/internal.js","./lock":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/lock.js","./provider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/provider.js","./signature":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/signature.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/types.js","./units":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/units.js","./withdrawal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/withdrawal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),s.toAscii=s.stripHexPrefix=s.padToEven=s.isHexString=s.isHexPrefixed=s.getKeys=s.getBinarySize=s.fromUtf8=s.fromAscii=s.arrayContainsArray=void 0,n(e("./constants"),s),n(e("./units"),s),n(e("./account"),s),n(e("./address"),s),n(e("./withdrawal"),s),n(e("./signature"),s),n(e("./bytes"),s),n(e("./types"),s),n(e("./encoding"),s),n(e("./asyncEventEmitter"),s);var a=e("./internal");Object.defineProperty(s,"arrayContainsArray",{enumerable:!0,get:function(){return a.arrayContainsArray}}),Object.defineProperty(s,"fromAscii",{enumerable:!0,get:function(){return a.fromAscii}}),Object.defineProperty(s,"fromUtf8",{enumerable:!0,get:function(){return a.fromUtf8}}),Object.defineProperty(s,"getBinarySize",{enumerable:!0,get:function(){return a.getBinarySize}}),Object.defineProperty(s,"getKeys",{enumerable:!0,get:function(){return a.getKeys}}),Object.defineProperty(s,"isHexPrefixed",{enumerable:!0,get:function(){return a.isHexPrefixed}}),Object.defineProperty(s,"isHexString",{enumerable:!0,get:function(){return a.isHexString}}),Object.defineProperty(s,"padToEven",{enumerable:!0,get:function(){return a.padToEven}}),Object.defineProperty(s,"stripHexPrefix",{enumerable:!0,get:function(){return a.stripHexPrefix}}),Object.defineProperty(s,"toAscii",{enumerable:!0,get:function(){return a.toAscii}}),n(e("./lock"),s),n(e("./provider"),s)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/internal.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(e){(function(){function t(e){if("string"!=typeof e)throw new Error("[isHexPrefixed] input must be type 'string', received type "+typeof e);return"0"===e[0]&&"x"===e[1]}Object.defineProperty(s,"__esModule",{value:!0}),s.isHexString=s.getKeys=s.fromAscii=s.fromUtf8=s.toAscii=s.arrayContainsArray=s.getBinarySize=s.padToEven=s.stripHexPrefix=s.isHexPrefixed=void 0,s.isHexPrefixed=t;function r(e){let t=e;if("string"!=typeof t)throw new Error("[padToEven] value must be type 'string', received "+typeof t);return t.length%2&&(t=`0${t}`),t}s.stripHexPrefix=e=>{if("string"!=typeof e)throw new Error("[stripHexPrefix] input must be type 'string', received "+typeof e);return t(e)?e.slice(2):e},s.padToEven=r,s.getBinarySize=function(t){if("string"!=typeof t)throw new Error("[getBinarySize] method requires input type 'string', received "+typeof t);return e.byteLength(t,"utf8")},s.arrayContainsArray=function(e,t,s){if(!0!==Array.isArray(e))throw new Error(`[arrayContainsArray] method requires input 'superset' to be an array, got type '${typeof e}'`);if(!0!==Array.isArray(t))throw new Error(`[arrayContainsArray] method requires input 'subset' to be an array, got type '${typeof t}'`);return t[!0===s?"some":"every"]((t=>e.indexOf(t)>=0))},s.toAscii=function(e){let t="",s=0;const r=e.length;for("0x"===e.substring(0,2)&&(s=2);s<r;s+=2){const r=parseInt(e.substr(s,2),16);t+=String.fromCharCode(r)}return t},s.fromUtf8=function(t){return`0x${r(e.from(t,"utf8").toString("hex")).replace(/^0+|0+$/g,"")}`},s.fromAscii=function(e){let t="";for(let s=0;s<e.length;s++){const r=e.charCodeAt(s).toString(16);t+=r.length<2?`0${r}`:r}return`0x${t}`},s.getKeys=function(e,t,s){if(!Array.isArray(e))throw new Error("[getKeys] method expects input 'params' to be an array, got "+typeof e);if("string"!=typeof t)throw new Error("[getKeys] method expects input 'key' to be type 'string', got "+typeof e);const r=[];for(let n=0;n<e.length;n++){let a=e[n][t];if(!0!==s||a){if("string"!=typeof a)throw new Error("invalid abi - expected type 'string', received "+typeof a)}else a="";r.push(a)}return r},s.isHexString=function(e,t){return!("string"!=typeof e||!e.match(/^0x[0-9A-Fa-f]*$/))&&!(void 0!==t&&t>0&&e.length!==2+2*t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/internal.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/lock.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.Lock=void 0;s.Lock=class{constructor(){this.permits=1,this.promiseResolverQueue=[]}async acquire(){return this.permits>0?(this.permits-=1,Promise.resolve(!0)):new Promise((e=>this.promiseResolverQueue.push(e)))}release(){if(this.permits+=1,this.permits>1&&this.promiseResolverQueue.length>0)console.warn("Lock.permits should never be > 0 when there is someone waiting.");else if(1===this.permits&&this.promiseResolverQueue.length>0){this.permits-=1;const e=this.promiseResolverQueue.shift();e&&e(!0)}}}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/lock.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/provider.js",{"micro-ftch":"/home/runner/work/metamask-extension/metamask-extension/node_modules/micro-ftch/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.getProvider=s.fetchFromProvider=void 0;const r=e("micro-ftch");s.fetchFromProvider=async(e,t)=>(await(0,r.default)(e,{headers:{"content-type":"application/json"},type:"json",data:{method:t.method,params:t.params,jsonrpc:"2.0",id:1}})).result;s.getProvider=e=>{if("string"==typeof e)return e;if(e?.connection?.url!==undefined)return e.connection.url;throw new Error("Must provide valid provider URL or Web3Provider")}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/provider.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/signature.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/constants.js","./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/helpers.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.hashPersonalMessage=s.isValidSignature=s.fromRpcSig=s.toCompactSig=s.toRpcSig=s.ecrecover=s.ecsign=void 0;const r=e("ethereum-cryptography/keccak"),n=e("ethereum-cryptography/secp256k1"),a=e("./bytes"),o=e("./constants"),i=e("./helpers");function m(e,t){return e===BigInt(0)||e===BigInt(1)?e:t===undefined?e-BigInt(27):e-(t*BigInt(2)+BigInt(35))}function c(e){return e===BigInt(0)||e===BigInt(1)}s.ecsign=function(e,s,r){const a=n.secp256k1.sign(e,s),o=a.toCompactRawBytes();return{r:t.from(o.slice(0,32)),s:t.from(o.slice(32,64)),v:r===undefined?BigInt(a.recovery+27):BigInt(a.recovery+35)+BigInt(r)*BigInt(2)}};s.ecrecover=function(e,s,r,o,i){const d=t.concat([(0,a.setLengthLeft)(r,32),(0,a.setLengthLeft)(o,32)],64),u=m(s,i);if(!c(u))throw new Error("Invalid signature v value");const l=n.secp256k1.Signature.fromCompact(d).addRecoveryBit(Number(u)).recoverPublicKey(e);return t.from(l.toRawBytes(!1).slice(1))};s.toRpcSig=function(e,s,r,n){if(!c(m(e,n)))throw new Error("Invalid signature v value");return(0,a.bufferToHex)(t.concat([(0,a.setLengthLeft)(s,32),(0,a.setLengthLeft)(r,32),(0,a.toBuffer)(e)]))};s.toCompactSig=function(e,s,r,n){if(!c(m(e,n)))throw new Error("Invalid signature v value");let o=r;return(e>BigInt(28)&&e%BigInt(2)===BigInt(1)||e===BigInt(1)||e===BigInt(28))&&(o=t.from(r),o[0]|=128),(0,a.bufferToHex)(t.concat([(0,a.setLengthLeft)(s,32),(0,a.setLengthLeft)(o,32)]))};s.fromRpcSig=function(e){const t=(0,a.toBuffer)(e);let s,r,n;if(t.length>=65)s=t.slice(0,32),r=t.slice(32,64),n=(0,a.bufferToBigInt)(t.slice(64));else{if(64!==t.length)throw new Error("Invalid signature length");s=t.slice(0,32),r=t.slice(32,64),n=BigInt((0,a.bufferToInt)(t.slice(32,33))>>7),r[0]&=127}return n<27&&(n+=BigInt(27)),{v:n,r:s,s:r}};s.isValidSignature=function(e,t,s,r=!0,n){if(32!==t.length||32!==s.length)return!1;if(!c(m(e,n)))return!1;const i=(0,a.bufferToBigInt)(t),d=(0,a.bufferToBigInt)(s);return!(i===BigInt(0)||i>=o.SECP256K1_ORDER||d===BigInt(0)||d>=o.SECP256K1_ORDER)&&!(r&&d>=o.SECP256K1_ORDER_DIV_2)};s.hashPersonalMessage=function(e){(0,i.assertIsBuffer)(e);const s=t.from(`Ethereum Signed Message:\n${e.length}`,"utf-8");return t.from((0,r.keccak256)(t.concat([s,e])))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/signature.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/types.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/bytes.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/internal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.toType=s.TypeOutput=void 0;const r=e("./bytes"),n=e("./internal");var a;!function(e){e[e.Number=0]="Number",e[e.BigInt=1]="BigInt",e[e.Buffer=2]="Buffer",e[e.PrefixedHexString=3]="PrefixedHexString"}(a=s.TypeOutput||(s.TypeOutput={})),s.toType=function(e,t){if(null===e)return null;if(e===undefined)return undefined;if("string"==typeof e&&!(0,n.isHexString)(e))throw new Error(`A string must be provided with a 0x-prefix, given: ${e}`);if("number"==typeof e&&!Number.isSafeInteger(e))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative input type)");const s=(0,r.toBuffer)(e);switch(t){case a.Buffer:return s;case a.BigInt:return(0,r.bufferToBigInt)(s);case a.Number:{const e=(0,r.bufferToBigInt)(s);if(e>BigInt(Number.MAX_SAFE_INTEGER))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative output type)");return Number(e)}case a.PrefixedHexString:return(0,r.bufferToHex)(s);default:throw new Error("unknown outputType")}}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/types.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/units.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.GWEI_TO_WEI=void 0,s.GWEI_TO_WEI=BigInt(1e9)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/units.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/withdrawal.js",{"./address":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/address.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/bytes.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/types.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.Withdrawal=void 0;const r=e("./address"),n=e("./bytes"),a=e("./types");class o{constructor(e,t,s,r){this.index=e,this.validatorIndex=t,this.address=s,this.amount=r}static fromWithdrawalData(e){const{index:t,validatorIndex:s,address:n,amount:i}=e,m=(0,a.toType)(t,a.TypeOutput.BigInt),c=(0,a.toType)(s,a.TypeOutput.BigInt),d=new r.Address((0,a.toType)(n,a.TypeOutput.Buffer)),u=(0,a.toType)(i,a.TypeOutput.BigInt);return new o(m,c,d,u)}static fromValuesArray(e){if(4!==e.length)throw Error(`Invalid withdrawalArray length expected=4 actual=${e.length}`);const[t,s,r,n]=e;return o.fromWithdrawalData({index:t,validatorIndex:s,address:r,amount:n})}static toBufferArray(e){const{index:s,validatorIndex:n,address:o,amount:i}=e,m=(0,a.toType)(s,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(s,a.TypeOutput.Buffer),c=(0,a.toType)(n,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(n,a.TypeOutput.Buffer);let d;d=o instanceof r.Address?o.buf:(0,a.toType)(o,a.TypeOutput.Buffer);return[m,c,d,(0,a.toType)(i,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(i,a.TypeOutput.Buffer)]}raw(){return o.toBufferArray(this)}toValue(){return{index:this.index,validatorIndex:this.validatorIndex,address:this.address.buf,amount:this.amount}}toJSON(){return{index:(0,n.bigIntToHex)(this.index),validatorIndex:(0,n.bigIntToHex)(this.validatorIndex),address:"0x"+this.address.buf.toString("hex"),amount:(0,n.bigIntToHex)(this.amount)}}}s.Withdrawal=o}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/withdrawal.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/abi.js",{"./errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/errors.js","./packer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/packer.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.decodeSingle=s.decode=s.encodePacked=s.encodeSingle=s.encode=void 0;const r=e("@metamask/utils"),n=e("./errors"),a=e("./packer");s.encode=(e,t,s,r)=>{try{return(0,a.pack)({types:e,values:t,packed:s,tight:r})}catch(e){if(e instanceof n.ParserError)throw new n.ParserError(`Unable to encode value: ${e.message}`,e);throw new n.ParserError(`An unexpected error occurred: ${(0,n.getErrorMessage)(e)}`,e)}};s.encodeSingle=(e,t)=>(0,s.encode)([e],[t]);s.encodePacked=(e,t,r)=>(0,s.encode)(e,t,!0,r);s.decode=(e,t)=>{const s=(0,r.createBytes)(t);try{return(0,a.unpack)(e,s)}catch(e){if(e instanceof n.ParserError)throw new n.ParserError(`Unable to decode value: ${e.message}`,e);throw new n.ParserError(`An unexpected error occurred: ${(0,n.getErrorMessage)(e)}`,e)}};s.decodeSingle=(e,t)=>{const a=(0,s.decode)([e],t);return(0,r.assert)(1===a.length,new n.ParserError("Decoded value array has unexpected length.")),a[0]}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/abi.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/errors.js",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.ParserError=s.getErrorStack=s.getErrorMessage=void 0;const r=e("@metamask/utils");s.getErrorMessage=e=>"string"==typeof e?e:e instanceof Error||(0,r.isObject)(e)&&(0,r.hasProperty)(e,"message")&&"string"==typeof e.message?e.message:"Unknown error.";s.getErrorStack=e=>e instanceof Error?e.stack:undefined;class n extends Error{constructor(e,t){super(e),this.name="ParserError";const r=(0,s.getErrorStack)(t);r&&(this.stack=r)}}s.ParserError=n}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/errors.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/index.js",{"./abi":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/abi.js","./errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/errors.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/types/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./abi"),s),n(e("./errors"),s),n(e("./types"),s)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/iterator.js",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.iterate=void 0;const r=e("@metamask/utils");s.iterate=function*(e,t=32){for(let s=0;s<e.length;s+=t){const n=e=>{(0,r.assert)(e>=0,"Cannot skip a negative number of bytes."),(0,r.assert)(e%t==0,"Length must be a multiple of the size."),s+=e},a=e.subarray(s);yield{skip:n,value:a}}return{skip:()=>undefined,value:new Uint8Array}}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/iterator.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/packer.js",{"./errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/errors.js","./iterator":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/iterator.js","./parsers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/index.js","./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/utils/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.unpack=s.pack=s.isDynamicParser=s.getParser=void 0;const r=e("@metamask/utils"),n=e("./errors"),a=e("./iterator"),o=e("./parsers"),i=e("./utils");s.getParser=e=>{const t={address:o.address,array:o.array,bool:o.bool,bytes:o.bytes,fixedBytes:o.fixedBytes,function:o.fn,number:o.number,string:o.string,tuple:o.tuple},s=t[e];if(s)return s;const r=Object.values(t).find((t=>t.isType(e)));if(r)return r;throw new n.ParserError(`The type "${e}" is not supported.`)};s.isDynamicParser=(e,t)=>{const{isDynamic:s}=e;return"function"==typeof s?s(t):s};s.pack=({types:e,values:t,packed:a=!1,tight:o=!1,arrayPacked:m=!1,byteArray:c=new Uint8Array})=>{(0,r.assert)(e.length===t.length,new n.ParserError(`The number of types (${e.length}) does not match the number of values (${t.length}).`));const{staticBuffer:d,dynamicBuffer:u,pointers:l}=e.reduce((({staticBuffer:e,dynamicBuffer:n,pointers:i},c,d)=>{const u=(0,s.getParser)(c),l=t[d];if(a||m||!(0,s.isDynamicParser)(u,c))return{staticBuffer:u.encode({buffer:e,value:l,type:c,packed:a,tight:o}),dynamicBuffer:n,pointers:i};return{staticBuffer:(0,r.concatBytes)([e,new Uint8Array(32)]),dynamicBuffer:u.encode({buffer:n,value:l,type:c,packed:a,tight:o}),pointers:[...i,{position:e.length,pointer:n.length}]}}),{staticBuffer:new Uint8Array,dynamicBuffer:new Uint8Array,pointers:[]});(0,r.assert)(!a&&!m||0===u.length,new n.ParserError("Invalid pack state."));const f=d.length,h=l.reduce(((e,{pointer:t,position:s})=>{const n=(0,i.padStart)((0,r.numberToBytes)(f+t));return(0,i.set)(e,n,s)}),d);return(0,r.concatBytes)([c,h,u])};s.unpack=(e,t)=>{const o=(0,a.iterate)(t);return e.map((e=>{const{value:{value:a,skip:i},done:m}=o.next();(0,r.assert)(!m,new n.ParserError(`The encoded value is invalid for the provided types. Reached end of buffer while attempting to parse "${e}".`));const c=(0,s.getParser)(e);if((0,s.isDynamicParser)(c,e)){const s=(0,r.bytesToNumber)(a.subarray(0,32)),n=t.subarray(s);return c.decode({type:e,value:n,skip:i})}return c.decode({type:e,value:a,skip:i})}))}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/packer.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/address.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/errors.js","../utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/utils/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.address=s.getAddress=void 0;const r=e("@metamask/utils"),n=e("../errors"),a=e("../utils");s.getAddress=e=>{const t=(0,r.createBytes)(e);return(0,r.assert)(t.length<=20,new n.ParserError(`Invalid address value. Expected address to be 20 bytes long, but received ${t.length} bytes.`)),(0,a.padStart)(t,20)},s.address={isDynamic:!1,isType:e=>"address"===e,getByteLength:()=>32,encode({buffer:e,value:t,packed:n}){const o=(0,s.getAddress)(t);if(n)return(0,r.concatBytes)([e,o]);const i=(0,a.padStart)(o);return(0,r.concatBytes)([e,i])},decode:({value:e})=>(0,r.add0x)((0,r.bytesToHex)(e.slice(12,32)))}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/address.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/array.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/errors.js","../packer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/packer.js","../utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/utils/index.js","./fixed-bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/fixed-bytes.js","./tuple":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/tuple.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.array=s.getTupleType=s.getArrayType=s.isArrayType=void 0;const r=e("@metamask/utils"),n=e("../errors"),a=e("../packer"),o=e("../utils"),i=e("./fixed-bytes"),m=e("./tuple"),c=/^(?<type>.*)\[(?<length>\d*?)\]$/u;s.isArrayType=e=>c.test(e);s.getArrayType=e=>{const t=e.match(c);return(0,r.assert)(t?.groups?.type,new n.ParserError(`Invalid array type. Expected an array type, but received "${e}".`)),[t.groups.type,t.groups.length?parseInt(t.groups.length,10):undefined]};s.getTupleType=(e,t)=>`(${new Array(t).fill(e).join(",")})`,s.array={isDynamic(e){const[t,r]=(0,s.getArrayType)(e);return r===undefined||(0,a.isDynamicParser)((0,a.getParser)(t),t)},isType:e=>(0,s.isArrayType)(e),getByteLength(e){(0,r.assert)((0,s.isArrayType)(e),new n.ParserError(`Expected an array type, but received "${e}".`));const[t,o]=(0,s.getArrayType)(e);return(0,a.isDynamicParser)(this,e)||o===undefined?32:m.tuple.getByteLength((0,s.getTupleType)(t,o))},encode({type:e,buffer:t,value:c,packed:d,tight:u}){const[l,f]=(0,s.getArrayType)(e);if((0,r.assert)(!d||!(0,s.isArrayType)(l),new n.ParserError("Cannot pack nested arrays.")),d&&(0,a.isDynamicParser)((0,a.getParser)(l),l))return(0,a.pack)({types:new Array(c.length).fill(l),values:c,byteArray:t,packed:d,arrayPacked:!0,tight:u});if(f)return(0,r.assert)(f===c.length,new n.ParserError(`Array length does not match type length. Expected a length of ${f}, but received ${c.length}.`)),m.tuple.encode({type:(0,s.getTupleType)(l,f),buffer:t,value:c,packed:i.fixedBytes.isType(l)&&u,tight:u});if(d)return(0,a.pack)({types:new Array(c.length).fill(l),values:c,byteArray:t,packed:i.fixedBytes.isType(l)&&u,arrayPacked:!0,tight:u});const h=(0,o.padStart)((0,r.numberToBytes)(c.length));return(0,a.pack)({types:new Array(c.length).fill(l),values:c,byteArray:(0,r.concatBytes)([t,h]),packed:d,tight:u})},decode({type:e,value:t,...o}){const[i,c]=(0,s.getArrayType)(e);if(c){const e=m.tuple.decode({type:(0,s.getTupleType)(i,c),value:t,...o});return(0,r.assert)(e.length===c,new n.ParserError(`Array length does not match type length. Expected a length of ${c}, but received ${e.length}.`)),e}const d=(0,r.bytesToNumber)(t.subarray(0,32));return(0,a.unpack)(new Array(d).fill(i),t.subarray(32))}}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/array.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/bool.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/errors.js","./number":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/number.js","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.bool=s.getBooleanValue=void 0;const r=e("@metamask/superstruct"),n=e("@metamask/utils"),a=e("../errors"),o=e("./number"),i=(0,r.coerce)((0,r.boolean)(),(0,r.union)([(0,r.literal)("true"),(0,r.literal)("false")]),(e=>"true"===e));s.getBooleanValue=e=>{try{return(0,r.create)(e,i)?BigInt(1):BigInt(0)}catch{throw new a.ParserError(`Invalid boolean value. Expected a boolean literal, or the string "true" or "false", but received "${e}".`)}},s.bool={isDynamic:!1,isType:e=>"bool"===e,getByteLength:()=>32,encode({buffer:e,value:t,packed:r,tight:a}){const i=(0,s.getBooleanValue)(t);return r?(0,n.concatBytes)([e,(0,n.bigIntToBytes)(i)]):o.number.encode({type:"uint256",buffer:e,value:i,packed:r,tight:a})},decode:e=>o.number.decode({...e,type:"uint256"})===BigInt(1)}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/bool.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/bytes.js",{"../utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/utils/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.bytes=void 0;const r=e("@metamask/utils"),n=e("../utils");s.bytes={isDynamic:!0,isType:e=>"bytes"===e,getByteLength:()=>32,encode({buffer:e,value:t,packed:s}){const a=(0,r.createBytes)(t);if(s)return(0,r.concatBytes)([e,a]);const o=32*Math.ceil(a.byteLength/32);return(0,r.concatBytes)([e,(0,n.padStart)((0,r.numberToBytes)(a.byteLength)),(0,n.padEnd)(a,o)])},decode({value:e}){const t=e.subarray(0,32),s=(0,r.bytesToNumber)(t);return e.slice(32,32+s)}}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/bytes.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/fixed-bytes.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/errors.js","../utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/utils/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.fixedBytes=s.getByteLength=void 0;const r=e("@metamask/utils"),n=e("../errors"),a=e("../utils"),o=/^bytes([0-9]{1,2})$/u;s.getByteLength=e=>{const t=e.match(o)?.[1];(0,r.assert)(t,`Invalid byte length. Expected a number between 1 and 32, but received "${e}".`);const s=Number(t);return(0,r.assert)(s>0&&s<=32,new n.ParserError(`Invalid byte length. Expected a number between 1 and 32, but received "${e}".`)),s},s.fixedBytes={isDynamic:!1,isType:e=>o.test(e),getByteLength:()=>32,encode({type:e,buffer:t,value:o,packed:i}){const m=(0,s.getByteLength)(e),c=(0,r.createBytes)(o);return(0,r.assert)(c.length<=m,new n.ParserError(`Expected a value of length ${m}, but received a value of length ${c.length}.`)),i?(0,r.concatBytes)([t,(0,a.padEnd)(c,m)]):(0,r.concatBytes)([t,(0,a.padEnd)(c)])},decode({type:e,value:t}){const r=(0,s.getByteLength)(e);return t.slice(0,r)}}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/fixed-bytes.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/function.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/errors.js","./fixed-bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/fixed-bytes.js","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.fn=s.getFunction=void 0;const r=e("@metamask/superstruct"),n=e("@metamask/utils"),a=e("../errors"),o=e("./fixed-bytes"),i=(0,r.coerce)((0,r.object)({address:n.StrictHexStruct,selector:n.StrictHexStruct}),(0,r.union)([n.StrictHexStruct,(0,r.instance)(Uint8Array)]),(e=>{const t=(0,n.createBytes)(e);return(0,n.assert)(24===t.length,new a.ParserError(`Invalid Solidity function. Expected function to be 24 bytes long, but received ${t.length} bytes.`)),{address:(0,n.bytesToHex)(t.subarray(0,20)),selector:(0,n.bytesToHex)(t.subarray(20,24))}}));s.getFunction=e=>{const t=(0,r.create)(e,i);return(0,n.concatBytes)([(0,n.hexToBytes)(t.address),(0,n.hexToBytes)(t.selector)])},s.fn={isDynamic:!1,isType:e=>"function"===e,getByteLength:()=>32,encode({buffer:e,value:t,packed:r,tight:n}){const a=(0,s.getFunction)(t);return o.fixedBytes.encode({type:"bytes24",buffer:e,value:a,packed:r,tight:n})},decode:({value:e})=>({address:(0,n.bytesToHex)(e.slice(0,20)),selector:(0,n.bytesToHex)(e.slice(20,24))})}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/function.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/index.js",{"./address":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/address.js","./array":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/array.js","./bool":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/bool.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/bytes.js","./fixed-bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/fixed-bytes.js","./function":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/function.js","./number":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/number.js","./parser":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/parser.js","./string":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/string.js","./tuple":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/tuple.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./address"),s),n(e("./array"),s),n(e("./bool"),s),n(e("./bytes"),s),n(e("./fixed-bytes"),s),n(e("./function"),s),n(e("./number"),s),n(e("./parser"),s),n(e("./string"),s),n(e("./tuple"),s)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/number.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/errors.js","../utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/utils/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.number=s.getBigInt=s.assertNumberLength=s.getLength=s.isSigned=void 0;const r=e("@metamask/utils"),n=e("../errors"),a=e("../utils"),o=/^u?int(?<length>[0-9]*)?$/u;s.isSigned=e=>!e.startsWith("u");s.getLength=e=>{if("int"===e||"uint"===e)return 256;const t=e.match(o);(0,r.assert)(t?.groups?.length,new n.ParserError(`Invalid number type. Expected a number type, but received "${e}".`));const s=parseInt(t.groups.length,10);return(0,r.assert)(s>=8&&s<=256,new n.ParserError(`Invalid number length. Expected a number between 8 and 256, but received "${e}".`)),(0,r.assert)(s%8==0,new n.ParserError(`Invalid number length. Expected a multiple of 8, but received "${e}".`)),s};s.assertNumberLength=(e,t)=>{const a=(0,s.getLength)(t),o=BigInt(2)**BigInt(a-((0,s.isSigned)(t)?1:0))-BigInt(1);(0,s.isSigned)(t)?(0,r.assert)(e>=-(o+BigInt(1))&&e<=o,new n.ParserError(`Number "${e}" is out of range for type "${t}".`)):(0,r.assert)(e<=o,new n.ParserError(`Number "${e}" is out of range for type "${t}".`))};s.getBigInt=e=>{try{return(0,r.createBigInt)(e)}catch{throw new n.ParserError(`Invalid number. Expected a valid number value, but received "${e}".`)}},s.number={isDynamic:!1,isType:e=>o.test(e),getByteLength:()=>32,encode({type:e,buffer:t,value:n,packed:o}){const i=(0,s.getBigInt)(n);if((0,s.assertNumberLength)(i,e),(0,s.isSigned)(e)){if(o){const n=(0,s.getLength)(e)/8;return(0,r.concatBytes)([t,(0,r.signedBigIntToBytes)(i,n)])}return(0,r.concatBytes)([t,(0,a.padStart)((0,r.signedBigIntToBytes)(i,32))])}if(o){const n=(0,s.getLength)(e)/8;return(0,r.concatBytes)([t,(0,a.padStart)((0,r.bigIntToBytes)(i),n)])}return(0,r.concatBytes)([t,(0,a.padStart)((0,r.bigIntToBytes)(i))])},decode({type:e,value:t}){const n=t.subarray(0,32);if((0,s.isSigned)(e)){const t=(0,r.bytesToSignedBigInt)(n);return(0,s.assertNumberLength)(t,e),t}const a=(0,r.bytesToBigInt)(n);return(0,s.assertNumberLength)(a,e),a}}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/number.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/parser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0})}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/parser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/string.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/bytes.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.string=void 0;const r=e("@metamask/utils"),n=e("./bytes");s.string={isDynamic:!0,isType:e=>"string"===e,getByteLength:()=>32,encode:({buffer:e,value:t,packed:s,tight:a})=>n.bytes.encode({type:"bytes",buffer:e,value:(0,r.stringToBytes)(t),packed:s,tight:a}),decode:e=>(0,r.bytesToString)(n.bytes.decode(e))}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/string.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/tuple.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/errors.js","../packer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/packer.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.tuple=s.getTupleElements=void 0;const r=e("@metamask/utils"),n=e("../errors"),a=e("../packer"),o=/^\((.+)\)$/u;s.getTupleElements=e=>{(0,r.assert)(e.startsWith("(")&&e.endsWith(")"),new n.ParserError(`Invalid tuple type. Expected tuple type, but received "${e}".`));const t=[];let s="",a=0;for(let r=1;r<e.length-1;r++){const n=e[r];","===n&&0===a?(t.push(s.trim()),s=""):(s+=n,"("===n?a+=1:")"===n&&(a-=1))}return s.trim()&&t.push(s.trim()),t},s.tuple={isDynamic:e=>(0,s.getTupleElements)(e).some((e=>{const t=(0,a.getParser)(e);return(0,a.isDynamicParser)(t,e)})),isType:e=>(e=>o.test(e))(e),getByteLength(e){if((0,a.isDynamicParser)(this,e))return 32;return(0,s.getTupleElements)(e).reduce(((e,t)=>e+(0,a.getParser)(t).getByteLength(t)),0)},encode({type:e,buffer:t,value:r,packed:n,tight:o}){const i=(0,s.getTupleElements)(e);return(0,a.pack)({types:i,values:r,byteArray:t,packed:n,tight:o})},decode({type:e,value:t,skip:r}){const n=(0,s.getTupleElements)(e);return r(this.getByteLength(e)-32),(0,a.unpack)(n,t)}}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/tuple.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/types/abi.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0})}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/types/abi.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/types/index.js",{"./abi":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/types/abi.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./abi"),s)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/types/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/utils/buffer.js",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.padEnd=s.padStart=s.set=void 0;const r=e("@metamask/utils");s.set=(e,t,s)=>(0,r.concatBytes)([e.subarray(0,s),t,e.subarray(s+t.length)]);s.padStart=(e,t=32)=>{const s=new Uint8Array(Math.max(t-e.length,0)).fill(0);return(0,r.concatBytes)([s,e])};s.padEnd=(e,t=32)=>{const s=new Uint8Array(Math.max(t-e.length,0)).fill(0);return(0,r.concatBytes)([e,s])}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/utils/buffer.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/utils/index.js",{"./buffer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/utils/buffer.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./buffer"),s)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/utils/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/encryption.js",{"./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/utils.js","@scure/base":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@scure/base/lib/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js",tweetnacl:"/home/runner/work/metamask-extension/metamask-extension/node_modules/tweetnacl/nacl-fast.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),a=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var s in e)"default"!==s&&Object.prototype.hasOwnProperty.call(e,s)&&r(t,e,s);return n(t,e),t};Object.defineProperty(s,"__esModule",{value:!0}),s.getEncryptionPublicKey=s.decryptSafely=s.decrypt=s.encryptSafely=s.encrypt=void 0;const o=e("@scure/base"),i=a(e("tweetnacl")),m=e("./utils");function c({publicKey:e,data:t,version:s}){if((0,m.isNullish)(e))throw new Error("Missing publicKey parameter");if((0,m.isNullish)(t))throw new Error("Missing data parameter");if((0,m.isNullish)(s))throw new Error("Missing version parameter");if("x25519-xsalsa20-poly1305"===s){if("string"!=typeof t)throw new Error("Message data must be given as a string");const s=i.box.keyPair();let r;try{r=o.base64.decode(e)}catch(e){throw new Error("Bad public key")}const n=o.utf8.decode(t),a=i.randomBytes(i.box.nonceLength),m=i.box(n,a,r,s.secretKey);return{version:"x25519-xsalsa20-poly1305",nonce:o.base64.encode(a),ephemPublicKey:o.base64.encode(s.publicKey),ciphertext:o.base64.encode(m)}}throw new Error("Encryption type/version not supported")}function d({encryptedData:e,privateKey:s}){if((0,m.isNullish)(e))throw new Error("Missing encryptedData parameter");if((0,m.isNullish)(s))throw new Error("Missing privateKey parameter");if("x25519-xsalsa20-poly1305"===e.version){const r=t.from(s,"hex"),n=i.box.keyPair.fromSecretKey(r).secretKey,a=o.base64.decode(e.nonce),m=o.base64.decode(e.ciphertext),c=o.base64.decode(e.ephemPublicKey),d=i.box.open(m,a,c,n);try{if(!d)throw new Error;const e=o.utf8.encode(d);if(!e)throw new Error;return e}catch(e){if(e&&"string"==typeof e.message&&e.message.length)throw new Error(`Decryption failed: ${e.message}`);throw new Error("Decryption failed.")}}throw new Error("Encryption type/version not supported.")}s.encrypt=c,s.encryptSafely=function({publicKey:e,data:s,version:r}){if((0,m.isNullish)(e))throw new Error("Missing publicKey parameter");if((0,m.isNullish)(s))throw new Error("Missing data parameter");if((0,m.isNullish)(r))throw new Error("Missing version parameter");if("object"==typeof s&&s&&"toJSON"in s)throw new Error("Cannot encrypt with toJSON property.  Please remove toJSON property");const n={data:s,padding:""},a=t.byteLength(JSON.stringify(n),"utf-8")%2048;let o=0;return a>0&&(o=2048-a-16),n.padding="0".repeat(o),c({publicKey:e,data:JSON.stringify(n),version:r})},s.decrypt=d,s.decryptSafely=function({encryptedData:e,privateKey:t}){if((0,m.isNullish)(e))throw new Error("Missing encryptedData parameter");if((0,m.isNullish)(t))throw new Error("Missing privateKey parameter");return JSON.parse(d({encryptedData:e,privateKey:t})).data},s.getEncryptionPublicKey=function(e){const s=t.from(e,"hex"),r=i.box.keyPair.fromSecretKey(s).publicKey;return o.base64.encode(r)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/encryption.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/index.js",{"./encryption":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/encryption.js","./personal-sign":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/personal-sign.js","./sign-eip7702-authorization":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/sign-eip7702-authorization.js","./sign-typed-data":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/sign-typed-data.js","./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/utils.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),s.normalize=s.concatSig=void 0,n(e("./personal-sign"),s),n(e("./sign-typed-data"),s),n(e("./encryption"),s),n(e("./sign-eip7702-authorization"),s);var a=e("./utils");Object.defineProperty(s,"concatSig",{enumerable:!0,get:function(){return a.concatSig}}),Object.defineProperty(s,"normalize",{enumerable:!0,get:function(){return a.normalize}})}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/personal-sign.js",{"./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/utils.js","@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.extractPublicKey=s.recoverPersonalSignature=s.personalSign=void 0;const r=e("@ethereumjs/util"),n=e("./utils");function a(e,t){const s=(0,r.hashPersonalMessage)((0,n.legacyToBuffer)(e));return(0,n.recoverPublicKey)(s,t)}s.personalSign=function({privateKey:e,data:t}){if((0,n.isNullish)(t))throw new Error("Missing data parameter");if((0,n.isNullish)(e))throw new Error("Missing privateKey parameter");const s=(0,n.legacyToBuffer)(t),a=(0,r.hashPersonalMessage)(s),o=(0,r.ecsign)(a,e);return(0,n.concatSig)((0,r.toBuffer)(o.v),o.r,o.s)},s.recoverPersonalSignature=function({data:e,signature:t}){if((0,n.isNullish)(e))throw new Error("Missing data parameter");if((0,n.isNullish)(t))throw new Error("Missing signature parameter");const s=a(e,t),o=(0,r.publicToAddress)(s);return(0,r.bufferToHex)(o)},s.extractPublicKey=function({data:e,signature:t}){if((0,n.isNullish)(e))throw new Error("Missing data parameter");if((0,n.isNullish)(t))throw new Error("Missing signature parameter");return`0x${a(e,t).toString("hex")}`}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/personal-sign.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/sign-eip7702-authorization.js",{"./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/utils.js","@ethereumjs/rlp":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethereumjs/rlp/dist/index.js","@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.hashEIP7702Authorization=s.recoverEIP7702Authorization=s.signEIP7702Authorization=void 0;const r=e("@ethereumjs/rlp"),n=e("@ethereumjs/util"),a=e("@metamask/utils"),o=e("ethereum-cryptography/keccak"),i=e("./utils");function m(e){c(e);const s=(0,r.encode)(e),n=t.concat([t.from("05","hex"),s]);return t.from((0,o.keccak256)(n))}function c(e){if((0,i.isNullish)(e))throw new Error("Missing authorization parameter");const[t,s,r]=e;if((0,i.isNullish)(t))throw new Error("Missing chainId parameter");if((0,i.isNullish)(s))throw new Error("Missing contractAddress parameter");if((0,i.isNullish)(r))throw new Error("Missing nonce parameter")}s.signEIP7702Authorization=function({privateKey:e,authorization:t}){if(c(t),(0,i.isNullish)(e))throw new Error("Missing privateKey parameter");const s=m(t),{r:r,s:a,v:o}=(0,n.ecsign)(s,e),d=(0,n.toBuffer)(o);return(0,i.concatSig)(d,r,a)},s.recoverEIP7702Authorization=function({signature:e,authorization:t}){if(c(t),(0,i.isNullish)(e))throw new Error("Missing signature parameter");const s=m(t),r=(0,i.recoverPublicKey)(s,e),o=(0,n.publicToAddress)(r);return(0,a.bytesToHex)(o)},s.hashEIP7702Authorization=m}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/sign-eip7702-authorization.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/sign-typed-data.js",{"./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/utils.js","@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/index.js","@metamask/abi-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/index.js","@metamask/abi-utils/dist/parsers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/parsers/index.js","@metamask/abi-utils/dist/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/abi-utils/dist/utils/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.recoverTypedSignature=s.signTypedData=s.typedSignatureHash=s.TypedDataUtils=s.TYPED_MESSAGE_SCHEMA=s.SignTypedDataVersion=void 0;const r=e("@ethereumjs/util"),n=e("@metamask/abi-utils"),a=e("@metamask/abi-utils/dist/parsers"),o=e("@metamask/abi-utils/dist/utils"),i=e("@metamask/utils"),m=e("ethereum-cryptography/keccak"),c=e("./utils");var d;function u(e,t){if(!Object.keys(d).includes(e))throw new Error(`Invalid version: '${e}'`);if(t&&!t.includes(e))throw new Error(`SignTypedDataVersion not allowed: '${e}'. Allowed versions are: ${t.join(", ")}`)}function l(e,t){(0,i.assert)(null!==t,`Unable to encode value: Invalid number. Expected a valid number value, but received "${t}".`);const s=BigInt(t),r=(0,a.getLength)(e),n=BigInt(2)**BigInt(r)-BigInt(1);return(0,i.assert)(s>=-n&&s<=n,`Unable to encode value: Number "${t}" is out of range for type "${e}".`),s}function f(e){let t=BigInt(0);for(let s=0;s<e.length;s++){const r=BigInt(e.charCodeAt(s)-48);t*=BigInt(10),t+=r>=49?r-BigInt(49)+BigInt(10):r>=17?r-BigInt(17)+BigInt(10):r}return(0,o.padStart)((0,i.bigIntToBytes)(t),20)}function h(e,t,s,a,c){if(u(c,[d.V3,d.V4]),e[s]!==undefined)return["bytes32",c===d.V4&&null==a?"0x0000000000000000000000000000000000000000000000000000000000000000":(0,r.arrToBufArr)((0,m.keccak256)(p(s,a,e,c)))];if("function"===s)throw new Error('Unsupported or invalid type: "function"');if(a===undefined)throw new Error(`missing value for field ${t} of type ${s}`);if("address"===s){if("number"==typeof a)return["address",(0,o.padStart)((0,i.numberToBytes)(a),20)];if((0,i.isStrictHexString)(a))return["address",(0,i.add0x)(a)];if("string"==typeof a)return["address",f(a).subarray(0,20)]}if("bool"===s)return["bool",Boolean(a)];if("bytes"===s)return"number"==typeof a?a=(0,i.numberToBytes)(a):(0,i.isStrictHexString)(a)||"0x"===a?a=(0,i.hexToBytes)(a):"string"==typeof a&&(a=(0,i.stringToBytes)(a)),["bytes32",(0,r.arrToBufArr)((0,m.keccak256)(a))];if(s.startsWith("bytes")&&"bytes"!==s&&!s.includes("["))return"number"==typeof a?a<0?["bytes32",new Uint8Array(32)]:["bytes32",(0,i.bigIntToBytes)(BigInt(a))]:(0,i.isStrictHexString)(a)?["bytes32",(0,i.hexToBytes)(a)]:["bytes32",a];if(s.startsWith("int")&&!s.includes("[")){const e=l(s,a);return e>=BigInt(0)?["uint256",e]:["int256",e]}if("string"===s)return a="number"==typeof a?(0,i.numberToBytes)(a):(0,i.stringToBytes)(null!=a?a:""),["bytes32",(0,r.arrToBufArr)((0,m.keccak256)(a))];if(s.endsWith("]")){if(c===d.V3)throw new Error("Arrays are unimplemented in encodeData; use V4 extension");const o=s.slice(0,s.lastIndexOf("[")),i=a.map((s=>h(e,t,o,s,c)));return["bytes32",(0,r.arrToBufArr)((0,m.keccak256)((0,n.encode)(i.map((([e])=>e)),i.map((([,e])=>e)))))]}return[s,a]}function p(e,t,s,a){u(a,[d.V3,d.V4]);const o=["bytes32"],i=[y(e,s)];for(const r of s[e]){if(a===d.V3&&t[r.name]===undefined)continue;const[e,n]=h(s,r.name,r.type,t[r.name],a);o.push(e),i.push(n)}return(0,r.arrToBufArr)((0,n.encode)(o,i))}function g(e,t){let s="";const r=k(e,t);r.delete(e);const n=[e,...Array.from(r).sort()];for(const e of n){if(!t[e])throw new Error(`No type definition specified: ${e}`);s+=`${e}(${t[e].map((({name:e,type:t})=>`${t} ${e}`)).join(",")})`}return s}function k(e,t,s=new Set){if("string"!=typeof e)throw new Error(`Invalid findTypeDependencies input ${JSON.stringify(e)}`);const r=e.match(/^\w*/u);if([e]=r,s.has(e)||t[e]===undefined)return s;s.add(e);for(const r of t[e])k(r.type,t,s);return s}function b(e,t,s,n){u(n,[d.V3,d.V4]);const a=p(e,t,s,n),o=(0,m.keccak256)(a);return(0,r.arrToBufArr)(o)}function y(e,t){const s=(0,i.stringToBytes)(g(e,t));return(0,r.arrToBufArr)((0,m.keccak256)(s))}function x(e){const t={};for(const r in s.TYPED_MESSAGE_SCHEMA.properties)e[r]&&(t[r]=e[r]);return"types"in t&&(t.types=Object.assign({EIP712Domain:[]},t.types)),t}function w(e,t){u(t,[d.V3,d.V4]);const s=x(e),{domain:r}=s;return b("EIP712Domain",r,{EIP712Domain:s.types.EIP712Domain},t)}function E(e,t){if((0,a.isArrayType)(e)&&Array.isArray(t)){const[s]=(0,a.getArrayType)(e);return t.map((e=>E(s,e)))}if("address"===e){if((0,i.isStrictHexString)(t))return(0,o.padStart)((0,i.hexToBytes)(t).subarray(0,20),20);if(t instanceof Uint8Array)return(0,o.padStart)(t.subarray(0,20),20)}if("bool"===e)return Boolean(t);if(e.startsWith("bytes")&&"bytes"!==e){const s=(0,a.getByteLength)(e);if("number"==typeof t)return t<0?new Uint8Array:(0,i.numberToBytes)(t).subarray(0,s);if((0,i.isStrictHexString)(t))return(0,i.hexToBytes)(t).subarray(0,s);if(t instanceof Uint8Array)return t.subarray(0,s)}if(e.startsWith("uint")&&"number"==typeof t)return Math.abs(t);if(e.startsWith("int")&&"number"==typeof t){const s=(0,a.getLength)(e);return BigInt.asIntN(s,BigInt(t))}return t}function _(e,t){return t.map((t=>{if("string"==typeof t||"number"==typeof t||"bigint"==typeof t){const s=l(e,t);if(s>=BigInt(0))return(0,o.padStart)((0,i.bigIntToBytes)(s),32);const r=(0,a.getLength)(e),n=BigInt.asIntN(r,s);return(0,i.signedBigIntToBytes)(n,32)}return t}))}function v(e){const t=new Error("Expect argument to be non-empty array");if("object"!=typeof e||!("length"in e)||!e.length)throw t;const s=e.map((({name:e,type:t,value:s})=>{if("address[]"===t)return{name:e,type:"bytes32[]",value:(r=s,r.map((e=>"number"==typeof e?(0,o.padStart)((0,i.numberToBytes)(e),32):(0,i.isStrictHexString)(e)?(0,o.padStart)((0,i.hexToBytes)(e).subarray(0,32),32):e instanceof Uint8Array?(0,o.padStart)(e.subarray(0,32),32):e)))};var r;if(t.startsWith("int")&&(0,a.isArrayType)(t)){const[r,n]=(0,a.getArrayType)(t);return{name:e,type:`bytes32[${null!=n?n:""}]`,value:_(r,s)}}return{name:e,type:t,value:E(t,s)}})),d=s.map((e=>"bytes"!==e.type?e.value:(0,c.legacyToBuffer)(e.value))),u=s.map((e=>{if("function"===e.type)throw new Error('Unsupported or invalid type: "function"');return e.type})),l=e.map((e=>{if(!e.name)throw t;return`${e.type} ${e.name}`}));return(0,r.arrToBufArr)((0,m.keccak256)((0,n.encodePacked)(["bytes32","bytes32"],[(0,m.keccak256)((0,n.encodePacked)(["string[]"],[l],!0)),(0,m.keccak256)((0,n.encodePacked)(u,d,!0))])))}!function(e){e.V1="V1",e.V3="V3",e.V4="V4"}(d=s.SignTypedDataVersion||(s.SignTypedDataVersion={})),s.TYPED_MESSAGE_SCHEMA={type:"object",properties:{types:{type:"object",additionalProperties:{type:"array",items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}},required:["name","type"]}}},primaryType:{type:"string"},domain:{type:"object"},message:{type:"object"}},required:["types","primaryType","domain","message"]},s.TypedDataUtils={encodeData:p,encodeType:g,findTypeDependencies:k,hashStruct:b,hashType:y,sanitizeData:x,eip712Hash:function(e,t){u(t,[d.V3,d.V4]);const s=x(e),n=[(0,i.hexToBytes)("1901")];return n.push(w(e,t)),"EIP712Domain"!==s.primaryType&&n.push(b(s.primaryType,s.message,s.types,t)),(0,r.arrToBufArr)((0,m.keccak256)((0,i.concatBytes)(n)))},eip712DomainHash:w},s.typedSignatureHash=function(e){const t=v(e);return(0,i.bytesToHex)(t)},s.signTypedData=function({privateKey:e,data:t,version:n}){if(u(n),(0,c.isNullish)(t))throw new Error("Missing data parameter");if((0,c.isNullish)(e))throw new Error("Missing private key parameter");const a=n===d.V1?v(t):s.TypedDataUtils.eip712Hash(t,n),o=(0,r.ecsign)(a,e);return(0,c.concatSig)((0,r.arrToBufArr)((0,i.bigIntToBytes)(o.v)),o.r,o.s)},s.recoverTypedSignature=function({data:e,signature:t,version:n}){if(u(n),(0,c.isNullish)(e))throw new Error("Missing data parameter");if((0,c.isNullish)(t))throw new Error("Missing signature parameter");const a=n===d.V1?v(e):s.TypedDataUtils.eip712Hash(e,n),o=(0,c.recoverPublicKey)(a,t),m=(0,r.publicToAddress)(o);return(0,i.bytesToHex)(m)}}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/sign-typed-data.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/utils.js",{"@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@ethereumjs/util/dist/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.normalize=s.recoverPublicKey=s.concatSig=s.legacyToBuffer=s.isNullish=s.padWithZeroes=void 0;const r=e("@ethereumjs/util"),n=e("@metamask/utils");function a(e,t){if(""!==e&&!/^[a-f0-9]+$/iu.test(e))throw new Error(`Expected an unprefixed hex string. Received: ${e}`);if(t<0)throw new Error(`Expected a non-negative integer target length. Received: ${t}`);return String.prototype.padStart.call(e,t,"0")}function o(e){return null===e||e===undefined}s.padWithZeroes=a,s.isNullish=o,s.legacyToBuffer=function(e){return"string"!=typeof e||(0,r.isHexString)(e)?(0,r.toBuffer)(e):t.from(e)},s.concatSig=function(e,t,s){const o=(0,r.fromSigned)(t),i=(0,r.fromSigned)(s),m=(0,r.bufferToInt)(e),c=a((0,r.toUnsigned)(o).toString("hex"),64),d=a((0,r.toUnsigned)(i).toString("hex"),64),u=(0,n.remove0x)((0,n.numberToHex)(m));return(0,n.add0x)(c.concat(d,u))},s.recoverPublicKey=function(e,t){const s=(0,r.fromRpcSig)(t);return(0,r.ecrecover)(e,s.v,s.r,s.s)},s.normalize=function(e){if(o(e))return undefined;if("number"==typeof e){if(e<0)return"0x";const t=(0,n.numberToBytes)(e);e=(0,n.bytesToHex)(t)}if("string"!=typeof e){let t="eth-sig-util.normalize() requires hex string or integer input.";throw t+=` received ${typeof e}: ${e}`,new Error(t)}return(0,n.add0x)(e.toLowerCase())}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@metamask/eth-sig-util/dist/utils.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-middleware/node_modules/@scure/base/lib/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function r(e){if(!Number.isSafeInteger(e))throw new Error(`Wrong integer: ${e}`)}function n(e){return e instanceof Uint8Array||null!=e&&"object"==typeof e&&"Uint8Array"===e.constructor.name}function a(...e){const t=e=>e,s=(e,t)=>s=>e(t(s));return{encode:e.map((e=>e.encode)).reduceRight(s,t),decode:e.map((e=>e.decode)).reduce(s,t)}}function o(e){return{encode:t=>{if(!Array.isArray(t)||t.length&&"number"!=typeof t[0])throw new Error("alphabet.encode input should be an array of numbers");return t.map((t=>{if(r(t),t<0||t>=e.length)throw new Error(`Digit index outside alphabet: ${t} (alphabet: ${e.length})`);return e[t]}))},decode:t=>{if(!Array.isArray(t)||t.length&&"string"!=typeof t[0])throw new Error("alphabet.decode input should be array of strings");return t.map((t=>{if("string"!=typeof t)throw new Error(`alphabet.decode: not string element=${t}`);const s=e.indexOf(t);if(-1===s)throw new Error(`Unknown letter: "${t}". Allowed: ${e}`);return s}))}}}function i(e=""){if("string"!=typeof e)throw new Error("join separator should be string");return{encode:t=>{if(!Array.isArray(t)||t.length&&"string"!=typeof t[0])throw new Error("join.encode input should be array of strings");for(let e of t)if("string"!=typeof e)throw new Error(`join.encode: non-string input=${e}`);return t.join(e)},decode:t=>{if("string"!=typeof t)throw new Error("join.decode input should be string");return t.split(e)}}}function m(e,t="="){if(r(e),"string"!=typeof t)throw new Error("padding chr should be string");return{encode(s){if(!Array.isArray(s)||s.length&&"string"!=typeof s[0])throw new Error("padding.encode input should be array of strings");for(let e of s)if("string"!=typeof e)throw new Error(`padding.encode: non-string input=${e}`);for(;s.length*e%8;)s.push(t);return s},decode(s){if(!Array.isArray(s)||s.length&&"string"!=typeof s[0])throw new Error("padding.encode input should be array of strings");for(let e of s)if("string"!=typeof e)throw new Error(`padding.decode: non-string input=${e}`);let r=s.length;if(r*e%8)throw new Error("Invalid padding: string should have whole number of bytes");for(;r>0&&s[r-1]===t;r--)if(!((r-1)*e%8))throw new Error("Invalid padding: string has too much padding");return s.slice(0,r)}}}function c(e){if("function"!=typeof e)throw new Error("normalize fn should be function");return{encode:e=>e,decode:t=>e(t)}}function d(e,t,s){if(t<2)throw new Error(`convertRadix: wrong from=${t}, base cannot be less than 2`);if(s<2)throw new Error(`convertRadix: wrong to=${s}, base cannot be less than 2`);if(!Array.isArray(e))throw new Error("convertRadix: data should be array");if(!e.length)return[];let n=0;const a=[],o=Array.from(e);for(o.forEach((e=>{if(r(e),e<0||e>=t)throw new Error(`Wrong integer: ${e}`)}));;){let e=0,r=!0;for(let a=n;a<o.length;a++){const i=o[a],m=t*e+i;if(!Number.isSafeInteger(m)||t*e/t!==e||m-i!=t*e)throw new Error("convertRadix: carry overflow");e=m%s;const c=Math.floor(m/s);if(o[a]=c,!Number.isSafeInteger(c)||c*s+e!==m)throw new Error("convertRadix: carry overflow");r&&(c?r=!1:n=a)}if(a.push(e),r)break}for(let t=0;t<e.length-1&&0===e[t];t++)a.push(0);return a.reverse()}
/*! scure-base - MIT License (c) 2022 Paul Miller (paulmillr.com) */
Object.defineProperty(s,"__esModule",{value:!0}),s.bytes=s.stringToBytes=s.str=s.bytesToString=s.hex=s.utf8=s.bech32m=s.bech32=s.base58check=s.createBase58check=s.base58xmr=s.base58xrp=s.base58flickr=s.base58=s.base64urlnopad=s.base64url=s.base64nopad=s.base64=s.base32crockford=s.base32hexnopad=s.base32hex=s.base32nopad=s.base32=s.base16=s.utils=void 0,s.assertNumber=r;const u=(e,t)=>t?u(t,e%t):e,l=(e,t)=>e+(t-u(e,t));function f(e,t,s,n){if(!Array.isArray(e))throw new Error("convertRadix2: data should be array");if(t<=0||t>32)throw new Error(`convertRadix2: wrong from=${t}`);if(s<=0||s>32)throw new Error(`convertRadix2: wrong to=${s}`);if(l(t,s)>32)throw new Error(`convertRadix2: carry overflow from=${t} to=${s} carryBits=${l(t,s)}`);let a=0,o=0;const i=2**s-1,m=[];for(const n of e){if(r(n),n>=2**t)throw new Error(`convertRadix2: invalid data word=${n} from=${t}`);if(a=a<<t|n,o+t>32)throw new Error(`convertRadix2: carry overflow pos=${o} from=${t}`);for(o+=t;o>=s;o-=s)m.push((a>>o-s&i)>>>0);a&=2**o-1}if(a=a<<s-o&i,!n&&o>=t)throw new Error("Excess padding");if(!n&&a)throw new Error(`Non-zero padding: ${a}`);return n&&o>0&&m.push(a>>>0),m}function h(e){return r(e),{encode:t=>{if(!n(t))throw new Error("radix.encode input should be Uint8Array");return d(Array.from(t),256,e)},decode:t=>{if(!Array.isArray(t)||t.length&&"number"!=typeof t[0])throw new Error("radix.decode input should be array of numbers");return Uint8Array.from(d(t,e,256))}}}function p(e,t=!1){if(r(e),e<=0||e>32)throw new Error("radix2: bits should be in (0..32]");if(l(8,e)>32||l(e,8)>32)throw new Error("radix2: carry overflow");return{encode:s=>{if(!n(s))throw new Error("radix2.encode input should be Uint8Array");return f(Array.from(s),8,e,!t)},decode:s=>{if(!Array.isArray(s)||s.length&&"number"!=typeof s[0])throw new Error("radix2.decode input should be array of numbers");return Uint8Array.from(f(s,e,8,t))}}}function g(e){if("function"!=typeof e)throw new Error("unsafeWrapper fn should be function");return function(...t){try{return e.apply(null,t)}catch(e){}}}function k(e,t){if(r(e),"function"!=typeof t)throw new Error("checksum fn should be function");return{encode(s){if(!n(s))throw new Error("checksum.encode: input should be Uint8Array");const r=t(s).slice(0,e),a=new Uint8Array(s.length+e);return a.set(s),a.set(r,s.length),a},decode(s){if(!n(s))throw new Error("checksum.decode: input should be Uint8Array");const r=s.slice(0,-e),a=t(r).slice(0,e),o=s.slice(-e);for(let t=0;t<e;t++)if(a[t]!==o[t])throw new Error("Invalid checksum");return r}}}s.utils={alphabet:o,chain:a,checksum:k,convertRadix:d,convertRadix2:f,radix:h,radix2:p,join:i,padding:m},s.base16=a(p(4),o("0123456789ABCDEF"),i("")),s.base32=a(p(5),o("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),m(5),i("")),s.base32nopad=a(p(5),o("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),i("")),s.base32hex=a(p(5),o("0123456789ABCDEFGHIJKLMNOPQRSTUV"),m(5),i("")),s.base32hexnopad=a(p(5),o("0123456789ABCDEFGHIJKLMNOPQRSTUV"),i("")),s.base32crockford=a(p(5),o("0123456789ABCDEFGHJKMNPQRSTVWXYZ"),i(""),c((e=>e.toUpperCase().replace(/O/g,"0").replace(/[IL]/g,"1")))),s.base64=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),m(6),i("")),s.base64nopad=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),i("")),s.base64url=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),m(6),i("")),s.base64urlnopad=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),i(""));const b=e=>a(h(58),o(e),i(""));s.base58=b("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz"),s.base58flickr=b("123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ"),s.base58xrp=b("rpshnaf39wBUDNEGHJKLM4PQRST7VWXYZ2bcdeCg65jkm8oFqi1tuvAxyz");const y=[0,2,3,5,6,7,9,10,11];s.base58xmr={encode(e){let t="";for(let r=0;r<e.length;r+=8){const n=e.subarray(r,r+8);t+=s.base58.encode(n).padStart(y[n.length],"1")}return t},decode(e){let t=[];for(let r=0;r<e.length;r+=11){const n=e.slice(r,r+11),a=y.indexOf(n.length),o=s.base58.decode(n);for(let e=0;e<o.length-a;e++)if(0!==o[e])throw new Error("base58xmr: wrong padding");t=t.concat(Array.from(o.slice(o.length-a)))}return Uint8Array.from(t)}};s.createBase58check=e=>a(k(4,(t=>e(e(t)))),s.base58),s.base58check=s.createBase58check;const x=a(o("qpzry9x8gf2tvdw0s3jn54khce6mua7l"),i("")),w=[996825010,642813549,513874426,1027748829,705979059];function E(e){const t=e>>25;let s=(33554431&e)<<5;for(let e=0;e<w.length;e++)1==(t>>e&1)&&(s^=w[e]);return s}function _(e,t,s=1){const r=e.length;let n=1;for(let t=0;t<r;t++){const s=e.charCodeAt(t);if(s<33||s>126)throw new Error(`Invalid prefix (${e})`);n=E(n)^s>>5}n=E(n);for(let t=0;t<r;t++)n=E(n)^31&e.charCodeAt(t);for(let e of t)n=E(n)^e;for(let e=0;e<6;e++)n=E(n);return n^=s,x.encode(f([n%2**30],30,5,!1))}function v(e){const t="bech32"===e?1:734539939,s=p(5),r=s.decode,n=s.encode,a=g(r);function o(e,s,r=90){if("string"!=typeof e)throw new Error("bech32.encode prefix should be string, not "+typeof e);if(s instanceof Uint8Array&&(s=Array.from(s)),!Array.isArray(s)||s.length&&"number"!=typeof s[0])throw new Error("bech32.encode words should be array of numbers, not "+typeof s);if(0===e.length)throw new TypeError(`Invalid prefix length ${e.length}`);const n=e.length+7+s.length;if(!1!==r&&n>r)throw new TypeError(`Length ${n} exceeds limit ${r}`);const a=e.toLowerCase(),o=_(a,s,t);return`${a}1${x.encode(s)}${o}`}function i(e,s=90){if("string"!=typeof e)throw new Error("bech32.decode input should be string, not "+typeof e);if(e.length<8||!1!==s&&e.length>s)throw new TypeError(`Wrong string length: ${e.length} (${e}). Expected (8..${s})`);const r=e.toLowerCase();if(e!==r&&e!==e.toUpperCase())throw new Error("String must be lowercase or uppercase");const n=r.lastIndexOf("1");if(0===n||-1===n)throw new Error('Letter "1" must be present between prefix and data only');const a=r.slice(0,n),o=r.slice(n+1);if(o.length<6)throw new Error("Data must be at least 6 characters long");const i=x.decode(o).slice(0,-6),m=_(a,i,t);if(!o.endsWith(m))throw new Error(`Invalid checksum in ${e}: expected "${m}"`);return{prefix:a,words:i}}return{encode:o,decode:i,encodeFromBytes:function(e,t){return o(e,n(t))},decodeToBytes:function(e){const{prefix:t,words:s}=i(e,!1);return{prefix:t,words:s,bytes:r(s)}},decodeUnsafe:g(i),fromWords:r,fromWordsUnsafe:a,toWords:n}}s.bech32=v("bech32"),s.bech32m=v("bech32m"),s.utf8={encode:e=>(new TextDecoder).decode(e),decode:e=>(new TextEncoder).encode(e)},s.hex=a(p(4),o("0123456789abcdef"),i(""),c((e=>{if("string"!=typeof e||e.length%2)throw new TypeError(`hex.decode: expected string, got ${typeof e} with length ${e.length}`);return e.toLowerCase()})));const A={utf8:s.utf8,hex:s.hex,base16:s.base16,base32:s.base32,base64:s.base64,base64url:s.base64url,base58:s.base58,base58xmr:s.base58xmr},T="Invalid encoding type. Available types: utf8, hex, base16, base32, base64, base64url, base58, base58xmr";s.bytesToString=(e,t)=>{if("string"!=typeof e||!A.hasOwnProperty(e))throw new TypeError(T);if(!n(t))throw new TypeError("bytesToString() expects Uint8Array");return A[e].encode(t)},s.str=s.bytesToString;s.stringToBytes=(e,t)=>{if(!A.hasOwnProperty(e))throw new TypeError(T);if("string"!=typeof t)throw new TypeError("stringToBytes() expects string");return A[e].decode(t)},s.bytes=s.stringToBytes}}},{package:"@metamask/eth-json-rpc-middleware>@metamask/eth-sig-util>@scure/base",file:"node_modules/@metamask/eth-json-rpc-middleware/node_modules/@scure/base/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/index.cjs",{"./provider-from-engine.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-engine.cjs","./provider-from-middleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-middleware.cjs","./safe-event-emitter-provider.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/safe-event-emitter-provider.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),s.SafeEventEmitterProvider=void 0,n(e("./provider-from-engine.cjs"),s),n(e("./provider-from-middleware.cjs"),s);var a=e("./safe-event-emitter-provider.cjs");Object.defineProperty(s,"SafeEventEmitterProvider",{enumerable:!0,get:function(){return a.SafeEventEmitterProvider}})}}},{package:"@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-provider/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-engine.cjs",{"./safe-event-emitter-provider.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/safe-event-emitter-provider.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.providerFromEngine=void 0;const r=e("./safe-event-emitter-provider.cjs");s.providerFromEngine=function(e){return new r.SafeEventEmitterProvider({engine:e})}}}},{package:"@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-engine.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-middleware.cjs",{"./provider-from-engine.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-engine.cjs","@metamask/json-rpc-engine":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.providerFromMiddleware=void 0;const r=e("@metamask/json-rpc-engine"),n=e("./provider-from-engine.cjs");s.providerFromMiddleware=function(e){const t=new r.JsonRpcEngine;return t.push(e),(0,n.providerFromEngine)(t)}}}},{package:"@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-provider/dist/provider-from-middleware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-json-rpc-provider/dist/safe-event-emitter-provider.cjs",{"@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/safe-event-emitter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/safe-event-emitter/dist/cjs/index.js",uuid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/uuid/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,n=this&&this.__classPrivateFieldSet||function(e,t,s,r,n){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?n.call(e,s):n?n.value=s:t.set(e,s),s},a=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)},o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.SafeEventEmitterProvider=s.convertEip1193RequestToJsonRpcRequest=void 0;const i=e("@metamask/rpc-errors"),m=o(e("@metamask/safe-event-emitter")),c=e("uuid");function d(e){const{id:t=(0,c.v4)(),jsonrpc:s="2.0",method:r,params:n}=e;return n?{id:t,jsonrpc:s,method:r,params:n}:{id:t,jsonrpc:s,method:r}}s.convertEip1193RequestToJsonRpcRequest=d;class u extends m.default{constructor({engine:e}){super(),r.set(this,void 0),this.sendAsync=(e,t)=>{const s=d(e);a(this,r,"f").handle(s,t)},this.send=(e,t)=>{if("function"!=typeof t)throw new Error('Must provide callback to "send" method.');const s=d(e);a(this,r,"f").handle(s,t)},n(this,r,e,"f"),e.on&&e.on("notification",(e=>{this.emit("data",null,e)}))}async request(e){const t=d(e),s=await a(this,r,"f").handle(t);if("result"in s)return s.result;const n=new i.JsonRpcError(s.error.code,s.error.message,s.error.data);throw"stack"in s.error&&(n.stack=s.error.stack),n}}s.SafeEventEmitterProvider=u,r=new WeakMap}}},{package:"@metamask/eth-json-rpc-provider",file:"node_modules/@metamask/eth-json-rpc-provider/dist/safe-event-emitter-provider.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-query/index.js",{"json-rpc-random-id":"/home/runner/work/metamask-extension/metamask-extension/node_modules/json-rpc-random-id/index.js",xtend:"/home/runner/work/metamask-extension/metamask-extension/node_modules/xtend/immutable.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){const r=e("json-rpc-random-id")(),n=e("xtend");function a(e){this.currentProvider=e}function o(e){return function(...t){const s=t.pop();this.sendAsync({method:e,params:t},s)}}function i(e,t){return function(...s){const r=s.pop();s.length<e&&s.push("latest"),this.sendAsync({method:t,params:s},r)}}t.exports=a,a.prototype.getBalance=i(2,"eth_getBalance"),a.prototype.getCode=i(2,"eth_getCode"),a.prototype.getTransactionCount=i(2,"eth_getTransactionCount"),a.prototype.getStorageAt=i(3,"eth_getStorageAt"),a.prototype.call=i(2,"eth_call"),a.prototype.protocolVersion=o("eth_protocolVersion"),a.prototype.syncing=o("eth_syncing"),a.prototype.coinbase=o("eth_coinbase"),a.prototype.mining=o("eth_mining"),a.prototype.hashrate=o("eth_hashrate"),a.prototype.gasPrice=o("eth_gasPrice"),a.prototype.accounts=o("eth_accounts"),a.prototype.blockNumber=o("eth_blockNumber"),a.prototype.getBlockTransactionCountByHash=o("eth_getBlockTransactionCountByHash"),a.prototype.getBlockTransactionCountByNumber=o("eth_getBlockTransactionCountByNumber"),a.prototype.getUncleCountByBlockHash=o("eth_getUncleCountByBlockHash"),a.prototype.getUncleCountByBlockNumber=o("eth_getUncleCountByBlockNumber"),a.prototype.sign=o("eth_sign"),a.prototype.sendTransaction=o("eth_sendTransaction"),a.prototype.sendRawTransaction=o("eth_sendRawTransaction"),a.prototype.estimateGas=o("eth_estimateGas"),a.prototype.getBlockByHash=o("eth_getBlockByHash"),a.prototype.getBlockByNumber=o("eth_getBlockByNumber"),a.prototype.getTransactionByHash=o("eth_getTransactionByHash"),a.prototype.getTransactionByBlockHashAndIndex=o("eth_getTransactionByBlockHashAndIndex"),a.prototype.getTransactionByBlockNumberAndIndex=o("eth_getTransactionByBlockNumberAndIndex"),a.prototype.getTransactionReceipt=o("eth_getTransactionReceipt"),a.prototype.getUncleByBlockHashAndIndex=o("eth_getUncleByBlockHashAndIndex"),a.prototype.getUncleByBlockNumberAndIndex=o("eth_getUncleByBlockNumberAndIndex"),a.prototype.getCompilers=o("eth_getCompilers"),a.prototype.compileLLL=o("eth_compileLLL"),a.prototype.compileSolidity=o("eth_compileSolidity"),a.prototype.compileSerpent=o("eth_compileSerpent"),a.prototype.newFilter=o("eth_newFilter"),a.prototype.newBlockFilter=o("eth_newBlockFilter"),a.prototype.newPendingTransactionFilter=o("eth_newPendingTransactionFilter"),a.prototype.uninstallFilter=o("eth_uninstallFilter"),a.prototype.getFilterChanges=o("eth_getFilterChanges"),a.prototype.getFilterLogs=o("eth_getFilterLogs"),a.prototype.getLogs=o("eth_getLogs"),a.prototype.getWork=o("eth_getWork"),a.prototype.submitWork=o("eth_submitWork"),a.prototype.submitHashrate=o("eth_submitHashrate"),a.prototype.sendAsync=function(e,t){var s;this.currentProvider.sendAsync((s=e,n({id:r(),jsonrpc:"2.0",params:[]},s)),(function(e,s){let r=e;return!e&&s.error&&(r=new Error(`EthQuery - RPC Error - ${s.error.message}`)),r?t(r):t(null,s.result)}))}}}},{package:"@metamask/controller-utils>@metamask/eth-query",file:"node_modules/@metamask/eth-query/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/encryption.js",{"./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/utils.js","@scure/base":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@scure/base/lib/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js",tweetnacl:"/home/runner/work/metamask-extension/metamask-extension/node_modules/tweetnacl/nacl-fast.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),a=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var s in e)"default"!==s&&Object.prototype.hasOwnProperty.call(e,s)&&r(t,e,s);return n(t,e),t};Object.defineProperty(s,"__esModule",{value:!0}),s.getEncryptionPublicKey=s.decryptSafely=s.decrypt=s.encryptSafely=s.encrypt=void 0;const o=e("@scure/base"),i=a(e("tweetnacl")),m=e("./utils");function c({publicKey:e,data:t,version:s}){if((0,m.isNullish)(e))throw new Error("Missing publicKey parameter");if((0,m.isNullish)(t))throw new Error("Missing data parameter");if((0,m.isNullish)(s))throw new Error("Missing version parameter");if("x25519-xsalsa20-poly1305"===s){if("string"!=typeof t)throw new Error("Message data must be given as a string");const s=i.box.keyPair();let r;try{r=o.base64.decode(e)}catch(e){throw new Error("Bad public key")}const n=o.utf8.decode(t),a=i.randomBytes(i.box.nonceLength),m=i.box(n,a,r,s.secretKey);return{version:"x25519-xsalsa20-poly1305",nonce:o.base64.encode(a),ephemPublicKey:o.base64.encode(s.publicKey),ciphertext:o.base64.encode(m)}}throw new Error("Encryption type/version not supported")}function d({encryptedData:e,privateKey:s}){if((0,m.isNullish)(e))throw new Error("Missing encryptedData parameter");if((0,m.isNullish)(s))throw new Error("Missing privateKey parameter");if("x25519-xsalsa20-poly1305"===e.version){const r=t.from(s,"hex"),n=i.box.keyPair.fromSecretKey(r).secretKey,a=o.base64.decode(e.nonce),m=o.base64.decode(e.ciphertext),c=o.base64.decode(e.ephemPublicKey),d=i.box.open(m,a,c,n);try{if(!d)throw new Error;const e=o.utf8.encode(d);if(!e)throw new Error;return e}catch(e){if(e&&"string"==typeof e.message&&e.message.length)throw new Error(`Decryption failed: ${e.message}`);throw new Error("Decryption failed.")}}throw new Error("Encryption type/version not supported.")}s.encrypt=c,s.encryptSafely=function({publicKey:e,data:s,version:r}){if((0,m.isNullish)(e))throw new Error("Missing publicKey parameter");if((0,m.isNullish)(s))throw new Error("Missing data parameter");if((0,m.isNullish)(r))throw new Error("Missing version parameter");if("object"==typeof s&&s&&"toJSON"in s)throw new Error("Cannot encrypt with toJSON property.  Please remove toJSON property");const n={data:s,padding:""},a=t.byteLength(JSON.stringify(n),"utf-8")%2048;let o=0;return a>0&&(o=2048-a-16),n.padding="0".repeat(o),c({publicKey:e,data:JSON.stringify(n),version:r})},s.decrypt=d,s.decryptSafely=function({encryptedData:e,privateKey:t}){if((0,m.isNullish)(e))throw new Error("Missing encryptedData parameter");if((0,m.isNullish)(t))throw new Error("Missing privateKey parameter");return JSON.parse(d({encryptedData:e,privateKey:t})).data},s.getEncryptionPublicKey=function(e){const s=t.from(e,"hex"),r=i.box.keyPair.fromSecretKey(s).publicKey;return o.base64.encode(r)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/encryption.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/index.js",{"./encryption":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/encryption.js","./personal-sign":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/personal-sign.js","./sign-typed-data":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/sign-typed-data.js","./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/utils.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),s.normalize=s.concatSig=void 0,n(e("./personal-sign"),s),n(e("./sign-typed-data"),s),n(e("./encryption"),s);var a=e("./utils");Object.defineProperty(s,"concatSig",{enumerable:!0,get:function(){return a.concatSig}}),Object.defineProperty(s,"normalize",{enumerable:!0,get:function(){return a.normalize}})}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/personal-sign.js",{"./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/utils.js","@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.extractPublicKey=s.recoverPersonalSignature=s.personalSign=void 0;const r=e("@ethereumjs/util"),n=e("./utils");function a(e,t){const s=(0,r.hashPersonalMessage)((0,n.legacyToBuffer)(e));return(0,n.recoverPublicKey)(s,t)}s.personalSign=function({privateKey:e,data:t}){if((0,n.isNullish)(t))throw new Error("Missing data parameter");if((0,n.isNullish)(e))throw new Error("Missing privateKey parameter");const s=(0,n.legacyToBuffer)(t),a=(0,r.hashPersonalMessage)(s),o=(0,r.ecsign)(a,e);return(0,n.concatSig)((0,r.toBuffer)(o.v),o.r,o.s)},s.recoverPersonalSignature=function({data:e,signature:t}){if((0,n.isNullish)(e))throw new Error("Missing data parameter");if((0,n.isNullish)(t))throw new Error("Missing signature parameter");const s=a(e,t),o=(0,r.publicToAddress)(s);return(0,r.bufferToHex)(o)},s.extractPublicKey=function({data:e,signature:t}){if((0,n.isNullish)(e))throw new Error("Missing data parameter");if((0,n.isNullish)(t))throw new Error("Missing signature parameter");return`0x${a(e,t).toString("hex")}`}}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/personal-sign.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/sign-typed-data.js",{"./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/utils.js","@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js","@metamask/abi-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/abi-utils/dist/index.js","@metamask/abi-utils/dist/parsers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/abi-utils/dist/parsers/index.js","@metamask/abi-utils/dist/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/abi-utils/dist/utils/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/index.cjs","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.recoverTypedSignature=s.signTypedData=s.typedSignatureHash=s.TypedDataUtils=s.TYPED_MESSAGE_SCHEMA=s.SignTypedDataVersion=void 0;const r=e("@ethereumjs/util"),n=e("@metamask/abi-utils"),a=e("@metamask/abi-utils/dist/parsers"),o=e("@metamask/abi-utils/dist/utils"),i=e("@metamask/utils"),m=e("ethereum-cryptography/keccak"),c=e("./utils");var d;function u(e,t){if(!Object.keys(d).includes(e))throw new Error(`Invalid version: '${e}'`);if(t&&!t.includes(e))throw new Error(`SignTypedDataVersion not allowed: '${e}'. Allowed versions are: ${t.join(", ")}`)}function l(e,t){(0,i.assert)(null!==t,`Unable to encode value: Invalid number. Expected a valid number value, but received "${t}".`);const s=BigInt(t),r=(0,a.getLength)(e),n=BigInt(2)**BigInt(r)-BigInt(1);return(0,i.assert)(s>=-n&&s<=n,`Unable to encode value: Number "${t}" is out of range for type "${e}".`),s}function f(e){let t=BigInt(0);for(let s=0;s<e.length;s++){const r=BigInt(e.charCodeAt(s)-48);t*=BigInt(10),t+=r>=49?r-BigInt(49)+BigInt(10):r>=17?r-BigInt(17)+BigInt(10):r}return(0,o.padStart)((0,i.bigIntToBytes)(t),20)}function h(e,t,s,a,c){if(u(c,[d.V3,d.V4]),e[s]!==undefined)return["bytes32",c===d.V4&&null==a?"0x0000000000000000000000000000000000000000000000000000000000000000":(0,r.arrToBufArr)((0,m.keccak256)(p(s,a,e,c)))];if("function"===s)throw new Error('Unsupported or invalid type: "function"');if(a===undefined)throw new Error(`missing value for field ${t} of type ${s}`);if("address"===s){if("number"==typeof a)return["address",(0,o.padStart)((0,i.numberToBytes)(a),20)];if((0,i.isStrictHexString)(a))return["address",(0,i.add0x)(a)];if("string"==typeof a)return["address",f(a).subarray(0,20)]}if("bool"===s)return["bool",Boolean(a)];if("bytes"===s)return"number"==typeof a?a=(0,i.numberToBytes)(a):(0,i.isStrictHexString)(a)||"0x"===a?a=(0,i.hexToBytes)(a):"string"==typeof a&&(a=(0,i.stringToBytes)(a)),["bytes32",(0,r.arrToBufArr)((0,m.keccak256)(a))];if(s.startsWith("bytes")&&"bytes"!==s&&!s.includes("["))return"number"==typeof a?a<0?["bytes32",new Uint8Array(32)]:["bytes32",(0,i.bigIntToBytes)(BigInt(a))]:(0,i.isStrictHexString)(a)?["bytes32",(0,i.hexToBytes)(a)]:["bytes32",a];if(s.startsWith("int")&&!s.includes("[")){const e=l(s,a);return e>=BigInt(0)?["uint256",e]:["int256",e]}if("string"===s)return a="number"==typeof a?(0,i.numberToBytes)(a):(0,i.stringToBytes)(null!=a?a:""),["bytes32",(0,r.arrToBufArr)((0,m.keccak256)(a))];if(s.endsWith("]")){if(c===d.V3)throw new Error("Arrays are unimplemented in encodeData; use V4 extension");const o=s.slice(0,s.lastIndexOf("[")),i=a.map((s=>h(e,t,o,s,c)));return["bytes32",(0,r.arrToBufArr)((0,m.keccak256)((0,n.encode)(i.map((([e])=>e)),i.map((([,e])=>e)))))]}return[s,a]}function p(e,t,s,a){u(a,[d.V3,d.V4]);const o=["bytes32"],i=[y(e,s)];for(const r of s[e]){if(a===d.V3&&t[r.name]===undefined)continue;const[e,n]=h(s,r.name,r.type,t[r.name],a);o.push(e),i.push(n)}return(0,r.arrToBufArr)((0,n.encode)(o,i))}function g(e,t){let s="";const r=k(e,t);r.delete(e);const n=[e,...Array.from(r).sort()];for(const e of n){if(!t[e])throw new Error(`No type definition specified: ${e}`);s+=`${e}(${t[e].map((({name:e,type:t})=>`${t} ${e}`)).join(",")})`}return s}function k(e,t,s=new Set){if("string"!=typeof e)throw new Error(`Invalid findTypeDependencies input ${JSON.stringify(e)}`);const r=e.match(/^\w*/u);if([e]=r,s.has(e)||t[e]===undefined)return s;s.add(e);for(const r of t[e])k(r.type,t,s);return s}function b(e,t,s,n){u(n,[d.V3,d.V4]);const a=p(e,t,s,n),o=(0,m.keccak256)(a);return(0,r.arrToBufArr)(o)}function y(e,t){const s=(0,i.stringToBytes)(g(e,t));return(0,r.arrToBufArr)((0,m.keccak256)(s))}function x(e){const t={};for(const r in s.TYPED_MESSAGE_SCHEMA.properties)e[r]&&(t[r]=e[r]);return"types"in t&&(t.types=Object.assign({EIP712Domain:[]},t.types)),t}function w(e,t){u(t,[d.V3,d.V4]);const s=x(e),{domain:r}=s;return b("EIP712Domain",r,{EIP712Domain:s.types.EIP712Domain},t)}function E(e,t){if((0,a.isArrayType)(e)&&Array.isArray(t)){const[s]=(0,a.getArrayType)(e);return t.map((e=>E(s,e)))}if("address"===e){if("number"==typeof t)return(0,o.padStart)((0,i.numberToBytes)(t),20);if((0,i.isStrictHexString)(t))return(0,o.padStart)((0,i.hexToBytes)(t).subarray(0,20),20);if(t instanceof Uint8Array)return(0,o.padStart)(t.subarray(0,20),20)}if("bool"===e)return Boolean(t);if(e.startsWith("bytes")&&"bytes"!==e){const s=(0,a.getByteLength)(e);if("number"==typeof t)return t<0?new Uint8Array:(0,i.numberToBytes)(t).subarray(0,s);if((0,i.isStrictHexString)(t))return(0,i.hexToBytes)(t).subarray(0,s);if(t instanceof Uint8Array)return t.subarray(0,s)}if(e.startsWith("uint")&&"number"==typeof t)return Math.abs(t);if(e.startsWith("int")&&"number"==typeof t){const s=(0,a.getLength)(e);return BigInt.asIntN(s,BigInt(t))}return t}function _(e,t){return t.map((t=>{if("string"==typeof t||"number"==typeof t||"bigint"==typeof t){const s=l(e,t);if(s>=BigInt(0))return(0,o.padStart)((0,i.bigIntToBytes)(s),32);const r=(0,a.getLength)(e),n=BigInt.asIntN(r,s);return(0,i.signedBigIntToBytes)(n,32)}return t}))}function v(e){const t=new Error("Expect argument to be non-empty array");if("object"!=typeof e||!("length"in e)||!e.length)throw t;const s=e.map((({name:e,type:t,value:s})=>{if("address[]"===t)return{name:e,type:"bytes32[]",value:(r=s,r.map((e=>"number"==typeof e?(0,o.padStart)((0,i.numberToBytes)(e),32):(0,i.isStrictHexString)(e)?(0,o.padStart)((0,i.hexToBytes)(e).subarray(0,32),32):e instanceof Uint8Array?(0,o.padStart)(e.subarray(0,32),32):e)))};var r;if(t.startsWith("int")&&(0,a.isArrayType)(t)){const[r,n]=(0,a.getArrayType)(t);return{name:e,type:`bytes32[${null!=n?n:""}]`,value:_(r,s)}}return{name:e,type:t,value:E(t,s)}})),d=s.map((e=>"bytes"!==e.type?e.value:(0,c.legacyToBuffer)(e.value))),u=s.map((e=>{if("function"===e.type)throw new Error('Unsupported or invalid type: "function"');return e.type})),l=e.map((e=>{if(!e.name)throw t;return`${e.type} ${e.name}`}));return(0,r.arrToBufArr)((0,m.keccak256)((0,n.encodePacked)(["bytes32","bytes32"],[(0,m.keccak256)((0,n.encodePacked)(["string[]"],[l],!0)),(0,m.keccak256)((0,n.encodePacked)(u,d,!0))])))}!function(e){e.V1="V1",e.V3="V3",e.V4="V4"}(d=s.SignTypedDataVersion||(s.SignTypedDataVersion={})),s.TYPED_MESSAGE_SCHEMA={type:"object",properties:{types:{type:"object",additionalProperties:{type:"array",items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}},required:["name","type"]}}},primaryType:{type:"string"},domain:{type:"object"},message:{type:"object"}},required:["types","primaryType","domain","message"]},s.TypedDataUtils={encodeData:p,encodeType:g,findTypeDependencies:k,hashStruct:b,hashType:y,sanitizeData:x,eip712Hash:function(e,t){u(t,[d.V3,d.V4]);const s=x(e),n=[(0,i.hexToBytes)("1901")];return n.push(w(e,t)),"EIP712Domain"!==s.primaryType&&n.push(b(s.primaryType,s.message,s.types,t)),(0,r.arrToBufArr)((0,m.keccak256)((0,i.concatBytes)(n)))},eip712DomainHash:w},s.typedSignatureHash=function(e){const t=v(e);return(0,i.bytesToHex)(t)},s.signTypedData=function({privateKey:e,data:t,version:n}){if(u(n),(0,c.isNullish)(t))throw new Error("Missing data parameter");if((0,c.isNullish)(e))throw new Error("Missing private key parameter");const a=n===d.V1?v(t):s.TypedDataUtils.eip712Hash(t,n),o=(0,r.ecsign)(a,e);return(0,c.concatSig)((0,r.arrToBufArr)((0,i.bigIntToBytes)(o.v)),o.r,o.s)},s.recoverTypedSignature=function({data:e,signature:t,version:n}){if(u(n),(0,c.isNullish)(e))throw new Error("Missing data parameter");if((0,c.isNullish)(t))throw new Error("Missing signature parameter");const a=n===d.V1?v(e):s.TypedDataUtils.eip712Hash(e,n),o=(0,c.recoverPublicKey)(a,t),m=(0,r.publicToAddress)(o);return(0,i.bytesToHex)(m)}}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/sign-typed-data.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/dist/utils.js",{"@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/index.cjs",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.normalize=s.recoverPublicKey=s.concatSig=s.legacyToBuffer=s.isNullish=s.padWithZeroes=void 0;const r=e("@ethereumjs/util"),n=e("@metamask/utils");function a(e,t){if(""!==e&&!/^[a-f0-9]+$/iu.test(e))throw new Error(`Expected an unprefixed hex string. Received: ${e}`);if(t<0)throw new Error(`Expected a non-negative integer target length. Received: ${t}`);return String.prototype.padStart.call(e,t,"0")}function o(e){return null===e||e===undefined}s.padWithZeroes=a,s.isNullish=o,s.legacyToBuffer=function(e){return"string"!=typeof e||(0,r.isHexString)(e)?(0,r.toBuffer)(e):t.from(e)},s.concatSig=function(e,t,s){const o=(0,r.fromSigned)(t),i=(0,r.fromSigned)(s),m=(0,r.bufferToInt)(e),c=a((0,r.toUnsigned)(o).toString("hex"),64),d=a((0,r.toUnsigned)(i).toString("hex"),64),u=(0,n.remove0x)((0,n.numberToHex)(m));return(0,n.add0x)(c.concat(d,u))},s.recoverPublicKey=function(e,t){const s=(0,r.fromRpcSig)(t);return(0,r.ecrecover)(e,s.v,s.r,s.s)},s.normalize=function(e){if(o(e))return undefined;if("number"==typeof e){if(e<0)return"0x";const t=(0,n.numberToBytes)(e);e=(0,n.bytesToHex)(t)}if("string"!=typeof e){let t="eth-sig-util.normalize() requires hex string or integer input.";throw t+=` received ${typeof e}: ${e}`,new Error(t)}return(0,n.add0x)(e.toLowerCase())}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util",file:"node_modules/@metamask/eth-sig-util/dist/utils.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/account.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js","./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js","@ethereumjs/rlp":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethereumjs/rlp/dist/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js","ethereum-cryptography/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/utils.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.accountBodyToRLP=s.accountBodyToSlim=s.accountBodyFromSlim=s.isZeroAddress=s.zeroAddress=s.importPublic=s.privateToAddress=s.privateToPublic=s.publicToAddress=s.pubToAddress=s.isValidPublic=s.isValidPrivate=s.generateAddress2=s.generateAddress=s.isValidChecksumAddress=s.toChecksumAddress=s.isValidAddress=s.Account=void 0;const r=e("@ethereumjs/rlp"),n=e("ethereum-cryptography/keccak"),a=e("ethereum-cryptography/secp256k1"),o=e("ethereum-cryptography/utils"),i=e("./bytes"),m=e("./constants"),c=e("./helpers"),d=e("./internal"),u=BigInt(0);class l{constructor(e=u,t=u,s=m.KECCAK256_RLP,r=m.KECCAK256_NULL){this.nonce=e,this.balance=t,this.storageRoot=s,this.codeHash=r,this._validate()}static fromAccountData(e){const{nonce:t,balance:s,storageRoot:r,codeHash:n}=e;return new l(t!==undefined?(0,i.bufferToBigInt)((0,i.toBuffer)(t)):undefined,s!==undefined?(0,i.bufferToBigInt)((0,i.toBuffer)(s)):undefined,r!==undefined?(0,i.toBuffer)(r):undefined,n!==undefined?(0,i.toBuffer)(n):undefined)}static fromRlpSerializedAccount(e){const t=(0,i.arrToBufArr)(r.RLP.decode(Uint8Array.from(e)));if(!Array.isArray(t))throw new Error("Invalid serialized account input. Must be array");return this.fromValuesArray(t)}static fromValuesArray(e){const[t,s,r,n]=e;return new l((0,i.bufferToBigInt)(t),(0,i.bufferToBigInt)(s),r,n)}_validate(){if(this.nonce<u)throw new Error("nonce must be greater than zero");if(this.balance<u)throw new Error("balance must be greater than zero");if(32!==this.storageRoot.length)throw new Error("storageRoot must have a length of 32");if(32!==this.codeHash.length)throw new Error("codeHash must have a length of 32")}raw(){return[(0,i.bigIntToUnpaddedBuffer)(this.nonce),(0,i.bigIntToUnpaddedBuffer)(this.balance),this.storageRoot,this.codeHash]}serialize(){return t.from(r.RLP.encode((0,i.bufArrToArr)(this.raw())))}isContract(){return!this.codeHash.equals(m.KECCAK256_NULL)}isEmpty(){return this.balance===u&&this.nonce===u&&this.codeHash.equals(m.KECCAK256_NULL)}}s.Account=l;s.isValidAddress=function(e){try{(0,c.assertIsString)(e)}catch(e){return!1}return/^0x[0-9a-fA-F]{40}$/.test(e)};s.toChecksumAddress=function(e,s){(0,c.assertIsHexString)(e);const r=(0,d.stripHexPrefix)(e).toLowerCase();let a="";if(s!==undefined){a=(0,i.bufferToBigInt)((0,i.toBuffer)(s)).toString()+"0x"}const m=t.from(a+r,"utf8"),u=(0,o.bytesToHex)((0,n.keccak256)(m));let l="0x";for(let e=0;e<r.length;e++)parseInt(u[e],16)>=8?l+=r[e].toUpperCase():l+=r[e];return l};s.isValidChecksumAddress=function(e,t){return(0,s.isValidAddress)(e)&&(0,s.toChecksumAddress)(e,t)===e};s.generateAddress=function(e,s){return(0,c.assertIsBuffer)(e),(0,c.assertIsBuffer)(s),(0,i.bufferToBigInt)(s)===BigInt(0)?t.from((0,n.keccak256)(r.RLP.encode((0,i.bufArrToArr)([e,null])))).slice(-20):t.from((0,n.keccak256)(r.RLP.encode((0,i.bufArrToArr)([e,s])))).slice(-20)};s.generateAddress2=function(e,s,r){if((0,c.assertIsBuffer)(e),(0,c.assertIsBuffer)(s),(0,c.assertIsBuffer)(r),20!==e.length)throw new Error("Expected from to be of length 20");if(32!==s.length)throw new Error("Expected salt to be of length 32");const a=(0,n.keccak256)(t.concat([t.from("ff","hex"),e,s,(0,n.keccak256)(r)]));return(0,i.toBuffer)(a).slice(-20)};s.isValidPrivate=function(e){return a.secp256k1.utils.isValidPrivateKey(e)};s.isValidPublic=function(e,s=!1){if((0,c.assertIsBuffer)(e),64===e.length)try{return a.secp256k1.ProjectivePoint.fromHex(t.concat([t.from([4]),e])),!0}catch(e){return!1}if(!s)return!1;try{return a.secp256k1.ProjectivePoint.fromHex(e),!0}catch(e){return!1}};s.pubToAddress=function(e,s=!1){if((0,c.assertIsBuffer)(e),s&&64!==e.length&&(e=t.from(a.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),64!==e.length)throw new Error("Expected pubKey to be of length 64");return t.from((0,n.keccak256)(e)).slice(-20)},s.publicToAddress=s.pubToAddress;s.privateToPublic=function(e){return(0,c.assertIsBuffer)(e),t.from(a.secp256k1.ProjectivePoint.fromPrivateKey(e).toRawBytes(!1).slice(1))};s.privateToAddress=function(e){return(0,s.publicToAddress)((0,s.privateToPublic)(e))};s.importPublic=function(e){return(0,c.assertIsBuffer)(e),64!==e.length&&(e=t.from(a.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),e};s.zeroAddress=function(){const e=(0,i.zeros)(20);return(0,i.bufferToHex)(e)};function f(e){const[t,s,r,n]=e;return[t,s,0===(0,i.arrToBufArr)(r).length?m.KECCAK256_RLP:r,0===(0,i.arrToBufArr)(n).length?m.KECCAK256_NULL:n]}s.isZeroAddress=function(e){try{(0,c.assertIsString)(e)}catch(e){return!1}return(0,s.zeroAddress)()===e},s.accountBodyFromSlim=f;const h=new Uint8Array(0);s.accountBodyToSlim=function(e){const[t,s,r,n]=e;return[t,s,(0,i.arrToBufArr)(r).equals(m.KECCAK256_RLP)?h:r,(0,i.arrToBufArr)(n).equals(m.KECCAK256_NULL)?h:n]},s.accountBodyToRLP=function(e,t=!0){const s=t?f(e):e;return(0,i.arrToBufArr)(r.RLP.encode(s))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/account.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/address.js",{"./account":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/account.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.Address=void 0;const r=e("./account"),n=e("./bytes");class a{constructor(e){if(20!==e.length)throw new Error("Invalid address length");this.buf=e}static zero(){return new a((0,n.zeros)(20))}static fromString(e){if(!(0,r.isValidAddress)(e))throw new Error("Invalid address");return new a((0,n.toBuffer)(e))}static fromPublicKey(e){if(!t.isBuffer(e))throw new Error("Public key should be Buffer");const s=(0,r.pubToAddress)(e);return new a(s)}static fromPrivateKey(e){if(!t.isBuffer(e))throw new Error("Private key should be Buffer");const s=(0,r.privateToAddress)(e);return new a(s)}static generate(e,t){if("bigint"!=typeof t)throw new Error("Expected nonce to be a bigint");return new a((0,r.generateAddress)(e.buf,(0,n.bigIntToBuffer)(t)))}static generate2(e,s,n){if(!t.isBuffer(s))throw new Error("Expected salt to be a Buffer");if(!t.isBuffer(n))throw new Error("Expected initCode to be a Buffer");return new a((0,r.generateAddress2)(e.buf,s,n))}equals(e){return this.buf.equals(e.buf)}isZero(){return this.equals(a.zero())}isPrecompileOrSystemAddress(){const e=(0,n.bufferToBigInt)(this.buf),t=BigInt(0),s=BigInt("0xffff");return e>=t&&e<=s}toString(){return"0x"+this.buf.toString("hex")}toBuffer(){return t.from(this.buf)}}s.Address=a}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/address.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js",{events:"/home/runner/work/metamask-extension/metamask-extension/node_modules/events/events.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.AsyncEventEmitter=void 0;const r=e("events");class n extends r.EventEmitter{emit(e,...t){let[s,r]=t;const n=this;let a=n._events[e]??[];return r===undefined&&"function"==typeof s&&(r=s,s=undefined),"newListener"!==e&&"removeListener"!==e||(s={event:s,fn:r},r=undefined),a=Array.isArray(a)?a:[a],async function(e,t,s){let r;for await(const n of t)try{n.length<2?n.call(e,s):await new Promise(((t,r)=>{n.call(e,s,(e=>{e?r(e):t()}))}))}catch(e){r=e}if(r)throw r}(n,a.slice(),s).then(r).catch(r),n.listenerCount(e)>0}once(e,t){const s=this;let r;if("function"!=typeof t)throw new TypeError("listener must be a function");return r=t.length>=2?function(n,a){s.removeListener(e,r),t(n,a)}:function(n){s.removeListener(e,r),t(n,r)},s.on(e,r),s}first(e,t){let s=this._events[e]??[];if("function"!=typeof t)throw new TypeError("listener must be a function");return Array.isArray(s)||(this._events[e]=s=[s]),s.unshift(t),this}before(e,t,s){return this.beforeOrAfter(e,t,s)}after(e,t,s){return this.beforeOrAfter(e,t,s,"after")}beforeOrAfter(e,t,s,r){let n,a,o=this._events[e]??[];const i="after"===r?1:0;if("function"!=typeof s)throw new TypeError("listener must be a function");if("function"!=typeof t)throw new TypeError("target must be a function");for(Array.isArray(o)||(this._events[e]=o=[o]),a=o.length,n=o.length;n--;)if(o[n]===t){a=n+i;break}return o.splice(a,0,s),this}on(e,t){return super.on(e,t)}addListener(e,t){return super.addListener(e,t)}prependListener(e,t){return super.prependListener(e,t)}prependOnceListener(e,t){return super.prependOnceListener(e,t)}removeAllListeners(e){return super.removeAllListeners(e)}removeListener(e,t){return super.removeListener(e,t)}eventNames(){return super.eventNames()}listeners(e){return super.listeners(e)}listenerCount(e){return super.listenerCount(e)}getMaxListeners(){return super.getMaxListeners()}setMaxListeners(e){return super.setMaxListeners(e)}}s.AsyncEventEmitter=n}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js",{"./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.intToUnpaddedBuffer=s.bigIntToUnpaddedBuffer=s.bigIntToHex=s.bufArrToArr=s.arrToBufArr=s.validateNoLeadingZeroes=s.baToJSON=s.toUtf8=s.short=s.addHexPrefix=s.toUnsigned=s.fromSigned=s.bufferToInt=s.bigIntToBuffer=s.bufferToBigInt=s.bufferToHex=s.toBuffer=s.unpadHexString=s.unpadArray=s.unpadBuffer=s.setLengthRight=s.setLengthLeft=s.zeros=s.intToBuffer=s.intToHex=void 0;const r=e("./helpers"),n=e("./internal");s.intToHex=function(e){if(!Number.isSafeInteger(e)||e<0)throw new Error(`Received an invalid integer type: ${e}`);return`0x${e.toString(16)}`};s.intToBuffer=function(e){const r=(0,s.intToHex)(e);return t.from((0,n.padToEven)(r.slice(2)),"hex")};s.zeros=function(e){return t.allocUnsafe(e).fill(0)};const a=function(e,t,r){const n=(0,s.zeros)(t);return r?e.length<t?(e.copy(n),n):e.slice(0,t):e.length<t?(e.copy(n,t-e.length),n):e.slice(-t)};s.setLengthLeft=function(e,t){return(0,r.assertIsBuffer)(e),a(e,t,!1)};s.setLengthRight=function(e,t){return(0,r.assertIsBuffer)(e),a(e,t,!0)};const o=function(e){let t=e[0];for(;e.length>0&&"0"===t.toString();)t=(e=e.slice(1))[0];return e};s.unpadBuffer=function(e){return(0,r.assertIsBuffer)(e),o(e)};s.unpadArray=function(e){return(0,r.assertIsArray)(e),o(e)};s.unpadHexString=function(e){return(0,r.assertIsHexString)(e),e=(0,n.stripHexPrefix)(e),"0x"+o(e)};s.toBuffer=function(e){if(null===e||e===undefined)return t.allocUnsafe(0);if(t.isBuffer(e))return t.from(e);if(Array.isArray(e)||e instanceof Uint8Array)return t.from(e);if("string"==typeof e){if(!(0,n.isHexString)(e))throw new Error(`Cannot convert string to buffer. toBuffer only supports 0x-prefixed hex strings and this string was given: ${e}`);return t.from((0,n.padToEven)((0,n.stripHexPrefix)(e)),"hex")}if("number"==typeof e)return(0,s.intToBuffer)(e);if("bigint"==typeof e){if(e<BigInt(0))throw new Error(`Cannot convert negative bigint to buffer. Given: ${e}`);let s=e.toString(16);return s.length%2&&(s="0"+s),t.from(s,"hex")}if(e.toArray)return t.from(e.toArray());if(e.toBuffer)return t.from(e.toBuffer());throw new Error("invalid type")};function i(e){const t=(0,s.bufferToHex)(e);return"0x"===t?BigInt(0):BigInt(t)}function m(e){return(0,s.toBuffer)("0x"+e.toString(16))}s.bufferToHex=function(e){return"0x"+(e=(0,s.toBuffer)(e)).toString("hex")},s.bufferToBigInt=i,s.bigIntToBuffer=m;s.bufferToInt=function(e){const t=Number(i(e));if(!Number.isSafeInteger(t))throw new Error("Number exceeds 53 bits");return t};s.fromSigned=function(e){return BigInt.asIntN(256,i(e))};s.toUnsigned=function(e){return m(BigInt.asUintN(256,e))};s.addHexPrefix=function(e){return"string"!=typeof e||(0,n.isHexPrefixed)(e)?e:"0x"+e},s.short=function(e,s=50){const r=t.isBuffer(e)?e.toString("hex"):e;return r.length<=s?r:r.slice(0,s)+"…"};s.toUtf8=function(e){if((e=(0,n.stripHexPrefix)(e)).length%2!=0)throw new Error("Invalid non-even hex string input for toUtf8() provided");return t.from(e.replace(/^(00)+|(00)+$/g,""),"hex").toString("utf8")};s.baToJSON=function(e){if(t.isBuffer(e))return`0x${e.toString("hex")}`;if(e instanceof Array){const t=[];for(let r=0;r<e.length;r++)t.push((0,s.baToJSON)(e[r]));return t}};s.validateNoLeadingZeroes=function(e){for(const[t,s]of Object.entries(e))if(s!==undefined&&s.length>0&&0===s[0])throw new Error(`${t} cannot have leading zeroes, received: ${s.toString("hex")}`)},s.arrToBufArr=function e(s){return Array.isArray(s)?s.map((t=>e(t))):t.from(s)},s.bufArrToArr=function e(t){return Array.isArray(t)?t.map((t=>e(t))):Uint8Array.from(t??[])};s.bigIntToHex=e=>"0x"+e.toString(16),s.bigIntToUnpaddedBuffer=function(e){return(0,s.unpadBuffer)(m(e))},s.intToUnpaddedBuffer=function(e){return(0,s.unpadBuffer)((0,s.intToBuffer)(e))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.MAX_WITHDRAWALS_PER_PAYLOAD=s.RLP_EMPTY_STRING=s.KECCAK256_RLP=s.KECCAK256_RLP_S=s.KECCAK256_RLP_ARRAY=s.KECCAK256_RLP_ARRAY_S=s.KECCAK256_NULL=s.KECCAK256_NULL_S=s.TWO_POW256=s.SECP256K1_ORDER_DIV_2=s.SECP256K1_ORDER=s.MAX_INTEGER_BIGINT=s.MAX_INTEGER=s.MAX_UINT64=void 0;const r=e("buffer"),n=e("ethereum-cryptography/secp256k1");s.MAX_UINT64=BigInt("0xffffffffffffffff"),s.MAX_INTEGER=BigInt("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),s.MAX_INTEGER_BIGINT=BigInt("115792089237316195423570985008687907853269984665640564039457584007913129639935"),s.SECP256K1_ORDER=n.secp256k1.CURVE.n,s.SECP256K1_ORDER_DIV_2=n.secp256k1.CURVE.n/BigInt(2),s.TWO_POW256=BigInt("0x10000000000000000000000000000000000000000000000000000000000000000"),s.KECCAK256_NULL_S="c5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",s.KECCAK256_NULL=r.Buffer.from(s.KECCAK256_NULL_S,"hex"),s.KECCAK256_RLP_ARRAY_S="1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",s.KECCAK256_RLP_ARRAY=r.Buffer.from(s.KECCAK256_RLP_ARRAY_S,"hex"),s.KECCAK256_RLP_S="56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",s.KECCAK256_RLP=r.Buffer.from(s.KECCAK256_RLP_S,"hex"),s.RLP_EMPTY_STRING=r.Buffer.from([128]),s.MAX_WITHDRAWALS_PER_PAYLOAD=16}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/encoding.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.compactBytesToNibbles=s.bytesToNibbles=s.nibblesToCompactBytes=s.nibblesToBytes=s.hasTerminator=void 0;s.hasTerminator=e=>e.length>0&&16===e[e.length-1];s.nibblesToBytes=(e,t)=>{for(let s=0,r=0;r<e.length;s+=1,r+=2)t[s]=e[r]<<4|e[r+1]};s.nibblesToCompactBytes=e=>{let t=0;(0,s.hasTerminator)(e)&&(t=1,e=e.subarray(0,e.length-1));const r=new Uint8Array(e.length/2+1);return r[0]=t<<5,1&~e.length||(r[0]|=16,r[0]|=e[0],e=e.subarray(1)),(0,s.nibblesToBytes)(e,r.subarray(1)),r};s.bytesToNibbles=e=>{const t=2*e.length+1,s=new Uint8Array(t);for(let t=0;t<e.length;t++){const r=e[t];s[2*t]=r/16,s[2*t+1]=r%16}return s[t-1]=16,s};s.compactBytesToNibbles=e=>{if(0===e.length)return e;let t=(0,s.bytesToNibbles)(e);t[0]<2&&(t=t.subarray(0,t.length-1));const r=2-(1&t[0]);return t.subarray(r)}}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/encoding.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js",{"../../../../../../is-buffer/index.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/is-buffer/index.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.assertIsString=s.assertIsArray=s.assertIsBuffer=s.assertIsHexString=void 0;const r=e("./internal");s.assertIsHexString=function(e){if(!(0,r.isHexString)(e)){throw new Error(`This method only supports 0x-prefixed hex strings but input was: ${e}`)}};s.assertIsBuffer=function(e){if(!t.isBuffer(e)){throw new Error(`This method only supports Buffer but input was: ${e}`)}};s.assertIsArray=function(e){if(!Array.isArray(e)){throw new Error(`This method only supports number arrays but input was: ${e}`)}};s.assertIsString=function(e){if("string"!=typeof e){throw new Error(`This method only supports strings but input was: ${e}`)}}}).call(this)}).call(this,{isBuffer:e("../../../../../../is-buffer/index.js")})}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js",{"./account":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/account.js","./address":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/address.js","./asyncEventEmitter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js","./encoding":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/encoding.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js","./lock":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/lock.js","./provider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/provider.js","./signature":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/signature.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/types.js","./units":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/units.js","./withdrawal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/withdrawal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),s.toAscii=s.stripHexPrefix=s.padToEven=s.isHexString=s.isHexPrefixed=s.getKeys=s.getBinarySize=s.fromUtf8=s.fromAscii=s.arrayContainsArray=void 0,n(e("./constants"),s),n(e("./units"),s),n(e("./account"),s),n(e("./address"),s),n(e("./withdrawal"),s),n(e("./signature"),s),n(e("./bytes"),s),n(e("./types"),s),n(e("./encoding"),s),n(e("./asyncEventEmitter"),s);var a=e("./internal");Object.defineProperty(s,"arrayContainsArray",{enumerable:!0,get:function(){return a.arrayContainsArray}}),Object.defineProperty(s,"fromAscii",{enumerable:!0,get:function(){return a.fromAscii}}),Object.defineProperty(s,"fromUtf8",{enumerable:!0,get:function(){return a.fromUtf8}}),Object.defineProperty(s,"getBinarySize",{enumerable:!0,get:function(){return a.getBinarySize}}),Object.defineProperty(s,"getKeys",{enumerable:!0,get:function(){return a.getKeys}}),Object.defineProperty(s,"isHexPrefixed",{enumerable:!0,get:function(){return a.isHexPrefixed}}),Object.defineProperty(s,"isHexString",{enumerable:!0,get:function(){return a.isHexString}}),Object.defineProperty(s,"padToEven",{enumerable:!0,get:function(){return a.padToEven}}),Object.defineProperty(s,"stripHexPrefix",{enumerable:!0,get:function(){return a.stripHexPrefix}}),Object.defineProperty(s,"toAscii",{enumerable:!0,get:function(){return a.toAscii}}),n(e("./lock"),s),n(e("./provider"),s)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(e){(function(){function t(e){if("string"!=typeof e)throw new Error("[isHexPrefixed] input must be type 'string', received type "+typeof e);return"0"===e[0]&&"x"===e[1]}Object.defineProperty(s,"__esModule",{value:!0}),s.isHexString=s.getKeys=s.fromAscii=s.fromUtf8=s.toAscii=s.arrayContainsArray=s.getBinarySize=s.padToEven=s.stripHexPrefix=s.isHexPrefixed=void 0,s.isHexPrefixed=t;function r(e){let t=e;if("string"!=typeof t)throw new Error("[padToEven] value must be type 'string', received "+typeof t);return t.length%2&&(t=`0${t}`),t}s.stripHexPrefix=e=>{if("string"!=typeof e)throw new Error("[stripHexPrefix] input must be type 'string', received "+typeof e);return t(e)?e.slice(2):e},s.padToEven=r,s.getBinarySize=function(t){if("string"!=typeof t)throw new Error("[getBinarySize] method requires input type 'string', received "+typeof t);return e.byteLength(t,"utf8")},s.arrayContainsArray=function(e,t,s){if(!0!==Array.isArray(e))throw new Error(`[arrayContainsArray] method requires input 'superset' to be an array, got type '${typeof e}'`);if(!0!==Array.isArray(t))throw new Error(`[arrayContainsArray] method requires input 'subset' to be an array, got type '${typeof t}'`);return t[!0===s?"some":"every"]((t=>e.indexOf(t)>=0))},s.toAscii=function(e){let t="",s=0;const r=e.length;for("0x"===e.substring(0,2)&&(s=2);s<r;s+=2){const r=parseInt(e.substr(s,2),16);t+=String.fromCharCode(r)}return t},s.fromUtf8=function(t){return`0x${r(e.from(t,"utf8").toString("hex")).replace(/^0+|0+$/g,"")}`},s.fromAscii=function(e){let t="";for(let s=0;s<e.length;s++){const r=e.charCodeAt(s).toString(16);t+=r.length<2?`0${r}`:r}return`0x${t}`},s.getKeys=function(e,t,s){if(!Array.isArray(e))throw new Error("[getKeys] method expects input 'params' to be an array, got "+typeof e);if("string"!=typeof t)throw new Error("[getKeys] method expects input 'key' to be type 'string', got "+typeof e);const r=[];for(let n=0;n<e.length;n++){let a=e[n][t];if(!0!==s||a){if("string"!=typeof a)throw new Error("invalid abi - expected type 'string', received "+typeof a)}else a="";r.push(a)}return r},s.isHexString=function(e,t){return!("string"!=typeof e||!e.match(/^0x[0-9A-Fa-f]*$/))&&!(void 0!==t&&t>0&&e.length!==2+2*t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/lock.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.Lock=void 0;s.Lock=class{constructor(){this.permits=1,this.promiseResolverQueue=[]}async acquire(){return this.permits>0?(this.permits-=1,Promise.resolve(!0)):new Promise((e=>this.promiseResolverQueue.push(e)))}release(){if(this.permits+=1,this.permits>1&&this.promiseResolverQueue.length>0)console.warn("Lock.permits should never be > 0 when there is someone waiting.");else if(1===this.permits&&this.promiseResolverQueue.length>0){this.permits-=1;const e=this.promiseResolverQueue.shift();e&&e(!0)}}}}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/lock.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/provider.js",{"micro-ftch":"/home/runner/work/metamask-extension/metamask-extension/node_modules/micro-ftch/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.getProvider=s.fetchFromProvider=void 0;const r=e("micro-ftch");s.fetchFromProvider=async(e,t)=>(await(0,r.default)(e,{headers:{"content-type":"application/json"},type:"json",data:{method:t.method,params:t.params,jsonrpc:"2.0",id:1}})).result;s.getProvider=e=>{if("string"==typeof e)return e;if(e?.connection?.url!==undefined)return e.connection.url;throw new Error("Must provide valid provider URL or Web3Provider")}}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/provider.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/signature.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js","./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.hashPersonalMessage=s.isValidSignature=s.fromRpcSig=s.toCompactSig=s.toRpcSig=s.ecrecover=s.ecsign=void 0;const r=e("ethereum-cryptography/keccak"),n=e("ethereum-cryptography/secp256k1"),a=e("./bytes"),o=e("./constants"),i=e("./helpers");function m(e,t){return e===BigInt(0)||e===BigInt(1)?e:t===undefined?e-BigInt(27):e-(t*BigInt(2)+BigInt(35))}function c(e){return e===BigInt(0)||e===BigInt(1)}s.ecsign=function(e,s,r){const a=n.secp256k1.sign(e,s),o=a.toCompactRawBytes();return{r:t.from(o.slice(0,32)),s:t.from(o.slice(32,64)),v:r===undefined?BigInt(a.recovery+27):BigInt(a.recovery+35)+BigInt(r)*BigInt(2)}};s.ecrecover=function(e,s,r,o,i){const d=t.concat([(0,a.setLengthLeft)(r,32),(0,a.setLengthLeft)(o,32)],64),u=m(s,i);if(!c(u))throw new Error("Invalid signature v value");const l=n.secp256k1.Signature.fromCompact(d).addRecoveryBit(Number(u)).recoverPublicKey(e);return t.from(l.toRawBytes(!1).slice(1))};s.toRpcSig=function(e,s,r,n){if(!c(m(e,n)))throw new Error("Invalid signature v value");return(0,a.bufferToHex)(t.concat([(0,a.setLengthLeft)(s,32),(0,a.setLengthLeft)(r,32),(0,a.toBuffer)(e)]))};s.toCompactSig=function(e,s,r,n){if(!c(m(e,n)))throw new Error("Invalid signature v value");let o=r;return(e>BigInt(28)&&e%BigInt(2)===BigInt(1)||e===BigInt(1)||e===BigInt(28))&&(o=t.from(r),o[0]|=128),(0,a.bufferToHex)(t.concat([(0,a.setLengthLeft)(s,32),(0,a.setLengthLeft)(o,32)]))};s.fromRpcSig=function(e){const t=(0,a.toBuffer)(e);let s,r,n;if(t.length>=65)s=t.slice(0,32),r=t.slice(32,64),n=(0,a.bufferToBigInt)(t.slice(64));else{if(64!==t.length)throw new Error("Invalid signature length");s=t.slice(0,32),r=t.slice(32,64),n=BigInt((0,a.bufferToInt)(t.slice(32,33))>>7),r[0]&=127}return n<27&&(n+=BigInt(27)),{v:n,r:s,s:r}};s.isValidSignature=function(e,t,s,r=!0,n){if(32!==t.length||32!==s.length)return!1;if(!c(m(e,n)))return!1;const i=(0,a.bufferToBigInt)(t),d=(0,a.bufferToBigInt)(s);return!(i===BigInt(0)||i>=o.SECP256K1_ORDER||d===BigInt(0)||d>=o.SECP256K1_ORDER)&&!(r&&d>=o.SECP256K1_ORDER_DIV_2)};s.hashPersonalMessage=function(e){(0,i.assertIsBuffer)(e);const s=t.from(`Ethereum Signed Message:\n${e.length}`,"utf-8");return t.from((0,r.keccak256)(t.concat([s,e])))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/signature.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/types.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.toType=s.TypeOutput=void 0;const r=e("./bytes"),n=e("./internal");var a;!function(e){e[e.Number=0]="Number",e[e.BigInt=1]="BigInt",e[e.Buffer=2]="Buffer",e[e.PrefixedHexString=3]="PrefixedHexString"}(a=s.TypeOutput||(s.TypeOutput={})),s.toType=function(e,t){if(null===e)return null;if(e===undefined)return undefined;if("string"==typeof e&&!(0,n.isHexString)(e))throw new Error(`A string must be provided with a 0x-prefix, given: ${e}`);if("number"==typeof e&&!Number.isSafeInteger(e))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative input type)");const s=(0,r.toBuffer)(e);switch(t){case a.Buffer:return s;case a.BigInt:return(0,r.bufferToBigInt)(s);case a.Number:{const e=(0,r.bufferToBigInt)(s);if(e>BigInt(Number.MAX_SAFE_INTEGER))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative output type)");return Number(e)}case a.PrefixedHexString:return(0,r.bufferToHex)(s);default:throw new Error("unknown outputType")}}}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/types.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/units.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.GWEI_TO_WEI=void 0,s.GWEI_TO_WEI=BigInt(1e9)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/units.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/withdrawal.js",{"./address":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/address.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/types.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.Withdrawal=void 0;const r=e("./address"),n=e("./bytes"),a=e("./types");class o{constructor(e,t,s,r){this.index=e,this.validatorIndex=t,this.address=s,this.amount=r}static fromWithdrawalData(e){const{index:t,validatorIndex:s,address:n,amount:i}=e,m=(0,a.toType)(t,a.TypeOutput.BigInt),c=(0,a.toType)(s,a.TypeOutput.BigInt),d=new r.Address((0,a.toType)(n,a.TypeOutput.Buffer)),u=(0,a.toType)(i,a.TypeOutput.BigInt);return new o(m,c,d,u)}static fromValuesArray(e){if(4!==e.length)throw Error(`Invalid withdrawalArray length expected=4 actual=${e.length}`);const[t,s,r,n]=e;return o.fromWithdrawalData({index:t,validatorIndex:s,address:r,amount:n})}static toBufferArray(e){const{index:s,validatorIndex:n,address:o,amount:i}=e,m=(0,a.toType)(s,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(s,a.TypeOutput.Buffer),c=(0,a.toType)(n,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(n,a.TypeOutput.Buffer);let d;d=o instanceof r.Address?o.buf:(0,a.toType)(o,a.TypeOutput.Buffer);return[m,c,d,(0,a.toType)(i,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(i,a.TypeOutput.Buffer)]}raw(){return o.toBufferArray(this)}toValue(){return{index:this.index,validatorIndex:this.validatorIndex,address:this.address.buf,amount:this.amount}}toJSON(){return{index:(0,n.bigIntToHex)(this.index),validatorIndex:(0,n.bigIntToHex)(this.validatorIndex),address:"0x"+this.address.buf.toString("hex"),amount:(0,n.bigIntToHex)(this.amount)}}}s.Withdrawal=o}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/withdrawal.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/assert.cjs",{"./errors.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/errors.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.assertExhaustive=s.assertStruct=s.assert=s.AssertionError=void 0;const r=e("@metamask/superstruct"),n=e("./errors.cjs");function a(e,t){return s=e,Boolean("string"==typeof s?.prototype?.constructor?.name)?new e({message:t}):e({message:t});var s}class o extends Error{constructor(e){super(e.message),this.code="ERR_ASSERTION"}}s.AssertionError=o,s.assert=function(e,t="Assertion failed.",s=o){if(!e){if(t instanceof Error)throw t;throw a(s,t)}},s.assertStruct=function(e,t,s="Assertion failed",i=o){try{(0,r.assert)(e,t)}catch(e){throw a(i,`${s}: ${function(e){return(0,n.getErrorMessage)(e).replace(/\.$/u,"")}(e)}.`)}},s.assertExhaustive=function(e){throw new Error("Invalid branch reached. Should be detected during compilation.")}}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/assert.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/base64.cjs",{"./assert.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/assert.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.base64=void 0;const r=e("@metamask/superstruct"),n=e("./assert.cjs");s.base64=(e,t={})=>{const s=t.paddingRequired??!1,a=t.characterSet??"base64";let o,i;return"base64"===a?o=String.raw`[A-Za-z0-9+\/]`:((0,n.assert)("base64url"===a),o=String.raw`[-_A-Za-z0-9]`),i=s?new RegExp(`^(?:${o}{4})*(?:${o}{3}=|${o}{2}==)?$`,"u"):new RegExp(`^(?:${o}{4})*(?:${o}{2,3}|${o}{3}=|${o}{2}==)?$`,"u"),(0,r.pattern)(e,i)}}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/base64.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/bytes.cjs",{"./assert.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/assert.cjs","./hex.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/hex.cjs","@scure/base":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/node_modules/@scure/base/lib/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.createDataView=s.concatBytes=s.valueToBytes=s.base64ToBytes=s.stringToBytes=s.numberToBytes=s.signedBigIntToBytes=s.bigIntToBytes=s.hexToBytes=s.bytesToBase64=s.bytesToString=s.bytesToNumber=s.bytesToSignedBigInt=s.bytesToBigInt=s.bytesToHex=s.assertIsBytes=s.isBytes=void 0;const r=e("@scure/base"),n=e("./assert.cjs"),a=e("./hex.cjs"),o=48,i=58,m=87;const c=function(){const e=[];return()=>{if(0===e.length)for(let t=0;t<256;t++)e.push(t.toString(16).padStart(2,"0"));return e}}();function d(e){return e instanceof Uint8Array}function u(e){(0,n.assert)(d(e),"Value must be a Uint8Array.")}function l(e){if(u(e),0===e.length)return"0x";const t=c(),s=new Array(e.length);for(let r=0;r<e.length;r++)s[r]=t[e[r]];return(0,a.add0x)(s.join(""))}function f(e){u(e);const t=l(e);return BigInt(t)}function h(e){if("0x"===e?.toLowerCase?.())return new Uint8Array;(0,a.assertIsHexString)(e);const t=(0,a.remove0x)(e).toLowerCase(),s=t.length%2==0?t:`0${t}`,r=new Uint8Array(s.length/2);for(let e=0;e<r.length;e++){const t=s.charCodeAt(2*e),n=s.charCodeAt(2*e+1),a=t-(t<i?o:m),c=n-(n<i?o:m);r[e]=16*a+c}return r}function p(e){(0,n.assert)("bigint"==typeof e,"Value must be a bigint."),(0,n.assert)(e>=BigInt(0),"Value must be a non-negative bigint.");return h(e.toString(16))}function g(e){(0,n.assert)("number"==typeof e,"Value must be a number."),(0,n.assert)(e>=0,"Value must be a non-negative number."),(0,n.assert)(Number.isSafeInteger(e),"Value is not a safe integer. Use `bigIntToBytes` instead.");return h(e.toString(16))}function k(e){return(0,n.assert)("string"==typeof e,"Value must be a string."),(new TextEncoder).encode(e)}function b(e){if("bigint"==typeof e)return p(e);if("number"==typeof e)return g(e);if("string"==typeof e)return e.startsWith("0x")?h(e):k(e);if(d(e))return e;throw new TypeError(`Unsupported value type: "${typeof e}".`)}s.isBytes=d,s.assertIsBytes=u,s.bytesToHex=l,s.bytesToBigInt=f,s.bytesToSignedBigInt=function(e){u(e);let t=BigInt(0);for(const s of e)t=(t<<BigInt(8))+BigInt(s);return BigInt.asIntN(8*e.length,t)},s.bytesToNumber=function(e){u(e);const t=f(e);return(0,n.assert)(t<=BigInt(Number.MAX_SAFE_INTEGER),"Number is not a safe integer. Use `bytesToBigInt` instead."),Number(t)},s.bytesToString=function(e){return u(e),(new TextDecoder).decode(e)},s.bytesToBase64=function(e){return u(e),r.base64.encode(e)},s.hexToBytes=h,s.bigIntToBytes=p,s.signedBigIntToBytes=function(e,t){(0,n.assert)("bigint"==typeof e,"Value must be a bigint."),(0,n.assert)("number"==typeof t,"Byte length must be a number."),(0,n.assert)(t>0,"Byte length must be greater than 0."),(0,n.assert)(function(e,t){(0,n.assert)(t>0);const s=e>>BigInt(31);return!((~e&s)+(e&~s)>>BigInt(8*t-1))}(e,t),"Byte length is too small to represent the given value.");let s=e;const r=new Uint8Array(t);for(let e=0;e<r.length;e++)r[e]=Number(BigInt.asUintN(8,s)),s>>=BigInt(8);return r.reverse()},s.numberToBytes=g,s.stringToBytes=k,s.base64ToBytes=function(e){return(0,n.assert)("string"==typeof e,"Value must be a string."),r.base64.decode(e)},s.valueToBytes=b,s.concatBytes=function(e){const t=new Array(e.length);let s=0;for(let r=0;r<e.length;r++){const n=b(e[r]);t[r]=n,s+=n.length}const r=new Uint8Array(s);for(let e=0,s=0;e<t.length;e++)r.set(t[e],s),s+=t[e].length;return r},s.createDataView=function(e){if(void 0!==t&&e instanceof t){const t=e.buffer.slice(e.byteOffset,e.byteOffset+e.byteLength);return new DataView(t)}return new DataView(e.buffer,e.byteOffset,e.byteLength)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/bytes.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/caip-types.cjs",{"@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.toCaipChainId=s.parseCaipAccountId=s.parseCaipChainId=s.isCaipAssetId=s.isCaipAssetType=s.isCaipAccountAddress=s.isCaipAccountId=s.isCaipReference=s.isCaipNamespace=s.isCaipChainId=s.KnownCaipNamespace=s.CaipAssetIdStruct=s.CaipAssetTypeStruct=s.CaipAccountAddressStruct=s.CaipAccountIdStruct=s.CaipReferenceStruct=s.CaipNamespaceStruct=s.CaipChainIdStruct=s.CAIP_ASSET_ID_REGEX=s.CAIP_ASSET_TYPE_REGEX=s.CAIP_ACCOUNT_ADDRESS_REGEX=s.CAIP_ACCOUNT_ID_REGEX=s.CAIP_REFERENCE_REGEX=s.CAIP_NAMESPACE_REGEX=s.CAIP_CHAIN_ID_REGEX=void 0;const r=e("@metamask/superstruct");function n(e){return(0,r.is)(e,s.CaipNamespaceStruct)}function a(e){return(0,r.is)(e,s.CaipReferenceStruct)}s.CAIP_CHAIN_ID_REGEX=/^(?<namespace>[-a-z0-9]{3,8}):(?<reference>[-_a-zA-Z0-9]{1,32})$/u,s.CAIP_NAMESPACE_REGEX=/^[-a-z0-9]{3,8}$/u,s.CAIP_REFERENCE_REGEX=/^[-_a-zA-Z0-9]{1,32}$/u,s.CAIP_ACCOUNT_ID_REGEX=/^(?<chainId>(?<namespace>[-a-z0-9]{3,8}):(?<reference>[-_a-zA-Z0-9]{1,32})):(?<accountAddress>[-.%a-zA-Z0-9]{1,128})$/u,s.CAIP_ACCOUNT_ADDRESS_REGEX=/^[-.%a-zA-Z0-9]{1,128}$/u,s.CAIP_ASSET_TYPE_REGEX=/^(?<chainId>(?<namespace>[-a-z0-9]{3,8}):(?<reference>[-_a-zA-Z0-9]{1,32}))\/(?<assetNamespace>[-a-z0-9]{3,8}):(?<assetReference>[-.%a-zA-Z0-9]{1,128})$/u,s.CAIP_ASSET_ID_REGEX=/^(?<chainId>(?<namespace>[-a-z0-9]{3,8}):(?<reference>[-_a-zA-Z0-9]{1,32}))\/(?<assetNamespace>[-a-z0-9]{3,8}):(?<assetReference>[-.%a-zA-Z0-9]{1,128})\/(?<tokenId>[-.%a-zA-Z0-9]{1,78})$/u,s.CaipChainIdStruct=(0,r.pattern)((0,r.string)(),s.CAIP_CHAIN_ID_REGEX),s.CaipNamespaceStruct=(0,r.pattern)((0,r.string)(),s.CAIP_NAMESPACE_REGEX),s.CaipReferenceStruct=(0,r.pattern)((0,r.string)(),s.CAIP_REFERENCE_REGEX),s.CaipAccountIdStruct=(0,r.pattern)((0,r.string)(),s.CAIP_ACCOUNT_ID_REGEX),s.CaipAccountAddressStruct=(0,r.pattern)((0,r.string)(),s.CAIP_ACCOUNT_ADDRESS_REGEX),s.CaipAssetTypeStruct=(0,r.pattern)((0,r.string)(),s.CAIP_ASSET_TYPE_REGEX),s.CaipAssetIdStruct=(0,r.pattern)((0,r.string)(),s.CAIP_ASSET_ID_REGEX),function(e){e.Bip122="bip122",e.Eip155="eip155",e.Wallet="wallet"}(s.KnownCaipNamespace||(s.KnownCaipNamespace={})),s.isCaipChainId=function(e){return(0,r.is)(e,s.CaipChainIdStruct)},s.isCaipNamespace=n,s.isCaipReference=a,s.isCaipAccountId=function(e){return(0,r.is)(e,s.CaipAccountIdStruct)},s.isCaipAccountAddress=function(e){return(0,r.is)(e,s.CaipAccountAddressStruct)},s.isCaipAssetType=function(e){return(0,r.is)(e,s.CaipAssetTypeStruct)},s.isCaipAssetId=function(e){return(0,r.is)(e,s.CaipAssetIdStruct)},s.parseCaipChainId=function(e){const t=s.CAIP_CHAIN_ID_REGEX.exec(e);if(!t?.groups)throw new Error("Invalid CAIP chain ID.");return{namespace:t.groups.namespace,reference:t.groups.reference}},s.parseCaipAccountId=function(e){const t=s.CAIP_ACCOUNT_ID_REGEX.exec(e);if(!t?.groups)throw new Error("Invalid CAIP account ID.");return{address:t.groups.accountAddress,chainId:t.groups.chainId,chain:{namespace:t.groups.namespace,reference:t.groups.reference}}},s.toCaipChainId=function(e,t){if(!n(e))throw new Error(`Invalid "namespace", must match: ${s.CAIP_NAMESPACE_REGEX.toString()}`);if(!a(t))throw new Error(`Invalid "reference", must match: ${s.CAIP_REFERENCE_REGEX.toString()}`);return`${e}:${t}`}}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/caip-types.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/checksum.cjs",{"./base64.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/base64.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.ChecksumStruct=void 0;const r=e("@metamask/superstruct"),n=e("./base64.cjs");s.ChecksumStruct=(0,r.size)((0,n.base64)((0,r.string)(),{paddingRequired:!0}),44,44)}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/checksum.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/coercers.cjs",{"./assert.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/assert.cjs","./bytes.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/bytes.cjs","./hex.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/hex.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createHex=s.createBytes=s.createBigInt=s.createNumber=void 0;const r=e("@metamask/superstruct"),n=e("./assert.cjs"),a=e("./bytes.cjs"),o=e("./hex.cjs"),i=(0,r.union)([(0,r.number)(),(0,r.bigint)(),(0,r.string)(),o.StrictHexStruct]),m=(0,r.coerce)((0,r.number)(),i,Number),c=(0,r.coerce)((0,r.bigint)(),i,BigInt),d=((0,r.union)([o.StrictHexStruct,(0,r.instance)(Uint8Array)]),(0,r.coerce)((0,r.instance)(Uint8Array),(0,r.union)([o.StrictHexStruct]),a.hexToBytes)),u=(0,r.coerce)(o.StrictHexStruct,(0,r.instance)(Uint8Array),a.bytesToHex);s.createNumber=function(e){try{const t=(0,r.create)(e,m);return(0,n.assert)(Number.isFinite(t),`Expected a number-like value, got "${e}".`),t}catch(t){if(t instanceof r.StructError)throw new Error(`Expected a number-like value, got "${e}".`);throw t}},s.createBigInt=function(e){try{return(0,r.create)(e,c)}catch(e){if(e instanceof r.StructError)throw new Error(`Expected a number-like value, got "${String(e.value)}".`);throw e}},s.createBytes=function(e){if("string"==typeof e&&"0x"===e.toLowerCase())return new Uint8Array;try{return(0,r.create)(e,d)}catch(e){if(e instanceof r.StructError)throw new Error(`Expected a bytes-like value, got "${String(e.value)}".`);throw e}},s.createHex=function(e){if(e instanceof Uint8Array&&0===e.length||"string"==typeof e&&"0x"===e.toLowerCase())return"0x";try{return(0,r.create)(e,u)}catch(e){if(e instanceof r.StructError)throw new Error(`Expected a bytes-like value, got "${String(e.value)}".`);throw e}}}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/coercers.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/collections.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,n,a=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)},o=this&&this.__classPrivateFieldSet||function(e,t,s,r,n){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?n.call(e,s):n?n.value=s:t.set(e,s),s};Object.defineProperty(s,"__esModule",{value:!0}),s.FrozenSet=s.FrozenMap=void 0;class i{get size(){return a(this,r,"f").size}[(r=new WeakMap,Symbol.iterator)](){return a(this,r,"f")[Symbol.iterator]()}constructor(e){r.set(this,void 0),o(this,r,new Map(e),"f"),Object.freeze(this)}entries(){return a(this,r,"f").entries()}forEach(e,t){return a(this,r,"f").forEach(((s,r,n)=>e.call(t,s,r,this)))}get(e){return a(this,r,"f").get(e)}has(e){return a(this,r,"f").has(e)}keys(){return a(this,r,"f").keys()}values(){return a(this,r,"f").values()}toString(){return`FrozenMap(${this.size}) {${this.size>0?` ${[...this.entries()].map((([e,t])=>`${String(e)} => ${String(t)}`)).join(", ")} `:""}}`}}s.FrozenMap=i;class m{get size(){return a(this,n,"f").size}[(n=new WeakMap,Symbol.iterator)](){return a(this,n,"f")[Symbol.iterator]()}constructor(e){n.set(this,void 0),o(this,n,new Set(e),"f"),Object.freeze(this)}entries(){return a(this,n,"f").entries()}forEach(e,t){return a(this,n,"f").forEach(((s,r,n)=>e.call(t,s,r,this)))}has(e){return a(this,n,"f").has(e)}keys(){return a(this,n,"f").keys()}values(){return a(this,n,"f").values()}toString(){return`FrozenSet(${this.size}) {${this.size>0?` ${[...this.values()].map((e=>String(e))).join(", ")} `:""}}`}}s.FrozenSet=m,Object.freeze(i),Object.freeze(i.prototype),Object.freeze(m),Object.freeze(m.prototype)}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/collections.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/encryption-types.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0})}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/encryption-types.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/errors.cjs",{"./misc.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/misc.cjs","pony-cause":"/home/runner/work/metamask-extension/metamask-extension/node_modules/pony-cause/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.wrapError=s.getErrorMessage=s.isErrorWithStack=s.isErrorWithMessage=s.isErrorWithCode=void 0;const r=e("pony-cause"),n=e("./misc.cjs");function a(e){return"object"==typeof e&&null!==e&&"code"in e}function o(e){return"object"==typeof e&&null!==e&&"message"in e}s.isErrorWithCode=a,s.isErrorWithMessage=o,s.isErrorWithStack=function(e){return"object"==typeof e&&null!==e&&"stack"in e},s.getErrorMessage=function(e){return o(e)&&"string"==typeof e.message?e.message:(0,n.isNullOrUndefined)(e)?"":String(e)},s.wrapError=function(e,t){if((s=e)instanceof Error||(0,n.isObject)(s)&&"Error"===s.constructor.name){let s;return s=2===Error.length?new Error(t,{cause:e}):new r.ErrorWithCause(t,{cause:e}),a(e)&&(s.code=e.code),s}var s;return t.length>0?new Error(`${String(e)}: ${t}`):new Error(String(e))}}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/errors.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/hex.cjs",{"./assert.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/assert.cjs","./bytes.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/bytes.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@noble/hashes/sha3":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@noble/hashes/sha3.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.remove0x=s.add0x=s.isValidChecksumAddress=s.getChecksumAddress=s.isValidHexAddress=s.assertIsStrictHexString=s.assertIsHexString=s.isStrictHexString=s.isHexString=s.HexChecksumAddressStruct=s.HexAddressStruct=s.StrictHexStruct=s.HexStruct=void 0;const r=e("@metamask/superstruct"),n=e("@noble/hashes/sha3"),a=e("./assert.cjs"),o=e("./bytes.cjs");function i(e){return(0,r.is)(e,s.HexStruct)}function m(e){return(0,r.is)(e,s.StrictHexStruct)}function c(e){(0,a.assert)((0,r.is)(e,s.HexChecksumAddressStruct),"Invalid hex address.");const t=u(e.toLowerCase()),i=u((0,o.bytesToHex)((0,n.keccak_256)(t)));return`0x${t.split("").map(((e,t)=>{const s=i[t];return(0,a.assert)((0,r.is)(s,(0,r.string)()),"Hash shorter than address."),parseInt(s,16)>7?e.toUpperCase():e})).join("")}`}function d(e){return!!(0,r.is)(e,s.HexChecksumAddressStruct)&&c(e)===e}function u(e){return e.startsWith("0x")||e.startsWith("0X")?e.substring(2):e}s.HexStruct=(0,r.pattern)((0,r.string)(),/^(?:0x)?[0-9a-f]+$/iu),s.StrictHexStruct=(0,r.pattern)((0,r.string)(),/^0x[0-9a-f]+$/iu),s.HexAddressStruct=(0,r.pattern)((0,r.string)(),/^0x[0-9a-f]{40}$/u),s.HexChecksumAddressStruct=(0,r.pattern)((0,r.string)(),/^0x[0-9a-fA-F]{40}$/u),s.isHexString=i,s.isStrictHexString=m,s.assertIsHexString=function(e){(0,a.assert)(i(e),"Value must be a hexadecimal string.")},s.assertIsStrictHexString=function(e){(0,a.assert)(m(e),'Value must be a hexadecimal string, starting with "0x".')},s.isValidHexAddress=function(e){return(0,r.is)(e,s.HexAddressStruct)||d(e)},s.getChecksumAddress=c,s.isValidChecksumAddress=d,s.add0x=function(e){return e.startsWith("0x")?e:e.startsWith("0X")?`0x${e.substring(2)}`:`0x${e}`},s.remove0x=u}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/hex.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/index.cjs",{"./assert.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/assert.cjs","./base64.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/base64.cjs","./bytes.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/bytes.cjs","./caip-types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/caip-types.cjs","./checksum.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/checksum.cjs","./coercers.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/coercers.cjs","./collections.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/collections.cjs","./encryption-types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/encryption-types.cjs","./errors.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/errors.cjs","./hex.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/hex.cjs","./json.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/json.cjs","./keyring.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/keyring.cjs","./logging.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/logging.cjs","./misc.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/misc.cjs","./number.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/number.cjs","./opaque.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/opaque.cjs","./promise.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/promise.cjs","./time.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/time.cjs","./transaction-types.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/transaction-types.cjs","./versions.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/versions.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./assert.cjs"),s),n(e("./base64.cjs"),s),n(e("./bytes.cjs"),s),n(e("./caip-types.cjs"),s),n(e("./checksum.cjs"),s),n(e("./coercers.cjs"),s),n(e("./collections.cjs"),s),n(e("./encryption-types.cjs"),s),n(e("./errors.cjs"),s),n(e("./hex.cjs"),s),n(e("./json.cjs"),s),n(e("./keyring.cjs"),s),n(e("./logging.cjs"),s),n(e("./misc.cjs"),s),n(e("./number.cjs"),s),n(e("./opaque.cjs"),s),n(e("./promise.cjs"),s),n(e("./time.cjs"),s),n(e("./transaction-types.cjs"),s),n(e("./versions.cjs"),s)}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/json.cjs",{"./assert.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/assert.cjs","./misc.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/misc.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.getJsonRpcIdValidator=s.assertIsJsonRpcError=s.isJsonRpcError=s.assertIsJsonRpcFailure=s.isJsonRpcFailure=s.assertIsJsonRpcSuccess=s.isJsonRpcSuccess=s.assertIsJsonRpcResponse=s.isJsonRpcResponse=s.assertIsPendingJsonRpcResponse=s.isPendingJsonRpcResponse=s.JsonRpcResponseStruct=s.JsonRpcFailureStruct=s.JsonRpcSuccessStruct=s.PendingJsonRpcResponseStruct=s.assertIsJsonRpcRequest=s.isJsonRpcRequest=s.assertIsJsonRpcNotification=s.isJsonRpcNotification=s.JsonRpcNotificationStruct=s.JsonRpcRequestStruct=s.JsonRpcParamsStruct=s.JsonRpcErrorStruct=s.JsonRpcIdStruct=s.JsonRpcVersionStruct=s.jsonrpc2=s.getJsonSize=s.getSafeJson=s.isValidJson=s.JsonStruct=s.UnsafeJsonStruct=s.exactOptional=s.object=void 0;const r=e("@metamask/superstruct"),n=e("./assert.cjs"),a=e("./misc.cjs");function o({path:e,branch:t}){const s=e[e.length-1];return(0,a.hasProperty)(t[t.length-2],s)}function i(e){return new r.Struct({...e,type:`optional ${e.type}`,validator:(t,s)=>!o(s)||e.validator(t,s),refiner:(t,s)=>!o(s)||e.refiner(t,s)})}s.object=e=>(0,r.object)(e),s.exactOptional=i;function m(e){return(0,r.create)(e,s.JsonStruct)}s.UnsafeJsonStruct=(0,r.union)([(0,r.literal)(null),(0,r.boolean)(),(0,r.define)("finite number",(e=>(0,r.is)(e,(0,r.number)())&&Number.isFinite(e))),(0,r.string)(),(0,r.array)((0,r.lazy)((()=>s.UnsafeJsonStruct))),(0,r.record)((0,r.string)(),(0,r.lazy)((()=>s.UnsafeJsonStruct)))]),s.JsonStruct=(0,r.coerce)(s.UnsafeJsonStruct,(0,r.any)(),(e=>((0,n.assertStruct)(e,s.UnsafeJsonStruct),JSON.parse(JSON.stringify(e,((e,t)=>"__proto__"===e||"constructor"===e?undefined:t)))))),s.isValidJson=function(e){try{return m(e),!0}catch{return!1}},s.getSafeJson=m,s.getJsonSize=function(e){(0,n.assertStruct)(e,s.JsonStruct,"Invalid JSON value");const t=JSON.stringify(e);return(new TextEncoder).encode(t).byteLength},s.jsonrpc2="2.0",s.JsonRpcVersionStruct=(0,r.literal)(s.jsonrpc2),s.JsonRpcIdStruct=(0,r.nullable)((0,r.union)([(0,r.number)(),(0,r.string)()])),s.JsonRpcErrorStruct=(0,s.object)({code:(0,r.integer)(),message:(0,r.string)(),data:i(s.JsonStruct),stack:i((0,r.string)())}),s.JsonRpcParamsStruct=(0,r.union)([(0,r.record)((0,r.string)(),s.JsonStruct),(0,r.array)(s.JsonStruct)]),s.JsonRpcRequestStruct=(0,s.object)({id:s.JsonRpcIdStruct,jsonrpc:s.JsonRpcVersionStruct,method:(0,r.string)(),params:i(s.JsonRpcParamsStruct)}),s.JsonRpcNotificationStruct=(0,s.object)({jsonrpc:s.JsonRpcVersionStruct,method:(0,r.string)(),params:i(s.JsonRpcParamsStruct)}),s.isJsonRpcNotification=function(e){return(0,r.is)(e,s.JsonRpcNotificationStruct)},s.assertIsJsonRpcNotification=function(e,t){(0,n.assertStruct)(e,s.JsonRpcNotificationStruct,"Invalid JSON-RPC notification",t)},s.isJsonRpcRequest=function(e){return(0,r.is)(e,s.JsonRpcRequestStruct)},s.assertIsJsonRpcRequest=function(e,t){(0,n.assertStruct)(e,s.JsonRpcRequestStruct,"Invalid JSON-RPC request",t)},s.PendingJsonRpcResponseStruct=(0,r.object)({id:s.JsonRpcIdStruct,jsonrpc:s.JsonRpcVersionStruct,result:(0,r.optional)((0,r.unknown)()),error:(0,r.optional)(s.JsonRpcErrorStruct)}),s.JsonRpcSuccessStruct=(0,s.object)({id:s.JsonRpcIdStruct,jsonrpc:s.JsonRpcVersionStruct,result:s.JsonStruct}),s.JsonRpcFailureStruct=(0,s.object)({id:s.JsonRpcIdStruct,jsonrpc:s.JsonRpcVersionStruct,error:s.JsonRpcErrorStruct}),s.JsonRpcResponseStruct=(0,r.union)([s.JsonRpcSuccessStruct,s.JsonRpcFailureStruct]),s.isPendingJsonRpcResponse=function(e){return(0,r.is)(e,s.PendingJsonRpcResponseStruct)},s.assertIsPendingJsonRpcResponse=function(e,t){(0,n.assertStruct)(e,s.PendingJsonRpcResponseStruct,"Invalid pending JSON-RPC response",t)},s.isJsonRpcResponse=function(e){return(0,r.is)(e,s.JsonRpcResponseStruct)},s.assertIsJsonRpcResponse=function(e,t){(0,n.assertStruct)(e,s.JsonRpcResponseStruct,"Invalid JSON-RPC response",t)},s.isJsonRpcSuccess=function(e){return(0,r.is)(e,s.JsonRpcSuccessStruct)},s.assertIsJsonRpcSuccess=function(e,t){(0,n.assertStruct)(e,s.JsonRpcSuccessStruct,"Invalid JSON-RPC success response",t)},s.isJsonRpcFailure=function(e){return(0,r.is)(e,s.JsonRpcFailureStruct)},s.assertIsJsonRpcFailure=function(e,t){(0,n.assertStruct)(e,s.JsonRpcFailureStruct,"Invalid JSON-RPC failure response",t)},s.isJsonRpcError=function(e){return(0,r.is)(e,s.JsonRpcErrorStruct)},s.assertIsJsonRpcError=function(e,t){(0,n.assertStruct)(e,s.JsonRpcErrorStruct,"Invalid JSON-RPC error",t)},s.getJsonRpcIdValidator=function(e){const{permitEmptyString:t,permitFractions:s,permitNull:r}={permitEmptyString:!0,permitFractions:!1,permitNull:!0,...e};return e=>Boolean("number"==typeof e&&(s||Number.isInteger(e))||"string"==typeof e&&(t||e.length>0)||r&&null===e)}}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/json.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/keyring.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0})}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/keyring.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/logging.cjs",{debug:"/home/runner/work/metamask-extension/metamask-extension/node_modules/debug/src/browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.createModuleLogger=s.createProjectLogger=void 0;const n=(0,r(e("debug")).default)("metamask");s.createProjectLogger=function(e){return n.extend(e)},s.createModuleLogger=function(e,t){return e.extend(t)}}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/logging.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/misc.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.calculateNumberSize=s.calculateStringSize=s.isASCII=s.isPlainObject=s.ESCAPE_CHARACTERS_REGEXP=s.JsonSize=s.getKnownPropertyNames=s.hasProperty=s.isObject=s.isNullOrUndefined=s.isNonEmptyArray=void 0,s.isNonEmptyArray=function(e){return Array.isArray(e)&&e.length>0},s.isNullOrUndefined=function(e){return null===e||e===undefined},s.isObject=function(e){return Boolean(e)&&"object"==typeof e&&!Array.isArray(e)};function r(e){return e.charCodeAt(0)<=127}s.hasProperty=(e,t)=>Object.hasOwnProperty.call(e,t),s.getKnownPropertyNames=function(e){return Object.getOwnPropertyNames(e)},function(e){e[e.Null=4]="Null",e[e.Comma=1]="Comma",e[e.Wrapper=1]="Wrapper",e[e.True=4]="True",e[e.False=5]="False",e[e.Quote=1]="Quote",e[e.Colon=1]="Colon",e[e.Date=24]="Date"}(s.JsonSize||(s.JsonSize={})),s.ESCAPE_CHARACTERS_REGEXP=/"|\\|\n|\r|\t/gu,s.isPlainObject=function(e){if("object"!=typeof e||null===e)return!1;try{let t=e;for(;null!==Object.getPrototypeOf(t);)t=Object.getPrototypeOf(t);return Object.getPrototypeOf(e)===t}catch(e){return!1}},s.isASCII=r,s.calculateStringSize=function(e){return e.split("").reduce(((e,t)=>r(t)?e+1:e+2),0)+(e.match(s.ESCAPE_CHARACTERS_REGEXP)??[]).length},s.calculateNumberSize=function(e){return e.toString().length}}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/misc.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/number.cjs",{"./assert.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/assert.cjs","./hex.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/hex.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.hexToBigInt=s.hexToNumber=s.bigIntToHex=s.numberToHex=void 0;const r=e("./assert.cjs"),n=e("./hex.cjs");s.numberToHex=e=>((0,r.assert)("number"==typeof e,"Value must be a number."),(0,r.assert)(e>=0,"Value must be a non-negative number."),(0,r.assert)(Number.isSafeInteger(e),"Value is not a safe integer. Use `bigIntToHex` instead."),(0,n.add0x)(e.toString(16)));s.bigIntToHex=e=>((0,r.assert)("bigint"==typeof e,"Value must be a bigint."),(0,r.assert)(e>=0,"Value must be a non-negative bigint."),(0,n.add0x)(e.toString(16)));s.hexToNumber=e=>{(0,n.assertIsHexString)(e);const t=parseInt(e,16);return(0,r.assert)(Number.isSafeInteger(t),"Value is not a safe integer. Use `hexToBigInt` instead."),t};s.hexToBigInt=e=>((0,n.assertIsHexString)(e),BigInt((0,n.add0x)(e)))}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/number.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/opaque.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0})}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/opaque.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/promise.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createDeferredPromise=void 0,s.createDeferredPromise=function({suppressUnhandledRejection:e=!1}={}){let t,s;const r=new Promise(((e,r)=>{t=e,s=r}));return e&&r.catch((e=>{})),{promise:r,resolve:t,reject:s}}}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/promise.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/time.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.timeSince=s.inMilliseconds=s.Duration=void 0,function(e){e[e.Millisecond=1]="Millisecond",e[e.Second=1e3]="Second",e[e.Minute=6e4]="Minute",e[e.Hour=36e5]="Hour",e[e.Day=864e5]="Day",e[e.Week=6048e5]="Week",e[e.Year=31536e6]="Year"}(s.Duration||(s.Duration={}));const r=(e,t)=>{if(!(e=>Number.isInteger(e)&&e>=0)(e))throw new Error(`"${t}" must be a non-negative integer. Received: "${e}".`)};s.inMilliseconds=function(e,t){return r(e,"count"),e*t},s.timeSince=function(e){return r(e,"timestamp"),Date.now()-e}}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/time.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/transaction-types.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0})}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/transaction-types.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/versions.cjs",{"./assert.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/assert.cjs","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs",semver:"/home/runner/work/metamask-extension/metamask-extension/node_modules/semver/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.satisfiesVersionRange=s.gtRange=s.gtVersion=s.assertIsSemVerRange=s.assertIsSemVerVersion=s.isValidSemVerRange=s.isValidSemVerVersion=s.VersionRangeStruct=s.VersionStruct=void 0;const r=e("@metamask/superstruct"),n=e("semver"),a=e("./assert.cjs");s.VersionStruct=(0,r.refine)((0,r.string)(),"Version",(e=>null!==(0,n.valid)(e)||`Expected SemVer version, got "${e}"`)),s.VersionRangeStruct=(0,r.refine)((0,r.string)(),"Version range",(e=>null!==(0,n.validRange)(e)||`Expected SemVer range, got "${e}"`)),s.isValidSemVerVersion=function(e){return(0,r.is)(e,s.VersionStruct)},s.isValidSemVerRange=function(e){return(0,r.is)(e,s.VersionRangeStruct)},s.assertIsSemVerVersion=function(e){(0,a.assertStruct)(e,s.VersionStruct)},s.assertIsSemVerRange=function(e){(0,a.assertStruct)(e,s.VersionRangeStruct)},s.gtVersion=function(e,t){return(0,n.gt)(e,t)},s.gtRange=function(e,t){return(0,n.gtr)(e,t)},s.satisfiesVersionRange=function(e,t){return(0,n.satisfies)(e,t,{includePrerelease:!0})}}}},{package:"@metamask/eth-sig-util>@metamask/utils",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/dist/versions.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/node_modules/@scure/base/lib/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function r(e){return e instanceof Uint8Array||ArrayBuffer.isView(e)&&"Uint8Array"===e.constructor.name}function n(e,...t){if(!r(e))throw new Error("Uint8Array expected");if(t.length>0&&!t.includes(e.length))throw new Error("Uint8Array expected of length "+t+", got length="+e.length)}function a(e,t){return!!Array.isArray(t)&&(0===t.length||(e?t.every((e=>"string"==typeof e)):t.every((e=>Number.isSafeInteger(e)))))}function o(e){if("function"!=typeof e)throw new Error("function expected");return!0}function i(e,t){if("string"!=typeof t)throw new Error(`${e}: string expected`);return!0}function m(e){if(!Number.isSafeInteger(e))throw new Error(`invalid integer: ${e}`)}function c(e){if(!Array.isArray(e))throw new Error("array expected")}function d(e,t){if(!a(!0,t))throw new Error(`${e}: array of strings expected`)}function u(e,t){if(!a(!1,t))throw new Error(`${e}: array of numbers expected`)}function l(...e){const t=e=>e,s=(e,t)=>s=>e(t(s));return{encode:e.map((e=>e.encode)).reduceRight(s,t),decode:e.map((e=>e.decode)).reduce(s,t)}}function f(e){const t="string"==typeof e?e.split(""):e,s=t.length;d("alphabet",t);const r=new Map(t.map(((e,t)=>[e,t])));return{encode:r=>(c(r),r.map((r=>{if(!Number.isSafeInteger(r)||r<0||r>=s)throw new Error(`alphabet.encode: digit index outside alphabet "${r}". Allowed: ${e}`);return t[r]}))),decode:t=>(c(t),t.map((t=>{i("alphabet.decode",t);const s=r.get(t);if(s===undefined)throw new Error(`Unknown letter: "${t}". Allowed: ${e}`);return s})))}}function h(e=""){return i("join",e),{encode:t=>(d("join.decode",t),t.join(e)),decode:t=>(i("join.decode",t),t.split(e))}}function p(e,t="="){return m(e),i("padding",t),{encode(s){for(d("padding.encode",s);s.length*e%8;)s.push(t);return s},decode(s){d("padding.decode",s);let r=s.length;if(r*e%8)throw new Error("padding: invalid, string should have whole number of bytes");for(;r>0&&s[r-1]===t;r--){if((r-1)*e%8==0)throw new Error("padding: invalid, string has too much padding")}return s.slice(0,r)}}}function g(e){return o(e),{encode:e=>e,decode:t=>e(t)}}function k(e,t,s){if(t<2)throw new Error(`convertRadix: invalid from=${t}, base cannot be less than 2`);if(s<2)throw new Error(`convertRadix: invalid to=${s}, base cannot be less than 2`);if(c(e),!e.length)return[];let r=0;const n=[],a=Array.from(e,(e=>{if(m(e),e<0||e>=t)throw new Error(`invalid integer: ${e}`);return e})),o=a.length;for(;;){let e=0,i=!0;for(let n=r;n<o;n++){const o=a[n],m=t*e,c=m+o;if(!Number.isSafeInteger(c)||m/t!==e||c-o!==m)throw new Error("convertRadix: carry overflow");const d=c/s;e=c%s;const u=Math.floor(d);if(a[n]=u,!Number.isSafeInteger(u)||u*s+e!==c)throw new Error("convertRadix: carry overflow");i&&(u?i=!1:r=n)}if(n.push(e),i)break}for(let t=0;t<e.length-1&&0===e[t];t++)n.push(0);return n.reverse()}
/*! scure-base - MIT License (c) 2022 Paul Miller (paulmillr.com) */
Object.defineProperty(s,"__esModule",{value:!0}),s.bytes=s.stringToBytes=s.str=s.bytesToString=s.hex=s.utf8=s.bech32m=s.bech32=s.base58check=s.createBase58check=s.base58xmr=s.base58xrp=s.base58flickr=s.base58=s.base64urlnopad=s.base64url=s.base64nopad=s.base64=s.base32crockford=s.base32hexnopad=s.base32hex=s.base32nopad=s.base32=s.base16=s.utils=void 0;const b=(e,t)=>0===t?e:b(t,e%t),y=(e,t)=>e+(t-b(e,t)),x=(()=>{let e=[];for(let t=0;t<40;t++)e.push(2**t);return e})();function w(e,t,s,r){if(c(e),t<=0||t>32)throw new Error(`convertRadix2: wrong from=${t}`);if(s<=0||s>32)throw new Error(`convertRadix2: wrong to=${s}`);if(y(t,s)>32)throw new Error(`convertRadix2: carry overflow from=${t} to=${s} carryBits=${y(t,s)}`);let n=0,a=0;const o=x[t],i=x[s]-1,d=[];for(const r of e){if(m(r),r>=o)throw new Error(`convertRadix2: invalid data word=${r} from=${t}`);if(n=n<<t|r,a+t>32)throw new Error(`convertRadix2: carry overflow pos=${a} from=${t}`);for(a+=t;a>=s;a-=s)d.push((n>>a-s&i)>>>0);const e=x[a];if(e===undefined)throw new Error("invalid carry");n&=e-1}if(n=n<<s-a&i,!r&&a>=t)throw new Error("Excess padding");if(!r&&n>0)throw new Error(`Non-zero padding: ${n}`);return r&&a>0&&d.push(n>>>0),d}function E(e){m(e);return{encode:t=>{if(!r(t))throw new Error("radix.encode input should be Uint8Array");return k(Array.from(t),256,e)},decode:t=>(u("radix.decode",t),Uint8Array.from(k(t,e,256)))}}function _(e,t=!1){if(m(e),e<=0||e>32)throw new Error("radix2: bits should be in (0..32]");if(y(8,e)>32||y(e,8)>32)throw new Error("radix2: carry overflow");return{encode:s=>{if(!r(s))throw new Error("radix2.encode input should be Uint8Array");return w(Array.from(s),8,e,!t)},decode:s=>(u("radix2.decode",s),Uint8Array.from(w(s,e,8,t)))}}function v(e){return o(e),function(...t){try{return e.apply(null,t)}catch(e){}}}function A(e,t){return m(e),o(t),{encode(s){if(!r(s))throw new Error("checksum.encode: input should be Uint8Array");const n=t(s).slice(0,e),a=new Uint8Array(s.length+e);return a.set(s),a.set(n,s.length),a},decode(s){if(!r(s))throw new Error("checksum.decode: input should be Uint8Array");const n=s.slice(0,-e),a=s.slice(-e),o=t(n).slice(0,e);for(let t=0;t<e;t++)if(o[t]!==a[t])throw new Error("Invalid checksum");return n}}}s.utils={alphabet:f,chain:l,checksum:A,convertRadix:k,convertRadix2:w,radix:E,radix2:_,join:h,padding:p},s.base16=l(_(4),f("0123456789ABCDEF"),h("")),s.base32=l(_(5),f("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),p(5),h("")),s.base32nopad=l(_(5),f("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),h("")),s.base32hex=l(_(5),f("0123456789ABCDEFGHIJKLMNOPQRSTUV"),p(5),h("")),s.base32hexnopad=l(_(5),f("0123456789ABCDEFGHIJKLMNOPQRSTUV"),h("")),s.base32crockford=l(_(5),f("0123456789ABCDEFGHJKMNPQRSTVWXYZ"),h(""),g((e=>e.toUpperCase().replace(/O/g,"0").replace(/[IL]/g,"1"))));const T=(()=>"function"==typeof Uint8Array.from([]).toBase64&&"function"==typeof Uint8Array.fromBase64)();s.base64=T?{encode:e=>(n(e),e.toBase64()),decode:e=>(i("base64",e),Uint8Array.fromBase64(e,{lastChunkHandling:"strict"}))}:l(_(6),f("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),p(6),h("")),s.base64nopad=l(_(6),f("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),h("")),s.base64url=T?{encode:e=>(n(e),e.toBase64({alphabet:"base64url"})),decode:e=>(i("base64",e),Uint8Array.fromBase64(e,{alphabet:"base64url"}))}:l(_(6),f("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),p(6),h("")),s.base64urlnopad=l(_(6),f("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),h(""));const j=e=>l(E(58),f(e),h(""));s.base58=j("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz"),s.base58flickr=j("123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ"),s.base58xrp=j("rpshnaf39wBUDNEGHJKLM4PQRST7VWXYZ2bcdeCg65jkm8oFqi1tuvAxyz");const B=[0,2,3,5,6,7,9,10,11];s.base58xmr={encode(e){let t="";for(let r=0;r<e.length;r+=8){const n=e.subarray(r,r+8);t+=s.base58.encode(n).padStart(B[n.length],"1")}return t},decode(e){let t=[];for(let r=0;r<e.length;r+=11){const n=e.slice(r,r+11),a=B.indexOf(n.length),o=s.base58.decode(n);for(let e=0;e<o.length-a;e++)if(0!==o[e])throw new Error("base58xmr: wrong padding");t=t.concat(Array.from(o.slice(o.length-a)))}return Uint8Array.from(t)}};s.createBase58check=e=>l(A(4,(t=>e(e(t)))),s.base58),s.base58check=s.createBase58check;const C=l(f("qpzry9x8gf2tvdw0s3jn54khce6mua7l"),h("")),P=[996825010,642813549,513874426,1027748829,705979059];function S(e){const t=e>>25;let s=(33554431&e)<<5;for(let e=0;e<P.length;e++)1==(t>>e&1)&&(s^=P[e]);return s}function I(e,t,s=1){const r=e.length;let n=1;for(let t=0;t<r;t++){const s=e.charCodeAt(t);if(s<33||s>126)throw new Error(`Invalid prefix (${e})`);n=S(n)^s>>5}n=S(n);for(let t=0;t<r;t++)n=S(n)^31&e.charCodeAt(t);for(let e of t)n=S(n)^e;for(let e=0;e<6;e++)n=S(n);return n^=s,C.encode(w([n%x[30]],30,5,!1))}function D(e){const t="bech32"===e?1:734539939,s=_(5),n=s.decode,a=s.encode,o=v(n);function m(e,s,n=90){i("bech32.encode prefix",e),r(s)&&(s=Array.from(s)),u("bech32.encode",s);const a=e.length;if(0===a)throw new TypeError(`Invalid prefix length ${a}`);const o=a+7+s.length;if(!1!==n&&o>n)throw new TypeError(`Length ${o} exceeds limit ${n}`);const m=e.toLowerCase(),c=I(m,s,t);return`${m}1${C.encode(s)}${c}`}function c(e,s=90){i("bech32.decode input",e);const r=e.length;if(r<8||!1!==s&&r>s)throw new TypeError(`invalid string length: ${r} (${e}). Expected (8..${s})`);const n=e.toLowerCase();if(e!==n&&e!==e.toUpperCase())throw new Error("String must be lowercase or uppercase");const a=n.lastIndexOf("1");if(0===a||-1===a)throw new Error('Letter "1" must be present between prefix and data only');const o=n.slice(0,a),m=n.slice(a+1);if(m.length<6)throw new Error("Data must be at least 6 characters long");const c=C.decode(m).slice(0,-6),d=I(o,c,t);if(!m.endsWith(d))throw new Error(`Invalid checksum in ${e}: expected "${d}"`);return{prefix:o,words:c}}return{encode:m,decode:c,encodeFromBytes:function(e,t){return m(e,a(t))},decodeToBytes:function(e){const{prefix:t,words:s}=c(e,!1);return{prefix:t,words:s,bytes:n(s)}},decodeUnsafe:v(c),fromWords:n,fromWordsUnsafe:o,toWords:a}}s.bech32=D("bech32"),s.bech32m=D("bech32m"),s.utf8={encode:e=>(new TextDecoder).decode(e),decode:e=>(new TextEncoder).encode(e)};const F=(()=>"function"==typeof Uint8Array.from([]).toHex&&"function"==typeof Uint8Array.fromHex)(),R={encode:e=>(n(e),e.toHex()),decode:e=>(i("hex",e),Uint8Array.fromHex(e))};s.hex=F?R:l(_(4),f("0123456789abcdef"),h(""),g((e=>{if("string"!=typeof e||e.length%2!=0)throw new TypeError(`hex.decode: expected string, got ${typeof e} with length ${e.length}`);return e.toLowerCase()})));const O={utf8:s.utf8,hex:s.hex,base16:s.base16,base32:s.base32,base64:s.base64,base64url:s.base64url,base58:s.base58,base58xmr:s.base58xmr},N="Invalid encoding type. Available types: utf8, hex, base16, base32, base64, base64url, base58, base58xmr";s.bytesToString=(e,t)=>{if("string"!=typeof e||!O.hasOwnProperty(e))throw new TypeError(N);if(!r(t))throw new TypeError("bytesToString() expects Uint8Array");return O[e].encode(t)},s.str=s.bytesToString;s.stringToBytes=(e,t)=>{if(!O.hasOwnProperty(e))throw new TypeError(N);if("string"!=typeof t)throw new TypeError("stringToBytes() expects string");return O[e].decode(t)},s.bytes=s.stringToBytes}}},{package:"@metamask/eth-sig-util>@metamask/utils>@scure/base",file:"node_modules/@metamask/eth-sig-util/node_modules/@metamask/utils/node_modules/@scure/base/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-sig-util/node_modules/@scure/base/lib/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function r(e){if(!Number.isSafeInteger(e))throw new Error(`Wrong integer: ${e}`)}function n(e){return e instanceof Uint8Array||null!=e&&"object"==typeof e&&"Uint8Array"===e.constructor.name}function a(...e){const t=e=>e,s=(e,t)=>s=>e(t(s));return{encode:e.map((e=>e.encode)).reduceRight(s,t),decode:e.map((e=>e.decode)).reduce(s,t)}}function o(e){return{encode:t=>{if(!Array.isArray(t)||t.length&&"number"!=typeof t[0])throw new Error("alphabet.encode input should be an array of numbers");return t.map((t=>{if(r(t),t<0||t>=e.length)throw new Error(`Digit index outside alphabet: ${t} (alphabet: ${e.length})`);return e[t]}))},decode:t=>{if(!Array.isArray(t)||t.length&&"string"!=typeof t[0])throw new Error("alphabet.decode input should be array of strings");return t.map((t=>{if("string"!=typeof t)throw new Error(`alphabet.decode: not string element=${t}`);const s=e.indexOf(t);if(-1===s)throw new Error(`Unknown letter: "${t}". Allowed: ${e}`);return s}))}}}function i(e=""){if("string"!=typeof e)throw new Error("join separator should be string");return{encode:t=>{if(!Array.isArray(t)||t.length&&"string"!=typeof t[0])throw new Error("join.encode input should be array of strings");for(let e of t)if("string"!=typeof e)throw new Error(`join.encode: non-string input=${e}`);return t.join(e)},decode:t=>{if("string"!=typeof t)throw new Error("join.decode input should be string");return t.split(e)}}}function m(e,t="="){if(r(e),"string"!=typeof t)throw new Error("padding chr should be string");return{encode(s){if(!Array.isArray(s)||s.length&&"string"!=typeof s[0])throw new Error("padding.encode input should be array of strings");for(let e of s)if("string"!=typeof e)throw new Error(`padding.encode: non-string input=${e}`);for(;s.length*e%8;)s.push(t);return s},decode(s){if(!Array.isArray(s)||s.length&&"string"!=typeof s[0])throw new Error("padding.encode input should be array of strings");for(let e of s)if("string"!=typeof e)throw new Error(`padding.decode: non-string input=${e}`);let r=s.length;if(r*e%8)throw new Error("Invalid padding: string should have whole number of bytes");for(;r>0&&s[r-1]===t;r--)if(!((r-1)*e%8))throw new Error("Invalid padding: string has too much padding");return s.slice(0,r)}}}function c(e){if("function"!=typeof e)throw new Error("normalize fn should be function");return{encode:e=>e,decode:t=>e(t)}}function d(e,t,s){if(t<2)throw new Error(`convertRadix: wrong from=${t}, base cannot be less than 2`);if(s<2)throw new Error(`convertRadix: wrong to=${s}, base cannot be less than 2`);if(!Array.isArray(e))throw new Error("convertRadix: data should be array");if(!e.length)return[];let n=0;const a=[],o=Array.from(e);for(o.forEach((e=>{if(r(e),e<0||e>=t)throw new Error(`Wrong integer: ${e}`)}));;){let e=0,r=!0;for(let a=n;a<o.length;a++){const i=o[a],m=t*e+i;if(!Number.isSafeInteger(m)||t*e/t!==e||m-i!=t*e)throw new Error("convertRadix: carry overflow");e=m%s;const c=Math.floor(m/s);if(o[a]=c,!Number.isSafeInteger(c)||c*s+e!==m)throw new Error("convertRadix: carry overflow");r&&(c?r=!1:n=a)}if(a.push(e),r)break}for(let t=0;t<e.length-1&&0===e[t];t++)a.push(0);return a.reverse()}
/*! scure-base - MIT License (c) 2022 Paul Miller (paulmillr.com) */
Object.defineProperty(s,"__esModule",{value:!0}),s.bytes=s.stringToBytes=s.str=s.bytesToString=s.hex=s.utf8=s.bech32m=s.bech32=s.base58check=s.createBase58check=s.base58xmr=s.base58xrp=s.base58flickr=s.base58=s.base64urlnopad=s.base64url=s.base64nopad=s.base64=s.base32crockford=s.base32hexnopad=s.base32hex=s.base32nopad=s.base32=s.base16=s.utils=void 0,s.assertNumber=r;const u=(e,t)=>t?u(t,e%t):e,l=(e,t)=>e+(t-u(e,t));function f(e,t,s,n){if(!Array.isArray(e))throw new Error("convertRadix2: data should be array");if(t<=0||t>32)throw new Error(`convertRadix2: wrong from=${t}`);if(s<=0||s>32)throw new Error(`convertRadix2: wrong to=${s}`);if(l(t,s)>32)throw new Error(`convertRadix2: carry overflow from=${t} to=${s} carryBits=${l(t,s)}`);let a=0,o=0;const i=2**s-1,m=[];for(const n of e){if(r(n),n>=2**t)throw new Error(`convertRadix2: invalid data word=${n} from=${t}`);if(a=a<<t|n,o+t>32)throw new Error(`convertRadix2: carry overflow pos=${o} from=${t}`);for(o+=t;o>=s;o-=s)m.push((a>>o-s&i)>>>0);a&=2**o-1}if(a=a<<s-o&i,!n&&o>=t)throw new Error("Excess padding");if(!n&&a)throw new Error(`Non-zero padding: ${a}`);return n&&o>0&&m.push(a>>>0),m}function h(e){return r(e),{encode:t=>{if(!n(t))throw new Error("radix.encode input should be Uint8Array");return d(Array.from(t),256,e)},decode:t=>{if(!Array.isArray(t)||t.length&&"number"!=typeof t[0])throw new Error("radix.decode input should be array of numbers");return Uint8Array.from(d(t,e,256))}}}function p(e,t=!1){if(r(e),e<=0||e>32)throw new Error("radix2: bits should be in (0..32]");if(l(8,e)>32||l(e,8)>32)throw new Error("radix2: carry overflow");return{encode:s=>{if(!n(s))throw new Error("radix2.encode input should be Uint8Array");return f(Array.from(s),8,e,!t)},decode:s=>{if(!Array.isArray(s)||s.length&&"number"!=typeof s[0])throw new Error("radix2.decode input should be array of numbers");return Uint8Array.from(f(s,e,8,t))}}}function g(e){if("function"!=typeof e)throw new Error("unsafeWrapper fn should be function");return function(...t){try{return e.apply(null,t)}catch(e){}}}function k(e,t){if(r(e),"function"!=typeof t)throw new Error("checksum fn should be function");return{encode(s){if(!n(s))throw new Error("checksum.encode: input should be Uint8Array");const r=t(s).slice(0,e),a=new Uint8Array(s.length+e);return a.set(s),a.set(r,s.length),a},decode(s){if(!n(s))throw new Error("checksum.decode: input should be Uint8Array");const r=s.slice(0,-e),a=t(r).slice(0,e),o=s.slice(-e);for(let t=0;t<e;t++)if(a[t]!==o[t])throw new Error("Invalid checksum");return r}}}s.utils={alphabet:o,chain:a,checksum:k,convertRadix:d,convertRadix2:f,radix:h,radix2:p,join:i,padding:m},s.base16=a(p(4),o("0123456789ABCDEF"),i("")),s.base32=a(p(5),o("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),m(5),i("")),s.base32nopad=a(p(5),o("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),i("")),s.base32hex=a(p(5),o("0123456789ABCDEFGHIJKLMNOPQRSTUV"),m(5),i("")),s.base32hexnopad=a(p(5),o("0123456789ABCDEFGHIJKLMNOPQRSTUV"),i("")),s.base32crockford=a(p(5),o("0123456789ABCDEFGHJKMNPQRSTVWXYZ"),i(""),c((e=>e.toUpperCase().replace(/O/g,"0").replace(/[IL]/g,"1")))),s.base64=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),m(6),i("")),s.base64nopad=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),i("")),s.base64url=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),m(6),i("")),s.base64urlnopad=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),i(""));const b=e=>a(h(58),o(e),i(""));s.base58=b("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz"),s.base58flickr=b("123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ"),s.base58xrp=b("rpshnaf39wBUDNEGHJKLM4PQRST7VWXYZ2bcdeCg65jkm8oFqi1tuvAxyz");const y=[0,2,3,5,6,7,9,10,11];s.base58xmr={encode(e){let t="";for(let r=0;r<e.length;r+=8){const n=e.subarray(r,r+8);t+=s.base58.encode(n).padStart(y[n.length],"1")}return t},decode(e){let t=[];for(let r=0;r<e.length;r+=11){const n=e.slice(r,r+11),a=y.indexOf(n.length),o=s.base58.decode(n);for(let e=0;e<o.length-a;e++)if(0!==o[e])throw new Error("base58xmr: wrong padding");t=t.concat(Array.from(o.slice(o.length-a)))}return Uint8Array.from(t)}};s.createBase58check=e=>a(k(4,(t=>e(e(t)))),s.base58),s.base58check=s.createBase58check;const x=a(o("qpzry9x8gf2tvdw0s3jn54khce6mua7l"),i("")),w=[996825010,642813549,513874426,1027748829,705979059];function E(e){const t=e>>25;let s=(33554431&e)<<5;for(let e=0;e<w.length;e++)1==(t>>e&1)&&(s^=w[e]);return s}function _(e,t,s=1){const r=e.length;let n=1;for(let t=0;t<r;t++){const s=e.charCodeAt(t);if(s<33||s>126)throw new Error(`Invalid prefix (${e})`);n=E(n)^s>>5}n=E(n);for(let t=0;t<r;t++)n=E(n)^31&e.charCodeAt(t);for(let e of t)n=E(n)^e;for(let e=0;e<6;e++)n=E(n);return n^=s,x.encode(f([n%2**30],30,5,!1))}function v(e){const t="bech32"===e?1:734539939,s=p(5),r=s.decode,n=s.encode,a=g(r);function o(e,s,r=90){if("string"!=typeof e)throw new Error("bech32.encode prefix should be string, not "+typeof e);if(s instanceof Uint8Array&&(s=Array.from(s)),!Array.isArray(s)||s.length&&"number"!=typeof s[0])throw new Error("bech32.encode words should be array of numbers, not "+typeof s);if(0===e.length)throw new TypeError(`Invalid prefix length ${e.length}`);const n=e.length+7+s.length;if(!1!==r&&n>r)throw new TypeError(`Length ${n} exceeds limit ${r}`);const a=e.toLowerCase(),o=_(a,s,t);return`${a}1${x.encode(s)}${o}`}function i(e,s=90){if("string"!=typeof e)throw new Error("bech32.decode input should be string, not "+typeof e);if(e.length<8||!1!==s&&e.length>s)throw new TypeError(`Wrong string length: ${e.length} (${e}). Expected (8..${s})`);const r=e.toLowerCase();if(e!==r&&e!==e.toUpperCase())throw new Error("String must be lowercase or uppercase");const n=r.lastIndexOf("1");if(0===n||-1===n)throw new Error('Letter "1" must be present between prefix and data only');const a=r.slice(0,n),o=r.slice(n+1);if(o.length<6)throw new Error("Data must be at least 6 characters long");const i=x.decode(o).slice(0,-6),m=_(a,i,t);if(!o.endsWith(m))throw new Error(`Invalid checksum in ${e}: expected "${m}"`);return{prefix:a,words:i}}return{encode:o,decode:i,encodeFromBytes:function(e,t){return o(e,n(t))},decodeToBytes:function(e){const{prefix:t,words:s}=i(e,!1);return{prefix:t,words:s,bytes:r(s)}},decodeUnsafe:g(i),fromWords:r,fromWordsUnsafe:a,toWords:n}}s.bech32=v("bech32"),s.bech32m=v("bech32m"),s.utf8={encode:e=>(new TextDecoder).decode(e),decode:e=>(new TextEncoder).encode(e)},s.hex=a(p(4),o("0123456789abcdef"),i(""),c((e=>{if("string"!=typeof e||e.length%2)throw new TypeError(`hex.decode: expected string, got ${typeof e} with length ${e.length}`);return e.toLowerCase()})));const A={utf8:s.utf8,hex:s.hex,base16:s.base16,base32:s.base32,base64:s.base64,base64url:s.base64url,base58:s.base58,base58xmr:s.base58xmr},T="Invalid encoding type. Available types: utf8, hex, base16, base32, base64, base64url, base58, base58xmr";s.bytesToString=(e,t)=>{if("string"!=typeof e||!A.hasOwnProperty(e))throw new TypeError(T);if(!n(t))throw new TypeError("bytesToString() expects Uint8Array");return A[e].encode(t)},s.str=s.bytesToString;s.stringToBytes=(e,t)=>{if(!A.hasOwnProperty(e))throw new TypeError(T);if("string"!=typeof t)throw new TypeError("stringToBytes() expects string");return A[e].decode(t)},s.bytes=s.stringToBytes}}},{package:"@metamask/eth-sig-util>@scure/base",file:"node_modules/@metamask/eth-sig-util/node_modules/@scure/base/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/dist/index.cjs",{"./simple-keyring.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/dist/simple-keyring.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.default=void 0;var n=e("./simple-keyring.cjs");Object.defineProperty(s,"default",{enumerable:!0,get:function(){return r(n).default}})}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring",file:"node_modules/@metamask/eth-simple-keyring/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/dist/simple-keyring.cjs",{"@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethereumjs/util/dist/cjs/index.js","@metamask/eth-sig-util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js",randombytes:"/home/runner/work/metamask-extension/metamask-extension/node_modules/randombytes/browser.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){var r,n,a,o,i=this&&this.__classPrivateFieldSet||function(e,t,s,r,n){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?n.call(e,s):n?n.value=s:t.set(e,s),s},m=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)},c=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0});const d=e("@ethereumjs/util"),u=e("@metamask/eth-sig-util"),l=e("@metamask/utils"),f=e("ethereum-cryptography/keccak"),h=c(e("randombytes")),p="Simple Key Pair";class g{constructor(e=[]){r.add(this),n.set(this,void 0),this.type=p,i(this,n,[],"f"),this.deserialize(e).catch((e=>{throw new Error(`Problem deserializing SimpleKeyring ${e.message}`)}))}async serialize(){return m(this,n,"f").map((e=>e.privateKey.toString("hex")))}async deserialize(e){i(this,n,e.map((e=>{const s=(0,d.stripHexPrefix)(e),r=t.from(s,"hex");return{privateKey:r,publicKey:t.from((0,d.privateToPublic)(r))}})),"f")}async addAccounts(e=1){const s=[];for(let r=0;r<e;r++){const e=k(),r=t.from((0,d.privateToPublic)(e));s.push({privateKey:e,publicKey:r})}i(this,n,m(this,n,"f").concat(s),"f");return s.map((({publicKey:e})=>(0,l.add0x)((0,l.bytesToHex)((0,d.publicToAddress)(e)))))}async getAccounts(){return m(this,n,"f").map((({publicKey:e})=>(0,l.add0x)((0,l.bytesToHex)((0,d.publicToAddress)(e)))))}async signTransaction(e,t,s={}){const n=m(this,r,"m",a).call(this,e,s);return t.sign(n)??t}async signEip7702Authorization(e,t,s={}){const n=m(this,r,"m",a).call(this,e,s);return(0,u.signEIP7702Authorization)({privateKey:n,authorization:t})}async signMessage(e,s,n={withAppKeyOrigin:"",validateMessage:!0}){const o=(0,d.stripHexPrefix)(s);if(n.validateMessage&&(0===o.length||!o.match(/^[a-fA-F0-9]*$/u)))throw new Error("Cannot sign invalid message");const i=m(this,r,"m",a).call(this,e,n),c=(0,d.ecsign)(t.from(o,"hex"),i);return(0,u.concatSig)(t.from((0,l.bigIntToBytes)(c.v)),t.from(c.r),t.from(c.s))}async signPersonalMessage(e,t,s={withAppKeyOrigin:""}){const n=m(this,r,"m",a).call(this,e,s);return(0,u.personalSign)({privateKey:n,data:t})}async decryptMessage(e,t){const s=m(this,r,"m",o).call(this,e).privateKey.toString("hex");return(0,u.decrypt)({privateKey:s,encryptedData:t})}async signTypedData(e,t,s={version:u.SignTypedDataVersion.V1}){let n=u.SignTypedDataVersion.V1;s.version&&function(e){return e in u.SignTypedDataVersion}(s.version)&&(n=u.SignTypedDataVersion[s.version]);const o=m(this,r,"m",a).call(this,e,s);return(0,u.signTypedData)({privateKey:o,data:t,version:n})}async getEncryptionPublicKey(e,t){const s=m(this,r,"m",a).call(this,e,t);return(0,u.getEncryptionPublicKey)(s.toString("hex"))}async getAppKeyAddress(e,t){if(!t||"string"!=typeof t)throw new Error("'origin' must be a non-empty string");const s=m(this,r,"m",o).call(this,e,{withAppKeyOrigin:t});return(0,l.add0x)((0,l.bytesToHex)((0,d.publicToAddress)(s.publicKey)))}async exportAccount(e,t={withAppKeyOrigin:""}){return m(this,r,"m",o).call(this,e,t).privateKey.toString("hex")}removeAccount(e){if(!m(this,n,"f").map((({publicKey:e})=>(0,l.bytesToHex)((0,d.publicToAddress)(e)).toLowerCase())).includes(e.toLowerCase()))throw new Error(`Address ${e} not found in this keyring`);i(this,n,m(this,n,"f").filter((({publicKey:t})=>(0,l.bytesToHex)((0,d.publicToAddress)(t)).toLowerCase()!==e.toLowerCase())),"f")}}function k(){const e=(0,h.default)(32);if(!(0,d.isValidPrivate)(e))throw new Error("Private key does not satisfy the curve requirements (ie. it is invalid)");return e}n=new WeakMap,r=new WeakSet,a=function(e,t={withAppKeyOrigin:""}){if(!e)throw new Error("Must specify address.");return m(this,r,"m",o).call(this,e,t).privateKey},o=function(e,s={}){const r=(0,u.normalize)(e);let a=m(this,n,"f").find((({publicKey:e})=>(0,l.bytesToHex)((0,d.publicToAddress)(e))===r));if(!a)throw new Error("Simple Keyring - Unable to find matching address.");if(s.withAppKeyOrigin){const{privateKey:e}=a,r=t.from(s.withAppKeyOrigin,"utf8"),n=t.concat([e,r]),o=(0,f.keccak256)(n),i=(0,d.privateToPublic)(o);a={privateKey:t.from(o),publicKey:t.from(i)}}return a},g.type=p,s.default=g}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring",file:"node_modules/@metamask/eth-simple-keyring/dist/simple-keyring.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/abi.js",{"./errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/errors.js","./packer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/packer.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.decodeSingle=s.decode=s.encodePacked=s.encodeSingle=s.encode=void 0;const r=e("@metamask/utils"),n=e("./errors"),a=e("./packer");s.encode=(e,t,s,r)=>{try{return(0,a.pack)({types:e,values:t,packed:s,tight:r})}catch(e){if(e instanceof n.ParserError)throw new n.ParserError(`Unable to encode value: ${e.message}`,e);throw new n.ParserError(`An unexpected error occurred: ${(0,n.getErrorMessage)(e)}`,e)}};s.encodeSingle=(e,t)=>(0,s.encode)([e],[t]);s.encodePacked=(e,t,r)=>(0,s.encode)(e,t,!0,r);s.decode=(e,t)=>{const s=(0,r.createBytes)(t);try{return(0,a.unpack)(e,s)}catch(e){if(e instanceof n.ParserError)throw new n.ParserError(`Unable to decode value: ${e.message}`,e);throw new n.ParserError(`An unexpected error occurred: ${(0,n.getErrorMessage)(e)}`,e)}};s.decodeSingle=(e,t)=>{const a=(0,s.decode)([e],t);return(0,r.assert)(1===a.length,new n.ParserError("Decoded value array has unexpected length.")),a[0]}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/abi.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/errors.js",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.ParserError=s.getErrorStack=s.getErrorMessage=void 0;const r=e("@metamask/utils");s.getErrorMessage=e=>"string"==typeof e?e:e instanceof Error||(0,r.isObject)(e)&&(0,r.hasProperty)(e,"message")&&"string"==typeof e.message?e.message:"Unknown error.";s.getErrorStack=e=>e instanceof Error?e.stack:undefined;class n extends Error{constructor(e,t){super(e),this.name="ParserError";const r=(0,s.getErrorStack)(t);r&&(this.stack=r)}}s.ParserError=n}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/errors.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/index.js",{"./abi":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/abi.js","./errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/errors.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/types/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./abi"),s),n(e("./errors"),s),n(e("./types"),s)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/iterator.js",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.iterate=void 0;const r=e("@metamask/utils");s.iterate=function*(e,t=32){for(let s=0;s<e.length;s+=t){const n=e=>{(0,r.assert)(e>=0,"Cannot skip a negative number of bytes."),(0,r.assert)(e%t==0,"Length must be a multiple of the size."),s+=e},a=e.subarray(s);yield{skip:n,value:a}}return{skip:()=>undefined,value:new Uint8Array}}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/iterator.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/packer.js",{"./errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/errors.js","./iterator":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/iterator.js","./parsers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/index.js","./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/utils/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.unpack=s.pack=s.isDynamicParser=s.getParser=void 0;const r=e("@metamask/utils"),n=e("./errors"),a=e("./iterator"),o=e("./parsers"),i=e("./utils");s.getParser=e=>{const t={address:o.address,array:o.array,bool:o.bool,bytes:o.bytes,fixedBytes:o.fixedBytes,function:o.fn,number:o.number,string:o.string,tuple:o.tuple},s=t[e];if(s)return s;const r=Object.values(t).find((t=>t.isType(e)));if(r)return r;throw new n.ParserError(`The type "${e}" is not supported.`)};s.isDynamicParser=(e,t)=>{const{isDynamic:s}=e;return"function"==typeof s?s(t):s};s.pack=({types:e,values:t,packed:a=!1,tight:o=!1,arrayPacked:m=!1,byteArray:c=new Uint8Array})=>{(0,r.assert)(e.length===t.length,new n.ParserError(`The number of types (${e.length}) does not match the number of values (${t.length}).`));const{staticBuffer:d,dynamicBuffer:u,pointers:l}=e.reduce((({staticBuffer:e,dynamicBuffer:n,pointers:i},c,d)=>{const u=(0,s.getParser)(c),l=t[d];if(a||m||!(0,s.isDynamicParser)(u,c))return{staticBuffer:u.encode({buffer:e,value:l,type:c,packed:a,tight:o}),dynamicBuffer:n,pointers:i};return{staticBuffer:(0,r.concatBytes)([e,new Uint8Array(32)]),dynamicBuffer:u.encode({buffer:n,value:l,type:c,packed:a,tight:o}),pointers:[...i,{position:e.length,pointer:n.length}]}}),{staticBuffer:new Uint8Array,dynamicBuffer:new Uint8Array,pointers:[]});(0,r.assert)(!a&&!m||0===u.length,new n.ParserError("Invalid pack state."));const f=d.length,h=l.reduce(((e,{pointer:t,position:s})=>{const n=(0,i.padStart)((0,r.numberToBytes)(f+t));return(0,i.set)(e,n,s)}),d);return(0,r.concatBytes)([c,h,u])};s.unpack=(e,t)=>{const o=(0,a.iterate)(t);return e.map((e=>{const{value:{value:a,skip:i},done:m}=o.next();(0,r.assert)(!m,new n.ParserError(`The encoded value is invalid for the provided types. Reached end of buffer while attempting to parse "${e}".`));const c=(0,s.getParser)(e);if((0,s.isDynamicParser)(c,e)){const s=(0,r.bytesToNumber)(a.subarray(0,32)),n=t.subarray(s);return c.decode({type:e,value:n,skip:i})}return c.decode({type:e,value:a,skip:i})}))}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/packer.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/address.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/errors.js","../utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/utils/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.address=s.getAddress=void 0;const r=e("@metamask/utils"),n=e("../errors"),a=e("../utils");s.getAddress=e=>{const t=(0,r.createBytes)(e);return(0,r.assert)(t.length<=20,new n.ParserError(`Invalid address value. Expected address to be 20 bytes long, but received ${t.length} bytes.`)),(0,a.padStart)(t,20)},s.address={isDynamic:!1,isType:e=>"address"===e,getByteLength:()=>32,encode({buffer:e,value:t,packed:n}){const o=(0,s.getAddress)(t);if(n)return(0,r.concatBytes)([e,o]);const i=(0,a.padStart)(o);return(0,r.concatBytes)([e,i])},decode:({value:e})=>(0,r.add0x)((0,r.bytesToHex)(e.slice(12,32)))}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/address.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/array.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/errors.js","../packer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/packer.js","../utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/utils/index.js","./fixed-bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/fixed-bytes.js","./tuple":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/tuple.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.array=s.getTupleType=s.getArrayType=s.isArrayType=void 0;const r=e("@metamask/utils"),n=e("../errors"),a=e("../packer"),o=e("../utils"),i=e("./fixed-bytes"),m=e("./tuple"),c=/^(?<type>.*)\[(?<length>\d*?)\]$/u;s.isArrayType=e=>c.test(e);s.getArrayType=e=>{const t=e.match(c);return(0,r.assert)(t?.groups?.type,new n.ParserError(`Invalid array type. Expected an array type, but received "${e}".`)),[t.groups.type,t.groups.length?parseInt(t.groups.length,10):undefined]};s.getTupleType=(e,t)=>`(${new Array(t).fill(e).join(",")})`,s.array={isDynamic(e){const[t,r]=(0,s.getArrayType)(e);return r===undefined||(0,a.isDynamicParser)((0,a.getParser)(t),t)},isType:e=>(0,s.isArrayType)(e),getByteLength(e){(0,r.assert)((0,s.isArrayType)(e),new n.ParserError(`Expected an array type, but received "${e}".`));const[t,o]=(0,s.getArrayType)(e);return(0,a.isDynamicParser)(this,e)||o===undefined?32:m.tuple.getByteLength((0,s.getTupleType)(t,o))},encode({type:e,buffer:t,value:c,packed:d,tight:u}){const[l,f]=(0,s.getArrayType)(e);if((0,r.assert)(!d||!(0,s.isArrayType)(l),new n.ParserError("Cannot pack nested arrays.")),d&&(0,a.isDynamicParser)((0,a.getParser)(l),l))return(0,a.pack)({types:new Array(c.length).fill(l),values:c,byteArray:t,packed:d,arrayPacked:!0,tight:u});if(f)return(0,r.assert)(f===c.length,new n.ParserError(`Array length does not match type length. Expected a length of ${f}, but received ${c.length}.`)),m.tuple.encode({type:(0,s.getTupleType)(l,f),buffer:t,value:c,packed:i.fixedBytes.isType(l)&&u,tight:u});if(d)return(0,a.pack)({types:new Array(c.length).fill(l),values:c,byteArray:t,packed:i.fixedBytes.isType(l)&&u,arrayPacked:!0,tight:u});const h=(0,o.padStart)((0,r.numberToBytes)(c.length));return(0,a.pack)({types:new Array(c.length).fill(l),values:c,byteArray:(0,r.concatBytes)([t,h]),packed:d,tight:u})},decode({type:e,value:t,...o}){const[i,c]=(0,s.getArrayType)(e);if(c){const e=m.tuple.decode({type:(0,s.getTupleType)(i,c),value:t,...o});return(0,r.assert)(e.length===c,new n.ParserError(`Array length does not match type length. Expected a length of ${c}, but received ${e.length}.`)),e}const d=(0,r.bytesToNumber)(t.subarray(0,32));return(0,a.unpack)(new Array(d).fill(i),t.subarray(32))}}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/array.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/bool.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/errors.js","./number":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/number.js","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.bool=s.getBooleanValue=void 0;const r=e("@metamask/superstruct"),n=e("@metamask/utils"),a=e("../errors"),o=e("./number"),i=(0,r.coerce)((0,r.boolean)(),(0,r.union)([(0,r.literal)("true"),(0,r.literal)("false")]),(e=>"true"===e));s.getBooleanValue=e=>{try{return(0,r.create)(e,i)?BigInt(1):BigInt(0)}catch{throw new a.ParserError(`Invalid boolean value. Expected a boolean literal, or the string "true" or "false", but received "${e}".`)}},s.bool={isDynamic:!1,isType:e=>"bool"===e,getByteLength:()=>32,encode({buffer:e,value:t,packed:r,tight:a}){const i=(0,s.getBooleanValue)(t);return r?(0,n.concatBytes)([e,(0,n.bigIntToBytes)(i)]):o.number.encode({type:"uint256",buffer:e,value:i,packed:r,tight:a})},decode:e=>o.number.decode({...e,type:"uint256"})===BigInt(1)}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/bool.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/bytes.js",{"../utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/utils/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.bytes=void 0;const r=e("@metamask/utils"),n=e("../utils");s.bytes={isDynamic:!0,isType:e=>"bytes"===e,getByteLength:()=>32,encode({buffer:e,value:t,packed:s}){const a=(0,r.createBytes)(t);if(s)return(0,r.concatBytes)([e,a]);const o=32*Math.ceil(a.byteLength/32);return(0,r.concatBytes)([e,(0,n.padStart)((0,r.numberToBytes)(a.byteLength)),(0,n.padEnd)(a,o)])},decode({value:e}){const t=e.subarray(0,32),s=(0,r.bytesToNumber)(t);return e.slice(32,32+s)}}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/bytes.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/fixed-bytes.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/errors.js","../utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/utils/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.fixedBytes=s.getByteLength=void 0;const r=e("@metamask/utils"),n=e("../errors"),a=e("../utils"),o=/^bytes([0-9]{1,2})$/u;s.getByteLength=e=>{const t=e.match(o)?.[1];(0,r.assert)(t,`Invalid byte length. Expected a number between 1 and 32, but received "${e}".`);const s=Number(t);return(0,r.assert)(s>0&&s<=32,new n.ParserError(`Invalid byte length. Expected a number between 1 and 32, but received "${e}".`)),s},s.fixedBytes={isDynamic:!1,isType:e=>o.test(e),getByteLength:()=>32,encode({type:e,buffer:t,value:o,packed:i}){const m=(0,s.getByteLength)(e),c=(0,r.createBytes)(o);return(0,r.assert)(c.length<=m,new n.ParserError(`Expected a value of length ${m}, but received a value of length ${c.length}.`)),i?(0,r.concatBytes)([t,(0,a.padEnd)(c,m)]):(0,r.concatBytes)([t,(0,a.padEnd)(c)])},decode({type:e,value:t}){const r=(0,s.getByteLength)(e);return t.slice(0,r)}}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/fixed-bytes.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/function.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/errors.js","./fixed-bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/fixed-bytes.js","@metamask/superstruct":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/superstruct/dist/index.cjs","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.fn=s.getFunction=void 0;const r=e("@metamask/superstruct"),n=e("@metamask/utils"),a=e("../errors"),o=e("./fixed-bytes"),i=(0,r.coerce)((0,r.object)({address:n.StrictHexStruct,selector:n.StrictHexStruct}),(0,r.union)([n.StrictHexStruct,(0,r.instance)(Uint8Array)]),(e=>{const t=(0,n.createBytes)(e);return(0,n.assert)(24===t.length,new a.ParserError(`Invalid Solidity function. Expected function to be 24 bytes long, but received ${t.length} bytes.`)),{address:(0,n.bytesToHex)(t.subarray(0,20)),selector:(0,n.bytesToHex)(t.subarray(20,24))}}));s.getFunction=e=>{const t=(0,r.create)(e,i);return(0,n.concatBytes)([(0,n.hexToBytes)(t.address),(0,n.hexToBytes)(t.selector)])},s.fn={isDynamic:!1,isType:e=>"function"===e,getByteLength:()=>32,encode({buffer:e,value:t,packed:r,tight:n}){const a=(0,s.getFunction)(t);return o.fixedBytes.encode({type:"bytes24",buffer:e,value:a,packed:r,tight:n})},decode:({value:e})=>({address:(0,n.bytesToHex)(e.slice(0,20)),selector:(0,n.bytesToHex)(e.slice(20,24))})}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/function.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/index.js",{"./address":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/address.js","./array":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/array.js","./bool":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/bool.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/bytes.js","./fixed-bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/fixed-bytes.js","./function":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/function.js","./number":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/number.js","./parser":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/parser.js","./string":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/string.js","./tuple":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/tuple.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./address"),s),n(e("./array"),s),n(e("./bool"),s),n(e("./bytes"),s),n(e("./fixed-bytes"),s),n(e("./function"),s),n(e("./number"),s),n(e("./parser"),s),n(e("./string"),s),n(e("./tuple"),s)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/number.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/errors.js","../utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/utils/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.number=s.getBigInt=s.assertNumberLength=s.getLength=s.isSigned=void 0;const r=e("@metamask/utils"),n=e("../errors"),a=e("../utils"),o=/^u?int(?<length>[0-9]*)?$/u;s.isSigned=e=>!e.startsWith("u");s.getLength=e=>{if("int"===e||"uint"===e)return 256;const t=e.match(o);(0,r.assert)(t?.groups?.length,new n.ParserError(`Invalid number type. Expected a number type, but received "${e}".`));const s=parseInt(t.groups.length,10);return(0,r.assert)(s>=8&&s<=256,new n.ParserError(`Invalid number length. Expected a number between 8 and 256, but received "${e}".`)),(0,r.assert)(s%8==0,new n.ParserError(`Invalid number length. Expected a multiple of 8, but received "${e}".`)),s};s.assertNumberLength=(e,t)=>{const a=(0,s.getLength)(t),o=BigInt(2)**BigInt(a-((0,s.isSigned)(t)?1:0))-BigInt(1);(0,s.isSigned)(t)?(0,r.assert)(e>=-(o+BigInt(1))&&e<=o,new n.ParserError(`Number "${e}" is out of range for type "${t}".`)):(0,r.assert)(e<=o,new n.ParserError(`Number "${e}" is out of range for type "${t}".`))};s.getBigInt=e=>{try{return(0,r.createBigInt)(e)}catch{throw new n.ParserError(`Invalid number. Expected a valid number value, but received "${e}".`)}},s.number={isDynamic:!1,isType:e=>o.test(e),getByteLength:()=>32,encode({type:e,buffer:t,value:n,packed:o}){const i=(0,s.getBigInt)(n);if((0,s.assertNumberLength)(i,e),(0,s.isSigned)(e)){if(o){const n=(0,s.getLength)(e)/8;return(0,r.concatBytes)([t,(0,r.signedBigIntToBytes)(i,n)])}return(0,r.concatBytes)([t,(0,a.padStart)((0,r.signedBigIntToBytes)(i,32))])}if(o){const n=(0,s.getLength)(e)/8;return(0,r.concatBytes)([t,(0,a.padStart)((0,r.bigIntToBytes)(i),n)])}return(0,r.concatBytes)([t,(0,a.padStart)((0,r.bigIntToBytes)(i))])},decode({type:e,value:t}){const n=t.subarray(0,32);if((0,s.isSigned)(e)){const t=(0,r.bytesToSignedBigInt)(n);return(0,s.assertNumberLength)(t,e),t}const a=(0,r.bytesToBigInt)(n);return(0,s.assertNumberLength)(a,e),a}}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/number.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/parser.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0})}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/parser.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/string.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/bytes.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.string=void 0;const r=e("@metamask/utils"),n=e("./bytes");s.string={isDynamic:!0,isType:e=>"string"===e,getByteLength:()=>32,encode:({buffer:e,value:t,packed:s,tight:a})=>n.bytes.encode({type:"bytes",buffer:e,value:(0,r.stringToBytes)(t),packed:s,tight:a}),decode:e=>(0,r.bytesToString)(n.bytes.decode(e))}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/string.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/tuple.js",{"../errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/errors.js","../packer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/packer.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.tuple=s.getTupleElements=void 0;const r=e("@metamask/utils"),n=e("../errors"),a=e("../packer"),o=/^\((.+)\)$/u;s.getTupleElements=e=>{(0,r.assert)(e.startsWith("(")&&e.endsWith(")"),new n.ParserError(`Invalid tuple type. Expected tuple type, but received "${e}".`));const t=[];let s="",a=0;for(let r=1;r<e.length-1;r++){const n=e[r];","===n&&0===a?(t.push(s.trim()),s=""):(s+=n,"("===n?a+=1:")"===n&&(a-=1))}return s.trim()&&t.push(s.trim()),t},s.tuple={isDynamic:e=>(0,s.getTupleElements)(e).some((e=>{const t=(0,a.getParser)(e);return(0,a.isDynamicParser)(t,e)})),isType:e=>(e=>o.test(e))(e),getByteLength(e){if((0,a.isDynamicParser)(this,e))return 32;return(0,s.getTupleElements)(e).reduce(((e,t)=>e+(0,a.getParser)(t).getByteLength(t)),0)},encode({type:e,buffer:t,value:r,packed:n,tight:o}){const i=(0,s.getTupleElements)(e);return(0,a.pack)({types:i,values:r,byteArray:t,packed:n,tight:o})},decode({type:e,value:t,skip:r}){const n=(0,s.getTupleElements)(e);return r(this.getByteLength(e)-32),(0,a.unpack)(n,t)}}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/tuple.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/types/abi.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0})}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/types/abi.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/types/index.js",{"./abi":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/types/abi.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./abi"),s)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/types/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/utils/buffer.js",{"@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.padEnd=s.padStart=s.set=void 0;const r=e("@metamask/utils");s.set=(e,t,s)=>(0,r.concatBytes)([e.subarray(0,s),t,e.subarray(s+t.length)]);s.padStart=(e,t=32)=>{const s=new Uint8Array(Math.max(t-e.length,0)).fill(0);return(0,r.concatBytes)([s,e])};s.padEnd=(e,t=32)=>{const s=new Uint8Array(Math.max(t-e.length,0)).fill(0);return(0,r.concatBytes)([e,s])}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/utils/buffer.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/utils/index.js",{"./buffer":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/utils/buffer.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./buffer"),s)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@metamask/abi-utils",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/utils/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/encryption.js",{"./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/utils.js","@scure/base":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@scure/base/lib/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js",tweetnacl:"/home/runner/work/metamask-extension/metamask-extension/node_modules/tweetnacl/nacl-fast.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),a=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var s in e)"default"!==s&&Object.prototype.hasOwnProperty.call(e,s)&&r(t,e,s);return n(t,e),t};Object.defineProperty(s,"__esModule",{value:!0}),s.getEncryptionPublicKey=s.decryptSafely=s.decrypt=s.encryptSafely=s.encrypt=void 0;const o=e("@scure/base"),i=a(e("tweetnacl")),m=e("./utils");function c({publicKey:e,data:t,version:s}){if((0,m.isNullish)(e))throw new Error("Missing publicKey parameter");if((0,m.isNullish)(t))throw new Error("Missing data parameter");if((0,m.isNullish)(s))throw new Error("Missing version parameter");if("x25519-xsalsa20-poly1305"===s){if("string"!=typeof t)throw new Error("Message data must be given as a string");const s=i.box.keyPair();let r;try{r=o.base64.decode(e)}catch(e){throw new Error("Bad public key")}const n=o.utf8.decode(t),a=i.randomBytes(i.box.nonceLength),m=i.box(n,a,r,s.secretKey);return{version:"x25519-xsalsa20-poly1305",nonce:o.base64.encode(a),ephemPublicKey:o.base64.encode(s.publicKey),ciphertext:o.base64.encode(m)}}throw new Error("Encryption type/version not supported")}function d({encryptedData:e,privateKey:s}){if((0,m.isNullish)(e))throw new Error("Missing encryptedData parameter");if((0,m.isNullish)(s))throw new Error("Missing privateKey parameter");if("x25519-xsalsa20-poly1305"===e.version){const r=t.from(s,"hex"),n=i.box.keyPair.fromSecretKey(r).secretKey,a=o.base64.decode(e.nonce),m=o.base64.decode(e.ciphertext),c=o.base64.decode(e.ephemPublicKey),d=i.box.open(m,a,c,n);try{if(!d)throw new Error;const e=o.utf8.encode(d);if(!e)throw new Error;return e}catch(e){if(e&&"string"==typeof e.message&&e.message.length)throw new Error(`Decryption failed: ${e.message}`);throw new Error("Decryption failed.")}}throw new Error("Encryption type/version not supported.")}s.encrypt=c,s.encryptSafely=function({publicKey:e,data:s,version:r}){if((0,m.isNullish)(e))throw new Error("Missing publicKey parameter");if((0,m.isNullish)(s))throw new Error("Missing data parameter");if((0,m.isNullish)(r))throw new Error("Missing version parameter");if("object"==typeof s&&s&&"toJSON"in s)throw new Error("Cannot encrypt with toJSON property.  Please remove toJSON property");const n={data:s,padding:""},a=t.byteLength(JSON.stringify(n),"utf-8")%2048;let o=0;return a>0&&(o=2048-a-16),n.padding="0".repeat(o),c({publicKey:e,data:JSON.stringify(n),version:r})},s.decrypt=d,s.decryptSafely=function({encryptedData:e,privateKey:t}){if((0,m.isNullish)(e))throw new Error("Missing encryptedData parameter");if((0,m.isNullish)(t))throw new Error("Missing privateKey parameter");return JSON.parse(d({encryptedData:e,privateKey:t})).data},s.getEncryptionPublicKey=function(e){const s=t.from(e,"hex"),r=i.box.keyPair.fromSecretKey(s).publicKey;return o.base64.encode(r)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/encryption.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/index.js",{"./encryption":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/encryption.js","./personal-sign":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/personal-sign.js","./sign-eip7702-authorization":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/sign-eip7702-authorization.js","./sign-typed-data":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/sign-typed-data.js","./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/utils.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),s.normalize=s.concatSig=void 0,n(e("./personal-sign"),s),n(e("./sign-typed-data"),s),n(e("./encryption"),s),n(e("./sign-eip7702-authorization"),s);var a=e("./utils");Object.defineProperty(s,"concatSig",{enumerable:!0,get:function(){return a.concatSig}}),Object.defineProperty(s,"normalize",{enumerable:!0,get:function(){return a.normalize}})}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/personal-sign.js",{"./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/utils.js","@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.extractPublicKey=s.recoverPersonalSignature=s.personalSign=void 0;const r=e("@ethereumjs/util"),n=e("./utils");function a(e,t){const s=(0,r.hashPersonalMessage)((0,n.legacyToBuffer)(e));return(0,n.recoverPublicKey)(s,t)}s.personalSign=function({privateKey:e,data:t}){if((0,n.isNullish)(t))throw new Error("Missing data parameter");if((0,n.isNullish)(e))throw new Error("Missing privateKey parameter");const s=(0,n.legacyToBuffer)(t),a=(0,r.hashPersonalMessage)(s),o=(0,r.ecsign)(a,e);return(0,n.concatSig)((0,r.toBuffer)(o.v),o.r,o.s)},s.recoverPersonalSignature=function({data:e,signature:t}){if((0,n.isNullish)(e))throw new Error("Missing data parameter");if((0,n.isNullish)(t))throw new Error("Missing signature parameter");const s=a(e,t),o=(0,r.publicToAddress)(s);return(0,r.bufferToHex)(o)},s.extractPublicKey=function({data:e,signature:t}){if((0,n.isNullish)(e))throw new Error("Missing data parameter");if((0,n.isNullish)(t))throw new Error("Missing signature parameter");return`0x${a(e,t).toString("hex")}`}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/personal-sign.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/sign-eip7702-authorization.js",{"./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/utils.js","@ethereumjs/rlp":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethereumjs/rlp/dist/index.js","@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.hashEIP7702Authorization=s.recoverEIP7702Authorization=s.signEIP7702Authorization=void 0;const r=e("@ethereumjs/rlp"),n=e("@ethereumjs/util"),a=e("@metamask/utils"),o=e("ethereum-cryptography/keccak"),i=e("./utils");function m(e){c(e);const s=(0,r.encode)(e),n=t.concat([t.from("05","hex"),s]);return t.from((0,o.keccak256)(n))}function c(e){if((0,i.isNullish)(e))throw new Error("Missing authorization parameter");const[t,s,r]=e;if((0,i.isNullish)(t))throw new Error("Missing chainId parameter");if((0,i.isNullish)(s))throw new Error("Missing contractAddress parameter");if((0,i.isNullish)(r))throw new Error("Missing nonce parameter")}s.signEIP7702Authorization=function({privateKey:e,authorization:t}){if(c(t),(0,i.isNullish)(e))throw new Error("Missing privateKey parameter");const s=m(t),{r:r,s:a,v:o}=(0,n.ecsign)(s,e),d=(0,n.toBuffer)(o);return(0,i.concatSig)(d,r,a)},s.recoverEIP7702Authorization=function({signature:e,authorization:t}){if(c(t),(0,i.isNullish)(e))throw new Error("Missing signature parameter");const s=m(t),r=(0,i.recoverPublicKey)(s,e),o=(0,n.publicToAddress)(r);return(0,a.bytesToHex)(o)},s.hashEIP7702Authorization=m}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/sign-eip7702-authorization.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/sign-typed-data.js",{"./utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/utils.js","@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js","@metamask/abi-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/index.js","@metamask/abi-utils/dist/parsers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/parsers/index.js","@metamask/abi-utils/dist/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/abi-utils/dist/utils/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.recoverTypedSignature=s.signTypedData=s.typedSignatureHash=s.TypedDataUtils=s.TYPED_MESSAGE_SCHEMA=s.SignTypedDataVersion=void 0;const r=e("@ethereumjs/util"),n=e("@metamask/abi-utils"),a=e("@metamask/abi-utils/dist/parsers"),o=e("@metamask/abi-utils/dist/utils"),i=e("@metamask/utils"),m=e("ethereum-cryptography/keccak"),c=e("./utils");var d;function u(e,t){if(!Object.keys(d).includes(e))throw new Error(`Invalid version: '${e}'`);if(t&&!t.includes(e))throw new Error(`SignTypedDataVersion not allowed: '${e}'. Allowed versions are: ${t.join(", ")}`)}function l(e,t){(0,i.assert)(null!==t,`Unable to encode value: Invalid number. Expected a valid number value, but received "${t}".`);const s=BigInt(t),r=(0,a.getLength)(e),n=BigInt(2)**BigInt(r)-BigInt(1);return(0,i.assert)(s>=-n&&s<=n,`Unable to encode value: Number "${t}" is out of range for type "${e}".`),s}function f(e){let t=BigInt(0);for(let s=0;s<e.length;s++){const r=BigInt(e.charCodeAt(s)-48);t*=BigInt(10),t+=r>=49?r-BigInt(49)+BigInt(10):r>=17?r-BigInt(17)+BigInt(10):r}return(0,o.padStart)((0,i.bigIntToBytes)(t),20)}function h(e,t,s,a,c){if(u(c,[d.V3,d.V4]),e[s]!==undefined)return["bytes32",c===d.V4&&null==a?"0x0000000000000000000000000000000000000000000000000000000000000000":(0,r.arrToBufArr)((0,m.keccak256)(p(s,a,e,c)))];if("function"===s)throw new Error('Unsupported or invalid type: "function"');if(a===undefined)throw new Error(`missing value for field ${t} of type ${s}`);if("address"===s){if("number"==typeof a)return["address",(0,o.padStart)((0,i.numberToBytes)(a),20)];if((0,i.isStrictHexString)(a))return["address",(0,i.add0x)(a)];if("string"==typeof a)return["address",f(a).subarray(0,20)]}if("bool"===s)return["bool",Boolean(a)];if("bytes"===s)return"number"==typeof a?a=(0,i.numberToBytes)(a):(0,i.isStrictHexString)(a)||"0x"===a?a=(0,i.hexToBytes)(a):"string"==typeof a&&(a=(0,i.stringToBytes)(a)),["bytes32",(0,r.arrToBufArr)((0,m.keccak256)(a))];if(s.startsWith("bytes")&&"bytes"!==s&&!s.includes("["))return"number"==typeof a?a<0?["bytes32",new Uint8Array(32)]:["bytes32",(0,i.bigIntToBytes)(BigInt(a))]:(0,i.isStrictHexString)(a)?["bytes32",(0,i.hexToBytes)(a)]:["bytes32",a];if(s.startsWith("int")&&!s.includes("[")){const e=l(s,a);return e>=BigInt(0)?["uint256",e]:["int256",e]}if("string"===s)return a="number"==typeof a?(0,i.numberToBytes)(a):(0,i.stringToBytes)(null!=a?a:""),["bytes32",(0,r.arrToBufArr)((0,m.keccak256)(a))];if(s.endsWith("]")){if(c===d.V3)throw new Error("Arrays are unimplemented in encodeData; use V4 extension");const o=s.slice(0,s.lastIndexOf("[")),i=a.map((s=>h(e,t,o,s,c)));return["bytes32",(0,r.arrToBufArr)((0,m.keccak256)((0,n.encode)(i.map((([e])=>e)),i.map((([,e])=>e)))))]}return[s,a]}function p(e,t,s,a){u(a,[d.V3,d.V4]);const o=["bytes32"],i=[y(e,s)];for(const r of s[e]){if(a===d.V3&&t[r.name]===undefined)continue;const[e,n]=h(s,r.name,r.type,t[r.name],a);o.push(e),i.push(n)}return(0,r.arrToBufArr)((0,n.encode)(o,i))}function g(e,t){let s="";const r=k(e,t);r.delete(e);const n=[e,...Array.from(r).sort()];for(const e of n){if(!t[e])throw new Error(`No type definition specified: ${e}`);s+=`${e}(${t[e].map((({name:e,type:t})=>`${t} ${e}`)).join(",")})`}return s}function k(e,t,s=new Set){if("string"!=typeof e)throw new Error(`Invalid findTypeDependencies input ${JSON.stringify(e)}`);const r=e.match(/^\w*/u);if([e]=r,s.has(e)||t[e]===undefined)return s;s.add(e);for(const r of t[e])k(r.type,t,s);return s}function b(e,t,s,n){u(n,[d.V3,d.V4]);const a=p(e,t,s,n),o=(0,m.keccak256)(a);return(0,r.arrToBufArr)(o)}function y(e,t){const s=(0,i.stringToBytes)(g(e,t));return(0,r.arrToBufArr)((0,m.keccak256)(s))}function x(e){const t={};for(const r in s.TYPED_MESSAGE_SCHEMA.properties)e[r]&&(t[r]=e[r]);return"types"in t&&(t.types=Object.assign({EIP712Domain:[]},t.types)),t}function w(e,t){u(t,[d.V3,d.V4]);const s=x(e),{domain:r}=s;return b("EIP712Domain",r,{EIP712Domain:s.types.EIP712Domain},t)}function E(e,t){if((0,a.isArrayType)(e)&&Array.isArray(t)){const[s]=(0,a.getArrayType)(e);return t.map((e=>E(s,e)))}if("address"===e){if((0,i.isStrictHexString)(t))return(0,o.padStart)((0,i.hexToBytes)(t).subarray(0,20),20);if(t instanceof Uint8Array)return(0,o.padStart)(t.subarray(0,20),20)}if("bool"===e)return Boolean(t);if(e.startsWith("bytes")&&"bytes"!==e){const s=(0,a.getByteLength)(e);if("number"==typeof t)return t<0?new Uint8Array:(0,i.numberToBytes)(t).subarray(0,s);if((0,i.isStrictHexString)(t))return(0,i.hexToBytes)(t).subarray(0,s);if(t instanceof Uint8Array)return t.subarray(0,s)}if(e.startsWith("uint")&&"number"==typeof t)return Math.abs(t);if(e.startsWith("int")&&"number"==typeof t){const s=(0,a.getLength)(e);return BigInt.asIntN(s,BigInt(t))}return t}function _(e,t){return t.map((t=>{if("string"==typeof t||"number"==typeof t||"bigint"==typeof t){const s=l(e,t);if(s>=BigInt(0))return(0,o.padStart)((0,i.bigIntToBytes)(s),32);const r=(0,a.getLength)(e),n=BigInt.asIntN(r,s);return(0,i.signedBigIntToBytes)(n,32)}return t}))}function v(e){const t=new Error("Expect argument to be non-empty array");if("object"!=typeof e||!("length"in e)||!e.length)throw t;const s=e.map((({name:e,type:t,value:s})=>{if("address[]"===t)return{name:e,type:"bytes32[]",value:(r=s,r.map((e=>"number"==typeof e?(0,o.padStart)((0,i.numberToBytes)(e),32):(0,i.isStrictHexString)(e)?(0,o.padStart)((0,i.hexToBytes)(e).subarray(0,32),32):e instanceof Uint8Array?(0,o.padStart)(e.subarray(0,32),32):e)))};var r;if(t.startsWith("int")&&(0,a.isArrayType)(t)){const[r,n]=(0,a.getArrayType)(t);return{name:e,type:`bytes32[${null!=n?n:""}]`,value:_(r,s)}}return{name:e,type:t,value:E(t,s)}})),d=s.map((e=>"bytes"!==e.type?e.value:(0,c.legacyToBuffer)(e.value))),u=s.map((e=>{if("function"===e.type)throw new Error('Unsupported or invalid type: "function"');return e.type})),l=e.map((e=>{if(!e.name)throw t;return`${e.type} ${e.name}`}));return(0,r.arrToBufArr)((0,m.keccak256)((0,n.encodePacked)(["bytes32","bytes32"],[(0,m.keccak256)((0,n.encodePacked)(["string[]"],[l],!0)),(0,m.keccak256)((0,n.encodePacked)(u,d,!0))])))}!function(e){e.V1="V1",e.V3="V3",e.V4="V4"}(d=s.SignTypedDataVersion||(s.SignTypedDataVersion={})),s.TYPED_MESSAGE_SCHEMA={type:"object",properties:{types:{type:"object",additionalProperties:{type:"array",items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}},required:["name","type"]}}},primaryType:{type:"string"},domain:{type:"object"},message:{type:"object"}},required:["types","primaryType","domain","message"]},s.TypedDataUtils={encodeData:p,encodeType:g,findTypeDependencies:k,hashStruct:b,hashType:y,sanitizeData:x,eip712Hash:function(e,t){u(t,[d.V3,d.V4]);const s=x(e),n=[(0,i.hexToBytes)("1901")];return n.push(w(e,t)),"EIP712Domain"!==s.primaryType&&n.push(b(s.primaryType,s.message,s.types,t)),(0,r.arrToBufArr)((0,m.keccak256)((0,i.concatBytes)(n)))},eip712DomainHash:w},s.typedSignatureHash=function(e){const t=v(e);return(0,i.bytesToHex)(t)},s.signTypedData=function({privateKey:e,data:t,version:n}){if(u(n),(0,c.isNullish)(t))throw new Error("Missing data parameter");if((0,c.isNullish)(e))throw new Error("Missing private key parameter");const a=n===d.V1?v(t):s.TypedDataUtils.eip712Hash(t,n),o=(0,r.ecsign)(a,e);return(0,c.concatSig)((0,r.arrToBufArr)((0,i.bigIntToBytes)(o.v)),o.r,o.s)},s.recoverTypedSignature=function({data:e,signature:t,version:n}){if(u(n),(0,c.isNullish)(e))throw new Error("Missing data parameter");if((0,c.isNullish)(t))throw new Error("Missing signature parameter");const a=n===d.V1?v(e):s.TypedDataUtils.eip712Hash(e,n),o=(0,c.recoverPublicKey)(a,t),m=(0,r.publicToAddress)(o);return(0,i.bytesToHex)(m)}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/sign-typed-data.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/utils.js",{"@ethereumjs/util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.normalize=s.recoverPublicKey=s.concatSig=s.legacyToBuffer=s.isNullish=s.padWithZeroes=void 0;const r=e("@ethereumjs/util"),n=e("@metamask/utils");function a(e,t){if(""!==e&&!/^[a-f0-9]+$/iu.test(e))throw new Error(`Expected an unprefixed hex string. Received: ${e}`);if(t<0)throw new Error(`Expected a non-negative integer target length. Received: ${t}`);return String.prototype.padStart.call(e,t,"0")}function o(e){return null===e||e===undefined}s.padWithZeroes=a,s.isNullish=o,s.legacyToBuffer=function(e){return"string"!=typeof e||(0,r.isHexString)(e)?(0,r.toBuffer)(e):t.from(e)},s.concatSig=function(e,t,s){const o=(0,r.fromSigned)(t),i=(0,r.fromSigned)(s),m=(0,r.bufferToInt)(e),c=a((0,r.toUnsigned)(o).toString("hex"),64),d=a((0,r.toUnsigned)(i).toString("hex"),64),u=(0,n.remove0x)((0,n.numberToHex)(m));return(0,n.add0x)(c.concat(d,u))},s.recoverPublicKey=function(e,t){const s=(0,r.fromRpcSig)(t);return(0,r.ecrecover)(e,s.v,s.r,s.s)},s.normalize=function(e){if(o(e))return undefined;if("number"==typeof e){if(e<0)return"0x";const t=(0,n.numberToBytes)(e);e=(0,n.bytesToHex)(t)}if("string"!=typeof e){let t="eth-sig-util.normalize() requires hex string or integer input.";throw t+=` received ${typeof e}: ${e}`,new Error(t)}return(0,n.add0x)(e.toLowerCase())}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/dist/utils.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/account.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js","./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js","@ethereumjs/rlp":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@ethereumjs/rlp/dist/index.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js","ethereum-cryptography/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/utils.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.accountBodyToRLP=s.accountBodyToSlim=s.accountBodyFromSlim=s.isZeroAddress=s.zeroAddress=s.importPublic=s.privateToAddress=s.privateToPublic=s.publicToAddress=s.pubToAddress=s.isValidPublic=s.isValidPrivate=s.generateAddress2=s.generateAddress=s.isValidChecksumAddress=s.toChecksumAddress=s.isValidAddress=s.Account=void 0;const r=e("@ethereumjs/rlp"),n=e("ethereum-cryptography/keccak"),a=e("ethereum-cryptography/secp256k1"),o=e("ethereum-cryptography/utils"),i=e("./bytes"),m=e("./constants"),c=e("./helpers"),d=e("./internal"),u=BigInt(0);class l{constructor(e=u,t=u,s=m.KECCAK256_RLP,r=m.KECCAK256_NULL){this.nonce=e,this.balance=t,this.storageRoot=s,this.codeHash=r,this._validate()}static fromAccountData(e){const{nonce:t,balance:s,storageRoot:r,codeHash:n}=e;return new l(t!==undefined?(0,i.bufferToBigInt)((0,i.toBuffer)(t)):undefined,s!==undefined?(0,i.bufferToBigInt)((0,i.toBuffer)(s)):undefined,r!==undefined?(0,i.toBuffer)(r):undefined,n!==undefined?(0,i.toBuffer)(n):undefined)}static fromRlpSerializedAccount(e){const t=(0,i.arrToBufArr)(r.RLP.decode(Uint8Array.from(e)));if(!Array.isArray(t))throw new Error("Invalid serialized account input. Must be array");return this.fromValuesArray(t)}static fromValuesArray(e){const[t,s,r,n]=e;return new l((0,i.bufferToBigInt)(t),(0,i.bufferToBigInt)(s),r,n)}_validate(){if(this.nonce<u)throw new Error("nonce must be greater than zero");if(this.balance<u)throw new Error("balance must be greater than zero");if(32!==this.storageRoot.length)throw new Error("storageRoot must have a length of 32");if(32!==this.codeHash.length)throw new Error("codeHash must have a length of 32")}raw(){return[(0,i.bigIntToUnpaddedBuffer)(this.nonce),(0,i.bigIntToUnpaddedBuffer)(this.balance),this.storageRoot,this.codeHash]}serialize(){return t.from(r.RLP.encode((0,i.bufArrToArr)(this.raw())))}isContract(){return!this.codeHash.equals(m.KECCAK256_NULL)}isEmpty(){return this.balance===u&&this.nonce===u&&this.codeHash.equals(m.KECCAK256_NULL)}}s.Account=l;s.isValidAddress=function(e){try{(0,c.assertIsString)(e)}catch(e){return!1}return/^0x[0-9a-fA-F]{40}$/.test(e)};s.toChecksumAddress=function(e,s){(0,c.assertIsHexString)(e);const r=(0,d.stripHexPrefix)(e).toLowerCase();let a="";if(s!==undefined){a=(0,i.bufferToBigInt)((0,i.toBuffer)(s)).toString()+"0x"}const m=t.from(a+r,"utf8"),u=(0,o.bytesToHex)((0,n.keccak256)(m));let l="0x";for(let e=0;e<r.length;e++)parseInt(u[e],16)>=8?l+=r[e].toUpperCase():l+=r[e];return l};s.isValidChecksumAddress=function(e,t){return(0,s.isValidAddress)(e)&&(0,s.toChecksumAddress)(e,t)===e};s.generateAddress=function(e,s){return(0,c.assertIsBuffer)(e),(0,c.assertIsBuffer)(s),(0,i.bufferToBigInt)(s)===BigInt(0)?t.from((0,n.keccak256)(r.RLP.encode((0,i.bufArrToArr)([e,null])))).slice(-20):t.from((0,n.keccak256)(r.RLP.encode((0,i.bufArrToArr)([e,s])))).slice(-20)};s.generateAddress2=function(e,s,r){if((0,c.assertIsBuffer)(e),(0,c.assertIsBuffer)(s),(0,c.assertIsBuffer)(r),20!==e.length)throw new Error("Expected from to be of length 20");if(32!==s.length)throw new Error("Expected salt to be of length 32");const a=(0,n.keccak256)(t.concat([t.from("ff","hex"),e,s,(0,n.keccak256)(r)]));return(0,i.toBuffer)(a).slice(-20)};s.isValidPrivate=function(e){return a.secp256k1.utils.isValidPrivateKey(e)};s.isValidPublic=function(e,s=!1){if((0,c.assertIsBuffer)(e),64===e.length)try{return a.secp256k1.ProjectivePoint.fromHex(t.concat([t.from([4]),e])),!0}catch(e){return!1}if(!s)return!1;try{return a.secp256k1.ProjectivePoint.fromHex(e),!0}catch(e){return!1}};s.pubToAddress=function(e,s=!1){if((0,c.assertIsBuffer)(e),s&&64!==e.length&&(e=t.from(a.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),64!==e.length)throw new Error("Expected pubKey to be of length 64");return t.from((0,n.keccak256)(e)).slice(-20)},s.publicToAddress=s.pubToAddress;s.privateToPublic=function(e){return(0,c.assertIsBuffer)(e),t.from(a.secp256k1.ProjectivePoint.fromPrivateKey(e).toRawBytes(!1).slice(1))};s.privateToAddress=function(e){return(0,s.publicToAddress)((0,s.privateToPublic)(e))};s.importPublic=function(e){return(0,c.assertIsBuffer)(e),64!==e.length&&(e=t.from(a.secp256k1.ProjectivePoint.fromHex(e).toRawBytes(!1).slice(1))),e};s.zeroAddress=function(){const e=(0,i.zeros)(20);return(0,i.bufferToHex)(e)};function f(e){const[t,s,r,n]=e;return[t,s,0===(0,i.arrToBufArr)(r).length?m.KECCAK256_RLP:r,0===(0,i.arrToBufArr)(n).length?m.KECCAK256_NULL:n]}s.isZeroAddress=function(e){try{(0,c.assertIsString)(e)}catch(e){return!1}return(0,s.zeroAddress)()===e},s.accountBodyFromSlim=f;const h=new Uint8Array(0);s.accountBodyToSlim=function(e){const[t,s,r,n]=e;return[t,s,(0,i.arrToBufArr)(r).equals(m.KECCAK256_RLP)?h:r,(0,i.arrToBufArr)(n).equals(m.KECCAK256_NULL)?h:n]},s.accountBodyToRLP=function(e,t=!0){const s=t?f(e):e;return(0,i.arrToBufArr)(r.RLP.encode(s))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/account.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/address.js",{"./account":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/account.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.Address=void 0;const r=e("./account"),n=e("./bytes");class a{constructor(e){if(20!==e.length)throw new Error("Invalid address length");this.buf=e}static zero(){return new a((0,n.zeros)(20))}static fromString(e){if(!(0,r.isValidAddress)(e))throw new Error("Invalid address");return new a((0,n.toBuffer)(e))}static fromPublicKey(e){if(!t.isBuffer(e))throw new Error("Public key should be Buffer");const s=(0,r.pubToAddress)(e);return new a(s)}static fromPrivateKey(e){if(!t.isBuffer(e))throw new Error("Private key should be Buffer");const s=(0,r.privateToAddress)(e);return new a(s)}static generate(e,t){if("bigint"!=typeof t)throw new Error("Expected nonce to be a bigint");return new a((0,r.generateAddress)(e.buf,(0,n.bigIntToBuffer)(t)))}static generate2(e,s,n){if(!t.isBuffer(s))throw new Error("Expected salt to be a Buffer");if(!t.isBuffer(n))throw new Error("Expected initCode to be a Buffer");return new a((0,r.generateAddress2)(e.buf,s,n))}equals(e){return this.buf.equals(e.buf)}isZero(){return this.equals(a.zero())}isPrecompileOrSystemAddress(){const e=(0,n.bufferToBigInt)(this.buf),t=BigInt(0),s=BigInt("0xffff");return e>=t&&e<=s}toString(){return"0x"+this.buf.toString("hex")}toBuffer(){return t.from(this.buf)}}s.Address=a}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/address.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js",{events:"/home/runner/work/metamask-extension/metamask-extension/node_modules/events/events.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.AsyncEventEmitter=void 0;const r=e("events");class n extends r.EventEmitter{emit(e,...t){let[s,r]=t;const n=this;let a=n._events[e]??[];return r===undefined&&"function"==typeof s&&(r=s,s=undefined),"newListener"!==e&&"removeListener"!==e||(s={event:s,fn:r},r=undefined),a=Array.isArray(a)?a:[a],async function(e,t,s){let r;for await(const n of t)try{n.length<2?n.call(e,s):await new Promise(((t,r)=>{n.call(e,s,(e=>{e?r(e):t()}))}))}catch(e){r=e}if(r)throw r}(n,a.slice(),s).then(r).catch(r),n.listenerCount(e)>0}once(e,t){const s=this;let r;if("function"!=typeof t)throw new TypeError("listener must be a function");return r=t.length>=2?function(n,a){s.removeListener(e,r),t(n,a)}:function(n){s.removeListener(e,r),t(n,r)},s.on(e,r),s}first(e,t){let s=this._events[e]??[];if("function"!=typeof t)throw new TypeError("listener must be a function");return Array.isArray(s)||(this._events[e]=s=[s]),s.unshift(t),this}before(e,t,s){return this.beforeOrAfter(e,t,s)}after(e,t,s){return this.beforeOrAfter(e,t,s,"after")}beforeOrAfter(e,t,s,r){let n,a,o=this._events[e]??[];const i="after"===r?1:0;if("function"!=typeof s)throw new TypeError("listener must be a function");if("function"!=typeof t)throw new TypeError("target must be a function");for(Array.isArray(o)||(this._events[e]=o=[o]),a=o.length,n=o.length;n--;)if(o[n]===t){a=n+i;break}return o.splice(a,0,s),this}on(e,t){return super.on(e,t)}addListener(e,t){return super.addListener(e,t)}prependListener(e,t){return super.prependListener(e,t)}prependOnceListener(e,t){return super.prependOnceListener(e,t)}removeAllListeners(e){return super.removeAllListeners(e)}removeListener(e,t){return super.removeListener(e,t)}eventNames(){return super.eventNames()}listeners(e){return super.listeners(e)}listenerCount(e){return super.listenerCount(e)}getMaxListeners(){return super.getMaxListeners()}setMaxListeners(e){return super.setMaxListeners(e)}}s.AsyncEventEmitter=n}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js",{"./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.intToUnpaddedBuffer=s.bigIntToUnpaddedBuffer=s.bigIntToHex=s.bufArrToArr=s.arrToBufArr=s.validateNoLeadingZeroes=s.baToJSON=s.toUtf8=s.short=s.addHexPrefix=s.toUnsigned=s.fromSigned=s.bufferToInt=s.bigIntToBuffer=s.bufferToBigInt=s.bufferToHex=s.toBuffer=s.unpadHexString=s.unpadArray=s.unpadBuffer=s.setLengthRight=s.setLengthLeft=s.zeros=s.intToBuffer=s.intToHex=void 0;const r=e("./helpers"),n=e("./internal");s.intToHex=function(e){if(!Number.isSafeInteger(e)||e<0)throw new Error(`Received an invalid integer type: ${e}`);return`0x${e.toString(16)}`};s.intToBuffer=function(e){const r=(0,s.intToHex)(e);return t.from((0,n.padToEven)(r.slice(2)),"hex")};s.zeros=function(e){return t.allocUnsafe(e).fill(0)};const a=function(e,t,r){const n=(0,s.zeros)(t);return r?e.length<t?(e.copy(n),n):e.slice(0,t):e.length<t?(e.copy(n,t-e.length),n):e.slice(-t)};s.setLengthLeft=function(e,t){return(0,r.assertIsBuffer)(e),a(e,t,!1)};s.setLengthRight=function(e,t){return(0,r.assertIsBuffer)(e),a(e,t,!0)};const o=function(e){let t=e[0];for(;e.length>0&&"0"===t.toString();)t=(e=e.slice(1))[0];return e};s.unpadBuffer=function(e){return(0,r.assertIsBuffer)(e),o(e)};s.unpadArray=function(e){return(0,r.assertIsArray)(e),o(e)};s.unpadHexString=function(e){return(0,r.assertIsHexString)(e),e=(0,n.stripHexPrefix)(e),"0x"+o(e)};s.toBuffer=function(e){if(null===e||e===undefined)return t.allocUnsafe(0);if(t.isBuffer(e))return t.from(e);if(Array.isArray(e)||e instanceof Uint8Array)return t.from(e);if("string"==typeof e){if(!(0,n.isHexString)(e))throw new Error(`Cannot convert string to buffer. toBuffer only supports 0x-prefixed hex strings and this string was given: ${e}`);return t.from((0,n.padToEven)((0,n.stripHexPrefix)(e)),"hex")}if("number"==typeof e)return(0,s.intToBuffer)(e);if("bigint"==typeof e){if(e<BigInt(0))throw new Error(`Cannot convert negative bigint to buffer. Given: ${e}`);let s=e.toString(16);return s.length%2&&(s="0"+s),t.from(s,"hex")}if(e.toArray)return t.from(e.toArray());if(e.toBuffer)return t.from(e.toBuffer());throw new Error("invalid type")};function i(e){const t=(0,s.bufferToHex)(e);return"0x"===t?BigInt(0):BigInt(t)}function m(e){return(0,s.toBuffer)("0x"+e.toString(16))}s.bufferToHex=function(e){return"0x"+(e=(0,s.toBuffer)(e)).toString("hex")},s.bufferToBigInt=i,s.bigIntToBuffer=m;s.bufferToInt=function(e){const t=Number(i(e));if(!Number.isSafeInteger(t))throw new Error("Number exceeds 53 bits");return t};s.fromSigned=function(e){return BigInt.asIntN(256,i(e))};s.toUnsigned=function(e){return m(BigInt.asUintN(256,e))};s.addHexPrefix=function(e){return"string"!=typeof e||(0,n.isHexPrefixed)(e)?e:"0x"+e},s.short=function(e,s=50){const r=t.isBuffer(e)?e.toString("hex"):e;return r.length<=s?r:r.slice(0,s)+"…"};s.toUtf8=function(e){if((e=(0,n.stripHexPrefix)(e)).length%2!=0)throw new Error("Invalid non-even hex string input for toUtf8() provided");return t.from(e.replace(/^(00)+|(00)+$/g,""),"hex").toString("utf8")};s.baToJSON=function(e){if(t.isBuffer(e))return`0x${e.toString("hex")}`;if(e instanceof Array){const t=[];for(let r=0;r<e.length;r++)t.push((0,s.baToJSON)(e[r]));return t}};s.validateNoLeadingZeroes=function(e){for(const[t,s]of Object.entries(e))if(s!==undefined&&s.length>0&&0===s[0])throw new Error(`${t} cannot have leading zeroes, received: ${s.toString("hex")}`)},s.arrToBufArr=function e(s){return Array.isArray(s)?s.map((t=>e(t))):t.from(s)},s.bufArrToArr=function e(t){return Array.isArray(t)?t.map((t=>e(t))):Uint8Array.from(t??[])};s.bigIntToHex=e=>"0x"+e.toString(16),s.bigIntToUnpaddedBuffer=function(e){return(0,s.unpadBuffer)(m(e))},s.intToUnpaddedBuffer=function(e){return(0,s.unpadBuffer)((0,s.intToBuffer)(e))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.MAX_WITHDRAWALS_PER_PAYLOAD=s.RLP_EMPTY_STRING=s.KECCAK256_RLP=s.KECCAK256_RLP_S=s.KECCAK256_RLP_ARRAY=s.KECCAK256_RLP_ARRAY_S=s.KECCAK256_NULL=s.KECCAK256_NULL_S=s.TWO_POW256=s.SECP256K1_ORDER_DIV_2=s.SECP256K1_ORDER=s.MAX_INTEGER_BIGINT=s.MAX_INTEGER=s.MAX_UINT64=void 0;const r=e("buffer"),n=e("ethereum-cryptography/secp256k1");s.MAX_UINT64=BigInt("0xffffffffffffffff"),s.MAX_INTEGER=BigInt("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),s.MAX_INTEGER_BIGINT=BigInt("115792089237316195423570985008687907853269984665640564039457584007913129639935"),s.SECP256K1_ORDER=n.secp256k1.CURVE.n,s.SECP256K1_ORDER_DIV_2=n.secp256k1.CURVE.n/BigInt(2),s.TWO_POW256=BigInt("0x10000000000000000000000000000000000000000000000000000000000000000"),s.KECCAK256_NULL_S="c5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",s.KECCAK256_NULL=r.Buffer.from(s.KECCAK256_NULL_S,"hex"),s.KECCAK256_RLP_ARRAY_S="1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",s.KECCAK256_RLP_ARRAY=r.Buffer.from(s.KECCAK256_RLP_ARRAY_S,"hex"),s.KECCAK256_RLP_S="56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",s.KECCAK256_RLP=r.Buffer.from(s.KECCAK256_RLP_S,"hex"),s.RLP_EMPTY_STRING=r.Buffer.from([128]),s.MAX_WITHDRAWALS_PER_PAYLOAD=16}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/encoding.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.compactBytesToNibbles=s.bytesToNibbles=s.nibblesToCompactBytes=s.nibblesToBytes=s.hasTerminator=void 0;s.hasTerminator=e=>e.length>0&&16===e[e.length-1];s.nibblesToBytes=(e,t)=>{for(let s=0,r=0;r<e.length;s+=1,r+=2)t[s]=e[r]<<4|e[r+1]};s.nibblesToCompactBytes=e=>{let t=0;(0,s.hasTerminator)(e)&&(t=1,e=e.subarray(0,e.length-1));const r=new Uint8Array(e.length/2+1);return r[0]=t<<5,1&~e.length||(r[0]|=16,r[0]|=e[0],e=e.subarray(1)),(0,s.nibblesToBytes)(e,r.subarray(1)),r};s.bytesToNibbles=e=>{const t=2*e.length+1,s=new Uint8Array(t);for(let t=0;t<e.length;t++){const r=e[t];s[2*t]=r/16,s[2*t+1]=r%16}return s[t-1]=16,s};s.compactBytesToNibbles=e=>{if(0===e.length)return e;let t=(0,s.bytesToNibbles)(e);t[0]<2&&(t=t.subarray(0,t.length-1));const r=2-(1&t[0]);return t.subarray(r)}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/encoding.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js",{"../../../../../../../../../is-buffer/index.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/is-buffer/index.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.assertIsString=s.assertIsArray=s.assertIsBuffer=s.assertIsHexString=void 0;const r=e("./internal");s.assertIsHexString=function(e){if(!(0,r.isHexString)(e)){throw new Error(`This method only supports 0x-prefixed hex strings but input was: ${e}`)}};s.assertIsBuffer=function(e){if(!t.isBuffer(e)){throw new Error(`This method only supports Buffer but input was: ${e}`)}};s.assertIsArray=function(e){if(!Array.isArray(e)){throw new Error(`This method only supports number arrays but input was: ${e}`)}};s.assertIsString=function(e){if("string"!=typeof e){throw new Error(`This method only supports strings but input was: ${e}`)}}}).call(this)}).call(this,{isBuffer:e("../../../../../../../../../is-buffer/index.js")})}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js",{"./account":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/account.js","./address":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/address.js","./asyncEventEmitter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/asyncEventEmitter.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js","./encoding":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/encoding.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js","./lock":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/lock.js","./provider":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/provider.js","./signature":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/signature.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/types.js","./units":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/units.js","./withdrawal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/withdrawal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),s.toAscii=s.stripHexPrefix=s.padToEven=s.isHexString=s.isHexPrefixed=s.getKeys=s.getBinarySize=s.fromUtf8=s.fromAscii=s.arrayContainsArray=void 0,n(e("./constants"),s),n(e("./units"),s),n(e("./account"),s),n(e("./address"),s),n(e("./withdrawal"),s),n(e("./signature"),s),n(e("./bytes"),s),n(e("./types"),s),n(e("./encoding"),s),n(e("./asyncEventEmitter"),s);var a=e("./internal");Object.defineProperty(s,"arrayContainsArray",{enumerable:!0,get:function(){return a.arrayContainsArray}}),Object.defineProperty(s,"fromAscii",{enumerable:!0,get:function(){return a.fromAscii}}),Object.defineProperty(s,"fromUtf8",{enumerable:!0,get:function(){return a.fromUtf8}}),Object.defineProperty(s,"getBinarySize",{enumerable:!0,get:function(){return a.getBinarySize}}),Object.defineProperty(s,"getKeys",{enumerable:!0,get:function(){return a.getKeys}}),Object.defineProperty(s,"isHexPrefixed",{enumerable:!0,get:function(){return a.isHexPrefixed}}),Object.defineProperty(s,"isHexString",{enumerable:!0,get:function(){return a.isHexString}}),Object.defineProperty(s,"padToEven",{enumerable:!0,get:function(){return a.padToEven}}),Object.defineProperty(s,"stripHexPrefix",{enumerable:!0,get:function(){return a.stripHexPrefix}}),Object.defineProperty(s,"toAscii",{enumerable:!0,get:function(){return a.toAscii}}),n(e("./lock"),s),n(e("./provider"),s)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(e){(function(){function t(e){if("string"!=typeof e)throw new Error("[isHexPrefixed] input must be type 'string', received type "+typeof e);return"0"===e[0]&&"x"===e[1]}Object.defineProperty(s,"__esModule",{value:!0}),s.isHexString=s.getKeys=s.fromAscii=s.fromUtf8=s.toAscii=s.arrayContainsArray=s.getBinarySize=s.padToEven=s.stripHexPrefix=s.isHexPrefixed=void 0,s.isHexPrefixed=t;function r(e){let t=e;if("string"!=typeof t)throw new Error("[padToEven] value must be type 'string', received "+typeof t);return t.length%2&&(t=`0${t}`),t}s.stripHexPrefix=e=>{if("string"!=typeof e)throw new Error("[stripHexPrefix] input must be type 'string', received "+typeof e);return t(e)?e.slice(2):e},s.padToEven=r,s.getBinarySize=function(t){if("string"!=typeof t)throw new Error("[getBinarySize] method requires input type 'string', received "+typeof t);return e.byteLength(t,"utf8")},s.arrayContainsArray=function(e,t,s){if(!0!==Array.isArray(e))throw new Error(`[arrayContainsArray] method requires input 'superset' to be an array, got type '${typeof e}'`);if(!0!==Array.isArray(t))throw new Error(`[arrayContainsArray] method requires input 'subset' to be an array, got type '${typeof t}'`);return t[!0===s?"some":"every"]((t=>e.indexOf(t)>=0))},s.toAscii=function(e){let t="",s=0;const r=e.length;for("0x"===e.substring(0,2)&&(s=2);s<r;s+=2){const r=parseInt(e.substr(s,2),16);t+=String.fromCharCode(r)}return t},s.fromUtf8=function(t){return`0x${r(e.from(t,"utf8").toString("hex")).replace(/^0+|0+$/g,"")}`},s.fromAscii=function(e){let t="";for(let s=0;s<e.length;s++){const r=e.charCodeAt(s).toString(16);t+=r.length<2?`0${r}`:r}return`0x${t}`},s.getKeys=function(e,t,s){if(!Array.isArray(e))throw new Error("[getKeys] method expects input 'params' to be an array, got "+typeof e);if("string"!=typeof t)throw new Error("[getKeys] method expects input 'key' to be type 'string', got "+typeof e);const r=[];for(let n=0;n<e.length;n++){let a=e[n][t];if(!0!==s||a){if("string"!=typeof a)throw new Error("invalid abi - expected type 'string', received "+typeof a)}else a="";r.push(a)}return r},s.isHexString=function(e,t){return!("string"!=typeof e||!e.match(/^0x[0-9A-Fa-f]*$/))&&!(void 0!==t&&t>0&&e.length!==2+2*t)}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/lock.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.Lock=void 0;s.Lock=class{constructor(){this.permits=1,this.promiseResolverQueue=[]}async acquire(){return this.permits>0?(this.permits-=1,Promise.resolve(!0)):new Promise((e=>this.promiseResolverQueue.push(e)))}release(){if(this.permits+=1,this.permits>1&&this.promiseResolverQueue.length>0)console.warn("Lock.permits should never be > 0 when there is someone waiting.");else if(1===this.permits&&this.promiseResolverQueue.length>0){this.permits-=1;const e=this.promiseResolverQueue.shift();e&&e(!0)}}}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/lock.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/provider.js",{"micro-ftch":"/home/runner/work/metamask-extension/metamask-extension/node_modules/micro-ftch/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.getProvider=s.fetchFromProvider=void 0;const r=e("micro-ftch");s.fetchFromProvider=async(e,t)=>(await(0,r.default)(e,{headers:{"content-type":"application/json"},type:"json",data:{method:t.method,params:t.params,jsonrpc:"2.0",id:1}})).result;s.getProvider=e=>{if("string"==typeof e)return e;if(e?.connection?.url!==undefined)return e.connection.url;throw new Error("Must provide valid provider URL or Web3Provider")}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/provider.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/signature.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./constants":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/constants.js","./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/helpers.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","ethereum-cryptography/keccak":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/keccak.js","ethereum-cryptography/secp256k1":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethereum-cryptography/secp256k1.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.hashPersonalMessage=s.isValidSignature=s.fromRpcSig=s.toCompactSig=s.toRpcSig=s.ecrecover=s.ecsign=void 0;const r=e("ethereum-cryptography/keccak"),n=e("ethereum-cryptography/secp256k1"),a=e("./bytes"),o=e("./constants"),i=e("./helpers");function m(e,t){return e===BigInt(0)||e===BigInt(1)?e:t===undefined?e-BigInt(27):e-(t*BigInt(2)+BigInt(35))}function c(e){return e===BigInt(0)||e===BigInt(1)}s.ecsign=function(e,s,r){const a=n.secp256k1.sign(e,s),o=a.toCompactRawBytes();return{r:t.from(o.slice(0,32)),s:t.from(o.slice(32,64)),v:r===undefined?BigInt(a.recovery+27):BigInt(a.recovery+35)+BigInt(r)*BigInt(2)}};s.ecrecover=function(e,s,r,o,i){const d=t.concat([(0,a.setLengthLeft)(r,32),(0,a.setLengthLeft)(o,32)],64),u=m(s,i);if(!c(u))throw new Error("Invalid signature v value");const l=n.secp256k1.Signature.fromCompact(d).addRecoveryBit(Number(u)).recoverPublicKey(e);return t.from(l.toRawBytes(!1).slice(1))};s.toRpcSig=function(e,s,r,n){if(!c(m(e,n)))throw new Error("Invalid signature v value");return(0,a.bufferToHex)(t.concat([(0,a.setLengthLeft)(s,32),(0,a.setLengthLeft)(r,32),(0,a.toBuffer)(e)]))};s.toCompactSig=function(e,s,r,n){if(!c(m(e,n)))throw new Error("Invalid signature v value");let o=r;return(e>BigInt(28)&&e%BigInt(2)===BigInt(1)||e===BigInt(1)||e===BigInt(28))&&(o=t.from(r),o[0]|=128),(0,a.bufferToHex)(t.concat([(0,a.setLengthLeft)(s,32),(0,a.setLengthLeft)(o,32)]))};s.fromRpcSig=function(e){const t=(0,a.toBuffer)(e);let s,r,n;if(t.length>=65)s=t.slice(0,32),r=t.slice(32,64),n=(0,a.bufferToBigInt)(t.slice(64));else{if(64!==t.length)throw new Error("Invalid signature length");s=t.slice(0,32),r=t.slice(32,64),n=BigInt((0,a.bufferToInt)(t.slice(32,33))>>7),r[0]&=127}return n<27&&(n+=BigInt(27)),{v:n,r:s,s:r}};s.isValidSignature=function(e,t,s,r=!0,n){if(32!==t.length||32!==s.length)return!1;if(!c(m(e,n)))return!1;const i=(0,a.bufferToBigInt)(t),d=(0,a.bufferToBigInt)(s);return!(i===BigInt(0)||i>=o.SECP256K1_ORDER||d===BigInt(0)||d>=o.SECP256K1_ORDER)&&!(r&&d>=o.SECP256K1_ORDER_DIV_2)};s.hashPersonalMessage=function(e){(0,i.assertIsBuffer)(e);const s=t.from(`Ethereum Signed Message:\n${e.length}`,"utf-8");return t.from((0,r.keccak256)(t.concat([s,e])))}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/signature.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/types.js",{"./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./internal":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/internal.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.toType=s.TypeOutput=void 0;const r=e("./bytes"),n=e("./internal");var a;!function(e){e[e.Number=0]="Number",e[e.BigInt=1]="BigInt",e[e.Buffer=2]="Buffer",e[e.PrefixedHexString=3]="PrefixedHexString"}(a=s.TypeOutput||(s.TypeOutput={})),s.toType=function(e,t){if(null===e)return null;if(e===undefined)return undefined;if("string"==typeof e&&!(0,n.isHexString)(e))throw new Error(`A string must be provided with a 0x-prefix, given: ${e}`);if("number"==typeof e&&!Number.isSafeInteger(e))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative input type)");const s=(0,r.toBuffer)(e);switch(t){case a.Buffer:return s;case a.BigInt:return(0,r.bufferToBigInt)(s);case a.Number:{const e=(0,r.bufferToBigInt)(s);if(e>BigInt(Number.MAX_SAFE_INTEGER))throw new Error("The provided number is greater than MAX_SAFE_INTEGER (please use an alternative output type)");return Number(e)}case a.PrefixedHexString:return(0,r.bufferToHex)(s);default:throw new Error("unknown outputType")}}}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/types.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/units.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.GWEI_TO_WEI=void 0,s.GWEI_TO_WEI=BigInt(1e9)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/units.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/withdrawal.js",{"./address":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/address.js","./bytes":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/bytes.js","./types":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/types.js",buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(t){(function(){Object.defineProperty(s,"__esModule",{value:!0}),s.Withdrawal=void 0;const r=e("./address"),n=e("./bytes"),a=e("./types");class o{constructor(e,t,s,r){this.index=e,this.validatorIndex=t,this.address=s,this.amount=r}static fromWithdrawalData(e){const{index:t,validatorIndex:s,address:n,amount:i}=e,m=(0,a.toType)(t,a.TypeOutput.BigInt),c=(0,a.toType)(s,a.TypeOutput.BigInt),d=new r.Address((0,a.toType)(n,a.TypeOutput.Buffer)),u=(0,a.toType)(i,a.TypeOutput.BigInt);return new o(m,c,d,u)}static fromValuesArray(e){if(4!==e.length)throw Error(`Invalid withdrawalArray length expected=4 actual=${e.length}`);const[t,s,r,n]=e;return o.fromWithdrawalData({index:t,validatorIndex:s,address:r,amount:n})}static toBufferArray(e){const{index:s,validatorIndex:n,address:o,amount:i}=e,m=(0,a.toType)(s,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(s,a.TypeOutput.Buffer),c=(0,a.toType)(n,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(n,a.TypeOutput.Buffer);let d;d=o instanceof r.Address?o.buf:(0,a.toType)(o,a.TypeOutput.Buffer);return[m,c,d,(0,a.toType)(i,a.TypeOutput.BigInt)===BigInt(0)?t.alloc(0):(0,a.toType)(i,a.TypeOutput.Buffer)]}raw(){return o.toBufferArray(this)}toValue(){return{index:this.index,validatorIndex:this.validatorIndex,address:this.address.buf,amount:this.amount}}toJSON(){return{index:(0,n.bigIntToHex)(this.index),validatorIndex:(0,n.bigIntToHex)(this.validatorIndex),address:"0x"+this.address.buf.toString("hex"),amount:(0,n.bigIntToHex)(this.amount)}}}s.Withdrawal=o}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@ethereumjs/util",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@metamask/eth-sig-util/node_modules/@ethereumjs/util/dist/withdrawal.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-simple-keyring/node_modules/@scure/base/lib/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function r(e){if(!Number.isSafeInteger(e))throw new Error(`Wrong integer: ${e}`)}function n(e){return e instanceof Uint8Array||null!=e&&"object"==typeof e&&"Uint8Array"===e.constructor.name}function a(...e){const t=e=>e,s=(e,t)=>s=>e(t(s));return{encode:e.map((e=>e.encode)).reduceRight(s,t),decode:e.map((e=>e.decode)).reduce(s,t)}}function o(e){return{encode:t=>{if(!Array.isArray(t)||t.length&&"number"!=typeof t[0])throw new Error("alphabet.encode input should be an array of numbers");return t.map((t=>{if(r(t),t<0||t>=e.length)throw new Error(`Digit index outside alphabet: ${t} (alphabet: ${e.length})`);return e[t]}))},decode:t=>{if(!Array.isArray(t)||t.length&&"string"!=typeof t[0])throw new Error("alphabet.decode input should be array of strings");return t.map((t=>{if("string"!=typeof t)throw new Error(`alphabet.decode: not string element=${t}`);const s=e.indexOf(t);if(-1===s)throw new Error(`Unknown letter: "${t}". Allowed: ${e}`);return s}))}}}function i(e=""){if("string"!=typeof e)throw new Error("join separator should be string");return{encode:t=>{if(!Array.isArray(t)||t.length&&"string"!=typeof t[0])throw new Error("join.encode input should be array of strings");for(let e of t)if("string"!=typeof e)throw new Error(`join.encode: non-string input=${e}`);return t.join(e)},decode:t=>{if("string"!=typeof t)throw new Error("join.decode input should be string");return t.split(e)}}}function m(e,t="="){if(r(e),"string"!=typeof t)throw new Error("padding chr should be string");return{encode(s){if(!Array.isArray(s)||s.length&&"string"!=typeof s[0])throw new Error("padding.encode input should be array of strings");for(let e of s)if("string"!=typeof e)throw new Error(`padding.encode: non-string input=${e}`);for(;s.length*e%8;)s.push(t);return s},decode(s){if(!Array.isArray(s)||s.length&&"string"!=typeof s[0])throw new Error("padding.encode input should be array of strings");for(let e of s)if("string"!=typeof e)throw new Error(`padding.decode: non-string input=${e}`);let r=s.length;if(r*e%8)throw new Error("Invalid padding: string should have whole number of bytes");for(;r>0&&s[r-1]===t;r--)if(!((r-1)*e%8))throw new Error("Invalid padding: string has too much padding");return s.slice(0,r)}}}function c(e){if("function"!=typeof e)throw new Error("normalize fn should be function");return{encode:e=>e,decode:t=>e(t)}}function d(e,t,s){if(t<2)throw new Error(`convertRadix: wrong from=${t}, base cannot be less than 2`);if(s<2)throw new Error(`convertRadix: wrong to=${s}, base cannot be less than 2`);if(!Array.isArray(e))throw new Error("convertRadix: data should be array");if(!e.length)return[];let n=0;const a=[],o=Array.from(e);for(o.forEach((e=>{if(r(e),e<0||e>=t)throw new Error(`Wrong integer: ${e}`)}));;){let e=0,r=!0;for(let a=n;a<o.length;a++){const i=o[a],m=t*e+i;if(!Number.isSafeInteger(m)||t*e/t!==e||m-i!=t*e)throw new Error("convertRadix: carry overflow");e=m%s;const c=Math.floor(m/s);if(o[a]=c,!Number.isSafeInteger(c)||c*s+e!==m)throw new Error("convertRadix: carry overflow");r&&(c?r=!1:n=a)}if(a.push(e),r)break}for(let t=0;t<e.length-1&&0===e[t];t++)a.push(0);return a.reverse()}
/*! scure-base - MIT License (c) 2022 Paul Miller (paulmillr.com) */
Object.defineProperty(s,"__esModule",{value:!0}),s.bytes=s.stringToBytes=s.str=s.bytesToString=s.hex=s.utf8=s.bech32m=s.bech32=s.base58check=s.createBase58check=s.base58xmr=s.base58xrp=s.base58flickr=s.base58=s.base64urlnopad=s.base64url=s.base64nopad=s.base64=s.base32crockford=s.base32hexnopad=s.base32hex=s.base32nopad=s.base32=s.base16=s.utils=void 0,s.assertNumber=r;const u=(e,t)=>t?u(t,e%t):e,l=(e,t)=>e+(t-u(e,t));function f(e,t,s,n){if(!Array.isArray(e))throw new Error("convertRadix2: data should be array");if(t<=0||t>32)throw new Error(`convertRadix2: wrong from=${t}`);if(s<=0||s>32)throw new Error(`convertRadix2: wrong to=${s}`);if(l(t,s)>32)throw new Error(`convertRadix2: carry overflow from=${t} to=${s} carryBits=${l(t,s)}`);let a=0,o=0;const i=2**s-1,m=[];for(const n of e){if(r(n),n>=2**t)throw new Error(`convertRadix2: invalid data word=${n} from=${t}`);if(a=a<<t|n,o+t>32)throw new Error(`convertRadix2: carry overflow pos=${o} from=${t}`);for(o+=t;o>=s;o-=s)m.push((a>>o-s&i)>>>0);a&=2**o-1}if(a=a<<s-o&i,!n&&o>=t)throw new Error("Excess padding");if(!n&&a)throw new Error(`Non-zero padding: ${a}`);return n&&o>0&&m.push(a>>>0),m}function h(e){return r(e),{encode:t=>{if(!n(t))throw new Error("radix.encode input should be Uint8Array");return d(Array.from(t),256,e)},decode:t=>{if(!Array.isArray(t)||t.length&&"number"!=typeof t[0])throw new Error("radix.decode input should be array of numbers");return Uint8Array.from(d(t,e,256))}}}function p(e,t=!1){if(r(e),e<=0||e>32)throw new Error("radix2: bits should be in (0..32]");if(l(8,e)>32||l(e,8)>32)throw new Error("radix2: carry overflow");return{encode:s=>{if(!n(s))throw new Error("radix2.encode input should be Uint8Array");return f(Array.from(s),8,e,!t)},decode:s=>{if(!Array.isArray(s)||s.length&&"number"!=typeof s[0])throw new Error("radix2.decode input should be array of numbers");return Uint8Array.from(f(s,e,8,t))}}}function g(e){if("function"!=typeof e)throw new Error("unsafeWrapper fn should be function");return function(...t){try{return e.apply(null,t)}catch(e){}}}function k(e,t){if(r(e),"function"!=typeof t)throw new Error("checksum fn should be function");return{encode(s){if(!n(s))throw new Error("checksum.encode: input should be Uint8Array");const r=t(s).slice(0,e),a=new Uint8Array(s.length+e);return a.set(s),a.set(r,s.length),a},decode(s){if(!n(s))throw new Error("checksum.decode: input should be Uint8Array");const r=s.slice(0,-e),a=t(r).slice(0,e),o=s.slice(-e);for(let t=0;t<e;t++)if(a[t]!==o[t])throw new Error("Invalid checksum");return r}}}s.utils={alphabet:o,chain:a,checksum:k,convertRadix:d,convertRadix2:f,radix:h,radix2:p,join:i,padding:m},s.base16=a(p(4),o("0123456789ABCDEF"),i("")),s.base32=a(p(5),o("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),m(5),i("")),s.base32nopad=a(p(5),o("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567"),i("")),s.base32hex=a(p(5),o("0123456789ABCDEFGHIJKLMNOPQRSTUV"),m(5),i("")),s.base32hexnopad=a(p(5),o("0123456789ABCDEFGHIJKLMNOPQRSTUV"),i("")),s.base32crockford=a(p(5),o("0123456789ABCDEFGHJKMNPQRSTVWXYZ"),i(""),c((e=>e.toUpperCase().replace(/O/g,"0").replace(/[IL]/g,"1")))),s.base64=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),m(6),i("")),s.base64nopad=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"),i("")),s.base64url=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),m(6),i("")),s.base64urlnopad=a(p(6),o("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"),i(""));const b=e=>a(h(58),o(e),i(""));s.base58=b("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz"),s.base58flickr=b("123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ"),s.base58xrp=b("rpshnaf39wBUDNEGHJKLM4PQRST7VWXYZ2bcdeCg65jkm8oFqi1tuvAxyz");const y=[0,2,3,5,6,7,9,10,11];s.base58xmr={encode(e){let t="";for(let r=0;r<e.length;r+=8){const n=e.subarray(r,r+8);t+=s.base58.encode(n).padStart(y[n.length],"1")}return t},decode(e){let t=[];for(let r=0;r<e.length;r+=11){const n=e.slice(r,r+11),a=y.indexOf(n.length),o=s.base58.decode(n);for(let e=0;e<o.length-a;e++)if(0!==o[e])throw new Error("base58xmr: wrong padding");t=t.concat(Array.from(o.slice(o.length-a)))}return Uint8Array.from(t)}};s.createBase58check=e=>a(k(4,(t=>e(e(t)))),s.base58),s.base58check=s.createBase58check;const x=a(o("qpzry9x8gf2tvdw0s3jn54khce6mua7l"),i("")),w=[996825010,642813549,513874426,1027748829,705979059];function E(e){const t=e>>25;let s=(33554431&e)<<5;for(let e=0;e<w.length;e++)1==(t>>e&1)&&(s^=w[e]);return s}function _(e,t,s=1){const r=e.length;let n=1;for(let t=0;t<r;t++){const s=e.charCodeAt(t);if(s<33||s>126)throw new Error(`Invalid prefix (${e})`);n=E(n)^s>>5}n=E(n);for(let t=0;t<r;t++)n=E(n)^31&e.charCodeAt(t);for(let e of t)n=E(n)^e;for(let e=0;e<6;e++)n=E(n);return n^=s,x.encode(f([n%2**30],30,5,!1))}function v(e){const t="bech32"===e?1:734539939,s=p(5),r=s.decode,n=s.encode,a=g(r);function o(e,s,r=90){if("string"!=typeof e)throw new Error("bech32.encode prefix should be string, not "+typeof e);if(s instanceof Uint8Array&&(s=Array.from(s)),!Array.isArray(s)||s.length&&"number"!=typeof s[0])throw new Error("bech32.encode words should be array of numbers, not "+typeof s);if(0===e.length)throw new TypeError(`Invalid prefix length ${e.length}`);const n=e.length+7+s.length;if(!1!==r&&n>r)throw new TypeError(`Length ${n} exceeds limit ${r}`);const a=e.toLowerCase(),o=_(a,s,t);return`${a}1${x.encode(s)}${o}`}function i(e,s=90){if("string"!=typeof e)throw new Error("bech32.decode input should be string, not "+typeof e);if(e.length<8||!1!==s&&e.length>s)throw new TypeError(`Wrong string length: ${e.length} (${e}). Expected (8..${s})`);const r=e.toLowerCase();if(e!==r&&e!==e.toUpperCase())throw new Error("String must be lowercase or uppercase");const n=r.lastIndexOf("1");if(0===n||-1===n)throw new Error('Letter "1" must be present between prefix and data only');const a=r.slice(0,n),o=r.slice(n+1);if(o.length<6)throw new Error("Data must be at least 6 characters long");const i=x.decode(o).slice(0,-6),m=_(a,i,t);if(!o.endsWith(m))throw new Error(`Invalid checksum in ${e}: expected "${m}"`);return{prefix:a,words:i}}return{encode:o,decode:i,encodeFromBytes:function(e,t){return o(e,n(t))},decodeToBytes:function(e){const{prefix:t,words:s}=i(e,!1);return{prefix:t,words:s,bytes:r(s)}},decodeUnsafe:g(i),fromWords:r,fromWordsUnsafe:a,toWords:n}}s.bech32=v("bech32"),s.bech32m=v("bech32m"),s.utf8={encode:e=>(new TextDecoder).decode(e),decode:e=>(new TextEncoder).encode(e)},s.hex=a(p(4),o("0123456789abcdef"),i(""),c((e=>{if("string"!=typeof e||e.length%2)throw new TypeError(`hex.decode: expected string, got ${typeof e} with length ${e.length}`);return e.toLowerCase()})));const A={utf8:s.utf8,hex:s.hex,base16:s.base16,base32:s.base32,base64:s.base64,base64url:s.base64url,base58:s.base58,base58xmr:s.base58xmr},T="Invalid encoding type. Available types: utf8, hex, base16, base32, base64, base64url, base58, base58xmr";s.bytesToString=(e,t)=>{if("string"!=typeof e||!A.hasOwnProperty(e))throw new TypeError(T);if(!n(t))throw new TypeError("bytesToString() expects Uint8Array");return A[e].encode(t)},s.str=s.bytesToString;s.stringToBytes=(e,t)=>{if(!A.hasOwnProperty(e))throw new TypeError(T);if("string"!=typeof t)throw new TypeError("stringToBytes() expects string");return A[e].decode(t)},s.bytes=s.stringToBytes}}},{package:"@metamask/keyring-controller>@metamask/eth-simple-keyring>@metamask/eth-sig-util>@scure/base",file:"node_modules/@metamask/eth-simple-keyring/node_modules/@scure/base/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/account-link.js",{"./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/helpers.js","./prefix-for-chain":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/prefix-for-chain.js","./prefix-for-network":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/prefix-for-network.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.getAccountLink=s.createCustomAccountLink=s.createAccountLinkForChain=s.createAccountLink=void 0;const n=e("./helpers"),a=r(e("./prefix-for-chain")),o=r(e("./prefix-for-network"));function i(e,t){const s=o.default(t);return null===s?"":`https://${s}etherscan.io/address/${e}`}function m(e,t){const s=a.default(t);return null===s?"":`https://${s}etherscan.io/address/${e}`}function c(e,t){return n.addPathToUrl(t,"address",e)}s.createAccountLink=i,s.createAccountLinkForChain=m,s.createCustomAccountLink=c,s.getAccountLink=function(e,t,s={},r=""){return s.blockExplorerUrl?c(e,s.blockExplorerUrl):r?i(e,r):m(e,t)}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/account-link.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/explorer-link.js",{"./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/helpers.js","./prefix-for-chain":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/prefix-for-chain.js","./prefix-for-network":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/prefix-for-network.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.getBlockExplorerLink=s.createExplorerLinkForChain=s.createExplorerLink=s.createCustomExplorerLink=void 0;const n=e("./helpers"),a=r(e("./prefix-for-chain")),o=r(e("./prefix-for-network"));function i(e,t){return n.addPathToUrl(t,"tx",e)}function m(e,t){const s=o.default(t);return null===s?"":`https://${s}etherscan.io/tx/${e}`}function c(e,t){const s=a.default(t);return null===s?"":`https://${s}etherscan.io/tx/${e}`}s.createCustomExplorerLink=i,s.createExplorerLink=m,s.createExplorerLinkForChain=c,s.getBlockExplorerLink=function(e,t={}){return t.blockExplorerUrl?i(e.hash,t.blockExplorerUrl):e.chainId?c(e.hash,e.chainId):m(e.hash,e.metamaskNetworkId)}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/explorer-link.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/helpers.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.addPathToUrl=void 0,s.addPathToUrl=(e,t,s)=>{const{username:r,password:n,protocol:a,host:o,pathname:i,search:m,hash:c}=new URL(e),d=i.endsWith("/")?`${i}${t}/${s}`:`${i}/${t}/${s}`;return new URL(`${a}//${r?`${r}:${n}`:""}${o}${d}${m}${c}`).toString()}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/helpers.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/index.js",{"./account-link":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/account-link.js","./explorer-link":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/explorer-link.js","./token-tracker-link":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/token-tracker-link.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){const r=e("./account-link"),n=e("./explorer-link"),a=e("./token-tracker-link");t.exports={createExplorerLink:n.createExplorerLink,createCustomExplorerLink:n.createCustomExplorerLink,createExplorerLinkForChain:n.createExplorerLinkForChain,createAccountLink:r.createAccountLink,createCustomAccountLink:r.createCustomAccountLink,createAccountLinkForChain:r.createAccountLinkForChain,createTokenTrackerLink:a.createTokenTrackerLink,createCustomTokenTrackerLink:a.createCustomTokenTrackerLink,createTokenTrackerLinkForChain:a.createTokenTrackerLinkForChain,getBlockExplorerLink:n.getBlockExplorerLink,getAccountLink:r.getAccountLink,getTokenTrackerLink:a.getTokenTrackerLink}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/prefix-for-chain.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){t.exports=function(e){let t;switch(e){case"0x1":t="";break;case"0x5":t="goerli.";break;case"0xaa36a7":t="sepolia.";break;default:t=null}return t}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/prefix-for-chain.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/prefix-for-network.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){t.exports=function(e){let t;switch(parseInt(e)){case 1:t="";break;case 5:t="goerli.";break;case 11155111:t="sepolia.";break;default:t=null}return t}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/prefix-for-network.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/token-tracker-link.js",{"./helpers":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/helpers.js","./prefix-for-chain":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/prefix-for-chain.js","./prefix-for-network":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/etherscan-link/dist/prefix-for-network.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.getTokenTrackerLink=s.createTokenTrackerLinkForChain=s.createCustomTokenTrackerLink=s.createTokenTrackerLink=void 0;const n=e("./helpers"),a=r(e("./prefix-for-chain")),o=r(e("./prefix-for-network"));function i(e,t,s){const r=o.default(t);return null===r?"":`https://${r}etherscan.io/token/${e}${s?`?a=${s}`:""}`}function m(e,t){return n.addPathToUrl(t,"token",e)}function c(e,t,s){const r=a.default(t);return null===r?"":`https://${r}etherscan.io/token/${e}${s?`?a=${s}`:""}`}s.createTokenTrackerLink=i,s.createCustomTokenTrackerLink=m,s.createTokenTrackerLinkForChain=c,s.getTokenTrackerLink=function(e,t,s,r,n={}){return n.blockExplorerUrl?m(e,n.blockExplorerUrl):s?i(e,s,r):c(e,t,r)}}}},{package:"@metamask/etherscan-link",file:"node_modules/@metamask/etherscan-link/dist/token-tracker-link.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-contract/lib/contract.js",{"./has-tx-object":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-contract/lib/has-tx-object.js","@babel/runtime/helpers/asyncToGenerator":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@babel/runtime/helpers/asyncToGenerator.js","@babel/runtime/helpers/interopRequireDefault":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@babel/runtime/helpers/interopRequireDefault.js","@babel/runtime/regenerator":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@babel/runtime/regenerator/index.js","@metamask/ethjs-filter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-filter/lib/index.js","@metamask/ethjs-util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-util/lib/index.js","ethjs-abi":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethjs-abi/lib/index.js","js-sha3":"/home/runner/work/metamask-extension/metamask-extension/node_modules/js-sha3/src/sha3.js","promise-to-callback":"/home/runner/work/metamask-extension/metamask-extension/node_modules/promise-to-callback/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=e("@babel/runtime/helpers/interopRequireDefault"),n=r(e("@babel/runtime/regenerator")),a=r(e("@babel/runtime/helpers/asyncToGenerator")),o=e("ethjs-abi"),i=e("@metamask/ethjs-filter"),m=e("@metamask/ethjs-util").getKeys,c=e("js-sha3").keccak_256,d=e("promise-to-callback"),u=e("./has-tx-object");t.exports=function(){var e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{},t=this;function s(e){return function(){var t,s=[].slice.call(arguments);"function"==typeof s[s.length-1]&&(t=s.pop());var n=function(e){return r.apply(this,arguments)}({methodObject:e,methodArgs:s});return t?d(n)(t):n}}function r(){return(r=(0,a.default)(n.default.mark((function e(s){var r,a,i,m,c,d,l;return n.default.wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return r=s.methodObject,a=s.methodArgs,i="call",m={},u(a)&&(m=a.pop()),(c=Object.assign({},t.defaultTxObject,m,{to:t.address})).data=o.encodeMethod(r,a),!1===r.constant&&(i="sendTransaction"),e.next=9,t.query[i](c);case 9:if(d=e.sent,"call"!==i){e.next=20;break}return e.prev=11,l=o.decodeMethod(r,d),e.abrupt("return",l);case 16:throw e.prev=16,e.t0=e.catch(11),new Error("[ethjs-contract] while formatting incoming raw call data "+JSON.stringify(d)+" "+e.t0);case 20:return e.abrupt("return",d);case 21:case"end":return e.stop()}}),e,null,[[11,16]])})))).apply(this,arguments)}t.abi=e.contractABI||[],t.query=e.query,t.address=e.address||"0x",t.bytecode=e.contractBytecode||"0x",t.defaultTxObject=e.contractDefaultTxObject||{},t.filters=new i(t.query),(l=t.abi,l.filter((function(e){return("function"===e.type||"event"===e.type)&&e.name.length>0}))).forEach((function(e){"function"===e.type?t[e.name]=s(e):"event"===e.type&&(t[e.name]=function(e){return function(){var s=[].slice.call(arguments),r=m(e.inputs,"type",!1),n=["0x"+c(e.name+"("+r.join(",")+")")],a=Object.assign({},s[0])||{},i=Object.assign({},s[0]||{},{to:t.address,topics:n}),d=Object.assign({},a,{decoder:function(t){return o.decodeEvent(e,t,n)},defaultFilterObject:i});return new t.filters.Filter(d)}}(e))}));var l}}}},{package:"eth-method-registry>@metamask/ethjs-contract",file:"node_modules/@metamask/ethjs-contract/lib/contract.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-contract/lib/has-tx-object.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=["from","to","data","value","gasPrice","gas"];t.exports=function(e){if(!Array.isArray(e)||0===e.length)return!1;var t=e[e.length-1];if(!t)return!1;if("object"!=typeof t)return!1;if(0===Object.keys(t).length)return!0;var s=Object.keys(t);if(r.some((function(e){return s.includes(e)})))return!0;return!1}}}},{package:"eth-method-registry>@metamask/ethjs-contract",file:"node_modules/@metamask/ethjs-contract/lib/has-tx-object.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-contract/lib/index.js",{"./contract":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-contract/lib/contract.js","./has-tx-object":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-contract/lib/has-tx-object.js","@metamask/ethjs-filter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-filter/lib/index.js","@metamask/ethjs-util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-util/lib/index.js","ethjs-abi":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethjs-abi/lib/index.js","js-sha3":"/home/runner/work/metamask-extension/metamask-extension/node_modules/js-sha3/src/sha3.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=e("ethjs-abi"),n=(e("js-sha3").keccak_256,e("@metamask/ethjs-filter"),e("@metamask/ethjs-util").getKeys),a=e("./contract"),o=e("./has-tx-object");t.exports=function(e){return function(t,s,i){if(!Array.isArray(t))throw new Error("[ethjs-contract] Contract ABI must be type Array, got type "+typeof t);if(void 0!==s&&"string"!=typeof s)throw new Error("[ethjs-contract] Contract bytecode must be type String, got type "+typeof s);if(void 0!==i&&"object"!=typeof i)throw new Error("[ethjs-contract] Contract default tx object must be type Object, got type "+typeof t);var m={at:function(r){return new a({address:r,query:e,contractBytecode:s,contractDefaultTxObject:i,contractABI:t})},new:function(){var a={},m=null,c=[].slice.call(arguments);"function"==typeof c[c.length-1]&&(m=c.pop()),o(c)&&(a=c.pop());var d=function(e){return e.filter((function(e){return"constructor"===e.type}))[0]}(t),u=Object.assign({},i,a);if(s&&(u.data=s),d){var l=r.encodeParams(n(d.inputs,"type"),c).substring(2);u.data=""+u.data+l}return m?e.sendTransaction(u,m):e.sendTransaction(u)}};return m}}}}},{package:"eth-method-registry>@metamask/ethjs-contract",file:"node_modules/@metamask/ethjs-contract/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-filter/lib/index.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){function r(e,t){function s(e){var s=this;s.filterId=null,s.options=Object.assign({delay:300,decoder:function(e){return e},defaultFilterObject:{}},e||{}),s.watchers={},s.interval=setInterval((function(){null!==s.filterId&&Object.keys(s.watchers).length>0&&t.getFilterChanges(s.filterId,(function(e,t){var r=[],n=null;if(!e)try{t.forEach((function(e,n){r[n]=t[n],"object"==typeof t[n]&&(r[n].data=s.options.decoder(r[n].data))}))}catch(e){n=new Error("[ethjs-filter] while decoding filter change event data from RPC '"+JSON.stringify(r)+"': "+e)}Object.keys(s.watchers).forEach((function(a){var o=s.watchers[a];!0!==o.stop?n?o.callback(n,null):e?o.callback(e,null):Array.isArray(r)&&t.length>0&&o.callback(e,r):delete s.watchers[a]}))}))}),s.options.delay)}return s.prototype.at=function(e){this.filterId=e},s.prototype.watch=function(e){var t=e||function(){},s=this,r=Math.random().toString(36).substring(7);return s.watchers[r]={callback:t,stop:!1,stopWatching:function(){s.watchers[r].stop=!0}},s.watchers[r]},s.prototype.uninstall=function(e){var s=this,r=e||null;s.watchers=Object.assign({}),clearInterval(s.interval);var n=new Promise((function(e,r){t.uninstallFilter(s.filterId,(function(t,s){t?r(t):e(s)}))}));return r&&n.then((function(e){return r(null,e)})).catch((function(e){return r(e,null)})),r?null:n},s.prototype.new=function(){var s=null,r=this,n=[],a=[].slice.call(arguments);"function"==typeof a[a.length-1]&&(s=a.pop()),"Filter"===e&&n.push(Object.assign(r.options.defaultFilterObject,a[a.length-1]||{}));var o=new Promise((function(s,a){n.push((function(e,t){e?a(e):(r.filterId=t,s(t))})),t["new"+e].apply(t,n)}));return s&&o.then((function(e){return s(null,e)})).catch((function(e){return s(e,null)})),s?null:o},s}t.exports=function e(t){var s=this;if(!(s instanceof e))throw new Error("the EthFilter object must be instantiated with `new` flag.. (e.g. `const filters = new EthFilter(query);`)");if("object"!=typeof t)throw new Error("the EthFilter object must be instantiated with an EthQuery instance (e.g. `const filters = new EthFilter(new EthQuery(provider));`). See github.com/ethjs/ethjs-query for more details..");s.Filter=r("Filter",t),s.BlockFilter=r("BlockFilter",t),s.PendingTransactionFilter=r("PendingTransactionFilter",t)}}}},{package:"eth-method-registry>@metamask/ethjs-contract>@metamask/ethjs-filter",file:"node_modules/@metamask/ethjs-filter/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-format/lib/index.js",{"@metamask/ethjs-util":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-util/lib/index.js","@metamask/number-to-bn":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/number-to-bn/src/index.js","ethjs-schema":"/home/runner/work/metamask-extension/metamask-extension/node_modules/ethjs-schema/src/schema.json","strip-hex-prefix":"/home/runner/work/metamask-extension/metamask-extension/node_modules/strip-hex-prefix/src/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=e("@metamask/number-to-bn"),n=e("ethjs-schema"),a=e("@metamask/ethjs-util"),o=a.arrayContainsArray,i=a.getBinarySize,m=a.padToEven,c=e("strip-hex-prefix");function d(e,t,s){if(-1===["string","number","object"].indexOf(typeof e)||null===e)return e;var n=r(e),a=s&&n.toString(16).length%2?"0":"";if(r(e).isNeg())throw new Error("[ethjs-format] while formatting quantity '"+n.toString(10)+"', invalid negative number. Number must be positive or zero.");return t?"0x"+a+n.toString(16):n}function u(e,t){var s=e;return-1===n.tags.indexOf(e)&&(s=d(e,t)),s}function l(e,t){var s=e,r=0;if("string"==typeof e&&(s="0x"+m(c(e)),r=i(s)),"0x00"===s&&(s="0x0"),"number"==typeof t&&null!==e&&"0x"!==s&&"0x0"!==s&&(!/^[0-9A-Fa-f]+$/.test(c(s))||r!==2+2*t))throw new Error("[ethjs-format] hex string '"+s+"' must be an alphanumeric "+(2+2*t)+" utf8 byte hex (chars: a-fA-F) string, is "+r+" bytes");return s}function f(e,t,s){var r=Object.assign({},t),a=null;if("string"==typeof e&&(a="Boolean|EthSyncing"===e?Object.assign({},n.objects.EthSyncing):"DATA|Transaction"===e?Object.assign({},n.objects.Transaction):Object.assign({},n.objects[e])),!o(Object.keys(t),a.__required))throw new Error("[ethjs-format] object "+JSON.stringify(t)+" must contain properties: "+a.__required.join(", "));return Object.keys(a).forEach((function(e){"__required"!==e&&void 0!==t[e]&&(r[e]=p(a[e],t[e],s))})),r}function h(e,t,s,r){var n=t.slice(),a=e;if("Array|DATA"===e&&(a=["D"]),"FilterChange"===e&&"string"==typeof t[0]&&(a=["D32"]),!0===s&&"number"==typeof r&&t.length<r)throw new Error("array "+JSON.stringify(t)+" must contain at least "+r+" params, but only contains "+t.length+".");return a=a.slice(),t.forEach((function(e,t){var r=0;a.length>1&&(r=t),n[t]=p(a[r],e,s)})),n}function p(e,t,s,r){var n=t;return"Q"===e?n=d(t,s):"QP"===e?n=d(t,s,!0):"Q|T"===e?n=u(t,s):"D"===e?n=l(t):"D20"===e?n=l(t,20):"D32"===e?n=l(t,32):"object"==typeof t&&null!==t&&!1===Array.isArray(t)?n=f(e,t,s):Array.isArray(t)&&(n=h(e,t,s,r)),n}t.exports={schema:n,formatQuantity:d,formatQuantityOrTag:u,formatObject:f,formatArray:h,format:p,formatInputs:function(e,t){return p(n.methods[e][0],t,!0,n.methods[e][2])},formatOutputs:function(e,t){return p(n.methods[e][1],t,!1)}}}}},{package:"eth-method-registry>@metamask/ethjs-query>@metamask/ethjs-format",file:"node_modules/@metamask/ethjs-format/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-query/lib/index.js",{"@metamask/ethjs-format":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-format/lib/index.js","@metamask/ethjs-rpc":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-rpc/lib/index.js","promise-to-callback":"/home/runner/work/metamask-extension/metamask-extension/node_modules/promise-to-callback/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=e("@metamask/ethjs-format"),n=e("@metamask/ethjs-rpc"),a=e("promise-to-callback");function o(e,t){var s=this,r=t||{};if(!(this instanceof o))throw new Error('[ethjs-query] the Eth object requires the "new" flag in order to function normally (i.e. `const eth = new Eth(provider);`).');if("object"!=typeof e)throw new Error("[ethjs-query] the Eth object requires that the first input 'provider' must be an object, got '"+typeof e+"' (i.e. 'const eth = new Eth(provider);')");s.options=Object.assign({debug:r.debug||!1,logger:r.logger||console,jsonSpace:r.jsonSpace||0}),s.rpc=new n(e),s.setProvider=s.rpc.setProvider}function i(e,t){return function(){var s=null,n=null,o=this,i=[].slice.call(arguments),m=e.replace("eth_","");i.length>0&&"function"==typeof i[i.length-1]&&(s=i.pop());var c=function(){var s=this;return new Promise((function(a,c){if(i.length<t[2])c(new Error("[ethjs-query] method '"+m+"' requires at least "+t[2]+" input (format type "+t[0][0]+"), "+i.length+" provided. For more information visit: https://github.com/ethereum/wiki/wiki/JSON-RPC#"+e.toLowerCase()));else if(i.length>t[0].length)c(new Error("[ethjs-query] method '"+m+"' requires at most "+t[0].length+" params, "+i.length+" provided '"+JSON.stringify(i,null,o.options.jsonSpace)+"'. For more information visit: https://github.com/ethereum/wiki/wiki/JSON-RPC#"+e.toLowerCase()));else{t[3]&&i.length<t[3]&&i.push("latest"),s.log("attempting method formatting for '"+m+"' with inputs "+JSON.stringify(i,null,s.options.jsonSpace));try{n=r.formatInputs(e,i),s.log("method formatting success for '"+m+"' with formatted result: "+JSON.stringify(n,null,s.options.jsonSpace))}catch(e){return void c(new Error("[ethjs-query] while formatting inputs '"+JSON.stringify(i,null,s.options.jsonSpace)+"' for method '"+m+"' error: "+e))}s.rpc.sendAsync({method:e,params:n}).then((function(t){s.log("attempting method formatting for '"+m+"' with raw outputs: "+JSON.stringify(t,null,s.options.jsonSpace));var n=r.formatOutputs(e,t);s.log("method formatting success for '"+m+"' formatted result: "+JSON.stringify(n,null,s.options.jsonSpace)),a(n)})).catch((function(e){c(e)}))}}))}.call(this);return s?a(c)(s):c}}t.exports=o,o.prototype.log=function(e){this.options.debug&&this.options.logger.log("[ethjs-query log] "+e)},Object.keys(r.schema.methods).forEach((function(e){Object.defineProperty(o.prototype,e.replace("eth_",""),{enumerable:!0,value:i(e,r.schema.methods[e])})}))}}},{package:"eth-method-registry>@metamask/ethjs-query",file:"node_modules/@metamask/ethjs-query/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-rpc/lib/index.js",{"promise-to-callback":"/home/runner/work/metamask-extension/metamask-extension/node_modules/promise-to-callback/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=e("promise-to-callback");function n(e,t){var s=this,r=t||{};if(!(this instanceof n))throw new Error('[ethjs-rpc] the EthRPC object requires the "new" flag in order to function normally (i.e. `const eth = new EthRPC(provider);`).');s.options=Object.assign({jsonSpace:r.jsonSpace||0,max:r.max||9999999999999}),s.idCounter=Math.floor(Math.random()*s.options.max),s.setProvider=function(e){if("object"!=typeof e)throw new Error("[ethjs-rpc] the EthRPC object requires that the first input 'provider' must be an object, got '"+typeof e+"' (i.e. 'const eth = new EthRPC(provider);')");s.currentProvider=e},s.setProvider(e)}t.exports=n,n.prototype.sendAsync=function(e,t){var s=this;s.idCounter=s.idCounter%s.options.max;var n,a,o=(n=e,a=s.idCounter++,Object.assign({},{id:a,jsonrpc:"2.0",params:[]},n)),i=new Promise((function(e,t){s.currentProvider.sendAsync(o,(function(r,n){var a=n||{};if(r||a.error){var i="[ethjs-rpc] "+(a.error?"rpc":"")+" error with payload "+JSON.stringify(o,null,s.options.jsonSpace)+" "+(r?String(r):JSON.stringify(a.error,null,s.options.jsonSpace)),m=new Error(i);return m.value=r||a.error,void t(m)}e(a.result)}))}));return t?r(i)(t):i}}}},{package:"eth-method-registry>@metamask/ethjs-query>@metamask/ethjs-rpc",file:"node_modules/@metamask/ethjs-rpc/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-unit/lib/index.js",{"@metamask/number-to-bn":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/number-to-bn/src/index.js","bn.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/bn.js/lib/bn.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=e("bn.js"),n=e("@metamask/number-to-bn"),a=new r(0),o=new r(-1),i={noether:"0",wei:"1",kwei:"1000",Kwei:"1000",babbage:"1000",femtoether:"1000",mwei:"1000000",Mwei:"1000000",lovelace:"1000000",picoether:"1000000",gwei:"1000000000",Gwei:"1000000000",shannon:"1000000000",nanoether:"1000000000",nano:"1000000000",szabo:"1000000000000",microether:"1000000000000",micro:"1000000000000",finney:"1000000000000000",milliether:"1000000000000000",milli:"1000000000000000",ether:"1000000000000000000",kether:"1000000000000000000000",grand:"1000000000000000000000",mether:"1000000000000000000000000",gether:"1000000000000000000000000000",tether:"1000000000000000000000000000000"};function m(e){var t=e?e.toLowerCase():"ether",s=i[t];if("string"!=typeof s)throw new Error("[ethjs-unit] the unit provided "+e+" doesn't exists, please use the one of the following units "+JSON.stringify(i,null,2));return new r(s,10)}function c(e){if("string"==typeof e){if(!e.match(/^-?[0-9.]+$/))throw new Error("while converting number to string, invalid number value '"+e+"', should be a number matching (^-?[0-9.]+).");return e}if("number"==typeof e)return String(e);if("object"==typeof e&&e.toString&&(e.toTwos||e.dividedToIntegerBy))return e.toPrecision?String(e.toPrecision()):e.toString(10);throw new Error("while converting number to string, invalid number value '"+e+"' type "+typeof e+".")}t.exports={unitMap:i,numberToString:c,getValueOfUnit:m,fromWei:function(e,t,s){var r=n(e),c=r.lt(a),d=m(t),u=i[t].length-1||1,l=s||{};c&&(r=r.mul(o));for(var f=r.mod(d).toString(10);f.length<u;)f="0"+f;l.pad||(f=f.match(/^([0-9]*[1-9]|0)(0*)/)[1]);var h=r.div(d).toString(10);l.commify&&(h=h.replace(/\B(?=(\d{3})+(?!\d))/g,","));var p=h+("0"==f?"":"."+f);return c&&(p="-"+p),p},toWei:function(e,t){var s=c(e),n=m(t),a=i[t].length-1||1,d="-"===s.substring(0,1);if(d&&(s=s.substring(1)),"."===s)throw new Error("[ethjs-unit] while converting number "+e+" to wei, invalid value");var u=s.split(".");if(u.length>2)throw new Error("[ethjs-unit] while converting number "+e+" to wei,  too many decimal points");var l=u[0],f=u[1];if(l||(l="0"),f||(f="0"),f.length>a)throw new Error("[ethjs-unit] while converting number "+e+" to wei, too many decimal places");for(;f.length<a;)f+="0";l=new r(l),f=new r(f);var h=l.mul(n).add(f);return d&&(h=h.mul(o)),new r(h.toString(10),10)}}}}},{package:"@metamask/controller-utils>@metamask/ethjs-unit",file:"node_modules/@metamask/ethjs-unit/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/ethjs-util/lib/index.js",{buffer:"/home/runner/work/metamask-extension/metamask-extension/node_modules/browserify/node_modules/buffer/index.js","is-hex-prefixed":"/home/runner/work/metamask-extension/metamask-extension/node_modules/is-hex-prefixed/src/index.js","strip-hex-prefix":"/home/runner/work/metamask-extension/metamask-extension/node_modules/strip-hex-prefix/src/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){(function(s){(function(){var r=e("is-hex-prefixed"),n=e("strip-hex-prefix");function a(e){var t=e;if("string"!=typeof t)throw new Error("[ethjs-util] while padding to even, value must be string, is currently "+typeof t+", while padToEven.");return t.length%2&&(t="0"+t),t}function o(e){return"0x"+e.toString(16)}t.exports={arrayContainsArray:function(e,t,s){if(!0!==Array.isArray(e))throw new Error("[ethjs-util] method arrayContainsArray requires input 'superset' to be an array got type '"+typeof e+"'");if(!0!==Array.isArray(t))throw new Error("[ethjs-util] method arrayContainsArray requires input 'subset' to be an array got type '"+typeof t+"'");return t[Boolean(s)?"some":"every"]((function(t){return e.indexOf(t)>=0}))},intToBuffer:function(e){var t=o(e);return s.from(a(t.slice(2)),"hex")},getBinarySize:function(e){if("string"!=typeof e)throw new Error("[ethjs-util] while getting binary size, method getBinarySize requires input 'str' to be type String, got '"+typeof e+"'.");return s.byteLength(e,"utf8")},isHexPrefixed:r,stripHexPrefix:n,padToEven:a,intToHex:o,fromAscii:function(e){for(var t="",s=0;s<e.length;s++){var r=e.charCodeAt(s).toString(16);t+=r.length<2?"0"+r:r}return"0x"+t},fromUtf8:function(e){return"0x"+a(s.from(e,"utf8").toString("hex")).replace(/^0+|0+$/g,"")},toAscii:function(e){var t="",s=0,r=e.length;for("0x"===e.substring(0,2)&&(s=2);s<r;s+=2){var n=parseInt(e.substr(s,2),16);t+=String.fromCharCode(n)}return t},toUtf8:function(e){return s.from(a(n(e).replace(/^0+|0+$/g,"")),"hex").toString("utf8")},getKeys:function(e,t,s){if(!Array.isArray(e))throw new Error("[ethjs-util] method getKeys expecting type Array as 'params' input, got '"+typeof e+"'");if("string"!=typeof t)throw new Error("[ethjs-util] method getKeys expecting type String for input 'key' got '"+typeof t+"'.");for(var r=[],n=0;n<e.length;n++){var a=e[n][t];if(s&&!a)a="";else if("string"!=typeof a)throw new Error("invalid abi");r.push(a)}return r},isHexString:function(e,t){return!("string"!=typeof e||!e.match(/^0x[0-9A-Fa-f]*$/))&&(!t||e.length===2+2*t)}}}).call(this)}).call(this,e("buffer").Buffer)}}},{package:"eth-method-registry>@metamask/ethjs-contract>@metamask/ethjs-util",file:"node_modules/@metamask/ethjs-util/lib/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gas-fee-controller/dist/GasFeeController.cjs",{"./determineGasFeeCalculations.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gas-fee-controller/dist/determineGasFeeCalculations.cjs","./gas-util.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gas-fee-controller/dist/gas-util.cjs","@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs","@metamask/eth-query":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/eth-query/index.js","@metamask/polling-controller":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/polling-controller/dist/index.cjs",uuid:"/home/runner/work/metamask-extension/metamask-extension/node_modules/uuid/dist/index.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,n,a,o=this&&this.__classPrivateFieldSet||function(e,t,s,r,n){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?n.call(e,s):n?n.value=s:t.set(e,s),s},i=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)},m=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.GasFeeController=s.GAS_ESTIMATE_TYPES=s.LEGACY_GAS_PRICES_API_URL=void 0;const c=e("@metamask/controller-utils"),d=m(e("@metamask/eth-query")),u=e("@metamask/polling-controller"),l=e("uuid"),f=m(e("./determineGasFeeCalculations.cjs")),h=e("./gas-util.cjs");s.LEGACY_GAS_PRICES_API_URL="https://api.metaswap.codefi.network/gasPrices",s.GAS_ESTIMATE_TYPES={FEE_MARKET:"fee-market",LEGACY:"legacy",ETH_GASPRICE:"eth_gasPrice",NONE:"none"};const p={gasFeeEstimatesByChainId:{persist:!0,anonymous:!1},gasFeeEstimates:{persist:!0,anonymous:!1},estimatedGasFeeTimeBounds:{persist:!0,anonymous:!1},gasEstimateType:{persist:!0,anonymous:!1},nonRPCGasFeeApisDisabled:{persist:!0,anonymous:!1}},g={gasFeeEstimatesByChainId:{},gasFeeEstimates:{},estimatedGasFeeTimeBounds:{},gasEstimateType:s.GAS_ESTIMATE_TYPES.NONE,nonRPCGasFeeApisDisabled:!1};class k extends((0,u.StaticIntervalPollingController)()){constructor({interval:e=15e3,messenger:t,state:m,getCurrentNetworkEIP1559Compatibility:c,getCurrentAccountEIP1559Compatibility:u,getChainId:l,getCurrentNetworkLegacyGasAPICompatibility:f,getProvider:h,onNetworkDidChange:k,legacyAPIEndpoint:b=s.LEGACY_GAS_PRICES_API_URL,EIP1559APIEndpoint:y,clientId:x}){if(super({name:"GasFeeController",metadata:p,messenger:t,state:{...g,...m}}),r.add(this),n.set(this,void 0),this.intervalDelay=e,this.setIntervalLength(e),this.pollTokens=new Set,this.getCurrentNetworkEIP1559Compatibility=c,this.getCurrentNetworkLegacyGasAPICompatibility=f,this.getCurrentAccountEIP1559Compatibility=u,o(this,n,h,"f"),this.EIP1559APIEndpoint=y,this.legacyAPIEndpoint=b,this.clientId=x,this.ethQuery=new d.default(i(this,n,"f").call(this)),k&&l)this.currentChainId=l(),k((async e=>{await i(this,r,"m",a).call(this,e)}));else{const{selectedNetworkClientId:e}=this.messagingSystem.call("NetworkController:getState");this.currentChainId=this.messagingSystem.call("NetworkController:getNetworkClientById",e).configuration.chainId,this.messagingSystem.subscribe("NetworkController:networkDidChange",(async e=>{await i(this,r,"m",a).call(this,e)}))}}async resetPolling(){if(0!==this.pollTokens.size){const e=Array.from(this.pollTokens);this.stopPolling(),await this.getGasFeeEstimatesAndStartPolling(e[0]),e.slice(1).forEach((e=>{this.pollTokens.add(e)}))}}async fetchGasFeeEstimates(e){return await this._fetchGasFeeEstimateData(e)}async getGasFeeEstimatesAndStartPolling(e){const t=e||(0,l.v1)();return this.pollTokens.add(t),1===this.pollTokens.size&&(await this._fetchGasFeeEstimateData(),this._poll()),t}async _fetchGasFeeEstimateData(e={}){const{shouldUpdateState:t=!0,networkClientId:s}=e;let r,n,a,o;if(s!==undefined){const e=this.messagingSystem.call("NetworkController:getNetworkClientById",s);a="0x38"===e.configuration.chainId,o=(0,c.convertHexToDecimal)(e.configuration.chainId);try{n=await this.messagingSystem.call("NetworkController:getEIP1559Compatibility",s)||!1}catch{n=!1}r=new d.default(e.provider)}r??(r=this.ethQuery),a??(a=this.getCurrentNetworkLegacyGasAPICompatibility()),o??(o=(0,c.convertHexToDecimal)(this.currentChainId));try{n??(n=await this.getEIP1559Compatibility())}catch(e){console.error(e),n??(n=!1)}const i=await(0,f.default)({isEIP1559Compatible:n,isLegacyGasAPICompatible:a,fetchGasEstimates:h.fetchGasEstimates,fetchGasEstimatesUrl:this.EIP1559APIEndpoint.replace("<chain_id>",`${o}`),fetchLegacyGasPriceEstimates:h.fetchLegacyGasPriceEstimates,fetchLegacyGasPriceEstimatesUrl:this.legacyAPIEndpoint.replace("<chain_id>",`${o}`),fetchEthGasPriceEstimate:h.fetchEthGasPriceEstimate,calculateTimeEstimate:h.calculateTimeEstimate,clientId:this.clientId,ethQuery:r,nonRPCGasFeeApisDisabled:this.state.nonRPCGasFeeApisDisabled});if(t){const e=(0,c.toHex)(o);this.update((t=>{this.currentChainId===e&&(t.gasFeeEstimates=i.gasFeeEstimates,t.estimatedGasFeeTimeBounds=i.estimatedGasFeeTimeBounds,t.gasEstimateType=i.gasEstimateType),t.gasFeeEstimatesByChainId??(t.gasFeeEstimatesByChainId={}),t.gasFeeEstimatesByChainId[e]={gasFeeEstimates:i.gasFeeEstimates,estimatedGasFeeTimeBounds:i.estimatedGasFeeTimeBounds,gasEstimateType:i.gasEstimateType}}))}return i}disconnectPoller(e){this.pollTokens.delete(e),0===this.pollTokens.size&&this.stopPolling()}stopPolling(){this.intervalId&&clearInterval(this.intervalId),this.pollTokens.clear(),this.resetState()}destroy(){super.destroy(),this.stopPolling()}_poll(){this.intervalId&&clearInterval(this.intervalId),this.intervalId=setInterval((async()=>{await(0,c.safelyExecute)((()=>this._fetchGasFeeEstimateData()))}),this.intervalDelay)}async _executePoll({networkClientId:e}){await this._fetchGasFeeEstimateData({networkClientId:e})}resetState(){this.update((()=>g))}async getEIP1559Compatibility(){const e=await this.getCurrentNetworkEIP1559Compatibility(),t=this.getCurrentAccountEIP1559Compatibility?.()??!0;return e&&t}getTimeEstimate(e,t){return this.state.gasFeeEstimates&&this.state.gasEstimateType===s.GAS_ESTIMATE_TYPES.FEE_MARKET?(0,h.calculateTimeEstimate)(e,t,this.state.gasFeeEstimates):{}}enableNonRPCGasFeeApis(){this.update((e=>{e.nonRPCGasFeeApisDisabled=!1}))}disableNonRPCGasFeeApis(){this.update((e=>{e.nonRPCGasFeeApisDisabled=!0}))}}s.GasFeeController=k,n=new WeakMap,r=new WeakSet,a=async function({selectedNetworkClientId:e}){const t=this.messagingSystem.call("NetworkController:getNetworkClientById",e).configuration.chainId;t!==this.currentChainId&&(this.ethQuery=new d.default(i(this,n,"f").call(this)),await this.resetPolling(),this.currentChainId=t)},s.default=k}}},{package:"@metamask/gas-fee-controller",file:"node_modules/@metamask/gas-fee-controller/dist/GasFeeController.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gas-fee-controller/dist/determineGasFeeCalculations.cjs",{"./GasFeeController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gas-fee-controller/dist/GasFeeController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const r=e("./GasFeeController.cjs");s.default=async function(e){try{return await async function(e){const{isEIP1559Compatible:t,isLegacyGasAPICompatible:s,nonRPCGasFeeApisDisabled:n}=e;try{if(t&&!n)return await async function(e){const{fetchGasEstimates:t,fetchGasEstimatesUrl:s,clientId:n,calculateTimeEstimate:a}=e,o=await t(s,n),{suggestedMaxPriorityFeePerGas:i,suggestedMaxFeePerGas:m}=o.medium,c=a(i,m,o);return{gasFeeEstimates:o,estimatedGasFeeTimeBounds:c,gasEstimateType:r.GAS_ESTIMATE_TYPES.FEE_MARKET}}(e);if(s&&!n)return await async function(e){const{fetchLegacyGasPriceEstimates:t,fetchLegacyGasPriceEstimatesUrl:s,clientId:n}=e;return{gasFeeEstimates:await t(s,n),estimatedGasFeeTimeBounds:{},gasEstimateType:r.GAS_ESTIMATE_TYPES.LEGACY}}(e);throw new Error("Main gas fee/price estimation failed. Use fallback")}catch{return await async function(e){const{ethQuery:t,fetchEthGasPriceEstimate:s}=e;return{gasFeeEstimates:await s(t),estimatedGasFeeTimeBounds:{},gasEstimateType:r.GAS_ESTIMATE_TYPES.ETH_GASPRICE}}(e)}}(e)}catch(e){if(e instanceof Error)throw new Error(`Gas fee/price estimation failed. Message: ${e.message}`);throw e}}}}},{package:"@metamask/gas-fee-controller",file:"node_modules/@metamask/gas-fee-controller/dist/determineGasFeeCalculations.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gas-fee-controller/dist/gas-util.cjs",{"@metamask/controller-utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/controller-utils/dist/index.cjs","bn.js":"/home/runner/work/metamask-extension/metamask-extension/node_modules/bn.js/lib/bn.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.calculateTimeEstimate=s.fetchEthGasPriceEstimate=s.fetchLegacyGasPriceEstimates=s.fetchGasEstimates=s.normalizeGWEIDecimalNumbers=void 0;const n=e("@metamask/controller-utils"),a=r(e("bn.js")),o=e=>({"X-Client-Id":e});function i(e){const t=(0,n.gweiDecToWEIBN)(e).toString(16);return(0,n.weiHexToGweiDec)(t)}s.normalizeGWEIDecimalNumbers=i,s.fetchGasEstimates=async function(e,t){const s=await(0,n.handleFetch)(e,t?{headers:o(t)}:undefined);return{low:{...s.low,suggestedMaxPriorityFeePerGas:i(s.low.suggestedMaxPriorityFeePerGas),suggestedMaxFeePerGas:i(s.low.suggestedMaxFeePerGas)},medium:{...s.medium,suggestedMaxPriorityFeePerGas:i(s.medium.suggestedMaxPriorityFeePerGas),suggestedMaxFeePerGas:i(s.medium.suggestedMaxFeePerGas)},high:{...s.high,suggestedMaxPriorityFeePerGas:i(s.high.suggestedMaxPriorityFeePerGas),suggestedMaxFeePerGas:i(s.high.suggestedMaxFeePerGas)},estimatedBaseFee:i(s.estimatedBaseFee),historicalBaseFeeRange:s.historicalBaseFeeRange,baseFeeTrend:s.baseFeeTrend,latestPriorityFeeRange:s.latestPriorityFeeRange,historicalPriorityFeeRange:s.historicalPriorityFeeRange,priorityFeeTrend:s.priorityFeeTrend,networkCongestion:s.networkCongestion}},s.fetchLegacyGasPriceEstimates=async function(e,t){const s=await(0,n.handleFetch)(e,{referrer:e,referrerPolicy:"no-referrer-when-downgrade",method:"GET",mode:"cors",headers:{"Content-Type":"application/json",...t&&o(t)}});return{low:s.SafeGasPrice,medium:s.ProposeGasPrice,high:s.FastGasPrice}},s.fetchEthGasPriceEstimate=async function(e){const t=await(0,n.query)(e,"gasPrice");return{gasPrice:(0,n.weiHexToGweiDec)(t).toString()}},s.calculateTimeEstimate=function(e,t,s){const{low:r,medium:o,high:i,estimatedBaseFee:m}=s,c=(0,n.gweiDecToWEIBN)(e),d=(0,n.gweiDecToWEIBN)(t),u=(0,n.gweiDecToWEIBN)(m),l=a.default.min(c,d.sub(u)),f=(0,n.gweiDecToWEIBN)(r.suggestedMaxPriorityFeePerGas),h=(0,n.gweiDecToWEIBN)(o.suggestedMaxPriorityFeePerGas),p=(0,n.gweiDecToWEIBN)(i.suggestedMaxPriorityFeePerGas);let g,k;return l.lt(f)?(g=null,k="unknown"):l.gte(f)&&l.lt(h)?(g=r.minWaitTimeEstimate,k=r.maxWaitTimeEstimate):l.gte(h)&&l.lt(p)?(g=o.minWaitTimeEstimate,k=o.maxWaitTimeEstimate):l.eq(p)?(g=i.minWaitTimeEstimate,k=i.maxWaitTimeEstimate):(g=0,k=i.maxWaitTimeEstimate),{lowerTimeBound:g,upperTimeBound:k}}}}},{package:"@metamask/gas-fee-controller",file:"node_modules/@metamask/gas-fee-controller/dist/gas-util.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gas-fee-controller/dist/index.cjs",{"./GasFeeController.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/gas-fee-controller/dist/GasFeeController.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r=this&&this.__createBinding||(Object.create?function(e,t,s,r){r===undefined&&(r=s);var n=Object.getOwnPropertyDescriptor(t,s);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[s]}}),Object.defineProperty(e,r,n)}:function(e,t,s,r){r===undefined&&(r=s),e[r]=t[s]}),n=this&&this.__exportStar||function(e,t){for(var s in e)"default"===s||Object.prototype.hasOwnProperty.call(t,s)||r(t,e,s)};Object.defineProperty(s,"__esModule",{value:!0}),n(e("./GasFeeController.cjs"),s)}}},{package:"@metamask/gas-fee-controller",file:"node_modules/@metamask/gas-fee-controller/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/jazzicon/colors.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){t.exports=["#01888C","#FC7500","#034F5D","#F73F01","#FC1960","#C7144C","#F3C100","#1598F2","#2465E1","#F19E02"]}}},{package:"@metamask/jazzicon",file:"node_modules/@metamask/jazzicon/colors.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/jazzicon/index.js",{"./colors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/jazzicon/colors.js","./paper":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/jazzicon/paper.js",color:"/home/runner/work/metamask-extension/metamask-extension/node_modules/color/index.js","mersenne-twister":"/home/runner/work/metamask-extension/metamask-extension/node_modules/mersenne-twister/src/mersenne-twister.js"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,n=e("mersenne-twister"),a=e("./paper"),o=e("color"),i=e("./colors"),m="http://www.w3.org/2000/svg";function c(e,t,s,n,a){var o=t/2,i=document.createElementNS(m,"rect");i.setAttributeNS(null,"x","0"),i.setAttributeNS(null,"y","0"),i.setAttributeNS(null,"width",t),i.setAttributeNS(null,"height",t);var c=r.random(),u=2*Math.PI*c,l=t/n*r.random()+s*t/n,f="translate("+Math.cos(u)*l+" "+Math.sin(u)*l+")"+" "+("rotate("+(360*c+180*r.random()).toFixed(1)+" "+o+" "+o+")");i.setAttributeNS(null,"transform",f);var h=d(e);i.setAttributeNS(null,"fill",h),a.appendChild(i)}function d(e){r.random();var t=Math.floor(e.length*r.random());return e.splice(t,1)[0]}t.exports=function(e,t){r=new n(t);var s=function(e,t){var s=30*t.random()-u/2;return e.map((function(e){var t=o(e);return t.rotate(s),t.hexString()}))}(i.slice(),r),l=a(e,d(s)).container,f=document.createElementNS(m,"svg");f.setAttributeNS(null,"x","0"),f.setAttributeNS(null,"y","0"),f.setAttributeNS(null,"width",e),f.setAttributeNS(null,"height",e),l.appendChild(f);for(var h=0;h<3;h++)c(s,e,h,3,f);return l};var u=30}}},{package:"@metamask/jazzicon",file:"node_modules/@metamask/jazzicon/index.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/jazzicon/paper.js",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){t.exports=function(e,t){var s=document.createElement("div");return s.style.borderRadius="50px",s.style.overflow="hidden",s.style.padding="0px",s.style.margin="0px",s.style.width=e+"px",s.style.height=e+"px",s.style.display="inline-block",s.style.background=t,{container:s}}}}},{package:"@metamask/jazzicon",file:"node_modules/@metamask/jazzicon/paper.js"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/JsonRpcEngine.cjs",{"@metamask/rpc-errors":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/rpc-errors/dist/index.cjs","@metamask/safe-event-emitter":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/safe-event-emitter/dist/cjs/index.js","@metamask/utils":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/utils/dist/index.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){var r,n,a,o,i,m,c,d,u,l,f,h,p,g=this&&this.__classPrivateFieldSet||function(e,t,s,r,n){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!n)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?n.call(e,s):n?n.value=s:t.set(e,s),s},k=this&&this.__classPrivateFieldGet||function(e,t,s,r){if("a"===s&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===s?r:"a"===s?r.call(e):r?r.value:t.get(e)},b=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(s,"__esModule",{value:!0}),s.JsonRpcEngine=void 0;const y=e("@metamask/rpc-errors"),x=b(e("@metamask/safe-event-emitter")),w=e("@metamask/utils");class E extends x.default{constructor({notificationHandler:e}={}){super(),r.add(this),a.set(this,!1),o.set(this,void 0),i.set(this,void 0),g(this,o,[],"f"),g(this,i,e,"f")}destroy(){k(this,o,"f").forEach((e=>{"destroy"in e&&"function"==typeof e.destroy&&e.destroy()})),g(this,o,[],"f"),g(this,a,!0,"f")}push(e){k(this,r,"m",m).call(this),k(this,o,"f").push(e)}handle(e,t){if(k(this,r,"m",m).call(this),t&&"function"!=typeof t)throw new Error('"callback" must be a function if provided.');return Array.isArray(e)?t?k(this,r,"m",c).call(this,e,t):k(this,r,"m",c).call(this,e):t?k(this,r,"m",d).call(this,e,t):this._promiseHandle(e)}asMiddleware(){return k(this,r,"m",m).call(this),async(e,t,s,r)=>{try{const[a,i,m]=await k(n,n,"m",l).call(n,e,t,k(this,o,"f"));return i?(await k(n,n,"m",h).call(n,m),r(a)):s((async e=>{try{await k(n,n,"m",h).call(n,m)}catch(t){return e(t)}return e()}))}catch(e){return r(e)}}}async _promiseHandle(e){return new Promise(((t,s)=>{k(this,r,"m",d).call(this,e,((e,r)=>{e&&r===undefined?s(e):t(r)})).catch(s)}))}}function _(e){return JSON.stringify(e,null,2)}s.JsonRpcEngine=E,n=E,a=new WeakMap,o=new WeakMap,i=new WeakMap,r=new WeakSet,m=function(){if(k(this,a,"f"))throw new Error("This engine is destroyed and can no longer be used.")},c=async function(e,t){try{if(0===e.length){const e=[{id:null,jsonrpc:"2.0",error:new y.JsonRpcError(y.errorCodes.rpc.invalidRequest,"Request batch must contain plain objects. Received an empty array")}];return t?t(null,e):e}const s=(await Promise.all(e.map(this._promiseHandle.bind(this)))).filter((e=>e!==undefined));return t?t(null,s):s}catch(e){if(t)return t(e);throw e}},d=async function(e,t){if(!e||Array.isArray(e)||"object"!=typeof e){const s=new y.JsonRpcError(y.errorCodes.rpc.invalidRequest,"Requests must be plain objects. Received: "+typeof e,{request:e});return t(s,{id:null,jsonrpc:"2.0",error:s})}if("string"!=typeof e.method){const s=new y.JsonRpcError(y.errorCodes.rpc.invalidRequest,"Must specify a string method. Received: "+typeof e.method,{request:e});return k(this,i,"f")&&!(0,w.isJsonRpcRequest)(e)?t(null):t(s,{id:e.id??null,jsonrpc:"2.0",error:s})}if(k(this,i,"f")&&(0,w.isJsonRpcNotification)(e)&&!(0,w.isJsonRpcRequest)(e)){try{await k(this,i,"f").call(this,e)}catch(s){return t(s)}return t(null)}let s=null;const r={...e},a={id:r.id,jsonrpc:r.jsonrpc};try{await k(n,n,"m",u).call(n,r,a,k(this,o,"f"))}catch(e){s=e}return s&&(delete a.result,a.error||(a.error=(0,y.serializeError)(s))),t(s,a)},u=async function(e,t,s){const[r,a,o]=await k(n,n,"m",l).call(n,e,t,s);if(k(n,n,"m",p).call(n,e,t,a),await k(n,n,"m",h).call(n,o),r)throw r},l=async function(e,t,s){const r=[];let a=null,o=!1;for(const i of s)if([a,o]=await k(n,n,"m",f).call(n,e,t,i,r),o)break;return[a,o,r.reverse()]},f=async function(e,t,s,r){return new Promise((n=>{const a=e=>{const s=e||t.error;s&&(t.error=(0,y.serializeError)(s)),n([s,!0])},o=s=>{t.error?a(t.error):(s&&("function"!=typeof s&&a(new y.JsonRpcError(y.errorCodes.rpc.internal,`JsonRpcEngine: "next" return handlers must be functions. Received "${typeof s}" for request:\n${_(e)}`,{request:e})),r.push(s)),n([null,!1]))};try{s(e,t,o,a)}catch(e){a(e)}}))},h=async function(e){for(const t of e)await new Promise(((e,s)=>{t((t=>t?s(t):e()))}))},p=function(e,t,s){if(!(0,w.hasProperty)(t,"result")&&!(0,w.hasProperty)(t,"error"))throw new y.JsonRpcError(y.errorCodes.rpc.internal,`JsonRpcEngine: Response has no error or result for request:\n${_(e)}`,{request:e});if(!s)throw new y.JsonRpcError(y.errorCodes.rpc.internal,`JsonRpcEngine: Nothing ended request:\n${_(e)}`,{request:e})}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/JsonRpcEngine.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/createAsyncMiddleware.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createAsyncMiddleware=void 0,s.createAsyncMiddleware=function(e){return async(t,s,r,n)=>{let a;const o=new Promise((e=>{a=e}));let i=null,m=!1;const c=async()=>(m=!0,r((e=>{i=e,a()})),o);try{await e(t,s,c),m?(await o,i(null)):n(null)}catch(e){i?i(e):n(e)}}}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/createAsyncMiddleware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/createScaffoldMiddleware.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createScaffoldMiddleware=void 0,s.createScaffoldMiddleware=function(e){return(t,s,r,n)=>{const a=e[t.method];return a===undefined?r():"function"==typeof a?a(t,s,r,n):(s.result=a,n())}}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/createScaffoldMiddleware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/getUniqueId.cjs",{},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.getUniqueId=void 0;const r=4294967295;let n=Math.floor(Math.random()*r);s.getUniqueId=function(){return n=(n+1)%r,n}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/getUniqueId.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/idRemapMiddleware.cjs",{"./getUniqueId.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/getUniqueId.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.createIdRemapMiddleware=void 0;const r=e("./getUniqueId.cjs");s.createIdRemapMiddleware=function(){return(e,t,s,n)=>{const a=e.id,o=(0,r.getUniqueId)();e.id=o,t.id=o,s((s=>{e.id=a,t.id=a,s()}))}}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/idRemapMiddleware.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/index.cjs",{"./JsonRpcEngine.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/JsonRpcEngine.cjs","./createAsyncMiddleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/createAsyncMiddleware.cjs","./createScaffoldMiddleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/createScaffoldMiddleware.cjs","./getUniqueId.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/getUniqueId.cjs","./idRemapMiddleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/idRemapMiddleware.cjs","./mergeMiddleware.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/mergeMiddleware.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.mergeMiddleware=s.JsonRpcEngine=s.createIdRemapMiddleware=s.getUniqueId=s.createScaffoldMiddleware=s.createAsyncMiddleware=void 0;var r=e("./createAsyncMiddleware.cjs");Object.defineProperty(s,"createAsyncMiddleware",{enumerable:!0,get:function(){return r.createAsyncMiddleware}});var n=e("./createScaffoldMiddleware.cjs");Object.defineProperty(s,"createScaffoldMiddleware",{enumerable:!0,get:function(){return n.createScaffoldMiddleware}});var a=e("./getUniqueId.cjs");Object.defineProperty(s,"getUniqueId",{enumerable:!0,get:function(){return a.getUniqueId}});var o=e("./idRemapMiddleware.cjs");Object.defineProperty(s,"createIdRemapMiddleware",{enumerable:!0,get:function(){return o.createIdRemapMiddleware}});var i=e("./JsonRpcEngine.cjs");Object.defineProperty(s,"JsonRpcEngine",{enumerable:!0,get:function(){return i.JsonRpcEngine}});var m=e("./mergeMiddleware.cjs");Object.defineProperty(s,"mergeMiddleware",{enumerable:!0,get:function(){return m.mergeMiddleware}})}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/index.cjs"}],["/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/mergeMiddleware.cjs",{"./JsonRpcEngine.cjs":"/home/runner/work/metamask-extension/metamask-extension/node_modules/@metamask/json-rpc-engine/dist/JsonRpcEngine.cjs"},function(){with(this.scopeTerminator)with(this.globalThis)return function(){"use strict";return function(e,t,s){Object.defineProperty(s,"__esModule",{value:!0}),s.mergeMiddleware=void 0;const r=e("./JsonRpcEngine.cjs");s.mergeMiddleware=function(e){const t=new r.JsonRpcEngine;return e.forEach((e=>t.push(e))),t.asMiddleware()}}}},{package:"@metamask/json-rpc-engine",file:"node_modules/@metamask/json-rpc-engine/dist/mergeMiddleware.cjs"}]],[],{});